import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "ym-2-32";
  // 储存对象
  item;

  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef) { }

  ngOnInit() {
    this.item = {
      tittle: {
        word: "",
        text: "",
        audio: ""
      },
      audio: '',
      questions: [{
        questionTittle: '',
        words: "",
        audio: '',
        blocks: [],
      },{
        questionTittle: '',
        words: "",
        audio: '',
        blocks: [],
      },{
        questionTittle: '',
        words: "",
        audio: '',
        blocks: [],
      },{
        questionTittle: '',
        words: "",
        audio: '',
        blocks: [],
      },{
        questionTittle: '',
        words: "",
        audio: '',
        blocks: [],
      },{
        questionTittle: '',
        words: "",
        audio: '',
        blocks: [],
      }],
    };

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      this.init();
      this.updateWords();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }

  onWordClicked(questionIdx, wordIdx) {
    let findIdx = this.item.questions[questionIdx].blocks.findIndex((block) => block.idx == wordIdx);
    if (findIdx == -1) {
      this.addBlock(questionIdx, wordIdx);
    } else {
      this.item.questions[questionIdx].blocks.splice(findIdx, 1);
    }
    this.save();
  }

  addQuestion() {
    this.item.questions.push({
      questionTittle: '',
      words: "",
      audio: '',
      blocks: [],
    });
    this.save();
  }

  deleteQuestion(idx) {
    this.item.questions.splice(idx, 1);
    this.save();
  }

  // 标题音频
  onTittleAudioUploadSuccess(e, key) {
    this.item.tittle.audio = e.url;
    this.save();
  }
  onWholeAudioUploadSuccess(e, idx) {
    this.item.audio = e.url;
    this.save();
  }
  onWholeQuestionAudioUploadSuccess(e, idx) {
    this.item.tittleAudio = e.url;
    this.save();
  }
  onQuestionAudioUploadSuccess(e, idx) {
    this.item.questions[idx].audio = e.url;
    this.save();
  }

  onWordAudioUploadSuccess(e, questionIdx, wordIdx) {
    let block = this.item.questions[questionIdx].blocks.find(block => block.idx == wordIdx);
    if (block) {
      block.audio = e.url;
    }
    this.save();
  }
  addBlock(questionIdx, wordIdx) {
    this.item.questions[questionIdx].blocks.push({
      idx: wordIdx,
      type: 'none',
      audio: '',
      img: '',
    });
  }

  radioClick(questionIdx, wordIdx, style) {
    let block = this.item.questions[questionIdx].blocks.find(block => block.idx == wordIdx);
    if (block) {
      if (block.type == style) {
        block.type = 'none';
      } else {
        block.type = style;
      }
    }
    this.save();
  }

  ngOnChanges() {
  }

  ngOnDestroy() {
  }



  init() {

  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, questionIdx, wordIdx) {
    let block = this.item.questions[questionIdx].blocks.find(block => block.idx == wordIdx);
    if (block) {
      block.img = e.url;
    }
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key) {

    this.item[key] = e.url;
    this.save();
  }

  words = [[]];
  updateWords() {
    this.words = [];
    this.item.questions.forEach((quesiton, idx) => {
      this.words.push([]);
      if (quesiton.words == '') {
        return;
      }
      this.words[idx].push(...quesiton.words.match(/(([a-z]|[A-Z]|[0-9]|'|-|&|_)+|.)/g).map((word, wordIdx) => {
        let disable = true;
        let block = false;
        let color = false;
        let bold = false;
        let audio = '';
        let img = '';
        let findIdx = quesiton.blocks.findIndex((block) => block.idx == wordIdx);
        if (findIdx != -1) {
          block = true;
          color = quesiton.blocks[findIdx].type == 'red';
          bold = quesiton.blocks[findIdx].type == 'bold';
          audio = quesiton.blocks[findIdx].audio;
          img = quesiton.blocks[findIdx].img;
        }

        if (word.match(/(([a-z]|[A-Z]|[0-9])+)/)) {
          disable = false;
        }

        let style = 'normal';
        if (color) {
          style = 'red';
        }
        if (bold) {
          style = 'bold';
        }
        if (disable) {
          style = 'disable';
          block = false;
        }

        return {
          word: word,
          block: block,
          style: style,
          audio: audio,
          img: img,
        }
      }));
    });
  }

  clearWords(questionIdx) {
    this.save();
  }
  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);
    this.updateWords();
    this.changeDetectorRef.markForCheck();
    this.changeDetectorRef.detectChanges();
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

