import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';

import { NzMessageService } from 'ng-zorro-antd/message'
import { TitleBean } from '../bean/TitleBean';
import { getDefaultExercisesBean, getDefaultLetterBean, WordBean } from '../bean/ExercisesBean';
import { BackgroundBean } from '../bean/BackgoundBean';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "YM4-10";
  // 储存对象
  item;


  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef, private message: NzMessageService) {

  }


  ngOnInit() {

    this.item = {};

    this.item.skinA = new BackgroundBean();

    this.item.skinB = new BackgroundBean();

    this.item.title = new TitleBean();

    this.item.exercisesArr = [];

    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }



  init() {
    console.log(this.item);
    if (!this.item.title) {
      this.item.title = new TitleBean();
    }

    //设置默认皮肤
    if (!this.item.skin) {
      this.item.skin = "A";
    }

    if (!this.item.skinA) {
      this.item.skinA = new BackgroundBean();
    }

    if (!this.item.skinB) {
      this.item.skinB = new BackgroundBean();
    }

    if (!this.item.exercisesArr) {

      this.item.exercisesArr = [];
    }

    let len = this.item.exercisesArr.length;

    if (len < 4) {

      for (let i = len; i < 4; ++i) {

        const exercises = getDefaultExercisesBean();
        this.item.exercisesArr.push(exercises);
      }
    }
  }


  /**
  * 储存图片数据
  * @param e
  */
  onImageUploadSuccess(e, item, key) {

    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, item, key) {

    item[key] = e.url;
    this.save();
  }

  saveIndex(item) {

    console.log(item);

    let canSave = true;

    for (let i = 0; i < this.item.exercisesArr.length; ++i) {

      let exercises = this.item.exercisesArr[i];

      if (item == exercises) {
        continue;
      }
      else if (exercises.answerIndex == item.answerIndex) {

        canSave = false;
        break;
      }
    }

    if (canSave) {
      this.save();
    }
    else {
      let id = this.message.error('已经存在相同的顺序号', { nzDuration: 0 }).messageId;
      setTimeout(() => {
        this.message.remove(id);
      }, 2500);
    }
  }

  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

  addLetter(word, key) {

    let letter = getDefaultLetterBean();

    word[key] = [...word[key], letter];

    this.save();
  }

  delLetter(word, key, index) {
    if (index !== -1) {
      word[key].splice(index, 1);
      word[key] = [...word[key]];
      this.save();
    }
  }

  clearBg() {
    if (this.item.skin === 'A') {
      this.item.skinA = new BackgroundBean();
    }
    else {
      this.item.skinB = new BackgroundBean();
    }

    this.save();
  }

  addWord(exercises, key) {
    let word = new WordBean();

    exercises[key] = [...exercises[key], word];

    this.save();
  }

  deleteWord(exercises, key, index) {
    if (index !== -1) {
      exercises[key].splice(index, 1);
      exercises[key] = [...exercises[key]];
      this.save();
    }
  }
}

