
import {
    Item
} from './Item'

import {
    Label,
    MySprite, tweenChange, ShapeRect, MyAnimation, ShapeRectNew

} from './Unit';

export class AudioComponent extends Item {

    bg: ShapeRect;

    curAudio;

    btnPlay: MySprite;

    btnStop: MySprite;

    totalTimeLabel: Label;

    curTimeLabel: Label;

    paused = false;

    ended = false;

    progress: ShapeRectNew;

    progressVal = 0;

    progressBtn: MySprite;

    touched = false;

    touchX = 0;

    /**进度条按钮当前坐标 */
    curX = 0

    progressInitX = 0;

    init(width: number, height: number) {
        const bg = new ShapeRect();
        bg.setSize(width, height);
        bg.alpha = 0;
        this.bg = bg;

        const audioPic = new MySprite();
        audioPic.init(this.images.get("bg_audio"));
        audioPic.scaleX = this.scaleX;
        audioPic.scaleY = this.scaleY;
        audioPic.x = bg.width / 2;
        audioPic.y = bg.height / 2;
        bg.addChild(audioPic);

        const btnPlay = new MySprite();
        btnPlay.init(this.images.get("btn_audio_off"), 0, 0);
        btnPlay.scaleX = this.scaleX;
        btnPlay.scaleY = this.scaleY;
        btnPlay.x = 0;
        btnPlay.y = 0;

        const btnPlayBg = new ShapeRect();
        btnPlayBg.setSize(btnPlay.getBoundingBox().width, btnPlay.getBoundingBox().height);
        btnPlayBg.alpha = 0;
        btnPlayBg.x = 429 * this.scaleX;
        btnPlayBg.y = 31 * this.scaleY;
        btnPlayBg.addChild(btnPlay);
        bg.addChild(btnPlayBg);
        this.btnPlay = btnPlayBg;

        const btnStop = new MySprite();
        btnStop.init(this.images.get("btn_audio_on"), 0, 0);
        btnStop.scaleX = this.scaleX;
        btnStop.scaleY = this.scaleY;
        btnStop.x = btnPlay.x;
        btnStop.y = btnPlay.y;

        const btnStopBg = new ShapeRect();
        btnStopBg.setSize(btnPlayBg.width, btnPlayBg.height);
        btnStopBg.alpha = 0;
        btnStopBg.x = btnPlayBg.x;
        btnStopBg.y = btnPlayBg.y;
        btnStopBg.addChild(btnStop);
        bg.addChild(btnStopBg);
        btnStopBg.visible = false;
        this.btnStop = btnStopBg;

        this.progressInitX = 42 * this.scaleX;

        const progressBar = new MySprite();
        progressBar.init(this.images.get("bg_audio_progress_bar"));
        progressBar.scaleX = this.scaleX;
        progressBar.scaleY = this.scaleY;
        progressBar.x = this.progressInitX + progressBar.getBoundingBox().width / 2;
        progressBar.y = 37 * this.scaleY + progressBar.getBoundingBox().height / 2;
        bg.addChild(progressBar);
        this.progressVal = progressBar.getBoundingBox().width;

        const progress = new ShapeRectNew();
        progress.setSize(0, progressBar.getBoundingBox().height, 13 * this.scaleX);
        progress.x = this.progressInitX;
        progress.y = 37 * this.scaleY;
        progress.fillColor = "#c80df3";
        bg.addChild(progress);
        this.progress = progress;

        const progressBtn = new MySprite();
        progressBtn.init(this.images.get("processBtn"), 0.5, 0);
        progressBtn.scaleX = this.scaleX;
        progressBtn.scaleY = this.scaleY;
        progressBtn.x = this.progressInitX;
        progressBtn.y = progress.y - (progressBtn.getBoundingBox().height - progress.height) / 2;
        bg.addChild(progressBtn);
        this.progressBtn = progressBtn;
        this.curX = progressBtn.x;

        const timeLabel = () => {
            const timeLabel = new Label();
            timeLabel.text = "0:00";
            timeLabel.fontColor = "#dc8300";
            timeLabel.fontSize = 26;
            timeLabel.fontName = "BRLNSR";
            timeLabel.scaleX = this.scaleX;
            timeLabel.scaleY = this.scaleY;
            timeLabel.textAlign = 'middle';
            timeLabel.refreshSize();
            return timeLabel;
        }

        const totalTime = timeLabel();
        totalTime.x = 343 * this.scaleX;
        totalTime.y = 70 * this.scaleY + totalTime.getBoundingBox().height / 2;
        bg.addChild(totalTime);
        this.totalTimeLabel = totalTime;

        const curTime = timeLabel();
        curTime.x = 55 * this.scaleX;
        curTime.y = totalTime.y;
        bg.addChild(curTime);
        this.curTimeLabel = curTime;

        const autoCover = new MySprite();
        autoCover.init(this.images.get("auto_cover"), 0, 0);
        autoCover.scaleX = this.scaleX;
        autoCover.scaleY = this.scaleY;
        autoCover.x = (bg.width - autoCover.getBoundingBox().width) / 2;
        autoCover.y = bg.height - autoCover.getBoundingBox().height - 17 * this.scaleY;
        bg.addChild(autoCover);
    }

    setAudio(audio) {
        if (!audio) {
            this.bg.visible = false;
        }
        else {
            this.bg.visible = true;
            this.btnPlay.visible = true;
            this.btnStop.visible = false;

            audio.currentTime = 0;
        }

        this.curAudio = audio;

        let playingTime = this.getPlayingTime();

        let time = this.getTimeStr(playingTime.totalTime);
        this.totalTimeLabel.text = time;

        this.setPlayInfo(playingTime);
    }

    /**
     * 
     * @param now true-重新开始播放，flase-继续播放
     * @param callback 
     */
    playAudio(now = false, callback = null) {

        if (!this.curAudio) {
            return;
        }

        this.ended = false;

        this.paused = false;

        this.showPlayStatus();

        this.showTime();

        playAudio(this.curAudio, now, () => {
            this.ended = true;

            this.showPlayStatus();

            if (callback) {
                callback();
            }
        });

    }

    /**
     * 暂停播放音频
     * @param reset 暂停是否重置：true-是，false-否
     * @param callback 
     */
    pauseAudio(reset = false, callback = null) {

        if (!this.paused) {
            if (!this.curAudio) {
                return;
            }
            pauseAudio(this.curAudio, reset);

            this.paused = true;

            this.showPlayStatus();
        }

        if (callback) {
            callback();
        }
    }

    getPlayingTime() {
        if (!this.curAudio) {
            return { totalTime: 0, curTime: 0 };
        }

        return { totalTime: this.curAudio.duration, curTime: this.curAudio.currentTime }
    }

    getTotalTime() {
        if (!this.curAudio) {
            return 0;
        }

        return this.curAudio.duration;
    }

    touchProBtn(mx: number) {
        this.touchX = mx;
        this.curX = this.progressBtn.x;
        this.touched = true;
    }

    drag2(toX: number, callback = null) {
        let dis = toX - this.touchX;

        this.drag(dis, callback);
    }

    /**
     * 滚动条拖动
     * @param dis 拖动距离
     * @param callback 拖动后执行函数
     */
    drag(dis: number, callback = null) {


        let newX = this.curX + dis;

        if (newX < this.progressInitX) {
            newX = this.progressInitX;
        }
        else if (newX > this.progressInitX + this.progressVal) {
            newX = this.progressInitX + this.progressVal;
        }

        this.progressBtn.x = newX;

        let distence = newX - this.progressInitX;

        this.setTimeByPercent(distence / this.progressVal);
        this.setPlayInfo(this.getPlayingTime());

        if (callback) {
            callback();
        }
    }

    /**
     * 根据百分设置当前播放时间
     * @param percent 百分比
     * @param play 是否立即播放
     */
    setTimeByPercent(percent: number, play = false) {
        if (!this.curAudio) {
            return;
        }

        let curTime = 0

        if (percent > 1) {
            curTime = this.curAudio.duration;
        }
        else if (percent < 0) {
            curTime = 0;
        }
        else {
            curTime = percent * this.curAudio.duration;
        }

        this.setTime(curTime, play);
    }

    /**
     * 设置播放时间
     * @param time 当前播放时间
     * @param play 是否立即播放
     */
    setTime(time: number, play = false) {

        if (!this.curAudio) {
            return;
        }

        let curTime = 0

        if (time > this.curAudio.duration) {
            curTime = this.curAudio.duration;
        }
        else if (time < 0) {
            curTime = 0;
        }
        else {
            curTime = time;
        }

        this.curAudio.currentTime = curTime;

        if (play) {
            this.curAudio.play();
        }
    }

    showPlayStatus() {

        this.btnPlay.visible = !this.btnPlay.visible;
        this.btnStop.visible = !this.btnPlay.visible;
    }

    showTime() {

        if (this.ended || this.paused) {
            return;
        }

        setTimeout(() => {
            let playingTime = this.getPlayingTime();

            this.setPlayInfo(playingTime);

            this.showTime();
        }, 100);
    }

    setPlayInfo(playingTime) {
        this.progressBtn.x = this.progressInitX + playingTime.curTime / playingTime.totalTime * this.progressVal;
        this.progress.width = this.progressVal * playingTime.curTime / playingTime.totalTime;
        let time = this.getTimeStr(playingTime.curTime);
        this.curTimeLabel.text = time;
    }

    private getTimeStr(time: number) {
        if (!time) {
            return "0:00";
        }

        let sec = Math.ceil(time % 60);

        let timeStr = Math.floor(time / 60) + ":" + (sec < 10 ? "0" + sec : sec);

        return timeStr;
    }
}

/**
 * 
 * @param audio 音频
 * @param now true-重新开始播放，flase-继续播放
 * @param callback 
 */
export function playAudio(audio, now = false, callback = null) {

    if (audio) {
        if (now) {
            audio.pause();
            audio.currentTime = 0;
        }

        if (callback) {
            audio.onended = () => {
                callback();
            };
        }
        audio.play();
    }
}

/**
 * 暂停播放音频
 * @param audio 音频 
 * @param reset 暂停是否重置：true-是，false-否
 * @param callback 
 */
export function pauseAudio(audio, reset = false, callback = null) {

    if (audio) {

        if (reset) {
            audio.currentTime = 0;
        }

        audio.pause();

        if (callback) {
            callback();
        }
    }
}