
import { text } from '@fortawesome/fontawesome-svg-core';
import { start } from 'repl';
import { LetterBean } from '../bean/ExercisesBean';
import { Label, Label2, ShapeRectNew, ShapeRect, LineRect, MySprite, Line, LabelText, ShapeCircle } from './Unit';

export class Exercises {

    data;

    bg: ShapeRectNew;

    indexLabel: Label;

    indexBg1: MySprite;

    images;

    index: number;

    answered: Boolean = false;

    wordBgArr: Array<Word> = [];

    shown = false;


    init(images, data) {

        this.images = images;

        this.data = data;


        let height = 248;

        let width = 470;

        const bg = new ShapeRectNew();
        bg.alpha = 0;
        bg.fillColor = "#000000";
        bg.setSize(width, height, 0);
        this.bg = bg;

        const textBg = new ShapeRect();
        textBg.setSize(width, 82);
        textBg.alpha = 0;
        textBg.x = 0;
        textBg.y = bg.height - textBg.height;
        bg.addChild(textBg);

        const textBgPic = new MySprite();
        textBgPic.init(this.images.get('content_bg'));
        textBgPic.x = bg.width / 2;
        textBgPic.y = textBg.height / 2;

        textBg.addChild(textBgPic);

        this.initIndex(textBg);

        //初始化单词
        this.initContent(textBg);

        //初始化图片
        this.initPic();

        this.answered = false;
    }

    private initIndex(parent: ShapeRect) {


        const indexBg1 = new MySprite();
        indexBg1.init(this.images.get('index_bg'));
        indexBg1.x = 18 + indexBg1.width / 2;
        indexBg1.y = parent.getBoundingBox().height / 2 - 4;
        parent.addChild(indexBg1);
        this.indexBg1 = indexBg1;

        const indexLabel = new Label();
        indexLabel.fontName = "FUTURAB";
        indexLabel.fontSize = 36;
        indexLabel.text = '' + this.index;
        indexLabel.fontColor = "#567790";
        indexLabel.alpha = 0;
        indexLabel.refreshSize();
        indexLabel.x = 18 + (50 - indexLabel.getBoundingBox().width) / 2;
        indexLabel.y = parent.height / 2;
        parent.addChild(indexLabel);
        this.indexLabel = indexLabel;
    }

    private initPic() {
        const pic = new MySprite();
        pic.init(this.images.get(this.data.picUrl));

        let w = pic.width;
        let h = pic.height;

        let scaleX = this.bg.width / w;

        let scaleY = 150 / h;

        let mapScale = Math.min(scaleX, scaleY);
        //如果超过最大，则进行缩小
        if (mapScale < 1) {
            pic.setScaleXY(mapScale);
        }

        pic.x = this.bg.width / 2;
        pic.y = 150 / 2;
        console.log(pic.y);
        this.bg.addChild(pic);
    }

    private initContent(parent: ShapeRect) {

        const getLetterLabel = (letter) => {

            const label = new Label();
            label.fontName = "GOTHIC";
            label.fontSize = 32;
            label.text = letter.val;
            if (letter.isFill == '1') {
                label.fontColor = "#c8161e";
            }
            else {
                label.fontColor = "#dcdddd";
            }
            label.refreshSize();
            label.y = parent.height / 2;

            return label;
        }

        const wordLabelArr = [];


        let startX = 89;

        for (let i = 0; i < this.data.wordArr.length; ++i) {

            let word = this.data.wordArr[i];

            let tX = startX;

            let totalW = 0;

            let tH = 0;

            const wordObj = new Word();

            for (let j = 0; j < word.letterArr.length; ++j) {

                let letter = word.letterArr[j]

                let label = getLetterLabel(letter);
                parent.addChild(label);

                let letterObj = new Letter();
                letterObj.letter = label;
                letterObj.isFill = letter.isFill;
                wordObj.letterArr.push(letterObj);  

                let w = Math.ceil(label.getBoundingBox().width);

                tH = Math.ceil(label.getBoundingBox().height);

                let dw = 3;

                //如果是填空，则增加下划线
                if (letter.isFill == '1') {

                    startX += dw;

                    label.x = startX;

                    let underLine = new Line();
                    underLine.lineColor = "#858585";
                    underLine.lineWidth = 3;
                    underLine.y = label.y + label.getBoundingBox().height / 2;
                    underLine.x = startX;
                    underLine.setLine(w);
                    parent.addChild(underLine);

                    w += dw;
                    label.alpha = 0;
                    wordLabelArr.push(label);

                }
                else {

                    if (word.letterArr[j - 1] && word.letterArr[j - 1].isFill == '1') {
                        startX += dw;
                    }

                    label.x = startX;
                }

                startX += w;
                totalW += w;
            }

            //不是末位，增加空格
            if (i != this.data.wordArr.length - 1) {
                let blank = new LetterBean();
                blank.val = " ";
                let label = getLetterLabel(blank);
                wordLabelArr.push(label);
                startX += label.getBoundingBox().width;
            }

            const wordBg = new ShapeRect();
            wordBg.alpha = 0;
            wordBg.setSize(totalW, tH);
            wordBg.x = tX;
            wordBg.y = (parent.height - tH) / 2;
            wordObj.bg = wordBg
            this.wordBgArr.push(wordObj);
            parent.addChild(wordBg);
        }
    }


    checkAnswer(answerIndex) {

        if (this.data.answerIndex == answerIndex) {

            this.indexLabel.alpha = 1;
            this.answered = true;

            return true;
        }

        return false;
    }

    showWord(index){
        
        let word = this.wordBgArr[index];

        if(!word){
            return;
        }

        if(this.shown){
            return;
        }

        for(let i =0; i < word.letterArr.length; ++ i){
            word.letterArr[i].letter.alpha = 1;
        }

        let exsit = false;

        for(let i = 0; i < this.wordBgArr.length; ++ i){

            let tWord = this.wordBgArr[i];

            for(let j =0; j < tWord.letterArr.length; ++ j){
                
                if(tWord.letterArr[j].letter.alpha == 0){
                    exsit = true;
                    break;
                }
            }

            //如果存在，则直接跳出
            if(exsit){
                break;
            }
        }

        if(!exsit){
            this.shown = true;

            //处理单词显示
            for(let i = 0; i < this.wordBgArr.length; ++ i){

                let tWord = this.wordBgArr[i];
    
                for(let j =0; j < tWord.letterArr.length; ++ j){
                    
                    let letter = tWord.letterArr[j];

                    //修改字体颜色
                    if(letter.isFill == '0'){
                        letter.letter.fontColor = '#000000';
                    }
                }
    
            }
        }
    }
}

export class Word{

    bg : ShapeRect;

    letterArr : Array<Letter> = [];

    
}

export class Letter{

    letter : Label;

    isFill : String = '0';
}