import { MySprite } from './Unit';

interface AirWindow extends Window {
    air: any;
    curCtx: any;
}
declare let window: AirWindow;

export class Item {
    /**图片集合 */
    images;

    audioObj;

    _scaleX = 1;

    _scaleY = 1;

    ctx;

    _width = 0;

    _height = 0;

    _x = 0;

    _y = 0;

    constructor(images, audioObj, scaleX = 1, scaleY = 1, ctx = null) {
        this.images = images;
        this.audioObj = audioObj;
        this._scaleX = scaleX;
        this._scaleY = scaleY;

        if (!ctx) {
            this.ctx = window.curCtx;
        } else {
            this.ctx = ctx;
        }
    }

    set width(width){
        this._width = width * this.scaleX;
    }
    get width(){
        return this._width;
    }

    set height(height){
        this._height = height * this.scaleY;
    }

    get height(){
        return this._height;
    }

    set scaleX(v) {
        this._scaleX = v;
    }
    get scaleX() {
        return this._scaleX;
    }

    set scaleY(v) {
        this._scaleY = v;
    }
    get scaleY() {
        return this._scaleY;
    }

    set x(x){
        this._x = x;
    }

    get x(){
        return this._x;
    }

    set y(y){
        this._y = y;
    }

    get y(){
        return this._y;
    }

    getPic(picName, anchorX: number = 0.5, anchorY: number = 0.5) {
        const pic = new MySprite();
        pic.init(this.images.get(picName), anchorX, anchorY);
        pic.scaleX = this.scaleX;
        pic.scaleY = this.scaleY;
        pic.x = 0;
        pic.y = 0;
        return pic;
    }

    checkClickTarget(target, mx: number, my: number) {

        const rect = target.getBoundingBox();

        if (this.checkPointInRect(mx, my, rect)) {
            return true;
        }
        return false;
    }

    checkPointInRect(x, y, rect) {
        if (x >= rect.x && x <= rect.x + rect.width) {
            if (y >= rect.y && y <= rect.y + rect.height) {
                return true;
            }
        }
        return false;
    }
}