
import {
    Label,
    MySprite, ShapeRect,

} from './Unit';

import {
    playAudio,
    pauseAudio

} from './AudioUtil';

export class Title {

    titleBg: ShapeRect;

    audio;

    images;

    titleData;


    constructor(titleData, images) {

        this.titleData = titleData;

        this.images = images;
    }

    init(mapScaleX = 1, mapScaleY = 1) {

        let titleBg = new ShapeRect();

        //初始化标题1背景
        const titePart1Bg = new ShapeRect();
        titePart1Bg.fillColor="#567790";
        let pWidth = 117 * mapScaleX;
        let pHeight = 65 * mapScaleY;
        titePart1Bg.setSize(pWidth, pHeight);
        titePart1Bg.setShadow(4,4,0, 'rgba(0, 0, 0, 0.2)');
        titePart1Bg.x = 0;
        
        titleBg.addChild(titePart1Bg);

        //标题1内容
        const part1 = new Label();
        part1.text = this.titleData.part1;
        part1.textAlign = 'left';
        part1.fontSize = 48;
        part1.fontName = "BRLNSDB";
        part1.fontColor = "#ffffff";
        part1.setScaleXY(mapScaleX);
        part1.refreshSize();
        part1.x = pWidth - part1.getBoundingBox().width - 13 * mapScaleX;
        part1.y = 5 * mapScaleY + part1.getBoundingBox().height / 2;
        titleBg.addChild(part1);

        //标题2内容
        const part2 = new Label();
        part2.text = this.titleData.part2;
        part2.fontSize = 36;
        part2.fontName = "FUTURA";
        part2.fontColor = "#000000";
        part2.setScaleXY(mapScaleX);
        part2.refreshSize();
        part2.x = titePart1Bg.getBoundingBox().width + 11 * mapScaleX;
        part2.y = 16 * mapScaleY + part2.getBoundingBox().height / 2;

        let height = Math.max(titePart1Bg.getBoundingBox().height, part2.getBoundingBox().height);
        let width = titePart1Bg.getBoundingBox().width + part2.getBoundingBox().width + 11 * mapScaleX;

        titePart1Bg.y = (height - pHeight)/2;
        
        titleBg.setSize(width, height);
        titleBg.alpha = 0;

        titleBg.addChild(part2);

        this.titleBg = titleBg;
    }

    getTitleBg(){
        return this.titleBg;
    }

    setAudio(audio){
        this.audio = audio;
    }

    playAudio(callback = null){
        playAudio(this.audio, true, callback);
        return this.audio;
    }

    pasueAudio(callback){
        pauseAudio(this.audio, true, callback)
    }
}