import { Component, ElementRef, ViewChild, OnInit, Input, OnDestroy, HostListener } from '@angular/core';

import {
  MySprite,
  ShapeRectNew

} from './Unit';
import { res, resAudio } from './resources';

import { Subject } from 'rxjs';
import { debounceTime } from 'rxjs/operators';

import TWEEN from '@tweenjs/tween.js';

import { Title } from './Title';

import { Listening } from './Listening';
import { Exercises} from './Exercises';
import { getDefaultExercisesBean, getDefaultLetterBean } from '../bean/ExercisesBean';
import { getDefaultTitle } from '../bean/TitleBean';


@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.css']
})
export class PlayComponent implements OnInit, OnDestroy {

  @ViewChild('canvas', { static: true }) canvas: ElementRef;
  @ViewChild('wrap', { static: true }) wrap: ElementRef;

  // 数据
  data;

  ctx;

  canvasWidth = 1280; // canvas实际宽度
  canvasHeight = 720; // canvas实际高度

  canvasBaseW = 1280; // canvas 资源预设宽度
  canvasBaseH = 720;  // canvas 资源预设高度

  mx; // 点击x坐标
  my; // 点击y坐标


  // 资源
  rawImages = new Map(res);
  rawAudios = new Map(resAudio);

  images = new Map();

  animationId: any;
  winResizeEventStream = new Subject();

  audioObj = {};

  //A皮肤显示框
  skinRenderArr = [];

  renderArr = [];
  mapScale = 1;

  canvasLeft;
  canvasTop;

  saveKey = 'YM4-10';

  canTouch = true;

  /**标题*/
  title: Title;

  listening: Listening;

  curAudio;

  exercisesArr: Array<Exercises> = [];

  curIndex = 0;

  @HostListener('window:resize', ['$event'])
  onResize(event) {
    this.winResizeEventStream.next();
  }


  ngOnInit() {

    this.data = {};

    // 获取数据
    const getData = (<any>window).courseware.getData;
    getData((data) => {

      if (data && typeof data == 'object') {
        this.data = data;
      }
      // console.log('data:' , data);

      // 初始化 各事件监听
      this.initListener();

      // 若无数据 则为预览模式 需要填充一些默认数据用来显示
      this.initDefaultData();

      // 初始化 音频资源
      this.initAudio();
      // 初始化 图片资源
      this.initImg();
      // 开始预加载资源
      this.load();

    }, this.saveKey);

  }

  ngOnDestroy() {
    window['curCtx'] = null;
    window.cancelAnimationFrame(this.animationId);
  }


  load() {

    // 预加载资源
    this.loadResources().then(() => {
      window["air"].hideAirClassLoading(this.saveKey, this.data);
      this.init();
      this.update();
    });
  }


  init() {

    this.initCtx();
    this.initData();
    this.initView();

    this.canTouch = true;

    this.playAudio('page', true);
  }

  initCtx() {
    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;
    this.canvas.nativeElement.width = this.wrap.nativeElement.clientWidth;
    this.canvas.nativeElement.height = this.wrap.nativeElement.clientHeight;


    this.ctx = this.canvas.nativeElement.getContext('2d');
    this.canvas.nativeElement.width = this.canvasWidth;
    this.canvas.nativeElement.height = this.canvasHeight;

    window['curCtx'] = this.ctx;
  }






  updateItem(item) {
    if (item) {
      item.update();
    }
  }

  updateArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].update(this);
    }
  }







  initListener() {

    this.winResizeEventStream
      .pipe(debounceTime(500))
      .subscribe(data => {
        this.renderAfterResize();
      });


    // ---------------------------------------------
    const setParentOffset = () => {
      const rect = this.canvas.nativeElement.getBoundingClientRect();
      this.canvasLeft = rect.left;
      this.canvasTop = rect.top;
    };
    const setMxMyByTouch = (event) => {
      if (event.touches.length <= 0) {
        return;
      }
      if (this.canvasLeft == null) {
        setParentOffset();
      }
      this.mx = event.touches[0].pageX - this.canvasLeft;
      this.my = event.touches[0].pageY - this.canvasTop;
    };

    const setMxMyByMouse = (event) => {
      this.mx = event.offsetX;
      this.my = event.offsetY;
    };
    // ---------------------------------------------


    let firstTouch = true;

    const touchDownFunc = (e) => {
      if (firstTouch) {
        firstTouch = false;
        removeMouseListener();
      }
      setMxMyByTouch(e);
      this.mapDown(e);
    };
    const touchMoveFunc = (e) => {
      setMxMyByTouch(e);
      this.mapMove(e);
    };
    const touchUpFunc = (e) => {
      setMxMyByTouch(e);
      this.mapUp(e);
    };

    const mouseDownFunc = (e) => {
      if (firstTouch) {
        firstTouch = false;
        removeTouchListener();
      }
      setMxMyByMouse(e);
      this.mapDown(e);
    };
    const mouseMoveFunc = (e) => {
      setMxMyByMouse(e);
      this.mapMove(e);
    };
    const mouseUpFunc = (e) => {
      setMxMyByMouse(e);
      this.mapUp(e);
    };


    const element = this.canvas.nativeElement;

    const addTouchListener = () => {
      element.addEventListener('touchstart', touchDownFunc);
      element.addEventListener('touchmove', touchMoveFunc);
      element.addEventListener('touchend', touchUpFunc);
      element.addEventListener('touchcancel', touchUpFunc);
    };
    const removeTouchListener = () => {
      element.removeEventListener('touchstart', touchDownFunc);
      element.removeEventListener('touchmove', touchMoveFunc);
      element.removeEventListener('touchend', touchUpFunc);
      element.removeEventListener('touchcancel', touchUpFunc);
    };

    const addMouseListener = () => {
      element.addEventListener('mousedown', mouseDownFunc);
      element.addEventListener('mousemove', mouseMoveFunc);
      element.addEventListener('mouseup', mouseUpFunc);
    };
    const removeMouseListener = () => {
      element.removeEventListener('mousedown', mouseDownFunc);
      element.removeEventListener('mousemove', mouseMoveFunc);
      element.removeEventListener('mouseup', mouseUpFunc);
    };

    addMouseListener();
    addTouchListener();
  }


  playAudio(key, now = false, callback = null) {

    const audio = this.audioObj[key];
    if (audio) {
      if (now) {
        audio.pause();
        audio.currentTime = 0;
      }

      if (callback) {
        audio.onended = () => {
          callback();
        };
      }
      audio.play();
    }
  }

  pauseAudio(key, callback = null) {

    const audio = this.audioObj[key];
    if (audio) {

      if (callback) {
        audio.onended = () => {
          callback();
        };
      }
      audio.pause();
    }
  }

  loadResources() {
    const pr = [];
    this.rawImages.forEach((value, key) => {// 预加载图片

      const p = this.preload(value)
        .then(img => {
          this.images.set(key, img);
        })
        .catch(err => console.log(err));

      pr.push(p);
    });

    this.rawAudios.forEach((value, key) => {// 预加载音频

      const a = this.preloadAudio(value)
        .then(() => {
          // this.images.set(key, img);
        })
        .catch(err => console.log(err));

      pr.push(a);
    });
    return Promise.all(pr);
  }

  preload(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      // img.crossOrigin = "anonymous";
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = url;
    });
  }

  preloadAudio(url) {
    return new Promise((resolve, reject) => {
      const audio = new Audio();
      audio.oncanplay = (a) => {
        resolve();
      };
      audio.onerror = () => {
        reject();
      };
      audio.src = url;
      audio.load();
    });
  }


  renderAfterResize() {
    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;
    this.init();
  }





  checkClickTarget(target) {

    const rect = target.getBoundingBox();
    
    if (this.checkPointInRect(this.mx, this.my, rect)) {
      return true;
    }
    return false;
  }

  getWorlRect(target) {

    let rect = target.getBoundingBox();

    if (target.parent) {

      const pRect = this.getWorlRect(target.parent);
      rect.x += pRect.x;
      rect.y += pRect.y;
    }
    return rect;
  }

  checkPointInRect(x, y, rect) {
    if (x >= rect.x && x <= rect.x + rect.width) {
      if (y >= rect.y && y <= rect.y + rect.height) {
        return true;
      }
    }
    return false;
  }





  addUrlToAudioObj(key, url = null, vlomue = 1, loop = false, callback = null) {

    const audioObj = this.audioObj;

    if (url == null) {
      url = key;
    }

    if (!key) {
      return;
    }

    this.rawAudios.set(key, url);

    const audio = new Audio();
    audio.src = url;
    audio.load();
    audio.loop = loop;
    audio.volume = vlomue;

    audioObj[key] = audio;

    if (callback) {
      audio.onended = () => {
        callback();
      };
    }
  }

  addUrlToImages(url) {
    this.rawImages.set(url, url);
  }

  addUrlToImage(url, key) {
    if (!key) {
      key = url;
    }

    this.rawImages.set(key, url);
  }




  // ======================================================编写区域==========================================================================





  /**
   * 添加默认数据 便于无数据时的展示
   */
  initDefaultData() {

    if (!this.data.exercisesArr) {

      this.data.exercisesArr = [];

      for (let i = 0; i < 4; ++i) {

        let exercises = getDefaultExercisesBean();

        exercises.answerIndex = i + 1;
   

        this.data.exercisesArr.push(exercises);

      }

    }

    if (!this.data.title) {
      this.data.title = getDefaultTitle();
    }

    //设置默认皮肤
    if (!this.data.skin) {
      this.data.skin = 'A';
    }
  }


  /**
   * 添加预加载图片
   */
  initImg() {

    //练习题图片
    for (let i = 0; i < this.data.exercisesArr.length; ++i) {

      let exercises = this.data.exercisesArr[i];

      if (exercises.picUrl) {
        this.addUrlToImages(exercises.picUrl);
      }

    }

    const loadBg = (skin, skinType) => {
      if (skin.lt.picUrl) {
        this.addUrlToImage(skin.lt.picUrl, skinType + "_" + skin.lt.picUrl);
      }

      if (skin.lm.picUrl) {
        this.addUrlToImage(skin.lm.picUrl, skinType + "_" + skin.lm.picUrl);
      }

      if (skin.lb.picUrl) {
        this.addUrlToImage(skin.lb.picUrl, skinType + "_" + skin.lb.picUrl);
      }

      if (skin.mt.picUrl) {
        this.addUrlToImage(skin.mt.picUrl, skinType + "_" + skin.mt.picUrl);
      }

      if (skin.mb.picUrl) {
        this.addUrlToImage(skin.mb.picUrl, skinType + "_" + skin.mb.picUrl);
      }

      if (skin.rt.picUrl) {
        this.addUrlToImage(skin.rt.picUrl, skinType + "_" + skin.rt.picUrl);
      }

      if (skin.rm.picUrl) {
        this.addUrlToImage(skin.rm.picUrl, skinType + "_" + skin.rm.picUrl);
      }

      if (skin.rb.picUrl) {
        this.addUrlToImage(skin.rb.picUrl, skinType + "_" + skin.rb.picUrl);
      }
    }

    if (this.data.skinA) {
      loadBg(this.data.skinA, 'A');
    }

    if (this.data.skinB) {
      loadBg(this.data.skinB, 'B');
    }

  }

  /**
   * 添加预加载音频
   */
  initAudio() {

    // 音效
    this.addUrlToAudioObj('click', this.rawAudios.get('click'), 0.3);

    this.addUrlToAudioObj('page', this.rawAudios.get('page'));

    this.addUrlToAudioObj('right', this.rawAudios.get('right'));


    //标题发音
    if (this.data.title.audioUrl) {
      this.addUrlToAudioObj('titleAudio', this.data.title.audioUrl);
    }


    //听力材料
    if (this.data.listenAudioUrl) {
      this.addUrlToAudioObj('listenAudio', this.data.listenAudioUrl);
    }


    //练习题音效
    for (let i = 0; i < this.data.exercisesArr.length; ++i) {

      let exercises = this.data.exercisesArr[i];

      this.addUrlToAudioObj('index_' + i, exercises.audioUrl);

      let wordArr = exercises.wordArr;

      for(let j = 0; j < wordArr.length; ++ j){
        this.addUrlToAudioObj('word_' + i + '_' + j, wordArr[j].audioUrl);
      }
    }

  }



  /**
   * 初始化数据
   */
  initData() {

    const sx = this.canvasWidth / this.canvasBaseW;
    const sy = this.canvasHeight / this.canvasBaseH;
    const s = Math.min(sx, sy);
    this.mapScale = s;

    this.renderArr = [];

    this.skinRenderArr = [];

    this.listening = null;

    this.curIndex = 0;

    if (this.curAudio) {
      this.curAudio.pause();
    }

    this.curAudio = null;

    this.exercisesArr = [];


  }



  /**
   * 初始化试图
   */
  initView() {


    this.initBg();

    this.initTitle();

    this.initBottomPart();

    this.initExercises();
  }

  initBg() {

    const getPic = (key, anchorX: number = 0.5, anchorY: number = 0.5) => {
      const pic = new MySprite();
      pic.init(this.images.get(key), anchorX, anchorY);
      pic.setScaleXY(this.mapScale);
      this.skinRenderArr.push(pic);
      return pic;
    }

    const initBg = (skin, skinType) => {

      //左上
      if (skin.lt.picUrl) {
        const pic = getPic(skinType + '_' + skin.lt.picUrl, 0, 0);
        pic.x = 0;
        pic.y = 0;

      }

      //左中
      if (skin.lm.picUrl) {
        const pic = getPic(skinType + '_' + skin.lm.picUrl, 0);
        pic.x = 0;
        pic.y = (this.canvasHeight - pic.getBoundingBox().height) / 2;
      }

      //左下
      if (skin.lb.picUrl) {
        const pic = getPic(skinType + '_' + skin.lb.picUrl, 0, 1);
        pic.x = 0;
        pic.y = this.canvasHeight;
      }

      //中上
      if (skin.mt.picUrl) {
        const pic = getPic(skinType + '_' + skin.mt.picUrl, 0.5, 0);
        pic.x = this.canvasWidth / 2;
        pic.y = 0;
      }

      //中下
      if (skin.mb.picUrl) {
        const pic = getPic(skinType + '_' + skin.mb.picUrl, 0.5, 1);
        pic.x = this.canvasWidth / 2;
        pic.y = this.canvasHeight;
      }

      //右上
      if (skin.rt.picUrl) {
        const pic = getPic(skinType + '_' + skin.rt.picUrl, 1, 0);
        pic.x = this.canvasWidth;
        pic.y = 0;
      }

      //右中
      if (skin.rm.picUrl) {
        const pic = getPic(skinType + '_' + skin.rm.picUrl, 1, 0.5);
        pic.x = this.canvasWidth;
        pic.y = this.canvasHeight / 2;
      }

      //右下
      if (skin.rb.picUrl) {
        const pic = getPic(skinType + '_' + skin.rb.picUrl, 1, 1);
        pic.x = this.canvasWidth;
        pic.y = this.canvasHeight;
      }
    }

    if (this.data.skin === 'A') {
      if (this.data.skinA) {
        initBg(this.data.skinA, 'A');
      }
    }
    else {
      if (this.data.skinB) {
        initBg(this.data.skinB, 'B');
      }
    }
  }

  initBottomPart() {

    const listening = new Listening(this.audioObj['listenAudio'], this.images);
    listening.init(this.mapScale, this.mapScale);

    listening.bg.x = this.canvasWidth - listening.bg.width - 10 * this.mapScale;
    listening.bg.y = this.canvasHeight - listening.bg.height - 8 * this.mapScale;
    this.listening = listening;

    this.renderArr.push(listening.bg);
  }

  initTitle() {
    const title = new Title(this.data.title, this.images);

    title.init(this.mapScale, this.mapScale);
    title.audio = this.audioObj['titleAudio'];
    this.title = title;

    title.titleBg.y = 0;
    title.titleBg.x = 0;

    this.renderArr.push(title.titleBg);
  }

  initExercises() {


    var dW = 586 * this.mapScale;

    var dH = 311 * this.mapScale;

    let col = 2;

    let rows = Math.ceil(this.data.exercisesArr.length / col);

    let startX = (this.canvasWidth - (col - 1) * dW) / 2;

    let startY = 7 * this.mapScale + (this.canvasHeight - 7 * this.mapScale - ((rows - 1) * 63 * this.mapScale + rows * 248 * this.mapScale)) / 2;


    let tempX = startX;

    for (let i = 0; i < this.data.exercisesArr.length; ++i) {

      let item = this.data.exercisesArr[i];
      
      let exercises = new Exercises();
      exercises.index = i + 1;
      exercises.init(this.images, item);
      exercises.bg.setScaleXY(this.mapScale);
      this.renderArr.push(exercises.bg);

      this.exercisesArr.push(exercises);

      exercises.bg.x = startX - exercises.bg.getBoundingBox().width / 2;
      exercises.bg.y = startY;

      //换行
      if ((i + 1) % col == 0) {
        startX = tempX;
        startY += dH;
      }
      else {
        startX += dW;
      }

    }

  }



  mapDown(event) {

    if (!this.canTouch) {
      return;
    }

    if (this.curAudio) {
      if (this.curAudio != this.listening.audio) {
        this.curAudio.pause();
      }
    }

    if (this.checkClickTarget(this.listening.bg)) {

      this.curAudio = this.listening.play(() => {
        this.listening.reset();
      });

      return;
    }

    if (this.curAudio) {
      if (this.curAudio == this.listening.audio) {
        this.listening.pauseAudio();
      }
      else {
        this.curAudio.pause();
      }

    }

    if (this.checkClickTarget(this.title.titleBg)) {
      this.curAudio = this.title.playAudio();
      return;
    }

    let clicked = false;
    
    for (let i = 0; i < this.exercisesArr.length; ++i) {
      
      let exercises = this.exercisesArr[i];

      if(this.checkClickTarget(exercises.bg)){
        this.clickExercises(exercises, i);
      }
    }

    if (clicked) {
      return;
    }

  }

  mapMove(event) {

  }

  mapUp(event) {

  }



  update() {

    // ----------------------------------------------------------
    this.animationId = window.requestAnimationFrame(this.update.bind(this));
    // 清除画布内容
    this.ctx.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
    // tween 更新动画
    TWEEN.update();
    // ----------------------------------------------------------

    this.updateArr(this.skinRenderArr);

    this.updateArr(this.renderArr);


  }

  clickExercises(exercises: Exercises, index:number){

    if(!exercises){
      return;
    }

    if(!exercises.answered){

      if(this.checkClickTarget(exercises.indexBg1)){
        let flag = exercises.checkAnswer(this.curIndex + 1);
        
        if(flag){

          this.curIndex ++;

          this.playAudio('right', true, ()=>{
            let key = 'index_' + index;
            this.curAudio = this.audioObj[key];
  
            this.playAudio(key, true);
          });
        }
      }

      
    }
    else{
      if(this.checkClickTarget(exercises.indexBg1)){
        let key = 'index_' + index;
        this.curAudio = this.audioObj[key];
  
        this.playAudio(key, true);
        return;
      }

      for(let i = 0; i < exercises.wordBgArr.length; ++ i){

        let wordBg = exercises.wordBgArr[i];

        if(this.checkClickTarget(wordBg.bg)){

          exercises.showWord(i);
          let key = 'word_' + index + '_' + i;
          this.curAudio = this.audioObj[key];
          this.playAudio(key, true);        

          break;
        }

      }
    }
  }
}
