import {Component, EventEmitter, Input, Output } from '@angular/core';  

@Component({
  selector: 'app-background-upload',
  templateUrl: './background-upload.component.html',
  styleUrls: ['./background-upload.component.scss']
}) 
export class BackgroundUploadComponent {

  @Input() items = {"leftTop": '', "middleTop": '', "rightTop": '', "leftMiddle": '', "rightMiddle": '', "leftBottom": '', "middleBottom": '', "rightBottom": ''};
  @Output() change = new EventEmitter();
  constructor( ) { }

  onImageUploadSuccess(e, items, key) {
    items[key] = e.url;
    this.change.emit(items)
  }

}
