import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { AnswerBean, getDefaultExercises, getDefaultLetter } from '../bean/Exercises';
import { getDefaultTile } from '../bean/TitleBean';
import { NzMessageService } from 'ng-zorro-antd/message'


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "YM5-3";
  // 储存对象
  item;


  constructor(private appRef: ApplicationRef, private changeDetectorRef: ChangeDetectorRef, private message: NzMessageService) {

  }


  ngOnInit() {

    this.item = {};

    this.item.skinA = {};

    this.item.skin = 'A';

    this.item.title = getDefaultTile();

    this.item.letterArr = [];

    /**练习题区域 */
    this.item.zoneArr = [];


    // 获取存储的数据
    (<any>window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

    }, this.saveKey);

  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }



  init() {

    if (!this.item.backgroudColor) {
      this.item.backgroudColor = "#ab82b8";
    }

    if (!this.item.title) {
      this.item.title = getDefaultTile();
    }

    if (!this.item.letterArr) {
      this.item.letterArr = [];
    }

    if(!this.item.skin){
      this.item.skin = 'A';
    }

    if (!this.item.skinA) {
      this.item.skinA = {};
    }

    if (!this.item.zoneArr) {
      this.item.zoneArr = [];
    }

    for (let i = this.item.zoneArr.length; i < 3; ++i) {

      let zone = {
        exercisesArr: []
      };

      this.item.zoneArr.push(zone);
    }

    for (let i = 0; i < this.item.zoneArr.length; ++i) {
      let zone = this.item.zoneArr[i];

      if (!zone) {
        zone = {
          exercisesArr: []
        };

        this.item.zoneArr[i] = zone;
      }

      for (let j = 0; j < zone.exercisesArr.length; ++j) {
        if (!zone.exercisesArr[j]) {
          zone.exercisesArr[j] = getDefaultExercises();
        }

        if (!zone.exercisesArr[j].answer) {
          zone.exercisesArr[j].answer = new AnswerBean();
        }
      }
    }
  }


  /**
    * 储存图片数据
    * @param e
    */
  onImageUploadSuccess(e, item, key) {

    item[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, item, key) {

    item[key] = e.url;
    this.save();
  }

  addLetterItem(item) {
    let letter = getDefaultLetter();

    item.letterArr.push(letter);

    item.letterArr = [...item.letterArr];

    this.save();
  }

  delLetter(item, index) {
    if (index !== -1) {
      item.letterArr.splice(index, 1);
      item.letterArr = [...item.letterArr];
      this.save();
    }
  }

  addExercisesItem(item) {
    let exercises = getDefaultExercises();

    item.exercisesArr.push(exercises);

    this.save();
  }

  delExercisesItem(item, index) {
    if (index !== -1) {
      item.exercisesArr.splice(index, 1);
      item.exercisesArr = [...item.exercisesArr];
      this.save();
    }
  }

  saveIndex(item) {

    console.log(item);

    let canSave = true;

    for (let i = 0; i < this.item.zoneArr.length; ++i) {
      let zone = this.item.zoneArr[i];

      for (let j = 0; j < zone.exercisesArr.length; ++j) {

        let exercises = zone.exercisesArr[j];

        if (item == exercises) {
          continue;
        }

        else if (exercises.answerIndex == item.answerIndex) {

          canSave = false;
          break;
        }
      }
    }

    console.log(canSave);

    if (canSave) {
      this.save();
    }
    else {
      let id = this.message.error('已经存在相同的顺序号', { nzDuration: 0 }).messageId;
      setTimeout(() => {
        this.message.remove(id);
      }, 2500);
    }
  }

  clearBg() {
    if (this.item.skin === 'A') {
      this.item.skinA = {};
    }

    this.save();
  }



  /**
   * 储存数据
   */
  save() {
    (<any>window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

