import { Label, Label2, LabelText, MySprite, ShapeCircle, ShapeRect } from "./Unit";

export class Exercises {
    data;

    images;

    indexBgColor;

    index: number;

    bg: ShapeRect;

    answer: ShapeRect;

    answerLabel: Label2;

    scaleX = 1;

    scaleY = 1;

    answered: Boolean = false;

    indexLabel : Label;

    indexLabelBg : ShapeRect;

    init(images, indexBgColor, data, scaleX = 1, scaleY = 1) {

        this.images = images;

        this.data = data;

        this.scaleX = scaleX;

        this.scaleY = scaleY;

        this.indexBgColor = indexBgColor;

        this.index = this.data.answerIndex;

        this.initBg();

        this.initIndex();

        this.initAnswer();
    }

    initBg() {
        let height = 48 * this.scaleY;

        let width = 284 * this.scaleX;

        const bg = new ShapeRect();
        bg.setSize(width, height);
        bg.alpha = 0;
        this.bg = bg;
    }

    initIndex() {
        let indexBg = new ShapeRect();
        indexBg.setSize(43 * this.scaleX, 46 * this.scaleY);
        indexBg.fillColor = this.indexBgColor;
        indexBg.x = 0;
        indexBg.y = (this.bg.height - indexBg.height) / 2;
        indexBg.alpha = 0.7;
        this.bg.addChild(indexBg);
        this.indexLabelBg = indexBg;

        let index = new Label();
        index.text = this.index + "";
        index.textAlign = 'center';
        index.fontSize = 36;
        index.fontName = "TCB";
        index.fontColor = "#ffffff";
        index.setScaleXY(this.scaleX);
        index.refreshSize();
        index.x = indexBg.width / 2;
        index.y = indexBg.height / 2;
        indexBg.addChild(index);
        index.alpha = 0;
        this.indexLabel = index;
    }

    initAnswer() {

        let startX = 43 * this.scaleX + 8 * this.scaleX;

        let answer = this.getAnswerView(this.data.answer);
        answer.x = startX;
        this.answer = answer;

        this.bg.addChild(answer);
    }

    getAnswerView(answerData) {
        const getLabelText = (letter) => {
            const text = new LabelText();
            text.val = letter.val;
            if (letter.isFill == '1') {
                text.fontColor = "#c5c5c5";
            }
            else {
                text.fontColor = "#000000";
            }
            text.underLine = false;

            return text;
        }



        let labelTextArr = [];

        for (let i = 0; i < answerData.letterArr.length; ++i) {

            var letter = answerData.letterArr[i];

            let label = getLabelText(letter);

            labelTextArr.push(label);
        }

        const answer = new Label2();
        answer.textArr = labelTextArr;
        answer.fontSize = 48;
        answer.fontName = "MMB";
        answer.setScaleXY(this.scaleX);
        answer.refreshSize();
        this.answerLabel = answer;

        const answerBg = new ShapeRect();
        answerBg.alpha = 0;
        answerBg.setSize(answer.getBoundingBox().width, answer.getBoundingBox().height);
        answerBg.y = (this.bg.height - answerBg.height) / 2;

        answer.y = answerBg.height / 2;
        answer.x = 0;
        answerBg.addChild(answer);

        this.bg.addChild(answerBg);


        return answerBg;
    }

    checkAnswer(answerIndex) {

        if (this.data.answerIndex == answerIndex) {

            this.indexLabel.alpha = 1

            this.answered = true;

            let textArr = this.answerLabel.textArr;

            for (let i = 0; i < textArr.length; ++i) {
                if (textArr[i].fontColor == "#c5c5c5") {
                    textArr[i].fontColor = "#c8161d";
                }
            }

            return true;
        }

        return false;
    }
} 