import { Label, ShapeCircle } from "./Unit";

export class Letter{
    data;

    images;

    bgColor;

    scaleX = 1;

    scaleY = 1;

    bg : ShapeCircle;

    init(images, data, bgColor, scaleX = 1, scaleY = 1) {

        this.images = images;

        this.data = data;

        this.bgColor = bgColor;

        this.scaleX = scaleX;

        this.scaleY = scaleY;

        this.initBg();

        this.initView();
    }

    initBg(){

        let radius = 52 * this.scaleX;

        let bg = new ShapeCircle();

        bg.setRadius(radius);

        bg.fillColor = this.bgColor;

        this.bg = bg;

    }

    initView(){
        const letter = new Label();
        letter.text = this.data.val;
        letter.textAlign = 'center';
        letter.fontSize = 64;
        letter.fontName = "BRLNSDB";
        letter.fontColor = "#ffffff";
        letter.setScaleXY(this.scaleX);
        letter.setMaxSize(80 * this.scaleX);
        letter.refreshSize();
        letter.x = 0;
        letter.y = 0;
        this.bg.addChild(letter);
    }
}