import { Component, ElementRef, ViewChild, OnInit, Input, OnDestroy, HostListener } from '@angular/core';

import {
  Label,
  MySprite, ShapeRectNew, tweenChange,

} from './Unit';
import { res, resAudio } from './resources';

import { Subject } from 'rxjs';
import { debounceTime } from 'rxjs/operators';

import TWEEN from '@tweenjs/tween.js';
import { Title } from './Title';
import { getDefaultTile } from '../bean/TitleBean';
import { Listening } from './Listening';
import { Letter } from './Letter';
import { Exercises } from './Exercises.spreat';
import { AnswerBean, getDefaultExercises } from '../bean/Exercises';




@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.css']
})
export class PlayComponent implements OnInit, OnDestroy {

  @ViewChild('canvas', { static: true }) canvas: ElementRef;
  @ViewChild('wrap', { static: true }) wrap: ElementRef;

  // 数据
  data;

  ctx;

  canvasWidth = 1280; // canvas实际宽度
  canvasHeight = 720; // canvas实际高度

  canvasBaseW = 1280; // canvas 资源预设宽度
  canvasBaseH = 720;  // canvas 资源预设高度

  mx; // 点击x坐标
  my; // 点击y坐标


  // 资源
  rawImages = new Map(res);
  rawAudios = new Map(resAudio);

  images = new Map();

  animationId: any;
  winResizeEventStream = new Subject();

  audioObj = {};

  renderArr;
  mapScale = 1;

  canvasLeft;
  canvasTop;

  saveKey = 'YM5-3';


  canTouch = true;

  /**标题*/
  title: Title;

  listening: Listening;

  curAudio;

  letterArr: Array<Letter>;

  exercisesArr: Array<Exercises> = [];

  curIndex = 0;

  @HostListener('window:resize', ['$event'])
  onResize(event) {
    this.winResizeEventStream.next();
  }


  ngOnInit() {

    this.data = {};

    // 获取数据
    const getData = (<any>window).courseware.getData;
    getData((data) => {

      if (data && typeof data == 'object') {
        this.data = data;
      }
      // console.log('data:' , data);

      // 初始化 各事件监听
      this.initListener();

      // 若无数据 则为预览模式 需要填充一些默认数据用来显示
      this.initDefaultData();

      // 初始化 音频资源
      this.initAudio();
      // 初始化 图片资源
      this.initImg();
      // 开始预加载资源
      this.load();

    }, this.saveKey);

  }

  ngOnDestroy() {
    window['curCtx'] = null;
    window.cancelAnimationFrame(this.animationId);
    this.cleanAudio();
  }


  cleanAudio() {
    if (this.audioObj) {
      for (const key in this.audioObj) {
        this.audioObj[key].pause();
      }
    }
  }


  load() {

    // 预加载资源
    this.loadResources().then(() => {
      window["air"].hideAirClassLoading(this.saveKey, this.data);
      this.init();
      this.update();
    });
  }


  init() {

    this.initCtx();
    this.initData();
    this.initView();
  }

  initCtx() {
    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;
    this.canvas.nativeElement.width = this.wrap.nativeElement.clientWidth;
    this.canvas.nativeElement.height = this.wrap.nativeElement.clientHeight;


    this.ctx = this.canvas.nativeElement.getContext('2d');
    this.canvas.nativeElement.width = this.canvasWidth;
    this.canvas.nativeElement.height = this.canvasHeight;

    window['curCtx'] = this.ctx;
    window['curImages'] = this.images;
  }






  updateItem(item) {
    if (item) {
      item.update();
    }
  }

  updateArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].update(this);
    }
  }







  initListener() {

    this.winResizeEventStream
      .pipe(debounceTime(500))
      .subscribe(data => {
        this.renderAfterResize();
      });


    // ---------------------------------------------
    const setParentOffset = () => {
      const rect = this.canvas.nativeElement.getBoundingClientRect();
      this.canvasLeft = rect.left;
      this.canvasTop = rect.top;
    };
    const setMxMyByTouch = (event) => {
      if (event.touches.length <= 0) {
        return;
      }
      if (this.canvasLeft == null) {
        setParentOffset();
      }
      this.mx = event.touches[0].pageX - this.canvasLeft;
      this.my = event.touches[0].pageY - this.canvasTop;
    };

    const setMxMyByMouse = (event) => {
      this.mx = event.offsetX;
      this.my = event.offsetY;
    };
    // ---------------------------------------------


    let firstTouch = true;

    const touchDownFunc = (e) => {
      if (firstTouch) {
        firstTouch = false;
        removeMouseListener();
      }
      setMxMyByTouch(e);
      this.mapDown(e);
    };
    const touchMoveFunc = (e) => {
      setMxMyByTouch(e);
      this.mapMove(e);
    };
    const touchUpFunc = (e) => {
      setMxMyByTouch(e);
      this.mapUp(e);
    };

    const mouseDownFunc = (e) => {
      if (firstTouch) {
        firstTouch = false;
        removeTouchListener();
      }
      setMxMyByMouse(e);
      this.mapDown(e);
    };
    const mouseMoveFunc = (e) => {
      setMxMyByMouse(e);
      this.mapMove(e);
    };
    const mouseUpFunc = (e) => {
      setMxMyByMouse(e);
      this.mapUp(e);
    };


    const element = this.canvas.nativeElement;

    const addTouchListener = () => {
      element.addEventListener('touchstart', touchDownFunc);
      element.addEventListener('touchmove', touchMoveFunc);
      element.addEventListener('touchend', touchUpFunc);
      element.addEventListener('touchcancel', touchUpFunc);
    };
    const removeTouchListener = () => {
      element.removeEventListener('touchstart', touchDownFunc);
      element.removeEventListener('touchmove', touchMoveFunc);
      element.removeEventListener('touchend', touchUpFunc);
      element.removeEventListener('touchcancel', touchUpFunc);
    };

    const addMouseListener = () => {
      element.addEventListener('mousedown', mouseDownFunc);
      element.addEventListener('mousemove', mouseMoveFunc);
      element.addEventListener('mouseup', mouseUpFunc);
    };
    const removeMouseListener = () => {
      element.removeEventListener('mousedown', mouseDownFunc);
      element.removeEventListener('mousemove', mouseMoveFunc);
      element.removeEventListener('mouseup', mouseUpFunc);
    };

    addMouseListener();
    addTouchListener();
  }


  playAudio(key, now = false, callback = null) {

    const audio = this.audioObj[key];
    if (audio) {
      if (now) {
        audio.pause();
        audio.currentTime = 0;
      }

      if (callback) {
        audio.onended = () => {
          callback();
        };
      }
      audio.play();
    }

    return audio;
  }



  loadResources() {
    const pr = [];
    this.rawImages.forEach((value, key) => {// 预加载图片

      const p = this.preload(value)
        .then(img => {
          this.images.set(key, img);
        })
        .catch(err => console.log(err));

      pr.push(p);
    });

    this.rawAudios.forEach((value, key) => {// 预加载音频

      const a = this.preloadAudio(value)
        .then(() => {
          // this.images.set(key, img);
        })
        .catch(err => console.log(err));

      pr.push(a);
    });
    return Promise.all(pr);
  }

  preload(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      // img.crossOrigin = "anonymous";
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = url;
    });
  }

  preloadAudio(url) {
    return new Promise((resolve, reject) => {
      const audio = new Audio();
      audio.oncanplay = (a) => {
        resolve(a);
      };
      audio.onerror = () => {
        reject();
      };
      audio.src = url;
      audio.load();
    });
  }


  renderAfterResize() {
    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;
    this.init();
  }





  checkClickTarget(target) {

    const rect = target.getBoundingBox();

    if (this.checkPointInRect(this.mx, this.my, rect)) {
      return true;
    }
    return false;
  }

  getWorlRect(target) {

    let rect = target.getBoundingBox();

    if (target.parent) {

      const pRect = this.getWorlRect(target.parent);
      rect.x += pRect.x;
      rect.y += pRect.y;
    }
    return rect;
  }

  checkPointInRect(x, y, rect) {
    if (x >= rect.x && x <= rect.x + rect.width) {
      if (y >= rect.y && y <= rect.y + rect.height) {
        return true;
      }
    }
    return false;
  }





  addUrlToAudioObj(key, url = null, vlomue = 1, loop = false, callback = null) {

    const audioObj = this.audioObj;

    if (url == null) {
      url = key;
    }

    this.rawAudios.set(key, url);

    const audio = new Audio();
    audio.src = url;
    audio.load();
    audio.loop = loop;
    audio.volume = vlomue;

    audioObj[key] = audio;

    if (callback) {
      audio.onended = () => {
        callback();
      };
    }
  }

  addUrlToImages(url) {
    this.rawImages.set(url, url);
  }

  addUrlToImage(url, key) {
    if (!key) {
      key = url;
    }

    this.rawImages.set(key, url);
  }





  // ======================================================编写区域==========================================================================





  /**
   * 添加默认数据 便于无数据时的展示
   */
  initDefaultData() {

    if (!this.data.title) {
      this.data.title = getDefaultTile();
    }

    if (!this.data.backgroudColor) {
      this.data.backgroudColor = "#B5C75F";
    }


    if (!this.data.letterArr) {
      this.data.letterArr = [];
    }

    if(!this.data.skin){
      this.data.skin = 'A';
    }

    if (!this.data.skinA) {
      this.data.skinA = {};
    }

    if (!this.data.zoneArr) {
      this.data.zoneArr = [];
    }

    for (let i = this.data.zoneArr.length; i < 3; ++i) {

      let zone = {
        exercisesArr: []
      };

      this.data.zoneArr.push(zone);
    }

    for (let i = 0; i < this.data.zoneArr.length; ++i) {
      let zone = this.data.zoneArr[i];

      if (!zone) {
        zone = {
          exercisesArr: []
        };

        this.data.zoneArr[i] = zone;
      }

      for (let j = 0; j < zone.exercisesArr.length; ++j) {
        if (!zone.exercisesArr[j]) {
          zone.exercisesArr[j] = getDefaultExercises();
        }

        if (!zone.exercisesArr[j].answer) {
          zone.exercisesArr[j].answer = new AnswerBean();
        }
      }
    }
  }


  /**
   * 添加预加载图片
   */
  initImg() {

    const loadBg = (skin, skinType) => {
      if (skin.lt_pic_url) {
        this.addUrlToImage(skin.lt_pic_url, skinType + "_" + skin.lt_pic_url);
      }

      if (skin.lm_pic_url) {
        this.addUrlToImage(skin.lm_pic_url, skinType + "_" + skin.lm_pic_url);
      }

      if (skin.lb_pic_url) {
        this.addUrlToImage(skin.lb_pic_url, skinType + "_" + skin.lb_pic_url);
      }

      if (skin.mt_pic_url) {
        this.addUrlToImage(skin.mt_pic_url, skinType + "_" + skin.mt_pic_url);
      }

      if (skin.mb_pic_url) {
        this.addUrlToImage(skin.mb_pic_url, skinType + "_" + skin.mb_pic_url);
      }

      if (skin.rt_pic_url) {
        this.addUrlToImage(skin.rt_pic_url, skinType + "_" + skin.rt_pic_url);
      }

      if (skin.rm_pic_url) {
        this.addUrlToImage(skin.rm_pic_url, skinType + "_" + skin.rm_pic_url);
      }

      if (skin.rb_pic_url) {
        this.addUrlToImage(skin.rb_pic_url, skinType + "_" + skin.rb_pic_url);
      }
    }

    if (this.data.skinA) {
      loadBg(this.data.skinA, 'A');
    }


  }

  /**
   * 添加预加载音频
   */
  initAudio() {



    // 音效
    this.addUrlToAudioObj('click', this.rawAudios.get('click'), 0.3);

    this.addUrlToAudioObj('right', this.rawAudios.get('right'));

    //标题发音
    if (this.data.title.audioUrl) {
      this.addUrlToAudioObj('titleAudio', this.data.title.audioUrl);
    }


    //听力材料
    if (this.data.audioUrl) {
      this.addUrlToAudioObj('listenAudio', this.data.audioUrl);
    }

    for (let i = 0; i < this.data.letterArr.length; ++i) {
      let letter = this.data.letterArr[i];

      if (letter.audioUrl) {
        this.addUrlToAudioObj(letter.audioUrl);
      }
    }

    for (let i = 0; i < this.data.zoneArr.length; ++i) {
      let zone = this.data.zoneArr[i];

      //练习题音效
      for (let i = 0; i < zone.exercisesArr.length; ++i) {

        let exercises = zone.exercisesArr[i];

        if (exercises.answer && exercises.answer.audioUrl) {
          this.addUrlToAudioObj('exercises_' + i, exercises.answer.audioUrl);
        }

        if(exercises.indexAudioUrl){
          this.addUrlToAudioObj('exercises_index_' + i, exercises.indexAudioUrl);
        }

      }
    }


  }



  /**
   * 初始化数据
   */
  initData() {

    const sx = this.canvasWidth / this.canvasBaseW;
    const sy = this.canvasHeight / this.canvasBaseH;
    const s = Math.min(sx, sy);
    this.mapScale = s;


    this.renderArr = [];

    if (this.curAudio) {
      this.curAudio.pause();
    }

    this.curAudio = null;

    this.letterArr = [];

    this.exercisesArr = [];

    this.curIndex = 0;
  }



  /**
   * 初始化试图
   */
  initView() {

    this.initBg();

    this.initTitle();

    this.initBottomPart();

    this.initLetter();

    this.initExercises();
  }

  initBg() {

    const getPic = (key, anchorX: number = 0.5, anchorY: number = 0.5) => {
      const pic = new MySprite();
      pic.init(this.images.get(key), anchorX, anchorY);
      pic.setScaleXY(this.mapScale);
      this.renderArr.push(pic);
      return pic;
    }

    const initBg = (skin, skinType) => {

      //左上
      if (skin.lt_pic_url) {
        const pic = getPic(skinType + '_' + skin.lt_pic_url, 0, 0);
        pic.x = 0;
        pic.y = 0;

      }

      //左中
      if (skin.lm_pic_url) {
        const pic = getPic(skinType + '_' + skin.lm_pic_url, 0);
        pic.x = 0;
        pic.y = (this.canvasHeight - pic.getBoundingBox().height) / 2;
      }

      //左下
      if (skin.lb_pic_url) {
        const pic = getPic(skinType + '_' + skin.lb_pic_url, 0, 1);
        pic.x = 0;
        pic.y = this.canvasHeight;
      }

      //中上
      if (skin.mt_pic_url) {
        const pic = getPic(skinType + '_' + skin.mt_pic_url, 0.5, 0);
        pic.x = this.canvasWidth / 2;
        pic.y = 0;
      }

      //中下
      if (skin.mb_pic_url) {
        const pic = getPic(skinType + '_' + skin.mb_pic_url, 0.5, 1);
        pic.x = this.canvasWidth / 2;
        pic.y = this.canvasHeight;
      }

      //右上
      if (skin.rt_pic_url) {
        const pic = getPic(skinType + '_' + skin.rt_pic_url, 1, 0);
        pic.x = this.canvasWidth;
        pic.y = 0;
      }

      //右中
      if (skin.rm_pic_url) {
        const pic = getPic(skinType + '_' + skin.rm_pic_url, 1, 0.5);
        pic.x = this.canvasWidth;
        pic.y = this.canvasHeight / 2;
      }

      //右下
      if (skin.rb_pic_url) {
        const pic = getPic(skinType + '_' + skin.rb_pic_url, 1, 1);
        pic.x = this.canvasWidth;
        pic.y = this.canvasHeight;
      }
    }

    if (this.data.skin === 'A') {
      if (this.data.skinA) {
        initBg(this.data.skinA, 'A');
      }
    }
    else {
      if (this.data.skinB) {
        initBg(this.data.skinB, 'B');
      }
    }
  }


  initBottomPart() {

    const listening = new Listening(this.audioObj['listenAudio'], this.images);
    listening.init(this.mapScale, this.mapScale);

    listening.bg.x = this.canvasWidth - listening.bg.width - 10 * this.mapScale;
    listening.bg.y = this.canvasHeight - listening.bg.height - 8 * this.mapScale;
    this.listening = listening;

    this.renderArr.push(listening.bg);
  }

  initTitle() {

    const title = new Title(this.data.title, this.images);

    title.init(this.mapScale, this.mapScale);
    title.audio = this.audioObj['titleAudio'];
    this.title = title;

    title.titleBg.y = 0;
    title.titleBg.x = 0;

    this.renderArr.push(title.titleBg);
  }


  initLetter() {

    let letterArr = this.data.letterArr;

    let dW = (47 + 104) * this.mapScale;

    let tW = (letterArr.length - 1) * dW;

    let startX = (this.canvasWidth - tW) / 2;

    let y = this.canvasHeight / 2 - 218 * this.mapScale;

    for (let i = 0; i < letterArr.length; ++i) {

      let letter = new Letter();
      letter.init(this.images, letterArr[i], this.data.backgroudColor, this.mapScale, this.mapScale);
      letter.bg.x = startX + dW * i;
      letter.bg.y = y;
      this.renderArr.push(letter.bg);
      this.letterArr.push(letter);
    }
  }


  initExercises() {

    let w = 344 * this.mapScale;

    let h = 344 * this.mapScale;

    let r = 20 * this.mapScale;

    let y = this.canvasHeight / 2 - 119 * this.mapScale;

    let dW = 50;

    let startX = (this.canvasWidth - (w * 3 + dW * (3 - 1))) / 2;


    const getView = (item, x = 0, y = 0) => {
      let exercises = new Exercises();

      exercises.init(this.images, this.data.backgroudColor, item, this.mapScale, this.mapScale);

      exercises.bg.x = x;

      exercises.bg.y = y;

      return exercises;
    }

    for (let i = 0; i < this.data.zoneArr.length; ++i) {
      const bg = new ShapeRectNew();
      bg.setSize(w, h, r);
      bg.fillColor = this.data.backgroudColor;
      bg.x = startX;
      bg.y = y;
      bg.alpha = 0.1;

      startX += w + dW;

      this.renderArr.push(bg);

      let exercisesArr = this.data.zoneArr[i].exercisesArr;

      if(!exercisesArr || exercisesArr.length == 0){
        continue;
      }

      let x = 29 * this.mapScale;

      let disH = 57 * this.mapScale;

      let startY = (h - exercisesArr.length * 48 * this.mapScale - (exercisesArr.length - 1) * disH) / 2;


      for (let j = 0; j < exercisesArr.length; ++j) {
       

        let exercises = getView(exercisesArr[j], x, startY);

        bg.addChild(exercises.bg);

        this.exercisesArr.push(exercises);

        startY += exercises.bg.height + disH;
      }

    }




  }


  mapDown(event) {

    if (!this.canTouch) {
      return;
    }

    if (this.curAudio) {
      if (this.curAudio != this.listening.audio) {
        this.curAudio.pause();
      }
    }

    if (this.checkClickTarget(this.listening.bg)) {

      this.curAudio = this.listening.play(() => {
        this.listening.reset();
      });

      return;
    }

    if (this.curAudio) {
      if (this.curAudio == this.listening.audio) {
        this.listening.pauseAudio();
      }
      else {
        this.curAudio.pause();
      }

    }

    if (this.checkClickTarget(this.title.titleBg)) {
      this.curAudio = this.title.playAudio();
      return;
    }

    for (let i = 0; i < this.letterArr.length; ++i) {
      let letter = this.letterArr[i];

      if (this.checkClickTarget(letter.bg)) {
        this.curAudio = this.playAudio(letter.data.audioUrl, true);
        break;
      }

    }

    let clicked = false;

    for (let i = 0; i < this.exercisesArr.length; ++i) {

      let exercises = this.exercisesArr[i];

      if (this.checkClickTarget(exercises.answer) || this.checkClickTarget(exercises.indexLabelBg)) {

        clicked = true;

        this.clickExercises(exercises, i);

        break;
      }
    }

    if (clicked) {
      return;
    }
  }

  mapMove(event) {

  }

  mapUp(event) {

  }



  update() {

    // ----------------------------------------------------------
    this.animationId = window.requestAnimationFrame(this.update.bind(this));
    // 清除画布内容
    this.ctx.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
    // tween 更新动画
    TWEEN.update();
    // ----------------------------------------------------------



    this.updateArr(this.renderArr);


  }

  clickExercises(exercises: Exercises, index: number) {

    const play = () => {
      let key = 'exercises_' + index;

      const audio = this.audioObj[key];

      this.curAudio = audio;

      this.playAudio(key, true);
    }

    if (exercises.answered) {
      play();

    }
    else {
      if (exercises.checkAnswer(this.curIndex + 1)) {

        this.playAudio('right', true, () => {
          let key = 'exercises_index_' + index;

          const audio = this.audioObj[key];

          this.curAudio = audio;

          this.playAudio(key, true);
          
        });

        this.curIndex += 1;
      }
      else {
        play();
      }
    }
  }

}
