/**
 * 
 * @param audio 音频
 * @param now true-重新开始播放，flase-继续播放
 * @param callback 
 */
export function playAudio(audio, now = false, callback = null) {

    if (audio) {
      if (now) {
        audio.pause();
        audio.currentTime = 0;
      }

      if (callback) {
        audio.onended = () => {
          callback();
        };
      }
      audio.play();
    }
}

/**
 * 暂停播放音频
 * @param audio 音频 
 * @param reset 暂停是否重置：true-是，false-否
 * @param callback 
 */
export function pauseAudio(audio, reset = false, callback = null) {

    if (audio) {

        if (reset) {
            audio.currentTime = 0;
        }

        audio.pause();

        if (callback) {
            callback();
        }
    }
}