import {Component, EventEmitter, Input, Output } from '@angular/core';  

@Component({
  selector: 'app-background-upload',
  templateUrl: './background-upload.component.html',
  styleUrls: ['./background-upload.component.scss']
}) 
export class BackgroundUploadComponent {

  @Input() items = {"leftTop": '', "middleTop": '', "rightTop": '', "leftMiddle": '', "rightMiddle": '', "leftBottom": '', "middleBottom": '', "rightBottom": ''};
  @Output() change = new EventEmitter();
  constructor( ) { }

  onImageUploadSuccess(e, items, key) {
    items[key] = e.url;
    this.change.emit(items)
  }

  cleanAll() {
    if(confirm("确定清空所有背景吗?")) {
      this.items["leftTop"] = "";
      this.items["middleTop"] = "";
      this.items["rightTop"] = "";

      this.items["leftMiddle"] = "";
      this.items["rightMiddle"] = "";

      this.items["leftBottom"] = "";
      this.items["middleBottom"] = "";
      this.items["rightBottom"] = "";
      this.change.emit(this.items)
    }
  }

  deletePic(key) {
    this.items[key] = ""
    this.change.emit(this.items)
  }
}
