
import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef} from '@angular/core';
import {ChangeDetectorRef} from '@angular/core';

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

picArr = [];
_item: any;
saveData;
wordArr = [];
saveKey='YM5-6'

constructor(private appRef: ApplicationRef,private changeDetectorRef: ChangeDetectorRef) {}
  ngOnInit() {
    this.item = {contentObj: {}};
    // 获取存储的数据
    (<any> window).courseware.getData(( data ) => { 
    if(data && !data.contentObj) {data.contentObj={}}
      if (data) {
        this.item = data;
      }
      this.ngOnInit2()
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();
    }, this.saveKey);
  }

  @Input()
  set item(item) {
    this._item = item;
    this.getData(item.contentObj.data);

  }
  get item() {
    return this._item;
  }

  @Output()
  update = new EventEmitter();



  constructor2() {
  }


  ngOnInit2() {

    // this.initData();
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }

  recordingIndex = []
  listOfOption = ['1', '2', '3', '4'];
  indexAudio = [];
  bgImages: Object = { leftTop: "", middleTop: "", rightTop: "", leftMiddle: "", rightMiddle: "", leftBottom: "", middleBottom: "", rightBottom: "" };

  backgroundImageChanged(e) {
    this.save()
  }

  onAudioUploadSuccessByItem_new(e, key, item?) {
    if(item){
      item[key] = e.url;
    }else{
      this.indexAudio[key] = e.url;
    }
    this.save();
  }

  getData(data) {


    this.saveData = {};
 
    this.saveData.title = {
      t_font_color1:'#70401e',
      t_font1:'BRLNSDB',
      t_font_size1:40,
      t_font_color:'#000000',
      t_font:'BRLNSDB',
      t_font_size:40,
      t_val1: "C",
      t_val2: "Listen, write circle and read"
    };

    // 获取存储的数据
    if (data) {
      this.saveData = data;
    }


    if ( !this.saveData.wordArr ) {
        this.saveData.wordArr = [];
    }

    if(!this.saveData.indexAudio) {
      this.saveData.indexAudio = []
    }

    if(!this.saveData.bgImages) {
      this.saveData.bgImages = { leftTop: "", middleTop: "", rightTop: "", leftMiddle: "", rightMiddle: "", leftBottom: "", middleBottom: "", rightBottom: "" };
    }

    if(!this.saveData.recordingIndex) {
      this.saveData.recordingIndex = []
    }

    
    this.init2();

    this.item.contentObj.data = this.saveData;
    console.log(this.saveData)
  }






  mapToOptionLabel(index) {
    let lebel = ""
    switch(index) {
      case "1": lebel = "左上"; break;
      case "2": lebel = "左下"; break;
      case "3": lebel = "右上"; break;
      case "4": lebel = "右下"; break;
    }
    return lebel
  }

  init2(){

    //标题
    if(!this.saveData.title){
      this.saveData.title = {
        t_font_color1:'#70401e',
        t_font1:'BRLNSDB',
        t_font_size1:40,
        t_font_color:'#000000',
        t_font:'BRLNSDB',
        t_font_size:40,
        t_val1: "", // "C",
        t_val2: "" // "Listen, write circle and read"
      };
    }

    if (this.saveData.wordArr) {
      this.wordArr = this.saveData.wordArr;
    } else {
      this.wordArr = this.getDefaultWordArr();
      this.saveData.wordArr = this.wordArr;
    }

    if(this.saveData.indexAudio) {
      this.indexAudio = this.saveData.indexAudio
    } else {
      this.indexAudio = ["", "", "", ""]
      this.saveData.indexAudio = this.indexAudio
    }

    if(this.saveData.bgImages) {
      this.bgImages = this.saveData.bgImages
    } else {
      this.bgImages = { leftTop: "", middleTop: "", rightTop: "", leftMiddle: "", rightMiddle: "", leftBottom: "", middleBottom: "", rightBottom: "" };
    }

  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key) {

    this.saveData[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, item, key) {
    item[key] = e.url;
    this.save();
  }

  onAudioUploadSuccessByItem(e, item, key) {
    item[key] = e.url;
    this.save();
  }

  /**
   * 储存数据
   */
  saveOld() {
    this.item.contentObj.data = this.saveData;
    this.save();
  }

  /**
   * 刷新 渲染页面
   */
  refreshOld() {
    // setTimeout(() => {
    //   this.appRef.tick();
    // }, 1);
  }

  deleteItem(index) {
    if (index !== -1) {
      this.wordArr.splice(index, 1);
    }

    // this.save();
    this.save();
  }

  addItem() {
    let item = this.wordItemData();
    this.wordArr.push(item);

    this.saveItem();
  }

  // addLetterItem(letters){

  //   let letter = this.letterData();

  //   letters.push(letter);

  //   this.save();
  // }

  deleteLetterItem(letters, index){
    if (index !== -1) {
      letters.splice(index, 1);
    }
    this.save();
  }


  wordItemData() {
    let color = "E5F4F9"
    switch(this.wordArr.length) {
      case 0: color = "E5F4F9"; break;
      case 1: color = "F0EAF4"; break;
      case 2: color = "F5F9EA"; break;
      case 3: color = "FFF1EB"; break;
    }
    return {
      words_left: "",
      words_right: "",
      correctOption: "left",
      word_val: '',
      word_audio_url: '',
      letters: []
    };
  }

  saveWordItem(index) {
    let val = this.wordArr[index].word_val;
    this.wordArr[index].letters = [];
    for(let i=0;i<val.length;i++){
      this.wordArr[index].letters.push({
        letter_val: val[i],
        letter_color: 'C04',
        is_: '0'
      });
    }
    this.save();
  }

  saveItem() {
    this.save();
  }

  getDefaultWordArr() {
    let arr = [];
    return arr;
  }

 save () { 
  if(this.item && this.saveData) {
    if(!this.item.contentObj) {
      this.item.contentObj={}
    } 
    this.item.contentObj.data = this.saveData 
    // console.log(this.saveData)
  }
    (<any> window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

