export function getPosByAngle(angle, len) {

    const radian = angle * Math.PI / 180;
    const x = Math.sin(radian) * len;
    const y = Math.cos(radian) * len;

    return { x, y };

}

export function getAngleByPos(px, py, mx, my) {

    const x = Math.abs(px - mx);
    const y = Math.abs(py - my);

    const z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
    const cos = y / z;
    const radina = Math.acos(cos); // 用反三角函数求弧度
    let angle = Math.floor(180 / (Math.PI / radina) * 100) / 100; // 将弧度转换成角度

    if (mx > px && my > py) {// 鼠标在第四象限
        angle = 180 - angle;
    }
    if (mx === px && my > py) {// 鼠标在y轴负方向上
        angle = 180;
    }
    if (mx > px && my === py) {// 鼠标在x轴正方向上
        angle = 90;
    }
    if (mx < px && my > py) {// 鼠标在第三象限
        angle = 180 + angle;
    }
    if (mx < px && my === py) {// 鼠标在x轴负方向
        angle = 270;
    }
    if (mx < px && my < py) {// 鼠标在第二象限
        angle = 360 - angle;
    }

    // console.log('angle: ', angle);
    return angle;

}

export function exchangeNodePos(baseNode, targetNode) {
    return baseNode.convertToNodeSpaceAR(targetNode._parent.convertToWorldSpaceAR(cc.v2(targetNode.x, targetNode.y)));
}

export function RandomInt(a, b = 0) {
    let max = Math.max(a, b);
    let min = Math.min(a, b);
    return Math.floor(Math.random() * (max - min) + min);
}

export function randomSortByArr(arr) {
    const newArr = [];
    const tmpArr = arr.concat();
    while (tmpArr.length > 0) {
        const randomIndex = Math.floor(tmpArr.length * Math.random());
        newArr.push(tmpArr[randomIndex]);
        tmpArr.splice(randomIndex, 1);
    }
    return newArr;
}

export async function asyncTweenTo(node, duration, obj, ease = undefined) {
    return new Promise((resolve, reject) => {
        cc.tween(node)
            .to(duration, obj, ease)
            .call(() => {
                resolve();
            })
            .start();
    });
}

export async function asyncPlayDragonBoneAnimation(node, animationName, time = 1) {
    return new Promise((resolve, reject) => {
        node.getComponent(dragonBones.ArmatureDisplay)
            .once(dragonBones.EventObject.COMPLETE, () => {
                resolve();
            });
        node.getComponent(dragonBones.ArmatureDisplay)
            .playAnimation(animationName, time);
    });
}

export async function asyncPlayEffectByUrl(url, loop = false) {
    return new Promise((resolve, reject) => {
        cc.assetManager.loadRemote(url, (err, clip) => {
            console.log(clip);
            cc.audioEngine.playEffect(clip, loop);
        });
    });
}

export async function jelly(node) {
    return new Promise((resolve, reject) => {
        cc.tween(node)
            .to(0.1, { scaleX: 0.9, scaleY: 1.1 })
            .to(0.1, { scaleX: 1.1, scaleY: 0.9 })
            .to(0.1, { scaleX: 1, scaleY: 1 })
            .call(resolve)
            .start();
    });
}

