import { Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef } from '@angular/core';
import { JsonPipe } from '@angular/common';
import { ComponentBase } from './ComponentBase';


@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent extends ComponentBase implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "card_machine";
  // 储存对象
  item: any = {
    title: '',
    questionText: '',
    questionTextAudio: '',
    audioFileName: '',
    questions: [],
  };

  addQuestion() {
    this.item.questions.push({
      type: 'img',
      audio: '',
      text: '',
      image: ''
    });
    this.save();
  }

  removeQuestion(idx) {
    this.item.questions.splice(idx, 1);
    this.save();
  }

  saveAudioFileName(name) {
    this.item.audioFileName=name;
    this.save();
  }

  handle_dragover(e) {
    e.preventDefault();
  }

  handle_drop(e) {
    e.preventDefault();
    const dt = e.dataTransfer.getData("text/plain");
    console.log("handle_drop===", dt);
    // 网络文件 dt 的数据遵循如下格式
    // 图片 "http://staging-teach.cdn.ireadabc.com/f38f9928-c3bd-47f8-9ed1-43c0e03d2f30.png";
    // 音频(JSON字符串) {url: "http://staging-teach.cdn.ireadabc.com/1c8694612563f4e2da707f1f6a37d066_l.mp3", name: "test.mp3"};
    // 视频(JSON字符串) {url: "http://staging-teach.cdn.ireadabc.com/c37a3945121274a1f7d95717327539ec_l.mp4", name: "视频.mp4"};
    // 骨骼动画(JSON字符串) {"ske":{"url":"http://staging-teach.cdn.ireadabc.com/3d4a36b83aada60709771fbe15e2b6db.json","name":"飞鸟_ske.json"},"tex":{"url":"http://staging-teach.cdn.ireadabc.com/08a676a5f456634f9c6c90e9efd3c2ea.json","name":"飞鸟_tex.json"},"png":{"url":"http://staging-teach.cdn.ireadabc.com/874393ecf5e0cd42a09f5b34d48854d2.png","name":"飞鸟_tex.png"}};
  }
}