
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Z_05_nxuan1/script/Z_05_nxuan1_utils.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '285dcaowiFEn6Ge0hRLnRLV', 'Z_05_nxuan1_utils');
// Z_05_nxuan1/script/Z_05_nxuan1_utils.js

"use strict";

exports.__esModule = true;
exports.getPosByAngle = getPosByAngle;
exports.getAngleByPos = getAngleByPos;
exports.exchangeNodePos = exchangeNodePos;
exports.RandomInt = RandomInt;
exports.randomSortByArr = randomSortByArr;
exports.asyncTweenTo = asyncTweenTo;
exports.asyncPlayDragonBoneAnimation = asyncPlayDragonBoneAnimation;
exports.asyncPlayEffectByUrl = asyncPlayEffectByUrl;
exports.jelly = jelly;

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function getPosByAngle(angle, len) {
  var radian = angle * Math.PI / 180;
  var x = Math.sin(radian) * len;
  var y = Math.cos(radian) * len;
  return {
    x: x,
    y: y
  };
}

function getAngleByPos(px, py, mx, my) {
  var x = Math.abs(px - mx);
  var y = Math.abs(py - my);
  var z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
  var cos = y / z;
  var radina = Math.acos(cos); // 用反三角函数求弧度

  var angle = Math.floor(180 / (Math.PI / radina) * 100) / 100; // 将弧度转换成角度

  if (mx > px && my > py) {
    // 鼠标在第四象限
    angle = 180 - angle;
  }

  if (mx === px && my > py) {
    // 鼠标在y轴负方向上
    angle = 180;
  }

  if (mx > px && my === py) {
    // 鼠标在x轴正方向上
    angle = 90;
  }

  if (mx < px && my > py) {
    // 鼠标在第三象限
    angle = 180 + angle;
  }

  if (mx < px && my === py) {
    // 鼠标在x轴负方向
    angle = 270;
  }

  if (mx < px && my < py) {
    // 鼠标在第二象限
    angle = 360 - angle;
  } // console.log('angle: ', angle);


  return angle;
}

function exchangeNodePos(baseNode, targetNode) {
  return baseNode.convertToNodeSpaceAR(targetNode._parent.convertToWorldSpaceAR(cc.v2(targetNode.x, targetNode.y)));
}

function RandomInt(a, b) {
  if (b === void 0) {
    b = 0;
  }

  var max = Math.max(a, b);
  var min = Math.min(a, b);
  return Math.floor(Math.random() * (max - min) + min);
}

function randomSortByArr(arr) {
  var newArr = [];
  var tmpArr = arr.concat();

  while (tmpArr.length > 0) {
    var randomIndex = Math.floor(tmpArr.length * Math.random());
    newArr.push(tmpArr[randomIndex]);
    tmpArr.splice(randomIndex, 1);
  }

  return newArr;
}

function asyncTweenTo(_x, _x2, _x3, _x4) {
  return _asyncTweenTo.apply(this, arguments);
}

function _asyncTweenTo() {
  _asyncTweenTo = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(node, duration, obj, ease) {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (ease === void 0) {
              ease = undefined;
            }

            return _context.abrupt("return", new Promise(function (resolve, reject) {
              cc.tween(node).to(duration, obj, ease).call(function () {
                resolve();
              }).start();
            }));

          case 2:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _asyncTweenTo.apply(this, arguments);
}

function asyncPlayDragonBoneAnimation(_x5, _x6, _x7) {
  return _asyncPlayDragonBoneAnimation.apply(this, arguments);
}

function _asyncPlayDragonBoneAnimation() {
  _asyncPlayDragonBoneAnimation = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(node, animationName, time) {
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            if (time === void 0) {
              time = 1;
            }

            return _context2.abrupt("return", new Promise(function (resolve, reject) {
              node.getComponent(dragonBones.ArmatureDisplay).once(dragonBones.EventObject.COMPLETE, function () {
                resolve();
              });
              node.getComponent(dragonBones.ArmatureDisplay).playAnimation(animationName, time);
            }));

          case 2:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _asyncPlayDragonBoneAnimation.apply(this, arguments);
}

function asyncPlayEffectByUrl(_x8, _x9) {
  return _asyncPlayEffectByUrl.apply(this, arguments);
}

function _asyncPlayEffectByUrl() {
  _asyncPlayEffectByUrl = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(url, loop) {
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            if (loop === void 0) {
              loop = false;
            }

            return _context3.abrupt("return", new Promise(function (resolve, reject) {
              cc.assetManager.loadRemote(url, function (err, clip) {
                console.log(clip);
                cc.audioEngine.playEffect(clip, loop);
              });
            }));

          case 2:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _asyncPlayEffectByUrl.apply(this, arguments);
}

function jelly(_x10) {
  return _jelly.apply(this, arguments);
}

function _jelly() {
  _jelly = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(node) {
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            return _context4.abrupt("return", new Promise(function (resolve, reject) {
              cc.tween(node).to(0.1, {
                scaleX: 0.9,
                scaleY: 1.1
              }).to(0.1, {
                scaleX: 1.1,
                scaleY: 0.9
              }).to(0.1, {
                scaleX: 1,
                scaleY: 1
              }).call(resolve).start();
            }));

          case 1:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _jelly.apply(this, arguments);
}

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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