"use strict";
cc._RF.push(module, '285dcaowiFEn6Ge0hRLnRLV', 'Z_05_nxuan1_utils');
// Z_05_nxuan1/script/Z_05_nxuan1_utils.js

"use strict";

exports.__esModule = true;
exports.getPosByAngle = getPosByAngle;
exports.getAngleByPos = getAngleByPos;
exports.exchangeNodePos = exchangeNodePos;
exports.RandomInt = RandomInt;
exports.randomSortByArr = randomSortByArr;
exports.asyncTweenTo = asyncTweenTo;
exports.asyncPlayDragonBoneAnimation = asyncPlayDragonBoneAnimation;
exports.asyncPlayEffectByUrl = asyncPlayEffectByUrl;
exports.jelly = jelly;

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function getPosByAngle(angle, len) {
  var radian = angle * Math.PI / 180;
  var x = Math.sin(radian) * len;
  var y = Math.cos(radian) * len;
  return {
    x: x,
    y: y
  };
}

function getAngleByPos(px, py, mx, my) {
  var x = Math.abs(px - mx);
  var y = Math.abs(py - my);
  var z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
  var cos = y / z;
  var radina = Math.acos(cos); // 用反三角函数求弧度

  var angle = Math.floor(180 / (Math.PI / radina) * 100) / 100; // 将弧度转换成角度

  if (mx > px && my > py) {
    // 鼠标在第四象限
    angle = 180 - angle;
  }

  if (mx === px && my > py) {
    // 鼠标在y轴负方向上
    angle = 180;
  }

  if (mx > px && my === py) {
    // 鼠标在x轴正方向上
    angle = 90;
  }

  if (mx < px && my > py) {
    // 鼠标在第三象限
    angle = 180 + angle;
  }

  if (mx < px && my === py) {
    // 鼠标在x轴负方向
    angle = 270;
  }

  if (mx < px && my < py) {
    // 鼠标在第二象限
    angle = 360 - angle;
  } // console.log('angle: ', angle);


  return angle;
}

function exchangeNodePos(baseNode, targetNode) {
  return baseNode.convertToNodeSpaceAR(targetNode._parent.convertToWorldSpaceAR(cc.v2(targetNode.x, targetNode.y)));
}

function RandomInt(a, b) {
  if (b === void 0) {
    b = 0;
  }

  var max = Math.max(a, b);
  var min = Math.min(a, b);
  return Math.floor(Math.random() * (max - min) + min);
}

function randomSortByArr(arr) {
  var newArr = [];
  var tmpArr = arr.concat();

  while (tmpArr.length > 0) {
    var randomIndex = Math.floor(tmpArr.length * Math.random());
    newArr.push(tmpArr[randomIndex]);
    tmpArr.splice(randomIndex, 1);
  }

  return newArr;
}

function asyncTweenTo(_x, _x2, _x3, _x4) {
  return _asyncTweenTo.apply(this, arguments);
}

function _asyncTweenTo() {
  _asyncTweenTo = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(node, duration, obj, ease) {
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (ease === void 0) {
              ease = undefined;
            }

            return _context.abrupt("return", new Promise(function (resolve, reject) {
              cc.tween(node).to(duration, obj, ease).call(function () {
                resolve();
              }).start();
            }));

          case 2:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _asyncTweenTo.apply(this, arguments);
}

function asyncPlayDragonBoneAnimation(_x5, _x6, _x7) {
  return _asyncPlayDragonBoneAnimation.apply(this, arguments);
}

function _asyncPlayDragonBoneAnimation() {
  _asyncPlayDragonBoneAnimation = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(node, animationName, time) {
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            if (time === void 0) {
              time = 1;
            }

            return _context2.abrupt("return", new Promise(function (resolve, reject) {
              node.getComponent(dragonBones.ArmatureDisplay).once(dragonBones.EventObject.COMPLETE, function () {
                resolve();
              });
              node.getComponent(dragonBones.ArmatureDisplay).playAnimation(animationName, time);
            }));

          case 2:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _asyncPlayDragonBoneAnimation.apply(this, arguments);
}

function asyncPlayEffectByUrl(_x8, _x9) {
  return _asyncPlayEffectByUrl.apply(this, arguments);
}

function _asyncPlayEffectByUrl() {
  _asyncPlayEffectByUrl = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(url, loop) {
    return regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            if (loop === void 0) {
              loop = false;
            }

            return _context3.abrupt("return", new Promise(function (resolve, reject) {
              cc.assetManager.loadRemote(url, function (err, clip) {
                console.log(clip);
                cc.audioEngine.playEffect(clip, loop);
              });
            }));

          case 2:
          case "end":
            return _context3.stop();
        }
      }
    }, _callee3);
  }));
  return _asyncPlayEffectByUrl.apply(this, arguments);
}

function jelly(_x10) {
  return _jelly.apply(this, arguments);
}

function _jelly() {
  _jelly = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(node) {
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            return _context4.abrupt("return", new Promise(function (resolve, reject) {
              cc.tween(node).to(0.1, {
                scaleX: 0.9,
                scaleY: 1.1
              }).to(0.1, {
                scaleX: 1.1,
                scaleY: 0.9
              }).to(0.1, {
                scaleX: 1,
                scaleY: 1
              }).call(resolve).start();
            }));

          case 1:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  }));
  return _jelly.apply(this, arguments);
}

cc._RF.pop();