"use strict";
cc._RF.push(module, '16e664NoZRDVLBg7jQiJNBs', 'Z_05_nxuan1');
// Z_05_nxuan1/scene/Z_05_nxuan1.js

"use strict";

var _Z_05_nxuan1_utils = require("../script/Z_05_nxuan1_utils");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
var defaultData = require('../script/Z_05_nxuan1_defaultData');

cc.Class({
  "extends": cc.Component,
  properties: {
    letter: 'b',
    bgNode: {
      type: cc.Prefab,
      "default": null
    },
    monkeyUpperNode: {
      type: cc.Prefab,
      "default": null
    },
    letterPageUINode: {
      type: cc.Prefab,
      "default": null
    },
    cloudPrefab: {
      type: cc.Prefab,
      "default": null
    },
    starAnimePrefab: {
      type: cc.Prefab,
      "default": null
    },
    starPreFab: {
      type: cc.Prefab,
      "default": null
    },
    sharkPreFab: {
      type: cc.Prefab,
      "default": null
    },
    arrowPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterAPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterBPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterCPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterDPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterEPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterFPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterGPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterHPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterIPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterJPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterKPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterLPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterMPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterNPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterOPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterPPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterQPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterRPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterSPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterTPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterUPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterVPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterWPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterXPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterYPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterZPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteraPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterbPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettercPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterdPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterePrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterfPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettergPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterhPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteriPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterjPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterkPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterlPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettermPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letternPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteroPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterpPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterqPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterrPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettersPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettertPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteruPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettervPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterwPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterxPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteryPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterzPrefab: {
      type: cc.Prefab,
      "default": null
    }
  },
  // LIFE-CYCLE CALLBACKS:
  // onLoad () {},
  ctor: function ctor() {
    this._imageResList = [];
    this._audioResList = [];
  },
  start: function start() {
    var _this = this;

    cc.debug.setDisplayStats(false);
    this.data = defaultData;
    this.getData(function (data) {
      if (data) {
        _this.data = data;
      }

      _this.preloadItem();
    });
  },
  getData: function getData(func) {
    if (window && window.courseware) {
      window.courseware.getData(func, 'Z_05_nxuan1');
    } else {
      func(defaultData);
    }
  },
  _imageResList: null,
  _audioResList: null,
  preloadItem: function preloadItem() {
    this.addPreloadImage();
    this.addPreloadAudio();
    this.preload();
    this.onLoadFinish();
  },
  addPreloadImage: function addPreloadImage() {},
  addPreloadAudio: function addPreloadAudio() {},
  preload: function preload() {
    var _this2 = this;

    var preloadArr = this._imageResList.concat(this._audioResList);

    cc.assetManager.loadAny(preloadArr, null, null, function (err, data) {
      _this2.hideAirClassLoading();
    });

    if (preloadArr.length == 0) {
      this.hideAirClassLoading();
    }
  },
  hideAirClassLoading: function hideAirClassLoading() {
    if (window && window["air"]) {
      window["air"].hideAirClassLoading();
      console.log('hideAirClassLoading');
    }
  },
  initListeners: function initListeners() {
    var _this3 = this;

    var btnSwitch = cc.find('Canvas/LetterPicturePage/BtnSwitch');
    var changeToBig = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToBig');
    var changeToSmall = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToSmall');
    var smallLetterBase = cc.find('Canvas/LetterPicturePage/SmallLetterBase');
    var bigLetterBase = cc.find('Canvas/LetterPicturePage/BigLetterBase');
    var pictureWordSmallBg = cc.find('Canvas/LetterPicturePage/PictureWordSmallBg');
    var pictureWordBigBg = cc.find('Canvas/LetterPicturePage/PictureWordBigBg');
    btnSwitch.on('click', function () {
      _this3.playEffect('按钮');

      changeToBig.active = !changeToBig.active;
      bigLetterBase.active = !bigLetterBase.active;
      pictureWordBigBg.active = !pictureWordBigBg.active;
      changeToSmall.active = !changeToSmall.active;
      smallLetterBase.active = !smallLetterBase.active;
      pictureWordSmallBg.active = !pictureWordSmallBg.active;
    });
    smallLetterBase.on('click', function () {
      _this3.playEffect("letter" + _this3.letter.toUpperCase());

      cc.tween(smallLetterBase).to(0.1, {
        angle: 5
      }).to(0.1, {
        angle: -5
      }).to(0.1, {
        angle: 0
      }).start();
    });
    bigLetterBase.on('click', function () {
      _this3.playEffect("letter" + _this3.letter.toUpperCase());

      cc.tween(bigLetterBase).to(0.1, {
        angle: 5
      }).to(0.1, {
        angle: -5
      }).to(0.1, {
        angle: 0
      }).start();
    });
    pictureWordSmallBg.on('click', function () {
      (0, _Z_05_nxuan1_utils.jelly)(pictureWordSmallBg);

      _this3.playEffect("word" + _this3.letter.toUpperCase());
    });
    pictureWordBigBg.on('click', function () {
      (0, _Z_05_nxuan1_utils.jelly)(pictureWordBigBg);

      _this3.playEffect("word" + _this3.letter.toUpperCase());
    });
    var btnClicked = false;
    var btnBefore = cc.find('Canvas/LetterPicturePage/BtnBefore');
    var btnNext = cc.find('Canvas/LetterPicturePage/BtnNext');
    btnBefore.on('click', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!btnClicked) {
                _context.next = 2;
                break;
              }

              return _context.abrupt("return");

            case 2:
              btnClicked = true;

              _this3.playEffect('按钮');

              _context.next = 6;
              return (0, _Z_05_nxuan1_utils.jelly)(btnBefore);

            case 6:
              _this3._status.currentLetterIdx--;
              _this3._status.currentLetterIdx = Math.max(_this3._status.currentLetterIdx, 0);

              _this3.updateLetter();

              btnClicked = false;

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    btnNext.on('click', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (!btnClicked) {
                _context2.next = 2;
                break;
              }

              return _context2.abrupt("return");

            case 2:
              btnClicked = true;

              _this3.playEffect('按钮');

              _context2.next = 6;
              return (0, _Z_05_nxuan1_utils.jelly)(btnNext);

            case 6:
              _this3._status.currentLetterIdx++;
              _this3._status.currentLetterIdx = Math.min(_this3._status.currentLetterIdx, _this3.data.letterList.length - 1);

              _this3.updateLetter();

              btnClicked = false;

            case 10:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  },
  onLoadFinish: function onLoadFinish() {
    this.initListeners();
    this._status = {
      currentLetterIdx: 0,
      currentStrokeIdx: 0,
      currentStrokeStageIdx: 0
    };
    this.updateLetter();
  },
  updateLetter: function updateLetter() {
    this.letter = this.data.letterList[this._status.currentLetterIdx];
    this.letter = this.letter.toUpperCase();
    this.createLetterPage(this.letter);
    this.updatePicturePage();
  },
  updatePicturePage: function updatePicturePage() {
    var _this4 = this;

    var bigLetter = cc.find('Canvas/LetterPicturePage/BigLetterBase/BigLetter');
    bigLetter.getComponent(cc.Label).string = this.letter.toUpperCase();
    var smallLetter = cc.find('Canvas/LetterPicturePage/SmallLetterBase/SmallLetter');
    smallLetter.getComponent(cc.Label).string = this.letter.toLowerCase();
    var bgListToLetter = ['QV', 'CHKUX', 'BGIW', 'AEJNOY', 'DFLMPRSTZ'];
    var showBgIdx = bgListToLetter.findIndex(function (str) {
      return str.indexOf(_this4.letter.toUpperCase()) != -1;
    });
    bgListToLetter.forEach(function (_, idx) {
      var bgNode = cc.find("Canvas/LetterPicturePage/BgNode_" + idx);
      bgNode.active = idx == showBgIdx;
    });
    var letterWordMap = {
      a: {
        big: '<color=#73edff>A</c><color=#ffffff>PPLE</color>',
        small: '<color=#abff61>a</c><color=#ffffff>pple</color>'
      },
      b: {
        big: '<color=#73edff>B</c><color=#ffffff>AG</color>',
        small: '<color=#abff61>b</c><color=#ffffff>ag</color>'
      },
      c: {
        big: '<color=#73edff>C</c><color=#ffffff>AT</color>',
        small: '<color=#abff61>c</c><color=#ffffff>at</color>'
      },
      d: {
        big: '<color=#73edff>D</c><color=#ffffff>OG</color>',
        small: '<color=#abff61>d</c><color=#ffffff>og</color>'
      },
      e: {
        big: '<color=#73edff>E</c><color=#ffffff>GG</color>',
        small: '<color=#abff61>e</c><color=#ffffff>gg</color>'
      },
      f: {
        big: '<color=#73edff>F</c><color=#ffffff>LOWER</color>',
        small: '<color=#abff61>f</c><color=#ffffff>lower</color>'
      },
      g: {
        big: '<color=#73edff>G</c><color=#ffffff>IRL</color>',
        small: '<color=#abff61>g</c><color=#ffffff>irl</color>'
      },
      h: {
        big: '<color=#73edff>H</c><color=#ffffff>AT</color>',
        small: '<color=#abff61>h</c><color=#ffffff>at</color>'
      },
      i: {
        big: '<color=#73edff>I</c><color=#ffffff>NK</color>',
        small: '<color=#abff61>i</c><color=#ffffff>nk</color>'
      },
      j: {
        big: '<color=#73edff>J</c><color=#ffffff>AM</color>',
        small: '<color=#abff61>j</c><color=#ffffff>am</color>'
      },
      k: {
        big: '<color=#73edff>K</c><color=#ffffff>EY</color>',
        small: '<color=#abff61>k</c><color=#ffffff>ey</color>'
      },
      l: {
        big: '<color=#73edff>L</c><color=#ffffff>ION</color>',
        small: '<color=#abff61>l</c><color=#ffffff>ion</color>'
      },
      m: {
        big: '<color=#73edff>M</c><color=#ffffff>ONKEY</color>',
        small: '<color=#abff61>m</c><color=#ffffff>onkey</color>'
      },
      n: {
        big: '<color=#73edff>N</c><color=#ffffff>OODLES</color>',
        small: '<color=#abff61>n</c><color=#ffffff>oodles</color>'
      },
      o: {
        big: '<color=#73edff>O</c><color=#ffffff>RANGE</color>',
        small: '<color=#abff61>o</c><color=#ffffff>range</color>'
      },
      p: {
        big: '<color=#73edff>P</c><color=#ffffff>ANDA</color>',
        small: '<color=#abff61>p</c><color=#ffffff>anda</color>'
      },
      q: {
        big: '<color=#73edff>Q</c><color=#ffffff>UEEN</color>',
        small: '<color=#abff61>q</c><color=#ffffff>ueen</color>'
      },
      r: {
        big: '<color=#73edff>R</c><color=#ffffff>ABBIT</color>',
        small: '<color=#abff61>r</c><color=#ffffff>abbit</color>'
      },
      s: {
        big: '<color=#73edff>S</c><color=#ffffff>WAN</color>',
        small: '<color=#abff61>s</c><color=#ffffff>wan</color>'
      },
      t: {
        big: '<color=#73edff>T</c><color=#ffffff>IGER</color>',
        small: '<color=#abff61>t</c><color=#ffffff>iger</color>'
      },
      u: {
        big: '<color=#73edff>U</c><color=#ffffff>MBRELLA</color>',
        small: '<color=#abff61>u</c><color=#ffffff>mbrella</color>'
      },
      v: {
        big: '<color=#73edff>V</c><color=#ffffff>IOLIN</color>',
        small: '<color=#abff61>v</c><color=#ffffff>iolin</color>'
      },
      w: {
        big: '<color=#73edff>W</c><color=#ffffff>INDOW</color>',
        small: '<color=#abff61>w</c><color=#ffffff>indow</color>'
      },
      x: {
        big: '<color=#ffffff>BO</color><color=#73edff>X</c>',
        small: '<color=#ffffff>bo</color><color=#abff61>x</c>'
      },
      y: {
        big: '<color=#73edff>Y</c><color=#ffffff>OGURT</color>',
        small: '<color=#abff61>y</c><color=#ffffff>ogurt</color>'
      },
      z: {
        big: '<color=#73edff>Z</c><color=#ffffff>EBRA</color>',
        small: '<color=#abff61>z</c><color=#ffffff>ebra</color>'
      }
    };
    var bigPictureWordRichText = cc.find('Canvas/LetterPicturePage/PictureWordBigBg/PictureWordBigRichText');
    bigPictureWordRichText.getComponent(cc.RichText).string = letterWordMap[this.letter.toLowerCase()].big;
    var pictureWordSmallRichText = cc.find('Canvas/LetterPicturePage/PictureWordSmallBg/PictureWordSmallRichText');
    pictureWordSmallRichText.getComponent(cc.RichText).string = letterWordMap[this.letter.toLowerCase()].small;
    var letterPictureBase = cc.find('Canvas/LetterPicturePage/LetterPicture');
    letterPictureBase.children.forEach(function (node) {
      return node.active = false;
    });
    var letterPictureNode = cc.find("Canvas/LetterPicturePage/LetterPicture/bg_" + this.letter.toLowerCase());
    letterPictureNode.active = true;
    letterPictureNode.addComponent(cc.Button);
    letterPictureNode.on('click', function () {
      (0, _Z_05_nxuan1_utils.jelly)(letterPictureNode);

      _this4.playEffect("word" + _this4.letter.toUpperCase());
    });
    var changeToBig = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToBig');
    var changeToSmall = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToSmall');
    var smallLetterBase = cc.find('Canvas/LetterPicturePage/SmallLetterBase');
    var bigLetterBase = cc.find('Canvas/LetterPicturePage/BigLetterBase');
    var pictureWordSmallBg = cc.find('Canvas/LetterPicturePage/PictureWordSmallBg');
    var pictureWordBigBg = cc.find('Canvas/LetterPicturePage/PictureWordBigBg');
    changeToBig.active = false;
    changeToSmall.active = true;
    smallLetterBase.active = false;
    bigLetterBase.active = true;
    pictureWordSmallBg.active = false;
    pictureWordBigBg.active = true;
    var btnBefore = cc.find('Canvas/LetterPicturePage/BtnBefore');
    var btnNext = cc.find('Canvas/LetterPicturePage/BtnNext');
    btnBefore.active = true;
    btnNext.active = true;

    if (this._status.currentLetterIdx == 0) {
      btnBefore.active = false;
    }

    if (this._status.currentLetterIdx == this.data.letterList.length - 1) {
      btnNext.active = false;
    }
  },
  createLetterPage: function createLetterPage(letter) {
    var _this5 = this;

    this._status.currentStrokeIdx = 0;
    this._status.currentStrokeStageIdx = 0;
    var letterNodeBase = cc.instantiate(this["letter" + letter + "Prefab"]);
    letterNodeBase.name = 'letterNodeBase';
    letterNodeBase.parent = this.node;
    var btnUpdate = letterNodeBase.getChildByName('BtnUpdate');
    btnUpdate.on('click', function () {
      _this5.drawCompleteLine(_this5._status.currentStrokeIdx);

      _this5._status.currentStrokeIdx++;

      if (_this5._status.currentStrokeIdx >= 4) {
        _this5._status.currentStrokeIdx = 0;
      }

      _this5.updateArrows(_this5._status.currentStrokeIdx);
    });
    btnUpdate.active = false;
    this.updateArrows(this._status.currentStrokeIdx); // this.drawCompleteLine(this._status.currentStrokeIdx);

    var letterPageUINode = cc.instantiate(this.letterPageUINode);
    letterPageUINode.name = 'letterPageUINode';
    letterPageUINode.parent = letterNodeBase;
    var speakerNode = letterPageUINode.getChildByName('SpeakerNode');
    speakerNode.on('click', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
      return regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _this5.startSpeakerAnime(speakerNode);

              _context3.next = 3;
              return _this5.playEffect("letter" + _this5.letter.toUpperCase());

            case 3:
              _this5.stopSpeakerAnime(speakerNode);

            case 4:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3);
    })));
    var showMonkey = false;

    if ('abcdefghijklmnopqrstuvwxyz'.indexOf(letter) !== -1) {
      showMonkey = true;
    }

    var pos0 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_0_0");
    this.createShark(pos0, this.getSharkAngle(0, 0), showMonkey);
    this.node.getComponent(cc.Widget).updateAlignment();
    letterNodeBase.scaleX = this.node.height / 720;
    letterNodeBase.scaleY = this.node.height / 720;
    var bgNode = cc.instantiate(this.bgNode);
    bgNode.parent = letterNodeBase;
    bgNode.zIndex = -1;
    bgNode.width = this.node.width / letterNodeBase.scaleY;
    bgNode.addComponent(cc.Button);
    bgNode.on('click', function () {});

    if (letter !== letter.toLowerCase()) {
      bgNode.getChildByName('BgLower').active = false;
    }

    if (letter == letter.toLowerCase()) {
      var monkeyUpperNode = cc.instantiate(this.monkeyUpperNode);
      monkeyUpperNode.parent = letterNodeBase;
      monkeyUpperNode.scaleX = 720 / this.node.height;
      monkeyUpperNode.scaleY = 720 / this.node.height;
      monkeyUpperNode.y = -letterNodeBase.height / 2;
    }

    var drawMaskNode = cc.find('Canvas/letterNodeBase/DrawMaskNode');
    var letterNode = cc.find('Canvas/letterNodeBase/bg_a'); // drawMaskNode.scaleX = letterNodeBase.height / 720;
    // drawMaskNode.scaleY = letterNodeBase.height / 720;
    // letterNode.scaleX = letterNodeBase.height / 720;
    // letterNode.scaleY = letterNodeBase.height / 720;
  },
  startSpeakerAnime: function startSpeakerAnime(speakerBase) {
    var speakers = [];

    for (var index = 0; index < 3; index++) {
      var node = cc.find("Canvas/letterNodeBase/letterPageUINode/SpeakerNode/SpeakerNode_" + index);
      speakers.push(node);
    }

    var currentIdx = 0;
    cc.tween(speakerBase).call(function () {
      speakers.forEach(function (node) {
        return node.active = false;
      });
      speakers[currentIdx % speakers.length].active = true;
      currentIdx++;
    }).delay(0.2).union().repeatForever().start();
  },
  stopSpeakerAnime: function stopSpeakerAnime(speakerBase) {
    speakerBase.stopAllActions();

    for (var index = 0; index < 3; index++) {
      var node = cc.find("Canvas/letterNodeBase/letterPageUINode/SpeakerNode/SpeakerNode_" + index);
      node.active = false;
    }

    var node0 = cc.find("Canvas/letterNodeBase/letterPageUINode/SpeakerNode/SpeakerNode_0");
    node0.active = true;
  },
  getPosListByStrokeIdx: function getPosListByStrokeIdx(strokeIdx) {
    var stepIdx = 0;
    var pos0 = null;
    var drawMaskNode = cc.find('Canvas/letterNodeBase/DrawMaskNode');
    var posList = [];

    do {
      pos0 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + strokeIdx + "_" + stepIdx);
      stepIdx++;

      if (pos0) {
        posList.push({
          x: pos0.x,
          y: pos0.y
        });
      }
    } while (pos0);

    return posList;
  },
  getCurrentCheckPos: function getCurrentCheckPos() {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var nodePosBase = cc.find('Canvas/letterNodeBase/NodePosBase');
    var pos1 = nodePosBase.getChildByName("NodePos_" + this._status.currentStrokeIdx + "_" + this._status.currentStrokeStageIdx);
    var pos2 = nodePosBase.getChildByName("NodePos_" + this._status.currentStrokeIdx + "_" + (this._status.currentStrokeStageIdx + 1));

    if (pos2) {
      return [{
        x: pos1.x,
        y: pos1.y
      }, {
        x: pos2.x,
        y: pos2.y
      }];
    }

    return null;
  },
  updateArrows: function updateArrows(idx) {
    var nodePosBase = cc.find("Canvas/letterNodeBase/NodePosBase");

    if (this.arrowPrefabList) {
      this.arrowPrefabList.forEach(function (node) {
        node.parent = null;
      });
    }

    this.arrowPrefabList = [];

    for (var i = 0; i < 5; i++) {
      var startNode = nodePosBase.getChildByName("NodePos_" + i + "_0");

      if (!startNode) {
        break;
      }

      this.createStep(startNode, nodePosBase, i, idx);
    }
  },
  createStep: function createStep(startNode, nodePosBase, stepIdx, idx) {
    startNode.opacity = 0;
    var lastNode = startNode;

    for (var j = 1; j < 100; j++) {
      var endNode = nodePosBase.getChildByName("NodePos_" + stepIdx + "_" + j);

      if (!endNode) {
        break;
      }

      endNode.opacity = 0;
      this.createArrows(endNode, lastNode, stepIdx, j, idx);
      lastNode = endNode;
    }

    if (stepIdx == idx) {
      this.createStar(lastNode);
    }
  },
  createArrows: function createArrows(endNode, lastNode, skipIdx, stepIdx, idx) {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var lineVec2 = cc.v2(endNode.x - lastNode.x, endNode.y - lastNode.y);
    var lineLength = lineVec2.mag();
    var arrowNumber = Math.ceil(lineLength / 100);

    for (var k = 0; k < arrowNumber; k++) {
      if (skipIdx != idx) {
        continue;
      }

      var arrowPrefab = cc.instantiate(this.arrowPrefab);
      arrowPrefab.x = lastNode.x + lineVec2.x * (k + 1) / (arrowNumber + 1);
      arrowPrefab.y = lastNode.y + lineVec2.y * (k + 1) / (arrowNumber + 1);
      arrowPrefab.angle = cc.v2(1, 0).signAngle(lineVec2) * 180 / Math.PI; // arrowPrefab.name = name;

      arrowPrefab.parent = letterNodeBase;
      this.arrowPrefabList.push(arrowPrefab);
      var nodeArrow = arrowPrefab.getChildByName('NodeArrow');
      cc.tween(nodeArrow).delay((stepIdx + k) * 0.3).to(0.2, {
        opacity: 0
      }).delay(0.5).to(0.2, {
        opacity: 255
      }).delay(7 - (stepIdx + k) * 0.3).union().repeatForever().start();
    }
  },
  createShark: function createShark(startNode, angle, monkey) {
    if (monkey === void 0) {
      monkey = false;
    }

    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var sharkNode = null;

    if (!this.sharkNode) {
      this.sharkNode = cc.instantiate(this.sharkPreFab);
      this.sharkNode.parent = letterNodeBase;
      this.sharkNode.zIndex = 2;
      this.sharkNode.x = startNode.x;
      this.sharkNode.y = startNode.y;
      this.addSharkListeners();
    }

    sharkNode = this.sharkNode.getChildByName('SharkNode');
    sharkNode.angle = angle;
    sharkNode.active = !monkey;
    var monkeyNode = this.sharkNode.getChildByName('MonkeyNode');
    monkeyNode.active = monkey;
    cc.tween(this.sharkNode).to(0.1, {
      x: startNode.x,
      y: startNode.y
    }).start();
    cc.tween(sharkNode).to(0.1, {
      angle: angle
    }).start();
  },
  onSharkMoveStart: function onSharkMoveStart(event) {
    (0, _Z_05_nxuan1_utils.jelly)(this.sharkNode);
    this.sharkNode.startPos = event.getLocation();
    this.playEffect('按住');
    this.onDrawStart(event);
    this.onSharkMoving(event);
  },
  onSharkMoving: function onSharkMoving(event) {
    var _this6 = this;

    if (!this.sharkNode) {
      return;
    }

    var startPos = this.sharkNode.startPos;

    if (!startPos) {
      return;
    }

    var location = event.getLocation();
    var currentPosList = this.getCurrentCheckPos();

    if (!currentPosList) {
      return;
    }

    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var pos1 = currentPosList[0],
        pos2 = currentPosList[1];
    var checkLine = cc.v2(pos2.x - pos1.x, pos2.y - pos1.y);
    var locationPos = letterNodeBase.convertToNodeSpaceAR(location);
    this.sharkNode.x = locationPos.x;
    this.sharkNode.y = locationPos.y;
    var trueSharkNode = this.sharkNode.getChildByName('SharkNode');
    var angle = cc.v2(1, 0).signAngle(checkLine) * 180 / Math.PI;

    if (angle - trueSharkNode.angle < -180) {
      angle += 360;
    }

    if (angle - trueSharkNode.angle > 180) {
      angle -= 360;
    }

    if (!this.sharkNode.angleAction) {
      this.sharkNode.angleAction = true;
      cc.tween(trueSharkNode).to(0.2, {
        angle: angle
      }).call(function () {
        _this6.sharkNode.angleAction = false;
      }).start();
    }

    if (this.checkPointInCircle(this.sharkNode, pos2, 50)) {
      this._status.currentStrokeStageIdx++;

      if (this.getCurrentCheckPos() === null) {
        this.drawCompleteLine(this._status.currentStrokeIdx);
        this.showStar();
        this._status.currentStrokeIdx++;
        this._status.currentStrokeStageIdx = 0;

        if (this.getCurrentCheckPos() === null) {
          this.showOver();
        }

        this.updateArrows(this._status.currentStrokeIdx);
        this.onSharkMoveEnd(event);
      }
    }

    var posList = this.getPosListByStrokeIdx(this._status.currentStrokeIdx);

    if (!this.checkPointInRangeList(letterNodeBase.convertToNodeSpaceAR(location), posList, 50)) {
      this._status.currentStrokeStageIdx = 0;
      this.onSharkMoveEnd(event);
      return;
    }

    this.onDrawMove(event);
  },
  getSharkAngle: function getSharkAngle(currentStrokeIdx, currentStrokeStageIdx) {
    var pos1 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + currentStrokeIdx + "_" + currentStrokeStageIdx);
    var pos2 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + currentStrokeIdx + "_" + (currentStrokeStageIdx + 1));
    var line = cc.v2(pos2.x - pos1.x, pos2.y - pos1.y);
    return cc.v2(1, 0).signAngle(line) * 180 / Math.PI;
  },
  onSharkMoveEnd: function onSharkMoveEnd(event) {
    var pos = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + this._status.currentStrokeIdx + "_0");

    if (!pos) {
      return;
    }

    this._status.currentStrokeStageIdx = 0;
    cc.tween(this.sharkNode).to(0.1, {
      x: pos.x,
      y: pos.y
    }).start();
    cc.tween(this.sharkNode.getChildByName('SharkNode')).to(0.1, {
      angle: this.getSharkAngle(this._status.currentStrokeIdx, 0)
    }).start();
    this.sharkNode.startPos = null;
    this.onDrawEnd(event);
  },
  addSharkListeners: function addSharkListeners() {
    this.sharkNode.on('touchstart', this.onSharkMoveStart, this);
    this.sharkNode.on('touchmove', this.onSharkMoving, this);
    this.sharkNode.on('touchend', this.onSharkMoveEnd, this);
    this.sharkNode.on('touchcancel', this.onSharkMoveEnd, this);
  },
  hideShark: function hideShark() {
    var _this7 = this;

    cc.tween(this.sharkNode).to(0.3, {
      opacity: 0
    }).call(function () {
      _this7.sharkNode.parent = null;
      _this7.sharkNode = null;
    }).start();
  },
  showOver: function showOver() {
    var _this8 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
      return regeneratorRuntime.wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              _this8.hideShark();

              _this8.playEffect('放大');

              _context4.next = 4;
              return _this8.showCompleteStar();

            case 4:
              _this8.playEffect("letter" + _this8.letter.toUpperCase());

              _context4.next = 7;
              return _this8.showRibbons();

            case 7:
              _this8.playEffect('撒花');

              _context4.next = 10;
              return _this8.showCloud();

            case 10:
              _this8.pageFlyOut();

              if (_this8.letter !== _this8.letter.toLowerCase()) {
                _this8.letter = _this8.letter.toLowerCase();

                _this8.createLetterPage(_this8.letter);
              }

            case 12:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4);
    }))();
  },
  showCompleteStar: function showCompleteStar() {
    var _this9 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
      return regeneratorRuntime.wrap(function _callee5$(_context5) {
        while (1) {
          switch (_context5.prev = _context5.next) {
            case 0:
              return _context5.abrupt("return", new Promise(function (resolve, reject) {
                _this9.starNode.zIndex = 10;
                cc.tween(_this9.starNode).to(0.1, {
                  opacity: 255
                }).to(1, {
                  x: 0,
                  y: 0,
                  scale: 3
                }).to(1, {
                  scale: 6,
                  opacity: 0
                }).call(resolve).start();
              }));

            case 1:
            case "end":
              return _context5.stop();
          }
        }
      }, _callee5);
    }))();
  },
  showCloud: function showCloud() {
    var _this10 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
      var cloudPosList, posList;
      return regeneratorRuntime.wrap(function _callee7$(_context7) {
        while (1) {
          switch (_context7.prev = _context7.next) {
            case 0:
              cloudPosList = [];
              posList = _this10.getCloudPosList();
              posList.forEach(function (stepList) {
                // stepList
                for (var i = 0; i < stepList.length - 1; i++) {
                  var pos0 = stepList[i];
                  var pos1 = stepList[i + 1];
                  var line = cc.v2(pos1.x - pos0.x, pos1.y - pos0.y);
                  cloudPosList.push(pos0);

                  if (line.mag() > 150) {
                    var length = Math.ceil(line.mag() / 80);

                    for (var j = 1; j < length; j++) {
                      var newLine = line.mul(j / length);
                      cloudPosList.push({
                        x: newLine.x + pos0.x,
                        y: newLine.y + pos0.y
                      });
                    }
                  }
                }

                cloudPosList.push(stepList[stepList.length - 1]);
              });
              _context7.next = 5;
              return Promise.all(cloudPosList.map( /*#__PURE__*/function () {
                var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(pos, idx) {
                  return regeneratorRuntime.wrap(function _callee6$(_context6) {
                    while (1) {
                      switch (_context6.prev = _context6.next) {
                        case 0:
                          _context6.next = 2;
                          return _this10.createCloud(pos, idx);

                        case 2:
                        case "end":
                          return _context6.stop();
                      }
                    }
                  }, _callee6);
                }));

                return function (_x, _x2) {
                  return _ref4.apply(this, arguments);
                };
              }()));

            case 5:
            case "end":
              return _context7.stop();
          }
        }
      }, _callee7);
    }))();
  },
  createCloud: function createCloud(_ref5, idx) {
    var _this11 = this;

    var x = _ref5.x,
        y = _ref5.y;
    return new Promise(function (resolve, reject) {
      var letterNodeBase = cc.find("Canvas/letterNodeBase");
      var cloud = cc.instantiate(_this11.cloudPrefab);
      cloud.parent = letterNodeBase;
      cloud.x = x;
      cloud.y = y;
      cloud.scale = 0;
      cc.tween(cloud).delay(idx * 0.1).to(0.2, {
        scale: 1.2
      }).to(0.05, {
        scale: 1
      }).call(resolve).start();
    });
  },
  getCloudPosList: function getCloudPosList() {
    var posList = [];

    do {
      var currentPosList = [];
      var currentStepIdx = posList.length;
      var currentPosIdx = 0;

      do {
        var pos = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + currentStepIdx + "_" + currentPosIdx);

        if (!pos) {
          break;
        }

        currentPosIdx++;
        currentPosList.push({
          x: pos.x,
          y: pos.y
        });
      } while (true);

      if (currentPosList.length == 0) {
        break;
      }

      posList.push(currentPosList);
    } while (true);

    return posList;
  },
  pageFlyOut: function pageFlyOut() {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    letterNodeBase.name = 'letterNodeBase0';
    letterNodeBase.zIndex = 10;
    cc.tween(letterNodeBase).to(1.2, {
      y: 1500
    }, {
      easing: 'cubicIn'
    }).start();
  },
  createStar: function createStar(endNode) {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");

    if (this.starNode) {
      this.starNode.parent = null;
      this.starNode = null;
    }

    var starNode = cc.instantiate(this.starPreFab);
    starNode.parent = letterNodeBase;
    starNode.x = endNode.x;
    starNode.y = endNode.y;
    this.starNode = starNode;
  },
  showStar: function showStar() {
    var _this12 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
      var starAnimeNode;
      return regeneratorRuntime.wrap(function _callee8$(_context8) {
        while (1) {
          switch (_context8.prev = _context8.next) {
            case 0:
              starAnimeNode = cc.instantiate(_this12.starAnimePrefab);
              starAnimeNode.parent = _this12.node;
              starAnimeNode.x = _this12.starNode.x;
              starAnimeNode.y = _this12.starNode.y;
              starAnimeNode.zIndex = 10;
              cc.tween(_this12.starNode).to(0.1, {
                opacity: 0
              }).start();

              _this12.playEffect('star');

              _context8.next = 9;
              return (0, _Z_05_nxuan1_utils.asyncPlayDragonBoneAnimation)(starAnimeNode, 'star', 1);

            case 9:
              starAnimeNode.parent = null;
              starAnimeNode = null;

            case 11:
            case "end":
              return _context8.stop();
          }
        }
      }, _callee8);
    }))();
  },
  showRibbons: function showRibbons() {
    var _this13 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
      var i, ribbonNodeBase, ribbonNode;
      return regeneratorRuntime.wrap(function _callee9$(_context9) {
        while (1) {
          switch (_context9.prev = _context9.next) {
            case 0:
              for (i = 0; i < 50; i++) {
                ribbonNodeBase = cc.instantiate(cc.find('Canvas/RibbonNodeBase'));
                ribbonNodeBase.parent = _this13.node;
                ribbonNodeBase.y = 400 + (0, _Z_05_nxuan1_utils.RandomInt)(720);
                ribbonNodeBase.zIndex = 10;
                ribbonNodeBase.x = (0, _Z_05_nxuan1_utils.RandomInt)(-720, 720);
                ribbonNodeBase.angle = (0, _Z_05_nxuan1_utils.RandomInt)(360);
                ribbonNode = ribbonNodeBase.getChildByName("RibbonNode_" + (0, _Z_05_nxuan1_utils.RandomInt)(4));
                ribbonNode.active = true;
                cc.tween(ribbonNodeBase).by(3, {
                  y: -1600,
                  x: (0, _Z_05_nxuan1_utils.RandomInt)(-100, 100),
                  angle: (0, _Z_05_nxuan1_utils.RandomInt)(-60, 60)
                }).start();
              }

            case 1:
            case "end":
              return _context9.stop();
          }
        }
      }, _callee9);
    }))();
  },
  drawCompleteLine: function drawCompleteLine(strokeIdx) {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeBase');
    this.drawLines(drawGraphyNode, this.getPosListByStrokeIdx(strokeIdx));
  },
  drawLines: function drawLines(drawNode, posList) {
    var graph = drawNode.getComponent(cc.Graphics);
    posList.forEach(function (pos, idx) {
      if (idx == 0) {
        graph.moveTo(pos.x, pos.y);
        return;
      }

      graph.lineTo(pos.x, pos.y);
    });
    graph.stroke();
  },
  onDrawStart: function onDrawStart(event) {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    var graph = drawGraphyNode.getComponent(cc.Graphics);
    var location = event.getLocation();
    var pos = drawGraphyNode.convertToNodeSpaceAR(location);
    graph.moveTo(pos.x, pos.y);
  },
  onDrawMove: function onDrawMove(event) {
    if (!this._moveCount) {
      this._moveCount = 0;
    }

    this._moveCount++;

    if (this._moveCount < 5) {
      return;
    }

    this._moveCount = 0;
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    var graph = drawGraphyNode.getComponent(cc.Graphics);
    var location = event.getLocation();
    var pos = drawGraphyNode.convertToNodeSpaceAR(location);
    graph.lineTo(pos.x, pos.y);
    graph.stroke();
  },
  onDrawEnd: function onDrawEnd(event) {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    var graph = drawGraphyNode.getComponent(cc.Graphics);
    graph.clear();
  },
  addDrawListeners: function addDrawListeners() {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    drawGraphyNode.on('touchstart', this.onDrawStart, this);
    drawGraphyNode.on('touchmove', this.onDrawMove, this);
    drawGraphyNode.on('touchend', this.onDrawEnd, this);
    drawGraphyNode.on('touchcancel', this.onDrawEnd, this);
  },
  checkPointInCircle: function checkPointInCircle(pos, center, radius) {
    var line = cc.v2(pos.x - center.x, pos.y - center.y);

    if (line.mag() > radius) {
      return false;
    }

    return true;
  },
  checkPointInRangeList: function checkPointInRangeList(pos, rangePosList, radius) {
    var _this14 = this;

    var inRange = false;
    rangePosList.forEach(function (rangePos, idx) {
      if (idx == 0) {
        return;
      }

      inRange = inRange || _this14.checkPointInRange(pos, rangePosList[idx - 1], rangePos, radius);
    });
    return inRange;
  },
  checkPointInRange: function checkPointInRange(pos, rangePos1, rangePos2, radius) {
    var linePos2 = cc.v2(rangePos2.x - rangePos1.x, rangePos2.y - rangePos1.y);
    var linePos = cc.v2(pos.x - rangePos1.x, pos.y - rangePos1.y);
    var angle = linePos2.signAngle(linePos);
    var distance = linePos.mag() * Math.sin(angle); // 如果pos点到pos1与pos2连线的距离大于半径，则超出

    if (distance > radius || distance < -radius) {
      return false;
    }

    var projection = linePos.mag() * Math.cos(angle); // 如果pos1到pos点的向量到pos1到pos2的向量投影长度超出范围

    if (projection < -radius || projection > radius + linePos2.mag()) {
      return false;
    }

    return true;
  },
  playEffect: function playEffect(name, loop, volume) {
    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
      var musicComponent;
      return regeneratorRuntime.wrap(function _callee10$(_context10) {
        while (1) {
          switch (_context10.prev = _context10.next) {
            case 0:
              musicComponent = cc.find('Canvas/MusicNode').getComponent('Z_05_nxuan1_MusicNode');
              _context10.next = 3;
              return musicComponent.playEffect(name, loop, volume);

            case 3:
            case "end":
              return _context10.stop();
          }
        }
      }, _callee10);
    }))();
  }
});

cc._RF.pop();