
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Z_05_nxuan1/scene/Z_05_nxuan1.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '16e664NoZRDVLBg7jQiJNBs', 'Z_05_nxuan1');
// Z_05_nxuan1/scene/Z_05_nxuan1.js

"use strict";

var _Z_05_nxuan1_utils = require("../script/Z_05_nxuan1_utils");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
var defaultData = require('../script/Z_05_nxuan1_defaultData');

cc.Class({
  "extends": cc.Component,
  properties: {
    letter: 'b',
    bgNode: {
      type: cc.Prefab,
      "default": null
    },
    monkeyUpperNode: {
      type: cc.Prefab,
      "default": null
    },
    letterPageUINode: {
      type: cc.Prefab,
      "default": null
    },
    cloudPrefab: {
      type: cc.Prefab,
      "default": null
    },
    starAnimePrefab: {
      type: cc.Prefab,
      "default": null
    },
    starPreFab: {
      type: cc.Prefab,
      "default": null
    },
    sharkPreFab: {
      type: cc.Prefab,
      "default": null
    },
    arrowPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterAPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterBPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterCPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterDPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterEPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterFPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterGPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterHPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterIPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterJPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterKPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterLPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterMPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterNPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterOPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterPPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterQPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterRPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterSPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterTPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterUPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterVPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterWPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterXPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterYPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterZPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteraPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterbPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettercPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterdPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterePrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterfPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettergPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterhPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteriPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterjPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterkPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterlPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettermPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letternPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteroPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterpPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterqPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterrPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettersPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettertPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteruPrefab: {
      type: cc.Prefab,
      "default": null
    },
    lettervPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterwPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterxPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letteryPrefab: {
      type: cc.Prefab,
      "default": null
    },
    letterzPrefab: {
      type: cc.Prefab,
      "default": null
    }
  },
  // LIFE-CYCLE CALLBACKS:
  // onLoad () {},
  ctor: function ctor() {
    this._imageResList = [];
    this._audioResList = [];
  },
  start: function start() {
    var _this = this;

    cc.debug.setDisplayStats(false);
    this.data = defaultData;
    this.getData(function (data) {
      if (data) {
        _this.data = data;
      }

      _this.preloadItem();
    });
  },
  getData: function getData(func) {
    if (window && window.courseware) {
      window.courseware.getData(func, 'Z_05_nxuan1');
    } else {
      func(defaultData);
    }
  },
  _imageResList: null,
  _audioResList: null,
  preloadItem: function preloadItem() {
    this.addPreloadImage();
    this.addPreloadAudio();
    this.preload();
    this.onLoadFinish();
  },
  addPreloadImage: function addPreloadImage() {},
  addPreloadAudio: function addPreloadAudio() {},
  preload: function preload() {
    var _this2 = this;

    var preloadArr = this._imageResList.concat(this._audioResList);

    cc.assetManager.loadAny(preloadArr, null, null, function (err, data) {
      _this2.hideAirClassLoading();
    });

    if (preloadArr.length == 0) {
      this.hideAirClassLoading();
    }
  },
  hideAirClassLoading: function hideAirClassLoading() {
    if (window && window["air"]) {
      window["air"].hideAirClassLoading();
      console.log('hideAirClassLoading');
    }
  },
  initListeners: function initListeners() {
    var _this3 = this;

    var btnSwitch = cc.find('Canvas/LetterPicturePage/BtnSwitch');
    var changeToBig = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToBig');
    var changeToSmall = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToSmall');
    var smallLetterBase = cc.find('Canvas/LetterPicturePage/SmallLetterBase');
    var bigLetterBase = cc.find('Canvas/LetterPicturePage/BigLetterBase');
    var pictureWordSmallBg = cc.find('Canvas/LetterPicturePage/PictureWordSmallBg');
    var pictureWordBigBg = cc.find('Canvas/LetterPicturePage/PictureWordBigBg');
    btnSwitch.on('click', function () {
      _this3.playEffect('按钮');

      changeToBig.active = !changeToBig.active;
      bigLetterBase.active = !bigLetterBase.active;
      pictureWordBigBg.active = !pictureWordBigBg.active;
      changeToSmall.active = !changeToSmall.active;
      smallLetterBase.active = !smallLetterBase.active;
      pictureWordSmallBg.active = !pictureWordSmallBg.active;
    });
    smallLetterBase.on('click', function () {
      _this3.playEffect("letter" + _this3.letter.toUpperCase());

      cc.tween(smallLetterBase).to(0.1, {
        angle: 5
      }).to(0.1, {
        angle: -5
      }).to(0.1, {
        angle: 0
      }).start();
    });
    bigLetterBase.on('click', function () {
      _this3.playEffect("letter" + _this3.letter.toUpperCase());

      cc.tween(bigLetterBase).to(0.1, {
        angle: 5
      }).to(0.1, {
        angle: -5
      }).to(0.1, {
        angle: 0
      }).start();
    });
    pictureWordSmallBg.on('click', function () {
      (0, _Z_05_nxuan1_utils.jelly)(pictureWordSmallBg);

      _this3.playEffect("word" + _this3.letter.toUpperCase());
    });
    pictureWordBigBg.on('click', function () {
      (0, _Z_05_nxuan1_utils.jelly)(pictureWordBigBg);

      _this3.playEffect("word" + _this3.letter.toUpperCase());
    });
    var btnClicked = false;
    var btnBefore = cc.find('Canvas/LetterPicturePage/BtnBefore');
    var btnNext = cc.find('Canvas/LetterPicturePage/BtnNext');
    btnBefore.on('click', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!btnClicked) {
                _context.next = 2;
                break;
              }

              return _context.abrupt("return");

            case 2:
              btnClicked = true;

              _this3.playEffect('按钮');

              _context.next = 6;
              return (0, _Z_05_nxuan1_utils.jelly)(btnBefore);

            case 6:
              _this3._status.currentLetterIdx--;
              _this3._status.currentLetterIdx = Math.max(_this3._status.currentLetterIdx, 0);

              _this3.updateLetter();

              btnClicked = false;

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    btnNext.on('click', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (!btnClicked) {
                _context2.next = 2;
                break;
              }

              return _context2.abrupt("return");

            case 2:
              btnClicked = true;

              _this3.playEffect('按钮');

              _context2.next = 6;
              return (0, _Z_05_nxuan1_utils.jelly)(btnNext);

            case 6:
              _this3._status.currentLetterIdx++;
              _this3._status.currentLetterIdx = Math.min(_this3._status.currentLetterIdx, _this3.data.letterList.length - 1);

              _this3.updateLetter();

              btnClicked = false;

            case 10:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  },
  onLoadFinish: function onLoadFinish() {
    this.initListeners();
    this._status = {
      currentLetterIdx: 0,
      currentStrokeIdx: 0,
      currentStrokeStageIdx: 0
    };
    this.updateLetter();
  },
  updateLetter: function updateLetter() {
    this.letter = this.data.letterList[this._status.currentLetterIdx];
    this.letter = this.letter.toUpperCase();
    this.createLetterPage(this.letter);
    this.updatePicturePage();
  },
  updatePicturePage: function updatePicturePage() {
    var _this4 = this;

    var bigLetter = cc.find('Canvas/LetterPicturePage/BigLetterBase/BigLetter');
    bigLetter.getComponent(cc.Label).string = this.letter.toUpperCase();
    var smallLetter = cc.find('Canvas/LetterPicturePage/SmallLetterBase/SmallLetter');
    smallLetter.getComponent(cc.Label).string = this.letter.toLowerCase();
    var bgListToLetter = ['QV', 'CHKUX', 'BGIW', 'AEJNOY', 'DFLMPRSTZ'];
    var showBgIdx = bgListToLetter.findIndex(function (str) {
      return str.indexOf(_this4.letter.toUpperCase()) != -1;
    });
    bgListToLetter.forEach(function (_, idx) {
      var bgNode = cc.find("Canvas/LetterPicturePage/BgNode_" + idx);
      bgNode.active = idx == showBgIdx;
    });
    var letterWordMap = {
      a: {
        big: '<color=#73edff>A</c><color=#ffffff>PPLE</color>',
        small: '<color=#abff61>a</c><color=#ffffff>pple</color>'
      },
      b: {
        big: '<color=#73edff>B</c><color=#ffffff>AG</color>',
        small: '<color=#abff61>b</c><color=#ffffff>ag</color>'
      },
      c: {
        big: '<color=#73edff>C</c><color=#ffffff>AT</color>',
        small: '<color=#abff61>c</c><color=#ffffff>at</color>'
      },
      d: {
        big: '<color=#73edff>D</c><color=#ffffff>OG</color>',
        small: '<color=#abff61>d</c><color=#ffffff>og</color>'
      },
      e: {
        big: '<color=#73edff>E</c><color=#ffffff>GG</color>',
        small: '<color=#abff61>e</c><color=#ffffff>gg</color>'
      },
      f: {
        big: '<color=#73edff>F</c><color=#ffffff>LOWER</color>',
        small: '<color=#abff61>f</c><color=#ffffff>lower</color>'
      },
      g: {
        big: '<color=#73edff>G</c><color=#ffffff>IRL</color>',
        small: '<color=#abff61>g</c><color=#ffffff>irl</color>'
      },
      h: {
        big: '<color=#73edff>H</c><color=#ffffff>AT</color>',
        small: '<color=#abff61>h</c><color=#ffffff>at</color>'
      },
      i: {
        big: '<color=#73edff>I</c><color=#ffffff>NK</color>',
        small: '<color=#abff61>i</c><color=#ffffff>nk</color>'
      },
      j: {
        big: '<color=#73edff>J</c><color=#ffffff>AM</color>',
        small: '<color=#abff61>j</c><color=#ffffff>am</color>'
      },
      k: {
        big: '<color=#73edff>K</c><color=#ffffff>EY</color>',
        small: '<color=#abff61>k</c><color=#ffffff>ey</color>'
      },
      l: {
        big: '<color=#73edff>L</c><color=#ffffff>ION</color>',
        small: '<color=#abff61>l</c><color=#ffffff>ion</color>'
      },
      m: {
        big: '<color=#73edff>M</c><color=#ffffff>ONKEY</color>',
        small: '<color=#abff61>m</c><color=#ffffff>onkey</color>'
      },
      n: {
        big: '<color=#73edff>N</c><color=#ffffff>OODLES</color>',
        small: '<color=#abff61>n</c><color=#ffffff>oodles</color>'
      },
      o: {
        big: '<color=#73edff>O</c><color=#ffffff>RANGE</color>',
        small: '<color=#abff61>o</c><color=#ffffff>range</color>'
      },
      p: {
        big: '<color=#73edff>P</c><color=#ffffff>ANDA</color>',
        small: '<color=#abff61>p</c><color=#ffffff>anda</color>'
      },
      q: {
        big: '<color=#73edff>Q</c><color=#ffffff>UEEN</color>',
        small: '<color=#abff61>q</c><color=#ffffff>ueen</color>'
      },
      r: {
        big: '<color=#73edff>R</c><color=#ffffff>ABBIT</color>',
        small: '<color=#abff61>r</c><color=#ffffff>abbit</color>'
      },
      s: {
        big: '<color=#73edff>S</c><color=#ffffff>WAN</color>',
        small: '<color=#abff61>s</c><color=#ffffff>wan</color>'
      },
      t: {
        big: '<color=#73edff>T</c><color=#ffffff>IGER</color>',
        small: '<color=#abff61>t</c><color=#ffffff>iger</color>'
      },
      u: {
        big: '<color=#73edff>U</c><color=#ffffff>MBRELLA</color>',
        small: '<color=#abff61>u</c><color=#ffffff>mbrella</color>'
      },
      v: {
        big: '<color=#73edff>V</c><color=#ffffff>IOLIN</color>',
        small: '<color=#abff61>v</c><color=#ffffff>iolin</color>'
      },
      w: {
        big: '<color=#73edff>W</c><color=#ffffff>INDOW</color>',
        small: '<color=#abff61>w</c><color=#ffffff>indow</color>'
      },
      x: {
        big: '<color=#ffffff>BO</color><color=#73edff>X</c>',
        small: '<color=#ffffff>bo</color><color=#abff61>x</c>'
      },
      y: {
        big: '<color=#73edff>Y</c><color=#ffffff>OGURT</color>',
        small: '<color=#abff61>y</c><color=#ffffff>ogurt</color>'
      },
      z: {
        big: '<color=#73edff>Z</c><color=#ffffff>EBRA</color>',
        small: '<color=#abff61>z</c><color=#ffffff>ebra</color>'
      }
    };
    var bigPictureWordRichText = cc.find('Canvas/LetterPicturePage/PictureWordBigBg/PictureWordBigRichText');
    bigPictureWordRichText.getComponent(cc.RichText).string = letterWordMap[this.letter.toLowerCase()].big;
    var pictureWordSmallRichText = cc.find('Canvas/LetterPicturePage/PictureWordSmallBg/PictureWordSmallRichText');
    pictureWordSmallRichText.getComponent(cc.RichText).string = letterWordMap[this.letter.toLowerCase()].small;
    var letterPictureBase = cc.find('Canvas/LetterPicturePage/LetterPicture');
    letterPictureBase.children.forEach(function (node) {
      return node.active = false;
    });
    var letterPictureNode = cc.find("Canvas/LetterPicturePage/LetterPicture/bg_" + this.letter.toLowerCase());
    letterPictureNode.active = true;
    letterPictureNode.addComponent(cc.Button);
    letterPictureNode.on('click', function () {
      (0, _Z_05_nxuan1_utils.jelly)(letterPictureNode);

      _this4.playEffect("word" + _this4.letter.toUpperCase());
    });
    var changeToBig = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToBig');
    var changeToSmall = cc.find('Canvas/LetterPicturePage/BtnSwitch/ChangeToSmall');
    var smallLetterBase = cc.find('Canvas/LetterPicturePage/SmallLetterBase');
    var bigLetterBase = cc.find('Canvas/LetterPicturePage/BigLetterBase');
    var pictureWordSmallBg = cc.find('Canvas/LetterPicturePage/PictureWordSmallBg');
    var pictureWordBigBg = cc.find('Canvas/LetterPicturePage/PictureWordBigBg');
    changeToBig.active = false;
    changeToSmall.active = true;
    smallLetterBase.active = false;
    bigLetterBase.active = true;
    pictureWordSmallBg.active = false;
    pictureWordBigBg.active = true;
    var btnBefore = cc.find('Canvas/LetterPicturePage/BtnBefore');
    var btnNext = cc.find('Canvas/LetterPicturePage/BtnNext');
    btnBefore.active = true;
    btnNext.active = true;

    if (this._status.currentLetterIdx == 0) {
      btnBefore.active = false;
    }

    if (this._status.currentLetterIdx == this.data.letterList.length - 1) {
      btnNext.active = false;
    }
  },
  createLetterPage: function createLetterPage(letter) {
    var _this5 = this;

    this._status.currentStrokeIdx = 0;
    this._status.currentStrokeStageIdx = 0;
    var letterNodeBase = cc.instantiate(this["letter" + letter + "Prefab"]);
    letterNodeBase.name = 'letterNodeBase';
    letterNodeBase.parent = this.node;
    var btnUpdate = letterNodeBase.getChildByName('BtnUpdate');
    btnUpdate.on('click', function () {
      _this5.drawCompleteLine(_this5._status.currentStrokeIdx);

      _this5._status.currentStrokeIdx++;

      if (_this5._status.currentStrokeIdx >= 4) {
        _this5._status.currentStrokeIdx = 0;
      }

      _this5.updateArrows(_this5._status.currentStrokeIdx);
    });
    btnUpdate.active = false;
    this.updateArrows(this._status.currentStrokeIdx); // this.drawCompleteLine(this._status.currentStrokeIdx);

    var letterPageUINode = cc.instantiate(this.letterPageUINode);
    letterPageUINode.name = 'letterPageUINode';
    letterPageUINode.parent = letterNodeBase;
    var speakerNode = letterPageUINode.getChildByName('SpeakerNode');
    speakerNode.on('click', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
      return regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _this5.startSpeakerAnime(speakerNode);

              _context3.next = 3;
              return _this5.playEffect("letter" + _this5.letter.toUpperCase());

            case 3:
              _this5.stopSpeakerAnime(speakerNode);

            case 4:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3);
    })));
    var showMonkey = false;

    if ('abcdefghijklmnopqrstuvwxyz'.indexOf(letter) !== -1) {
      showMonkey = true;
    }

    var pos0 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_0_0");
    this.createShark(pos0, this.getSharkAngle(0, 0), showMonkey);
    this.node.getComponent(cc.Widget).updateAlignment();
    letterNodeBase.scaleX = this.node.height / 720;
    letterNodeBase.scaleY = this.node.height / 720;
    var bgNode = cc.instantiate(this.bgNode);
    bgNode.parent = letterNodeBase;
    bgNode.zIndex = -1;
    bgNode.width = this.node.width / letterNodeBase.scaleY;
    bgNode.addComponent(cc.Button);
    bgNode.on('click', function () {});

    if (letter !== letter.toLowerCase()) {
      bgNode.getChildByName('BgLower').active = false;
    }

    if (letter == letter.toLowerCase()) {
      var monkeyUpperNode = cc.instantiate(this.monkeyUpperNode);
      monkeyUpperNode.parent = letterNodeBase;
      monkeyUpperNode.scaleX = 720 / this.node.height;
      monkeyUpperNode.scaleY = 720 / this.node.height;
      monkeyUpperNode.y = -letterNodeBase.height / 2;
    }

    var drawMaskNode = cc.find('Canvas/letterNodeBase/DrawMaskNode');
    var letterNode = cc.find('Canvas/letterNodeBase/bg_a'); // drawMaskNode.scaleX = letterNodeBase.height / 720;
    // drawMaskNode.scaleY = letterNodeBase.height / 720;
    // letterNode.scaleX = letterNodeBase.height / 720;
    // letterNode.scaleY = letterNodeBase.height / 720;
  },
  startSpeakerAnime: function startSpeakerAnime(speakerBase) {
    var speakers = [];

    for (var index = 0; index < 3; index++) {
      var node = cc.find("Canvas/letterNodeBase/letterPageUINode/SpeakerNode/SpeakerNode_" + index);
      speakers.push(node);
    }

    var currentIdx = 0;
    cc.tween(speakerBase).call(function () {
      speakers.forEach(function (node) {
        return node.active = false;
      });
      speakers[currentIdx % speakers.length].active = true;
      currentIdx++;
    }).delay(0.2).union().repeatForever().start();
  },
  stopSpeakerAnime: function stopSpeakerAnime(speakerBase) {
    speakerBase.stopAllActions();

    for (var index = 0; index < 3; index++) {
      var node = cc.find("Canvas/letterNodeBase/letterPageUINode/SpeakerNode/SpeakerNode_" + index);
      node.active = false;
    }

    var node0 = cc.find("Canvas/letterNodeBase/letterPageUINode/SpeakerNode/SpeakerNode_0");
    node0.active = true;
  },
  getPosListByStrokeIdx: function getPosListByStrokeIdx(strokeIdx) {
    var stepIdx = 0;
    var pos0 = null;
    var drawMaskNode = cc.find('Canvas/letterNodeBase/DrawMaskNode');
    var posList = [];

    do {
      pos0 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + strokeIdx + "_" + stepIdx);
      stepIdx++;

      if (pos0) {
        posList.push({
          x: pos0.x,
          y: pos0.y
        });
      }
    } while (pos0);

    return posList;
  },
  getCurrentCheckPos: function getCurrentCheckPos() {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var nodePosBase = cc.find('Canvas/letterNodeBase/NodePosBase');
    var pos1 = nodePosBase.getChildByName("NodePos_" + this._status.currentStrokeIdx + "_" + this._status.currentStrokeStageIdx);
    var pos2 = nodePosBase.getChildByName("NodePos_" + this._status.currentStrokeIdx + "_" + (this._status.currentStrokeStageIdx + 1));

    if (pos2) {
      return [{
        x: pos1.x,
        y: pos1.y
      }, {
        x: pos2.x,
        y: pos2.y
      }];
    }

    return null;
  },
  updateArrows: function updateArrows(idx) {
    var nodePosBase = cc.find("Canvas/letterNodeBase/NodePosBase");

    if (this.arrowPrefabList) {
      this.arrowPrefabList.forEach(function (node) {
        node.parent = null;
      });
    }

    this.arrowPrefabList = [];

    for (var i = 0; i < 5; i++) {
      var startNode = nodePosBase.getChildByName("NodePos_" + i + "_0");

      if (!startNode) {
        break;
      }

      this.createStep(startNode, nodePosBase, i, idx);
    }
  },
  createStep: function createStep(startNode, nodePosBase, stepIdx, idx) {
    startNode.opacity = 0;
    var lastNode = startNode;

    for (var j = 1; j < 100; j++) {
      var endNode = nodePosBase.getChildByName("NodePos_" + stepIdx + "_" + j);

      if (!endNode) {
        break;
      }

      endNode.opacity = 0;
      this.createArrows(endNode, lastNode, stepIdx, j, idx);
      lastNode = endNode;
    }

    if (stepIdx == idx) {
      this.createStar(lastNode);
    }
  },
  createArrows: function createArrows(endNode, lastNode, skipIdx, stepIdx, idx) {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var lineVec2 = cc.v2(endNode.x - lastNode.x, endNode.y - lastNode.y);
    var lineLength = lineVec2.mag();
    var arrowNumber = Math.ceil(lineLength / 100);

    for (var k = 0; k < arrowNumber; k++) {
      if (skipIdx != idx) {
        continue;
      }

      var arrowPrefab = cc.instantiate(this.arrowPrefab);
      arrowPrefab.x = lastNode.x + lineVec2.x * (k + 1) / (arrowNumber + 1);
      arrowPrefab.y = lastNode.y + lineVec2.y * (k + 1) / (arrowNumber + 1);
      arrowPrefab.angle = cc.v2(1, 0).signAngle(lineVec2) * 180 / Math.PI; // arrowPrefab.name = name;

      arrowPrefab.parent = letterNodeBase;
      this.arrowPrefabList.push(arrowPrefab);
      var nodeArrow = arrowPrefab.getChildByName('NodeArrow');
      cc.tween(nodeArrow).delay((stepIdx + k) * 0.3).to(0.2, {
        opacity: 0
      }).delay(0.5).to(0.2, {
        opacity: 255
      }).delay(7 - (stepIdx + k) * 0.3).union().repeatForever().start();
    }
  },
  createShark: function createShark(startNode, angle, monkey) {
    if (monkey === void 0) {
      monkey = false;
    }

    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var sharkNode = null;

    if (!this.sharkNode) {
      this.sharkNode = cc.instantiate(this.sharkPreFab);
      this.sharkNode.parent = letterNodeBase;
      this.sharkNode.zIndex = 2;
      this.sharkNode.x = startNode.x;
      this.sharkNode.y = startNode.y;
      this.addSharkListeners();
    }

    sharkNode = this.sharkNode.getChildByName('SharkNode');
    sharkNode.angle = angle;
    sharkNode.active = !monkey;
    var monkeyNode = this.sharkNode.getChildByName('MonkeyNode');
    monkeyNode.active = monkey;
    cc.tween(this.sharkNode).to(0.1, {
      x: startNode.x,
      y: startNode.y
    }).start();
    cc.tween(sharkNode).to(0.1, {
      angle: angle
    }).start();
  },
  onSharkMoveStart: function onSharkMoveStart(event) {
    (0, _Z_05_nxuan1_utils.jelly)(this.sharkNode);
    this.sharkNode.startPos = event.getLocation();
    this.playEffect('按住');
    this.onDrawStart(event);
    this.onSharkMoving(event);
  },
  onSharkMoving: function onSharkMoving(event) {
    var _this6 = this;

    if (!this.sharkNode) {
      return;
    }

    var startPos = this.sharkNode.startPos;

    if (!startPos) {
      return;
    }

    var location = event.getLocation();
    var currentPosList = this.getCurrentCheckPos();

    if (!currentPosList) {
      return;
    }

    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    var pos1 = currentPosList[0],
        pos2 = currentPosList[1];
    var checkLine = cc.v2(pos2.x - pos1.x, pos2.y - pos1.y);
    var locationPos = letterNodeBase.convertToNodeSpaceAR(location);
    this.sharkNode.x = locationPos.x;
    this.sharkNode.y = locationPos.y;
    var trueSharkNode = this.sharkNode.getChildByName('SharkNode');
    var angle = cc.v2(1, 0).signAngle(checkLine) * 180 / Math.PI;

    if (angle - trueSharkNode.angle < -180) {
      angle += 360;
    }

    if (angle - trueSharkNode.angle > 180) {
      angle -= 360;
    }

    if (!this.sharkNode.angleAction) {
      this.sharkNode.angleAction = true;
      cc.tween(trueSharkNode).to(0.2, {
        angle: angle
      }).call(function () {
        _this6.sharkNode.angleAction = false;
      }).start();
    }

    if (this.checkPointInCircle(this.sharkNode, pos2, 50)) {
      this._status.currentStrokeStageIdx++;

      if (this.getCurrentCheckPos() === null) {
        this.drawCompleteLine(this._status.currentStrokeIdx);
        this.showStar();
        this._status.currentStrokeIdx++;
        this._status.currentStrokeStageIdx = 0;

        if (this.getCurrentCheckPos() === null) {
          this.showOver();
        }

        this.updateArrows(this._status.currentStrokeIdx);
        this.onSharkMoveEnd(event);
      }
    }

    var posList = this.getPosListByStrokeIdx(this._status.currentStrokeIdx);

    if (!this.checkPointInRangeList(letterNodeBase.convertToNodeSpaceAR(location), posList, 50)) {
      this._status.currentStrokeStageIdx = 0;
      this.onSharkMoveEnd(event);
      return;
    }

    this.onDrawMove(event);
  },
  getSharkAngle: function getSharkAngle(currentStrokeIdx, currentStrokeStageIdx) {
    var pos1 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + currentStrokeIdx + "_" + currentStrokeStageIdx);
    var pos2 = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + currentStrokeIdx + "_" + (currentStrokeStageIdx + 1));
    var line = cc.v2(pos2.x - pos1.x, pos2.y - pos1.y);
    return cc.v2(1, 0).signAngle(line) * 180 / Math.PI;
  },
  onSharkMoveEnd: function onSharkMoveEnd(event) {
    var pos = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + this._status.currentStrokeIdx + "_0");

    if (!pos) {
      return;
    }

    this._status.currentStrokeStageIdx = 0;
    cc.tween(this.sharkNode).to(0.1, {
      x: pos.x,
      y: pos.y
    }).start();
    cc.tween(this.sharkNode.getChildByName('SharkNode')).to(0.1, {
      angle: this.getSharkAngle(this._status.currentStrokeIdx, 0)
    }).start();
    this.sharkNode.startPos = null;
    this.onDrawEnd(event);
  },
  addSharkListeners: function addSharkListeners() {
    this.sharkNode.on('touchstart', this.onSharkMoveStart, this);
    this.sharkNode.on('touchmove', this.onSharkMoving, this);
    this.sharkNode.on('touchend', this.onSharkMoveEnd, this);
    this.sharkNode.on('touchcancel', this.onSharkMoveEnd, this);
  },
  hideShark: function hideShark() {
    var _this7 = this;

    cc.tween(this.sharkNode).to(0.3, {
      opacity: 0
    }).call(function () {
      _this7.sharkNode.parent = null;
      _this7.sharkNode = null;
    }).start();
  },
  showOver: function showOver() {
    var _this8 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
      return regeneratorRuntime.wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              _this8.hideShark();

              _this8.playEffect('放大');

              _context4.next = 4;
              return _this8.showCompleteStar();

            case 4:
              _this8.playEffect("letter" + _this8.letter.toUpperCase());

              _context4.next = 7;
              return _this8.showRibbons();

            case 7:
              _this8.playEffect('撒花');

              _context4.next = 10;
              return _this8.showCloud();

            case 10:
              _this8.pageFlyOut();

              if (_this8.letter !== _this8.letter.toLowerCase()) {
                _this8.letter = _this8.letter.toLowerCase();

                _this8.createLetterPage(_this8.letter);
              }

            case 12:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4);
    }))();
  },
  showCompleteStar: function showCompleteStar() {
    var _this9 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
      return regeneratorRuntime.wrap(function _callee5$(_context5) {
        while (1) {
          switch (_context5.prev = _context5.next) {
            case 0:
              return _context5.abrupt("return", new Promise(function (resolve, reject) {
                _this9.starNode.zIndex = 10;
                cc.tween(_this9.starNode).to(0.1, {
                  opacity: 255
                }).to(1, {
                  x: 0,
                  y: 0,
                  scale: 3
                }).to(1, {
                  scale: 6,
                  opacity: 0
                }).call(resolve).start();
              }));

            case 1:
            case "end":
              return _context5.stop();
          }
        }
      }, _callee5);
    }))();
  },
  showCloud: function showCloud() {
    var _this10 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
      var cloudPosList, posList;
      return regeneratorRuntime.wrap(function _callee7$(_context7) {
        while (1) {
          switch (_context7.prev = _context7.next) {
            case 0:
              cloudPosList = [];
              posList = _this10.getCloudPosList();
              posList.forEach(function (stepList) {
                // stepList
                for (var i = 0; i < stepList.length - 1; i++) {
                  var pos0 = stepList[i];
                  var pos1 = stepList[i + 1];
                  var line = cc.v2(pos1.x - pos0.x, pos1.y - pos0.y);
                  cloudPosList.push(pos0);

                  if (line.mag() > 150) {
                    var length = Math.ceil(line.mag() / 80);

                    for (var j = 1; j < length; j++) {
                      var newLine = line.mul(j / length);
                      cloudPosList.push({
                        x: newLine.x + pos0.x,
                        y: newLine.y + pos0.y
                      });
                    }
                  }
                }

                cloudPosList.push(stepList[stepList.length - 1]);
              });
              _context7.next = 5;
              return Promise.all(cloudPosList.map( /*#__PURE__*/function () {
                var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6(pos, idx) {
                  return regeneratorRuntime.wrap(function _callee6$(_context6) {
                    while (1) {
                      switch (_context6.prev = _context6.next) {
                        case 0:
                          _context6.next = 2;
                          return _this10.createCloud(pos, idx);

                        case 2:
                        case "end":
                          return _context6.stop();
                      }
                    }
                  }, _callee6);
                }));

                return function (_x, _x2) {
                  return _ref4.apply(this, arguments);
                };
              }()));

            case 5:
            case "end":
              return _context7.stop();
          }
        }
      }, _callee7);
    }))();
  },
  createCloud: function createCloud(_ref5, idx) {
    var _this11 = this;

    var x = _ref5.x,
        y = _ref5.y;
    return new Promise(function (resolve, reject) {
      var letterNodeBase = cc.find("Canvas/letterNodeBase");
      var cloud = cc.instantiate(_this11.cloudPrefab);
      cloud.parent = letterNodeBase;
      cloud.x = x;
      cloud.y = y;
      cloud.scale = 0;
      cc.tween(cloud).delay(idx * 0.1).to(0.2, {
        scale: 1.2
      }).to(0.05, {
        scale: 1
      }).call(resolve).start();
    });
  },
  getCloudPosList: function getCloudPosList() {
    var posList = [];

    do {
      var currentPosList = [];
      var currentStepIdx = posList.length;
      var currentPosIdx = 0;

      do {
        var pos = cc.find("Canvas/letterNodeBase/NodePosBase/NodePos_" + currentStepIdx + "_" + currentPosIdx);

        if (!pos) {
          break;
        }

        currentPosIdx++;
        currentPosList.push({
          x: pos.x,
          y: pos.y
        });
      } while (true);

      if (currentPosList.length == 0) {
        break;
      }

      posList.push(currentPosList);
    } while (true);

    return posList;
  },
  pageFlyOut: function pageFlyOut() {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");
    letterNodeBase.name = 'letterNodeBase0';
    letterNodeBase.zIndex = 10;
    cc.tween(letterNodeBase).to(1.2, {
      y: 1500
    }, {
      easing: 'cubicIn'
    }).start();
  },
  createStar: function createStar(endNode) {
    var letterNodeBase = cc.find("Canvas/letterNodeBase");

    if (this.starNode) {
      this.starNode.parent = null;
      this.starNode = null;
    }

    var starNode = cc.instantiate(this.starPreFab);
    starNode.parent = letterNodeBase;
    starNode.x = endNode.x;
    starNode.y = endNode.y;
    this.starNode = starNode;
  },
  showStar: function showStar() {
    var _this12 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
      var starAnimeNode;
      return regeneratorRuntime.wrap(function _callee8$(_context8) {
        while (1) {
          switch (_context8.prev = _context8.next) {
            case 0:
              starAnimeNode = cc.instantiate(_this12.starAnimePrefab);
              starAnimeNode.parent = _this12.node;
              starAnimeNode.x = _this12.starNode.x;
              starAnimeNode.y = _this12.starNode.y;
              starAnimeNode.zIndex = 10;
              cc.tween(_this12.starNode).to(0.1, {
                opacity: 0
              }).start();

              _this12.playEffect('star');

              _context8.next = 9;
              return (0, _Z_05_nxuan1_utils.asyncPlayDragonBoneAnimation)(starAnimeNode, 'star', 1);

            case 9:
              starAnimeNode.parent = null;
              starAnimeNode = null;

            case 11:
            case "end":
              return _context8.stop();
          }
        }
      }, _callee8);
    }))();
  },
  showRibbons: function showRibbons() {
    var _this13 = this;

    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
      var i, ribbonNodeBase, ribbonNode;
      return regeneratorRuntime.wrap(function _callee9$(_context9) {
        while (1) {
          switch (_context9.prev = _context9.next) {
            case 0:
              for (i = 0; i < 50; i++) {
                ribbonNodeBase = cc.instantiate(cc.find('Canvas/RibbonNodeBase'));
                ribbonNodeBase.parent = _this13.node;
                ribbonNodeBase.y = 400 + (0, _Z_05_nxuan1_utils.RandomInt)(720);
                ribbonNodeBase.zIndex = 10;
                ribbonNodeBase.x = (0, _Z_05_nxuan1_utils.RandomInt)(-720, 720);
                ribbonNodeBase.angle = (0, _Z_05_nxuan1_utils.RandomInt)(360);
                ribbonNode = ribbonNodeBase.getChildByName("RibbonNode_" + (0, _Z_05_nxuan1_utils.RandomInt)(4));
                ribbonNode.active = true;
                cc.tween(ribbonNodeBase).by(3, {
                  y: -1600,
                  x: (0, _Z_05_nxuan1_utils.RandomInt)(-100, 100),
                  angle: (0, _Z_05_nxuan1_utils.RandomInt)(-60, 60)
                }).start();
              }

            case 1:
            case "end":
              return _context9.stop();
          }
        }
      }, _callee9);
    }))();
  },
  drawCompleteLine: function drawCompleteLine(strokeIdx) {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeBase');
    this.drawLines(drawGraphyNode, this.getPosListByStrokeIdx(strokeIdx));
  },
  drawLines: function drawLines(drawNode, posList) {
    var graph = drawNode.getComponent(cc.Graphics);
    posList.forEach(function (pos, idx) {
      if (idx == 0) {
        graph.moveTo(pos.x, pos.y);
        return;
      }

      graph.lineTo(pos.x, pos.y);
    });
    graph.stroke();
  },
  onDrawStart: function onDrawStart(event) {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    var graph = drawGraphyNode.getComponent(cc.Graphics);
    var location = event.getLocation();
    var pos = drawGraphyNode.convertToNodeSpaceAR(location);
    graph.moveTo(pos.x, pos.y);
  },
  onDrawMove: function onDrawMove(event) {
    if (!this._moveCount) {
      this._moveCount = 0;
    }

    this._moveCount++;

    if (this._moveCount < 5) {
      return;
    }

    this._moveCount = 0;
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    var graph = drawGraphyNode.getComponent(cc.Graphics);
    var location = event.getLocation();
    var pos = drawGraphyNode.convertToNodeSpaceAR(location);
    graph.lineTo(pos.x, pos.y);
    graph.stroke();
  },
  onDrawEnd: function onDrawEnd(event) {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    var graph = drawGraphyNode.getComponent(cc.Graphics);
    graph.clear();
  },
  addDrawListeners: function addDrawListeners() {
    var drawGraphyNode = cc.find('Canvas/letterNodeBase/DrawMaskNode/DrawGraphyNodeCurrent');
    drawGraphyNode.on('touchstart', this.onDrawStart, this);
    drawGraphyNode.on('touchmove', this.onDrawMove, this);
    drawGraphyNode.on('touchend', this.onDrawEnd, this);
    drawGraphyNode.on('touchcancel', this.onDrawEnd, this);
  },
  checkPointInCircle: function checkPointInCircle(pos, center, radius) {
    var line = cc.v2(pos.x - center.x, pos.y - center.y);

    if (line.mag() > radius) {
      return false;
    }

    return true;
  },
  checkPointInRangeList: function checkPointInRangeList(pos, rangePosList, radius) {
    var _this14 = this;

    var inRange = false;
    rangePosList.forEach(function (rangePos, idx) {
      if (idx == 0) {
        return;
      }

      inRange = inRange || _this14.checkPointInRange(pos, rangePosList[idx - 1], rangePos, radius);
    });
    return inRange;
  },
  checkPointInRange: function checkPointInRange(pos, rangePos1, rangePos2, radius) {
    var linePos2 = cc.v2(rangePos2.x - rangePos1.x, rangePos2.y - rangePos1.y);
    var linePos = cc.v2(pos.x - rangePos1.x, pos.y - rangePos1.y);
    var angle = linePos2.signAngle(linePos);
    var distance = linePos.mag() * Math.sin(angle); // 如果pos点到pos1与pos2连线的距离大于半径，则超出

    if (distance > radius || distance < -radius) {
      return false;
    }

    var projection = linePos.mag() * Math.cos(angle); // 如果pos1到pos点的向量到pos1到pos2的向量投影长度超出范围

    if (projection < -radius || projection > radius + linePos2.mag()) {
      return false;
    }

    return true;
  },
  playEffect: function playEffect(name, loop, volume) {
    return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
      var musicComponent;
      return regeneratorRuntime.wrap(function _callee10$(_context10) {
        while (1) {
          switch (_context10.prev = _context10.next) {
            case 0:
              musicComponent = cc.find('Canvas/MusicNode').getComponent('Z_05_nxuan1_MusicNode');
              _context10.next = 3;
              return musicComponent.playEffect(name, loop, volume);

            case 3:
            case "end":
              return _context10.stop();
          }
        }
      }, _callee10);
    }))();
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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