# h5-template-generator

原生H5课件的脚手架，生成的项目只有jQuery框架，如需其他框架则另行引入即可

# 使用简介

## 前期准备

* git下载  https://git-scm.com/downloads 
* nodejs下载  https://nodejs.org/zh-cn/download/
* 谷歌浏览器下载  https://www.google.cn/chrome/

都下载最新版就行，然后默认安装就可以


## 生成项目

* 登录绘玩云课件开发平台：http://staging-teach.ireadabc.com/manage/login
* 输入测试的用户名/密码：developers/12345678
* 在左侧菜单点击“模板管理”，然后点击“新建模板”, 填写必要的信息，在“技术选型”一项上选择“普通模板”
* 点击“确定”后，列表页就会出现一个新生成的模板项目
* 在项目的卡片下找到“开发”按钮，则会弹出相对应的git地址

## 获取并启动项目

```
// xxx 是上面项目对应的Git地址
git clone xxx
cd 项目名称/
npm install
npm start

//启动成功后打开浏览器， 输入：
```
<!-- 查看表单页面 -->
http://localhost:3000/form/index.html
<!-- 查看展示页面 -->
http://localhost:3000/play/index.html

```
则可以看到这个项目的初始化效果了

```

## 项目结构

|-- bin

|-- dist

|-- form

|-- lib

|-- node_modules

|-- play

|-- publish

|-- .gitignore

|-- app.js

|-- package-lock.json

|-- package.json

|-- README.md



* 其中 play 文件夹是H5模板展示页面，form 文件夹是模板的配置页面
* lib 文件夹存放模板样式的静态资源，例如小图标、背景图片、字体、样式等等
* 其他文件夹开发者可以不做任何更改

## 开始开发

本脚手架的页面是全面开放的，不限制使用任何前端技术，但是必须要使用CDN引入的方式，不可将类似webpack打包后的代码放进来充当页面，提交的代码要通俗易懂，可维护性强，尽量不要使用一些太过激进或者还不够稳定兼容性不好的技术

### 开发配置页面（form/）

配置页面主要作用是为了呈现多样化模板，提高H5模板的高复用性、灵活性提供的一个配置工具，根据H5模板的设计规划或特性，会规定某些元素是可以配置的，比如背景图片、音频、选项、标题等等等等。(课件制作者) 通过配置页面，就可以灵活的更换这些，从而形成多种多样的课件。


配置页面的开发要求很简单，我们不关心布局、样式、交互等所有实现细节与效果，只需调用两个内置的全局接口即可：

* setData 接口，用于将配置的数据存储到云端。

  此方法是一个异步的方法，接收三个必要参数

  obj: 一个json对象

  callback: 回调函数

  t_name: 模板名称

  一般使用例子如下：

  ```
  var t_name = "mb_0001";  // 模板名称
  var obj = {test: "Hello"}; // 配置的数据
  window.courseware.setData(obj, function () {
    console.log("数据保存成功");
  }, t_name);
  ```

* getData 接口，用于当点击修改的时候将配置的数据从云端获取下来。

  此方法是一个异步的方法，接收两个必要参数 

  > callback: 回调函数, 回调函数里会得到云端保存的数据

  > t_name: 模板名称

  一般使用例子如下：

  ```
  window.courseware.getData((data) => {
    //data 就是云端获取的数据，也就是setData方法存到云端的那个obj
    //模板开发者需要根据数据，依次填写到表单的相应位置，方便用户二次修改编辑
  });
  ```

### 开发展示页面（play/）

展示页面主要是呈现模板，通过H5技术，实现多样化的交互与展示方式。


展示页面更简单，开发者可以运用各种技术，实现Web端可以实现的任何效果，包括2D、3D、动画、游戏等各种场景，把表单配置的数据获取到，用于渲染相对应的页面即可：
 
* getData 接口，用于当点击修改的时候将配置的数据从云端获取下来。

  此方法是一个异步的方法，接收两个必要参数 

  > callback: 回调函数, 回调函数里会得到云端保存的数据

  > t_name: 模板名称

  一般使用例子如下：

  ```
  window.courseware.getData((data) => {
    //data 就是云端获取的数据，也就是setData方法存到云端的那个obj
    //模板开发者需要根据数据来渲染或控制展示页面的呈现，达到模板的互动目的 
  });
  ```

  ### 互动课件

  通过H5的交互方式，我们可以很轻松的制作在线的互动课件，使老师端与学生端实现联动，使在线课堂更具有交互性。

  * onEvent 定义事件：用于自定义同步事件，配合多端互动使用，与sendEvent方法配合使用，用于监听多端发送的同步事件

  参数

  > evtName : 自定义事件的名称

  > callback : 回调函数，回调函数里会得到传过来的数据

  使用例子：

  ```
  const cw = window.courseware;
  //订阅一个事件
  cw.onEvent('testEvent', (data,next) => {
    console.log(data); 
    //处理事件的同步逻辑

    //在逻辑处理完之后一定要执行next方法,用于解锁事件队列
    next();
  }); 
  ```

  * sendEvent 发送事件：用于自定义同步事件，配合多端互动使用，与onEvent方法配合使用，用于对端发送同步事件

  参数

  > evtName : 自定义事件的名称

  > data : 传递的参数 

  使用例子：

  ```
  const cw = window.courseware;
  //发送事件
  //这样，所有端（教师、学生） 都会触发 testEvent 方法
  cw.sendEvent('testEvent', 'Hello world'); 

  ```

  * storeAspect 存储切面数据： 课件的切面状态数据；互动课件需要每一个开发者设计切面状态，用于学生进入已经进行的课件，恢复课件同步。例如老师讲图片轮播到第四页，这个时候学生进入教师，要恢复到第四页，才能跟老师同步上课。

  参数

  > data : 保存的数据，一个JSON对象

  使用例子：

  ```
  const cw = window.courseware; 
  //存储切面数据，用于学生进入教室，同步课堂信息等
  cw.storeAspect({page: 5}); 
  ```

  * getAspect 获取切面数据： 课件的切面状态数据；互动课件需要每一个开发者设计切面状态，用于学生进入已经进行的课件，恢复课件同步。例如老师讲图片轮播到第四页，这个时候学生进入教师，要恢复到第四页，才能跟老师同步上课。

  参数

  > callback : 获取切面数据的回调函数

  使用例子：

  ```
  const cw = window.courseware; 
  //存储切面数据，用于学生进入教室，同步课堂信息等
  cw.getAspect(function(aspect){
    //恢复切面状态的逻辑
  }); 
  ```

  * 补充项

  1)  有时候我们在实现模板效果的时候，需要一些基本的信息，比如教室信息、当前用户信息等等，例如，老师会显示某个按钮，而学生不显示，我们可以用如下方式获取教室信息；后续大部分静态信息都会完善到这个对象里

  ```
  //获取教室信息，值得注意的是获取这个信息一定要再 getData方法之后，或者确保页面完成之后
  getData((data, aspect) => {
    let airClassInfo = window.air.airClassInfo;
    console.log(airClassInfo);
  }); 
  ```

  2)  互动课件的 getData 方法的回调函数里多返回了一个切面参数，类似如下：

  ```
  const getData = window.courseware.getData;
  getData((data, aspect) => {
    //data 就是云端获取的数据，也就是setData方法存到云端的那个obj
    //aspect 切面参数，用于恢复页面的状态
    //模板开发者需要根据数据来渲染或控制展示页面的呈现，达到模板的互动目的 
  });
  ``` 

  3)  一些必要的内置事件，通过监听这些事件，我们可以实现一些相关的功能

      * userchange 事件，用来监听教室内部的人员变动情况，例如某人进入，某人退出都会触发此事件

        示例：

        ```
        const cw = window.courseware;
        //订阅一个事件
        cw.onEvent('userchange', (data,next) => {
          //data的结构如下
          /*{
           *  id: '变动用户的ID',
           *  connected: true/false,  true: 连接的，false:d断开的
           *  status: 'connect/reconnect',  connect：新建连接，reconnect:重新连接；这个字段在断开连接的事件里是缺失的
           *  all_user: []  这个是现有的用户列表 
           *}
           */
          console.log(data); 
          //处理事件的同步逻辑

          //在逻辑处理完之后一定要执行next方法,用于解锁事件队列
          next();
        }); 
        
        ```

  4)  测试互动课件

      我们在本地开发时，如果想单独测试老师页面或者学生页面，可以用如下方式：

        老师页面：http://localhost:3000/play/index.html?role=tea

        学生页面：http://localhost:3000/play/index.html?role=stu

      如果想要测试老师和学生的互动效果，可以访问如下地址：

        http://staging-teach.ireadabc.com/template_ci/debug

      然后点右上角“设置”，选择互动课件，这样就可以模拟两端测试了，左侧为老师右侧为学生



  ### 补充方法

  在模板的编辑或展示过程中，还会经常遇到如下两个场景，特提供针对性的解决办法

  1)  表单录入往往需要上传图片、音视频等多媒体文件，所以脚手架内置如下方法，用于获取一个上传到云端的接口方法

  ```
  const uploadUrl = window.courseware.uploadUrl;
  const uploadData = window.courseware.uploadData;

  // 例如上传一张图片文件：
  // html:

  <input type="file" name="image" accept="image/*">

  // jQuery:

  $("[name='image']").change(function(){
    const files = $(this).prop('files');
    const formData = new FormData();
    formData.append("file", file);
    for (const key in uploadData) {
      formData.append(key, uploadData[key]);
    }
    $.ajax({
        url: uploadUrl,
        type: "post",
        data: formData,
        dataType: 'text',
        contentType: false,
        processData: false,
        success: function(data) {
          console.log("文件上传成功，返回值：", data);
        },
        error: function(data) {
          console.error("文件上传失败", data);
        }
    });
  }

  ```

  2)  在展示页面加载完成的时候，需要调用一下下面的方法，用于释放切换课件的遮罩层

  ```
  //此方法为固定写法，
  //其中t_name为模板名称，obj是云端存储的配置数据
  window.air.hideAirClassLoading(t_name,obj);
  ```

  3)  有些模板需要在一打开的时候就触发一些动画或者开场音乐音效等，这种一定不要直接运行，而是使用如下写法

  ```
  const cw = window.courseware;
  //订阅课件移入屏幕事件
  cw.onEvent('course-in-screen', (data,next) => {
    console.log(data); 
    //处理初始化播放音频、动画等逻辑

    //在逻辑处理完之后一定要执行next方法,用于解锁事件队列
    next();
  }); 

  ```

  ## 本地调试

  ### 普通模板

  * 打开浏览器：http://staging-teach.ireadabc.com/template_ci/debug 
  * 点击右上角齿轮，选择技术选型、调试模式选择“普通”

  ### 互动模板

  * 打开浏览器：http://staging-teach.ireadabc.com/template_ci/debug 
  * 点击右上角齿轮，选择技术选型、调试模式选择“互动”
  * 左侧老师、右侧学生

  ## 打包发布

  登录云平台： http://staging-teach.ireadabc.com/ 
  点击“模板管理” 菜单，找到对应的模板卡片，点击“发布”按钮，则开始发布任务
  点击“模板发布队列”，可以查看模板的发布情况


  ## 常见问题汇总

  ### 静态资源引用路径写法

  css文件里面要带 ..  , eg:
  ```
  background-image: url("../../assets/playground-house/bg.jpg");
  ```

  其他的文件(html、ts、resources.js)里路径要开头不带斜杠， eg:
  ```
  src="assets/guess-read/btn.png"
  ```
  
  ### no such file or directory,

  出现类似如：
  ```
  Error: ENOENT: no such file or directory, open 'C:/publish/resources/xxxx/v1/index.html'
  ```
  这样的代码时， 请确认新建模板的时候表单填写的“配置页面URL”与“展示页面URL” 填写的路径是否正确

  ### 已经发布的模板，制作课件时看不到

  如果模板已经确认发布成功了，制作课件的时候却看不到这个模板，请编辑模板，查看模板类型是否选择为“课中模板”
