

/* 

window.courseware.getData(callback,key);  //用于获取数据
window.courseware.setData(data,callback,key);  //用于存储数据
var uploadUrl = window.courseware.uploadUrl();  //上传文件的路径
var uploadData = window.courseware.uploadData();  //上传文件必须要的参数 

*/

// 全局变量
const key = "ai_fundub";

const callServerMethod = (method, data) => {
  return new Promise((resolve, reject) => {
    window.courseware.onEvent(method, (result, next) => {
      // window.courseware.removeEvent(method, key);
      resolve(result);
      next();
    }, key);
    window.courseware.sendEvent(method, data, key);
  });
}

// 等待 DOM 加载完成后初始化
document.addEventListener('DOMContentLoaded', () => {
  window.courseware.getData(function (data) {
    window.air.hideAirClassLoading(key, data);

    // if (!data) {
    //   // 加载默认数据
    //   $.getJSON('../play/defaultData.json', function (defaultData) {
    //     callServerMethod('getGameList', {}).then(res => {
    //       gameSetObj = res;
    //       initVueApp(defaultData);
    //     });
    //   })
    //   return;
    // }
    //数据加载完，才算页面加载完成 
    initVueApp(data);
  }, key);
});

// 初始化Vue应用
function initVueApp(savedData) {
  window.vueApp = new Vue({
    el: '#app',
    data: {

      loadingText: '',
      videoUrl: '',
      currentTime: '00:00.000',
      videoDuration: 0,
      uploadUrl: window.courseware.uploadUrl(),
      uploadData: window.courseware.uploadData(),

      ossUploadUrl: '',
      ossUploadData: {},

      isPlaying: false,
      uploading: false,
      uploadProgress: 0,
      playbackRate: 1,
    },
    mounted() {
      // 如果有保存的数据，恢复状态
      if (savedData && savedData.videoUrl) {
        this.videoUrl = savedData.videoUrl.replace('http://', 'https://');
        if (this.videoUrl) {
          this.deepCheckUtilHave(this.videoUrl.replace('.mp4', '_mini.mp4')).then(res => {
            this.videoUrl = this.videoUrl.replace('.mp4', '_mini.mp4');
          });
        }
      }
    },

    beforeDestroy() {
      // 清理定时器
      if (this.syncInterval) {
        clearInterval(this.syncInterval);
      }
    },
    methods: {
      // 检查 URL 资源是否有效
      async checkUrlValid(url) {
        try {
          const response = await fetch(url, {
            method: 'HEAD',
            mode: 'cors',
            cache: 'no-cache'
          });

          // 检查状态码是否在 200-299 范围内
          if (response.ok) {
            return true
          } else {
            return false
          }
        } catch (error) {
          return false
        }
      },

      onContainerClick() {
        
      },

      async deepCheckUtilHave(url) {
        let isHave = await this.checkUrlValid(url);
        let count = 0;
        while (!isHave) {
          await new Promise(resolve => setTimeout(resolve, 1000));
          isHave = await this.checkUrlValid(url);
          count++;
          this.loadingText = `正在等待压缩视频...${count}s`;
        }
        return isHave;
      },

      // 计算文件MD5（支持大文件分块处理）
      async calculateMD5(file) {
        return new Promise((resolve, reject) => {
          // 对于小文件，直接计算
          if (file.size < 10 * 1024 * 1024) {
            const reader = new FileReader();
            reader.onload = (e) => {
              try {
                const wordArray = CryptoJS.lib.WordArray.create(e.target.result);
                const hash = CryptoJS.MD5(wordArray);
                resolve(hash.toString());
              } catch (err) {
                reject(err);
              }
            };
            reader.onerror = error => reject(error);
            reader.readAsArrayBuffer(file);
            return;
          }

          // 大文件分块处理 - 使用流式处理避免内存溢出
          const chunkSize = 1024 * 1024; // 1MB 分块
          const chunks = Math.ceil(file.size / chunkSize);
          let currentChunk = 0;
          let lastLoggedProgress = 0; // 记录上次打印的进度

          // 使用 CryptoJS 的流式处理
          const md5Hasher = CryptoJS.algo.MD5.create();

          const processChunk = () => {
            if (currentChunk >= chunks) {
              // 所有分块处理完成，计算最终 MD5
              try {
                const finalHash = md5Hasher.finalize();
                resolve(finalHash.toString());
              } catch (error) {
                reject(error);
              }
              return;
            }

            const start = currentChunk * chunkSize;
            const end = Math.min(start + chunkSize, file.size);
            const chunk = file.slice(start, end);

            const reader = new FileReader();
            reader.onload = function (e) {
              try {
                // 将当前分块转换为 WordArray 并更新哈希
                const wordArray = CryptoJS.lib.WordArray.create(e.target.result);
                md5Hasher.update(wordArray);
                currentChunk++;

                // 更新进度（可选，如果需要显示 MD5 计算进度）
                const progress = Math.round((currentChunk / chunks) * 100);
                if (progress % 10 === 0 && progress > 0 && progress !== lastLoggedProgress) { // 每 10% 更新一次，避免重复
                  console.log(`MD5 计算进度: ${progress}%`);
                  lastLoggedProgress = progress;
                }

                // 使用 setTimeout 避免阻塞 UI
                setTimeout(processChunk, 0);
              } catch (error) {
                reject(error);
              }
            };
            reader.onerror = function (error) {
              reject(error);
            };
            reader.readAsArrayBuffer(chunk);
          };

          // 开始处理第一个分块
          processChunk();
        });
      },

      // 上传文件到OSS
      async uploadToOSS(file, ossConfig) {
        // try {
        const client = new OSS({
          region: ossConfig.region,
          accessKeyId: ossConfig.accessKeyId,
          accessKeySecret: ossConfig.accessKeySecret,
          stsToken: ossConfig.securityToken,
          bucket: ossConfig.bucket,
          cors: true,
          secure: true,
          silent: true
        });
        const videoClient = new OSS({
          region: ossConfig.region,
          accessKeyId: ossConfig.accessKeyId,
          accessKeySecret: ossConfig.accessKeySecret,
          stsToken: ossConfig.securityToken,
          bucket: 'iplayabc-worker-queue-video-mini',
          cors: true,
          secure: true,
          silent: true
        });

        // 计算文件MD5作为新文件名
        this.$message.info('正在计算文件 MD5 值...');
        let md5 = await this.calculateMD5(file);
        const ext = file.name.split('.').pop().toLowerCase();
        let newFileName = `${md5}.${ext}`;
        console.log('md5==', md5);

        // 上传文件到OSS
        let isExist = false;
        try {
          // 使用 getObjectMeta 代替 head，并添加 silent 参数
          await client.getObjectMeta(newFileName, { silent: true });
          if (ext == 'mp4') {
            await videoClient.getObjectMeta(newFileName.replace('.mp4', '_mini.mp4'), { silent: true });
          }
          isExist = true;
        } catch (error) {
          if (error.code !== 'NoSuchKey') {
            throw error; // 如果是其他错误就抛出
          }
          // 如果是 NoSuchKey 错误，说明文件不存在，继续上传流程
        }
        if (isExist) {
        } else {
          console.log('开始上传文件,md5==', md5);
          await client.multipartUpload(newFileName, file, {
            progress: (p) => {
              const progress = Math.floor(p * 50);
              this.uploadProgress = progress;
            }
          });
          if (ext == 'mp4') {
            newFileName = `${md5}_mini.mp4`;
            await videoClient.multipartUpload(newFileName, file, {
              progress: (p) => {
                const progress = Math.floor(p * 50) + 50;
                this.uploadProgress = progress;
              }
            });
          }
        }
        return `${ossConfig.domain.replace('http://', 'https://')}${newFileName}`;
        // } catch (error) {
        //   console.error('上传到OSS出错:', error);
        //   throw error;
        // }
      },

      // 上传相关方法
      beforeUpload(file) {
        const isMP4 = file.type === 'video/mp4';
        if (!isMP4) {
          this.$message.error('只能上传 mp4 文件!');
          return false;
        }

        this.$nextTick(async () => {
          const ossSignature = await callServerMethod('getOSSSignature');
          const ossConfig = ossSignature.data;
          if (!ossSignature) {
            return false;
          } else {
            const res = await this.uploadToOSS(file, ossConfig);
            this.uploading = false;
            this.uploadProgress = 100;
            await this.deepCheckUtilHave(res);
            this.videoUrl = res;
            this.$message.success('视频上传成功!');

            this.saveData();
          }
        });
        // 开始上传，显示进度条
        this.uploading = true;
        this.uploadProgress = 0;
        return false;
      },

      onUploadError() {
        this.uploading = false;
        this.uploadProgress = 0;
        this.$message.error('视频上传失败!');
      },

      confirmReupload() {
        this.$confirm('重新上传视频将覆盖当前视频并且无法撤销，确定要继续吗？', '确认重新上传', {
          confirmButtonText: '确定',
          cancelButtonText: '取消',
          type: 'warning'
        }).then(() => {
          this.reuploadVideo();
        }).catch(() => {
          // 用户取消操作
        });
      },

      reuploadVideo() {
        // 重置所有数据
        this.videoUrl = '';
        this.currentTime = '00:00.000';
        this.videoDuration = 0;
        this.uploading = false;
        this.uploadProgress = 0;
        this.playbackRate = 1; // 重置播放速度
        // 保存重置后的数据
        this.saveData();
        // 触发文件选择
        this.$nextTick(() => {
          this.$refs.upload.$el.querySelector('input[type="file"]').click();
        });
      },

      // 视频控制方法 - 波形图控制视频
      togglePlayPause() {
      },

      // 设置播放速度 - 波形图控制视频速度
      setPlaybackRate() {
        // 同步视频的播放速度
        if (this.$refs.videoPlayer) {
          this.$refs.videoPlayer.playbackRate = parseFloat(this.playbackRate);
        }
      },

      // 绑定视频元素事件监听器
      bindVideoEvents() {
        if (!this.$refs.videoPlayer) return;

        const video = this.$refs.videoPlayer;

        // 监听视频结束事件，同步波形图状态
        video.addEventListener('ended', () => {
          this.isPlaying = false;
        });

        // 监听视频加载事件，确保波形图静音
        video.addEventListener('loadedmetadata', () => {
        });

        // 监听视频播放事件，确保波形图静音
        video.addEventListener('play', () => {
        });
      }, 
             
      // 数据持久化
      saveData() {
        const data = {
          videoUrl: this.videoUrl.replace('_mini.mp4', '.mp4'),
          playbackRate: this.playbackRate,
        };
        window.courseware.setData(data, function () {
        }, key);
      },

      // 工具方法
      formatTime(seconds) {
        // 确保输入是数字
        seconds = parseFloat(seconds);
        if (isNaN(seconds)) {
          console.error('formatTime 接收到无效值:', seconds);
          return '00:00.000';
        }

        const hours = Math.floor(seconds / 3600);
        const minutes = Math.floor((seconds % 3600) / 60);
        const secs = Math.floor(seconds % 60);
        const ms = Math.floor((seconds % 1) * 1000);



        if (hours > 0) {
          return `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}.${ms.toString().padStart(3, '0')}`;
        } else {
          return `${minutes.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}.${ms.toString().padStart(3, '0')}`;
        }
      },
    }
  });
}