// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class stickers extends cc.Component {

    @property(cc.Prefab)
    stickerP: cc.Prefab = null;

    @property
    text: string = 'hello';
    @property(cc.SpriteFrame)
    sp1:cc.SpriteFrame=null;
    @property(cc.SpriteFrame)
    sp2:cc.SpriteFrame=null;
    @property(cc.SpriteFrame)
    sp1_1:cc.SpriteFrame=null;
    @property(cc.SpriteFrame)
    sp1_2:cc.SpriteFrame=null;
    num=0;


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {

    }
    initStickers(num){
        this.num=num;
        let width=34;
        let speed=15;
        let allWidth=width*num+(num-1)*speed;
        this.node.removeAllChildren()
        for(let i=0;i<num;i++){
            let node =cc.instantiate(this.stickerP);
            node.x=-allWidth/2+width/2+i*(width+speed);
            node.name="sticker"+i;
            node.parent=this.node;
        }

    }
    changOneSticker(index, isSuc){
        let sticker=this.node.getChildByName("sticker"+index);
        let stroke=sticker.getChildByName("stroke");
        if(isSuc){
            stroke.active=false;
            sticker.getComponent(cc.Sprite).spriteFrame=this.sp2;
            sticker.opacity=0;
            sticker.scale=0.5;
            cc.tween(sticker)
            .to(0.4,{opacity:255,scale:1.2})
            .to(0.2,{scale:1})
            .start()

        }else{
            stroke.active=true;
            stroke.getComponent(cc.Sprite).spriteFrame=this.sp1_2
        }
        

    }
    updateStickers(list){
        console.log("updateStickersList",list)
        for(let i=0;i<this.num;i++){
            let sticker=this.node.getChildByName("sticker"+i)
            let stroke=sticker.getChildByName("stroke");
            if(list[i]===1){
                stroke.active=false;
                sticker.getComponent(cc.Sprite).spriteFrame=this.sp2
            }else{
                sticker.getComponent(cc.Sprite).spriteFrame=this.sp1
                stroke.active=false;
                if(list[i]===0){
                    stroke.active=true;
                    stroke.getComponent(cc.Sprite).spriteFrame=this.sp1_1
                }
                if(list[i]===-1){
                    stroke.active=true;
                    stroke.getComponent(cc.Sprite).spriteFrame=this.sp1_2
                }

            }
        }

    }

    // update (dt) {}
}
