// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html
// import { asyncDelay, onHomeworkFinish } from "../script/util";

const { ccclass, property } = cc._decorator;

@ccclass
export default class panel extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';
    @property(dragonBones.ArmatureDisplay)
    dragon: dragonBones.ArmatureDisplay = null;
    @property(dragonBones.ArmatureDisplay)
    dragon1: dragonBones.ArmatureDisplay = null;
    @property(dragonBones.ArmatureDisplay)
    dragon2: dragonBones.ArmatureDisplay = null;
    @property(cc.Node)
    cakeN: cc.Node = null;
    @property(cc.Node)
    frameN: cc.Node = null;
    @property([cc.Prefab])
    cakePicePList = []
    piceWidthList = [310, 280, 250, 220, 190];
    mainCtil: any = null;


    start() {
    }

    //     "text": "dog",
    //     "audio": "http://staging-teach.cdn.ireadabc.com/dfb27b510e121a1045a3b7613a530e43.mp3",
    //     "dragonBoneData": {
    //       "skeJsonData": {
    //         "url": "http://staging-teach.cdn.ireadabc.com/19d1a7f807cb34e8706d2d3b0324278b.json",
    //         "name": "right_ske.json"
    //       }, "texJsonData": {
    //         "url": "http://staging-teach.cdn.ireadabc.com/8593091ce08cf9fd7c2d86f332b6cd6c.json",
    //         "name": "right_tex.json"
    //       }, "texPngData": {
    //         "url": "http://staging-teach.cdn.ireadabc.com/d623e6d625ef102dbc5420b2f37fa52f.png",
    //         "name": "right_tex.png"
    //       }
    //     }, "waitTime": 12, "choosewaitTime": 5, "testWaitTime": 3, "rightLetter": "d", "wrongLetter": "b"
    //   },    }
    initPanel(data, mainCtil) {
        this.frameN.y = 700;
        this.frameN.off("click");
        this.frameN.on("click", () => {
            this.playDragon();
        })
        this.dragon.node.active = false;
        this.mainCtil = mainCtil;
        let index = 0;
        let picesN = cc.find("cake/picesP", this.node)
        cc.find("cake/cakeD", this.node).getComponentInChildren(cc.Label).string = data.text;
        picesN.removeAllChildren()
        let strs = data.text.split("");
        console.log("strs===", strs)
        for (let i = 0; i < strs.length; i++) {
            if (strs[i] == data.rightLetter) {
                index = i
                continue
            }
            let posIndex = i > index ? i - 1 : i;
            let cakePice = cc.instantiate(this.cakePicePList[i]);
            cakePice.off("click")
            cakePice.parent = picesN;
            cakePice.getChildByName("stroke").active = false;
            cakePice.getComponentInChildren(cc.Label).string = strs[i];
            cakePice.x = 0;
            cakePice.zIndex = 10 - i;
            let posInfo = this.getYAndSacle(cakePice, posIndex);
            console.log("posInfo====", posInfo, posIndex)
            cakePice.scale = posInfo.scale;
            cakePice.y = posInfo.y
        }
        let rightPice = cc.instantiate(this.cakePicePList[index]);
        let wrongPice = cc.instantiate(this.cakePicePList[index]);
        rightPice.zIndex = 10 - index;
        rightPice.parent = picesN;
        wrongPice.parent = picesN;
        rightPice.x = 450
        wrongPice.x = 450
        wrongPice.name = "wrongPice"
        rightPice.name = "rightPice"
        rightPice.getComponentInChildren(cc.Label).string = data.rightLetter;
        rightPice.off("click")
        rightPice.on("click", (e) => {
            rightPice.getChildByName("stroke").active = true;
            this.mainCtil.changeTrue(this)
        })
        wrongPice.off("click")
        wrongPice.on("click", () => {
            this.mainCtil.changeFalse()
        })
        wrongPice.getComponentInChildren(cc.Label).string = data.wrongLetter;
        let random = Math.random();
        if (random > 0.5) {
            rightPice.y = 150
            wrongPice.y = 400
        } else {
            rightPice.y = 400
            wrongPice.y = 150
        }
    }
    getYAndSacle(node, index) {
        let scale = this.piceWidthList[index] / node.width;
        let y = scale * node.height / 2;
        for (let i = 0; i < index; i++) {
            y += 175 * this.piceWidthList[i] / 310 * 0.65
        }
        return {
            scale: scale,
            y: y
        }
    }
    movePices() {
        let picesList = [];
        let children = cc.find("cake/picesP", this.node).children;
        for (let i = 0; i < children.length; i++) {
            if (children[i].name != "wrongPice") {
                picesList.push(children[i]);
            }
        }
        picesList.sort((a, b) => {
            return b.zIndex - a.zIndex
        })
        for (let j = 0; j < picesList.length; j++) {
            let posInfo = this.getYAndSacle(picesList[j], j);
            cc.tween(picesList[j])
                .to(1, { x: 0, y: posInfo.y, scale: posInfo.scale })
                .call(() => {
                    if (picesList[j].name == "rightPice") {
                        picesList[j].getChildByName("stroke").active = false;
                        console.log("rightPiceActionStop")
                        this.mainCtil.changeEnd(true)
                        this.outPice();
                        this.dragon.node.active = true;
                        let topPice = picesList[picesList.length - 1]
                        let topPiceInfo = this.getYAndSacle(topPice, picesList.length - 1);
                        this.dragon.node.y = topPiceInfo.y + topPice.height / 2 * topPiceInfo.scale - 40
                        this.dragon.playAnimation("newAnimation", 1)
                        this.mainCtil.playLocalAudio("suc")
                    }
                })
                .start();

        }


    }
    failPicesAction(timeOut) {
        let slag = cc.find("cake/slag", this.node)
        let wrongPice = cc.find("cake/picesP", this.node).getChildByName("wrongPice")
        let rightPice = cc.find("cake/picesP", this.node).getChildByName("rightPice")
        wrongPice.zIndex = 100;
        if (timeOut) {
            slag.active = true;
            wrongPice.active = false;
            rightPice.active = false;
            this.mainCtil.moveOutCandle1(
                () => {
                    this.mainCtil.nextQuestion();
                }
            )
            cc.tween(this.mainCtil.musicBtn.node)
                .to(0.3, { x: 900 })
                .start();
        } else {
            rightPice.active = false;
            this.mainCtil.moveOutCandle1()
            cc.tween(this.mainCtil.musicBtn.node)
                .to(0.3, { x: 900 })
                .start();
            this.mainCtil.playLocalAudio("err");
            cc.tween(wrongPice)
                .to(0.3, { y: 10 })
                .call(() => {
                    wrongPice.active = false;
                    slag.active = true
                    this.mainCtil.nextQuestion();
                })
                .start();



        }

    }
    outPice() {
        let wrongPice = cc.find("cake/picesP", this.node).getChildByName("wrongPice")
        cc.tween(wrongPice)
            .to(0.3, { x: 1100 })
            .call(() => {
                wrongPice.destroy();
                cc.tween(this.frameN)
                    .to(0.3, { y: 0 })
                    .call(() => {
                        this.playDragon();
                        this.mainCtil.playAudioByUrl(this.mainCtil.data.guideAudio, () => {
                            this.mainCtil.startTalking()
                        })
                        this.mainCtil.moveInCandle2();
                        this.mainCtil.initRedBtn();
                        cc.tween(this.mainCtil.redBtnN)
                            .to(0.3, { x: 550 })
                            .start();
                        // guideAudio
                    })
                    .start();

            })
            .start();

    }

    playDragon() {
        if (this.frameN.getChildByName("tikeaN")) {
            let dragonDisplay = this.frameN.getChildByName("tikeaN").getComponent(dragonBones.ArmatureDisplay);
            dragonDisplay.playAnimation('newAnimation', 1);
        } else {
            let dragonBoneData = this.mainCtil.getQuestionData().dragonBoneData;
            this.mainCtil.getDragonBone(this.frameN, "tikeaN", dragonBoneData.texPngData.url, dragonBoneData.skeJsonData.url, dragonBoneData.texJsonData.url)
        }
    }
    showBlock(){
        let block = this.node.getChildByName("block");
        block.active = true;
        block.opacity = 0;
        cc.tween(block)
        .to(0.5, { opacity: 255 })
        .start();
        if (this.frameN.getChildByName("tikeaN")) {
            this.frameN.getChildByName("tikeaN").active = false;
            this.dragon1.node.active=false;
        }
    }
    showResult(isSuc) {
        // this.dragon.node.active=false;
        let block = this.node.getChildByName("block");
        let nicetry = block.getChildByName("nicetry");
        this.dragon1.node.active=true;
        if (isSuc) {
            this.mainCtil.playLocalAudio("excellent")
            this.dragon1.playAnimation("newAnimation", 1)
            this.dragon1.on(dragonBones.EventObject.COMPLETE, () => {
                console.log("骨骼动画结束")
                block.active = false;
                this.mainCtil.nextQuestion();

            })

        } else {
            this.mainCtil.playLocalAudio("talkerr")
            this.dragon1.node.active = false;
            cc.tween(nicetry)
                .to(0.3, { y: -50 })
                .to(0.1, { y: 0 })
                .delay(1)
                .to(0.3, { y: -500 })
                .call(() => {
                    block.active = false;
                    this.mainCtil.nextQuestion();
                })
                .start();


        }
        // if(suc)
    }
    over(answerList){
        this.dragon1.node.active = false;
        this.dragon.node.active = false;
        let length=answerList.length;
        let sucTime=0;
        let over=cc.find("over",this.node);
        over.active=true;
        let nicetry=cc.find("over/nicetry",this.node);
        let comeon=cc.find("over/comeon",this.node)
        for(let i=0;i<length;i++){
            if(answerList[i]==1){
                sucTime++
            }
        }
        cc.tween(this.frameN)
        .to(0.3, { y: 0 })
        .call(()=>{
            if(sucTime==length){
                this.dragon2.node.active=true;
                this.dragon2.playAnimation("normal", 1)
                this.mainCtil.playLocalAudio("allRigtht")
            }else if((sucTime/length)>=0.6){
                this.mainCtil.playLocalAudio("nicetry");
                cc.tween(nicetry)
                .to(0.3, { y: -50 })
                .to(0.1, { y: 0 })
                .delay(1)
                .to(0.3, { y: -500 })
                .start();
            }else{
                this.mainCtil.playLocalAudio("comeon")
                cc.tween(comeon)
                .to(0.3, { y: -50 })
                .to(0.1, { y: 0 })
                .delay(1)
                .to(0.3, { y: -500 })
                .start();
            }
        })
        .start()
        // if(sucTime==length){
        //     this.dragon2.node.active=true;
        //     this.dragon2.playAnimation("normal", 1)
        //     this.mainCtil.playLocalAudio("allRigtht")
        // }else if((sucTime/length)>=0.6){
        //     this.mainCtil.playLocalAudio("nicetry");
        //     cc.tween(nicetry)
        //     .to(0.3, { y: -50 })
        //     .to(0.1, { y: 0 })
        //     .delay(1)
        //     .to(0.3, { y: -500 })
        //     .start();
        // }else{
        //     this.mainCtil.playLocalAudio("comeon")
        //     cc.tween(comeon)
        //     .to(0.3, { y: -50 })
        //     .to(0.1, { y: 0 })
        //     .delay(1)
        //     .to(0.3, { y: -500 })
        //     .start();
        // }
        

    }


    // update (dt) {}
}
