// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import { playAudio, playAudioByUrl } from "../script/util";

const { ccclass, property } = cc._decorator;

@ccclass
export default class AudioBar extends cc.Component {

    @property(cc.Node)
    audioIcon: cc.Node = null;
    private _clipUrl: string;

    onLoad() {
        this.node.on("click", this._playClip, this);
    }
    set url(url: string) {
        this._clipUrl = url;
    }
    _playClip() {
        this.node.stopAllActions();
        this.audioIcon.active = true;
        playAudioByUrl(this._clipUrl, this._stopAni.bind(this));
        cc.tween(this.audioIcon).blink(800, 1000).start();
    }
    _stopAni() {
        this.node.stopAllActions();
        this.audioIcon.active = false;
    }

    // update (dt) {}
}
