// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class Candle extends cc.Component {

    @property(cc.ProgressBar)
    proBar: cc.ProgressBar = null;

    @property(dragonBones.ArmatureDisplay)
    fire: dragonBones.ArmatureDisplay = null;

    @property(dragonBones.ArmatureDisplay)
    fireEnd: dragonBones.ArmatureDisplay = null;

    @property(cc.SpriteFrame)
    skin: Array<cc.SpriteFrame> = [];

    private _endCall: any;
    private _totalTime: number;
    private _fireOn: boolean;
    private _costTime: number;


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

        this._fireOn = false;
        this.fire.node.active = true;
        this.fireEnd.node.active = false;
        this.proBar.progress = 1;
    }

    setSkin(type: number) {
        this.node.active = true;
        this.fire.node.active = true;
        this.fireEnd.node.active = false;
        this.proBar.barSprite.spriteFrame = this.skin[type];
        this.proBar.progress = 1;
    }

    fireOn(time: number, endCall) {

        this._totalTime = time;
        this._costTime = 0;
        this._endCall = endCall;
        this._fireOn = true;

    }
    fireStop() {
        this._fireOn = false;
    }
    update(dt) {

        if (this._fireOn) {
            this._costTime += dt;
            this.proBar.progress = 1 - this._costTime / this._totalTime;
            if (this.proBar.progress < 0.20) {
                this.fire.node.active = false;
                this.fireEnd.node.active = true;
            }
            if (this.proBar.progress <= 0) {
                this._fireOn = false;
                this._endCall && this._endCall();
                this._endCall = null;
                this.node.active = false;
            }
        }
    }
}
