// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class ChoseNode extends cc.Component {

    @property(cc.Sprite)
    cake: cc.Sprite = null;
    @property(cc.Sprite)
    cover: cc.Sprite = null;
    @property(cc.Label)
    lb: cc.Label = null;

    @property(cc.SpriteFrame)
    cakeList: Array<cc.SpriteFrame> = [];
    @property(cc.SpriteFrame)
    coverList: Array<cc.SpriteFrame> = [];
    private _isAnswer: boolean;
    private _clickCall: Function;

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.cover.node.active = false;
    }
    onEnable() {
        this.node.on("click", this._onClickCake, this);
    }
    onDisable() {
        this.node.off("click", this._onClickCake, this);
    }
    _onClickCake() {

        if (this._isAnswer) {
            this.cover.node.active = true;
            cc.tween(this.cover).delay(0.5).hide().start();
        }

        this._clickCall && this._clickCall(this.node, this._isAnswer);

    }
    init(txt: string, isAnswer: boolean, clickCall: Function) {

        this.node.active = true;
        this.lb.string = txt;
        this._isAnswer = isAnswer;
        this._clickCall = clickCall;
    }

    // update (dt) {}
}
