
import { playAudio } from "./util";

const { ccclass, property, requireComponent } = cc._decorator;

@ccclass
@requireComponent(cc.Button)
export default class AudioButton extends cc.Component {
    @property(cc.AudioClip)
    clickAudio: cc.AudioClip = null;

    onClick(callback: Function, target) {
        this.node.on("click", () => {
            this.clickAudio && playAudio(this.clickAudio);
            callback.call(target);
        }, this);
    }

    onceClick(callback: Function, target) {
        this.node.once("click", () => {
            this.clickAudio && playAudio(this.clickAudio);
            callback.call(target);
        }, this);
    }
}
