const fs = require('fs');

const removeDir =  async function (src) {
  const exists = await fs.existsSync(src);
  if (!exists) {
    return;
  }

  //读取目录
  const st = await fs.statSync(src);
  const paths = await fs.readdirSync(src);
  for (let i = 0; i < paths.length; i++) {
    let path = paths[i];
    const newSrc = `${src}/${path}`;
    const st = await fs.statSync(newSrc);
    if (st.isFile()) {
      console.log('remove: ' + newSrc);
      await fs.unlinkSync(newSrc);
    } else if (st.isDirectory()) {
      await removeDir(newSrc);
    }
  }
  await fs.rmdirSync(src);
}

const copyDir = async function (src, dst) {
  const exists = await fs.existsSync(dst);
  if (!exists) {
    await fs.mkdirSync(dst);
  }
  //读取目录
  const paths = await fs.readdirSync(src);
  for (let i = 0; i < paths.length; i++) {
    let path = paths[i];
    const newSrc = `${src}/${path}`;
    const newDst = `${dst}/${path}`;
    const st = await fs.statSync(newSrc);
    if (st.isFile()) {
      console.log('copy: ' + newDst);
      const data = await fs.readFileSync(newSrc);
      await fs.writeFileSync(newDst, data);
    } else if (st.isDirectory()) {
      await copyDir(newSrc, newDst);
    }
  }
};
module.exports = {
  fix2: function (num) {
    if (num >= 10) {
      return '' + num;
    } else {
      return '0' + num;
    }
  },
  copyDir: copyDir,
  removeDir: removeDir,
};
