// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import utils = require("../../../bin/utils");
import { playAudio } from "../script/util";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Cake extends cc.Component {

    @property(cc.Node)
    cakes: Array<cc.Node> = [];
    @property(cc.Node)
    lbRoot: cc.Node = null;
    @property(cc.Node)
    lbNode: cc.Node = null;
    @property(cc.Node)
    top: cc.Node = null;
    @property(cc.Node)
    candle: cc.Node = null;
    @property(cc.AudioClip)
    candleClip: cc.AudioClip = null;


    private _word: string[];

    private _widths = [310, 280, 250, 220, 190];

    // LIFE-CYCLE CALLBACKS:
    onLoad() {
    }

    init(word: Array<string>,) {
        this._word = word;
        for (let i = 0; i < this.cakes.length; ++i) {
            let cakeNode = this.cakes[i];
            cakeNode.active = false;
        }


        this.lbRoot.removeAllChildren();
        let height = 0;
        let index = 0;
        for (let i = word.length - 1; i >= 0; --i) {
            let cakeNode = this.cakes[i];
            cakeNode.active = true;

            let width = this._widths[index]
            let scale = width / cakeNode.width;
            cakeNode.width = width;
            cakeNode.height = cakeNode.height * scale;
            cakeNode.y = height;



            let lbNode = cc.instantiate(this.lbNode);
            lbNode.parent = this.lbRoot;
            lbNode.y = height + cakeNode.height * scale * 0.5;
            lbNode.x = 0;
            lbNode.getComponent(cc.Label).string = word[i];
            height += (cakeNode.height * 0.8) * scale;
            index++;

            this.top.x = 0;
            this.top.y = height;

            console.log("height===" + height);
        }

        this.top.active = false;

    }
    insert(txt: string, index: number) {
        this._word.splice(index, 0, txt);
        this.init(this._word);
        this.top.active = true;
        this.candle.getComponent(dragonBones.ArmatureDisplay).playAnimation("newAnimation", 1);
        playAudio(this.candleClip);
        console.log("insert done");

    }

    start() {

    }

    // update (dt) {}
}
