
const { ccclass, property } = cc._decorator;

@ccclass
export default class CakeBar extends cc.Component {

    @property(cc.Node)
    Cake: cc.Node = null;

    init(total: number) {
        for (let i = 0; i < total; ++i) {
            let name = "cake_" + i;
            let node = cc.instantiate(this.Cake);
            node.name = name;
            node.parent = this.node;
            node.zIndex = i;
        }
        this.Cake.active = false;
    }
    updateUI(index: number, state: number) {

        let node = this.node.getChildByName("cake_" + index);
        node.getChildByName("fall").active = state == 2;
        node.getChildByName("in").active = state == 0;
        node.getChildByName("done").active = state == 1;
        if (state == 1) {
            node.opacity = 0;
            cc.tween(node).to(0.5, { opacity: 127, scale: 1.2 }).to(0.5, { opacity: 255, scale: 1 }).start();
        }

    }


    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {

    }

    // update (dt) {}
}
