// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

import {playAudioByUrl, setSprNodeMaxLen, btnClickAnima} from "./util";

cc.Class({
	extends: cc.Component,

	properties: {
		baseWidth: {
			default: 1280,
			type: cc.Integer
		},
		baseHeight: {
			default: 720,
			type: cc.Integer
		}
		// foo: {
		//     // ATTRIBUTES:
		//     default: null,        // The default value will be used only when the component attaching
		//                           // to a node for the first time
		//     type: cc.SpriteFrame, // optional, default is typeof default
		//     serializable: true,   // optional, default is true
		// },
		// bar: {
		//     get () {
		//         return this._bar;
		//     },
		//     set (value) {
		//         this._bar = value;
		//     }
		// },
	},

	// LIFE-CYCLE CALLBACKS:

	// baseWidth: 1280;
	// baseHeight: 720;

	onLoad() {
		this.initSceneData();
		this.initSize();
	},

	initSceneData() {
		this._imageResList = [];
		this._audioResList = [];
		this._animaResList = [];
	},

	_designSize: null,
	_frameSize: null,
	_mapScaleMin: null,
	_mapScaleMax: null,
	_cocosScale: null,
	initSize() {


		// 注意cc.winSize只有在适配后(修改fitHeight/fitWidth后)才能获取到正确的值,因此使用cc.getFrameSize()来获取初始的屏幕大小
		let screen_size = cc.view.getFrameSize().width / cc.view.getFrameSize().height
		let design_size = cc.Canvas.instance.designResolution.width / cc.Canvas.instance.designResolution.height
		let f = screen_size >= design_size
		cc.Canvas.instance.fitHeight = f
		cc.Canvas.instance.fitWidth = !f

		const frameSize = cc.view.getFrameSize();
		this._frameSize = frameSize;

		this._designSize = cc.view.getDesignResolutionSize();

		let sx = cc.winSize.width / frameSize.width;
		let sy = cc.winSize.height / frameSize.height;
		this._cocosScale = Math.min(sx, sy);

		sx = frameSize.width / this._designSize.width;
		sy = frameSize.height / this._designSize.height;
		this._mapScaleMin = Math.min(sx, sy) * this._cocosScale;
		this._mapScaleMax = Math.max(sx, sy) * this._cocosScale;




		cc.log('cc.Canvas: ', cc.Canvas);
	},

	start() {
		let getData = this.getData.bind(this);
		if (window && window.courseware) {
			// console.log('has window');
			getData = window.courseware.getData;
		}
		getData((data) => {
			console.log('data:', data);
			this.data = data || this.getDefaultData();
			this.data = JSON.parse(JSON.stringify(this.data))
			this.preloadItem()
		})
	},


	_imageResList: null,
	_audioResList: null,
	_animaResList: null,
	preloadItem() {
		this.addPreloadImage();
		this.addPreloadAudio();
		this.addPreloadAnima();
		this.preload();
	},

	getData(func) {
		func(this.getDefaultData());
	},

	getDefaultData() {

		const dataJson = '{"groupArr":[{"bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/c892fd494530c7ea5321f5ad8fd5171d.png","rect":{"x":302.17,"y":0,"width":1242.67,"height":699}},"hotZoneItemArr":[{"id":"1600134210418","index":0,"fontScale":1.44296875,"imgScale":1,"mapScale":1.44296875,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/3db1a0ed6b7e33d5f9f284e1a5980349.json","name":"Ubbie_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/4232e00c9b1d272e650e51dbb785e498.json","name":"Ubbie_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/2e56dbe3134380952a725eacceb86359.png","name":"Ubbie_tex.png"},"gIdx":"0","rect":{"x":517,"y":245.17,"width":208.65,"height":208.65}},{"id":"1600134212707","index":1,"pic_url":"http://staging-teach.cdn.ireadabc.com/92381001e3a2fb7d08920748144dba6d.png","audio_url":"http://staging-teach.cdn.ireadabc.com/1961d807c944e6551af02c7b57e117f3.mp3","itemType":"pic","fontScale":1.44296875,"imgScale":1.1417140432518729,"mapScale":1.44296875,"gIdx":"1","rect":{"x":653.56,"y":47.3,"width":175.82,"height":100.47}}],"picArr":[{"pic_url":"http://staging-teach.cdn.ireadabc.com/be8ec5cee7a3074440478b00a4a84f5e.png","audio_url":"http://staging-teach.cdn.ireadabc.com/f51e3fedc88aa69a99f6ef579f7de047.mp3","isRight":"1"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/7404f50bbe6f8bb60a41280211e7d563.png","audio_url":"http://staging-teach.cdn.ireadabc.com/fbe2f23b9eb191a9330f99800e0d54d5.mp3","isRight":"0"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/4c49ea30ff4e7a038480614602a331e2.png","audio_url":"http://staging-teach.cdn.ireadabc.com/cf5077b8cbcaa1dc664df569d4af6043.mp3","isRight":"0"}],"pop_pic_url":"http://staging-teach.cdn.ireadabc.com/92381001e3a2fb7d08920748144dba6d.png","title":"I need ..","title_audio_url":"http://staging-teach.cdn.ireadabc.com/22e9facddfbf087ecdf2b60dba6019ef.mp3","skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/51e9d8e4e2e963a7658d07eba6c282f8.json","name":"Ubbie_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/4232e00c9b1d272e650e51dbb785e498.json","name":"Ubbie_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/2e56dbe3134380952a725eacceb86359.png","name":"Ubbie_tex.png"},"bubble_audio_url":"http://staging-teach.cdn.ireadabc.com/0be0ec35fa203e84e4d955f8c32d26bb.mp3"},{"bgItem":{"url":"http://staging-teach.cdn.ireadabc.com/e15de0b2819aa341ec4424ff061917bf.png","rect":{"x":302.17,"y":0,"width":1242.67,"height":699}},"hotZoneItemArr":[{"id":"1600306712362","index":0,"fontScale":1.44296875,"imgScale":1,"mapScale":1.44296875,"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/3db1a0ed6b7e33d5f9f284e1a5980349.json","name":"Ubbie_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/4232e00c9b1d272e650e51dbb785e498.json","name":"Ubbie_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/2e56dbe3134380952a725eacceb86359.png","name":"Ubbie_tex.png"},"gIdx":"0","rect":{"x":523.16,"y":251.33,"width":196.35,"height":196.35}},{"id":"1600306713123","index":1,"pic_url":"http://staging-teach.cdn.ireadabc.com/1e6968ec44a3ce922120109adc3260b9.png","audio_url":"http://staging-teach.cdn.ireadabc.com/0128a59057e63c4c6b4b96556d077a98.mp3","itemType":"pic","fontScale":1.44296875,"imgScale":2.6666666666666665,"mapScale":1.44296875,"gIdx":"1","rect":{"x":745.39,"y":3.23,"width":176,"height":184}}],"picArr":[{"pic_url":"http://staging-teach.cdn.ireadabc.com/c8abf7383d65bcbdba8f390785cece60.png","audio_url":"http://staging-teach.cdn.ireadabc.com/83513f8d6083ebe072e3f9e47a21558a.mp3","isRight":"1"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/f6f4bbef497409fef3c8f1d375893829.png","audio_url":"http://staging-teach.cdn.ireadabc.com/5285e1e88a26a08783757e9c43a8653f.mp3","isRight":"0"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/7b18a7931d64f7b9e8b7ecd25cb5e3d4.png","audio_url":"http://staging-teach.cdn.ireadabc.com/440cf9d57752b30691d90ed565e8c924.mp3","isRight":"0"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/8e21a700c4d00930e8c05082a9a70c83.jpg","audio_url":"http://staging-teach.cdn.ireadabc.com/a5fa20e0c6024421b0d9a7007c303503.mp3","isRight":"0"},{"pic_url":"http://staging-teach.cdn.ireadabc.com/bf3650b10ffe365ccaac59a8b3983244.jpg","audio_url":"http://staging-teach.cdn.ireadabc.com/a41f0f2bf190396e2641ec8dada8edfe.mp3","isRight":"0"}],"skeJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/51e9d8e4e2e963a7658d07eba6c282f8.json","name":"Ubbie_ske.json"},"texJsonData":{"url":"http://staging-teach.cdn.ireadabc.com/4232e00c9b1d272e650e51dbb785e498.json","name":"Ubbie_tex.json"},"texPngData":{"url":"http://staging-teach.cdn.ireadabc.com/2e56dbe3134380952a725eacceb86359.png","name":"Ubbie_tex.png"},"title":"I want ..","title_audio_url":"http://staging-teach.cdn.ireadabc.com/694a80e21cefd6e53880d61e684e1c94.mp3","pop_pic_url":"http://staging-teach.cdn.ireadabc.com/35d3ec81cdf2cfe73c6010d668c36c83.png"}]}'
		const data1 = JSON.parse(dataJson);
		return data1;
	},

	preload() {

		const preloadArr = this._imageResList.concat(this._audioResList).concat(this._animaResList);
		cc.assetManager.loadAny(preloadArr, null, null, (err, data) => {
			console.log(' preload data, ', data);

			// typeof
			this.loadEnd();
			if (window && window["air"]) {
				window["air"].hideAirClassLoading();
			}
		});
	},

	addPreloadImage() {
		if (this.data.groupArr) {
			this.data.groupArr.forEach(group => {

				if (group.bgItem) {
					this._imageResList.push({url: group.bgItem.url});
				}
				if (group.hotZoneItemArr) {
					group.hotZoneItemArr.forEach((item) => {
						if (item.pic_url) {
							this._imageResList.push({url: item.pic_url});
						}
					})
				}
			

				if (group.picArr) {
					group.picArr.forEach(pic => {
						this._imageResList.push({url: pic.pic_url});
					})
				}
			})
		}

	},

	addPreloadAudio() {

		this.data.groupArr.forEach((item) => {
			this._audioResList.push({url: item.title_audio_url});
			this._audioResList.push({url: item.question_audio_url});

			item.picArr.forEach((subItem) => {
				this._audioResList.push({url: subItem.audio_url});
			})

		});

	},

	addPreloadAnima() {
		if (!this.data.groupArr) {
			return;
		}
		this.data.groupArr.forEach((group) => {

			if (group.hotZoneItemArr) {
				group.hotZoneItemArr.forEach((item) => {
					if (item.gIdx == '0' &item.skeJsonData) {
						this._animaResList.push({url: item.skeJsonData.url});
						this._animaResList.push({url: item.texJsonData.url});
						this._animaResList.push({url: item.texPngData.url});
					}
				})
			}
			
			if (group.skeJsonData) {
				this._animaResList.push({url: group.skeJsonData.url});
				this._animaResList.push({url: group.texJsonData.url});
				this._animaResList.push({url: group.texPngData.url});
			}
		})

	},

	loadEnd() {
		this.initData();
		this.initAudio();
		this.initView();
		this.initListener();
	},

	audioEnter: null,
	audioAppear: null,
	audioCircle: null,
	audioClick: null,
	audioPop: null,
	audioRight: null,
	audioWrong: null,
	audioUp: null,
	audioDown: null,
	initAudio() {
		const audioNode = cc.find('Canvas/res/audio');

		const getAudioByResName = (resName) => {
			return audioNode.getChildByName(resName).getComponent(cc.AudioSource);
		}

		this.audioClick = getAudioByResName('click');
		this.audioWrong = getAudioByResName('wrong');
		this.audioUp = getAudioByResName('up');
		this.audioDown = getAudioByResName('down');

		// cc.audioEngine.play(this.audioBgm.clip, true, 0.1)

	},

	groupIdx: null,
	_cantouch: null,
	
	initData() {
	
		this.groupIdx = 0;
		this.curGroup= this.data.groupArr[this.groupIdx];

		this._cantouch = true;
		this.isShowRightAnima = false;
	},


	getSprNode(resName) {
		const sf = cc.find('Canvas/res/img/' + resName).getComponent(cc.Sprite).spriteFrame;
		const node = new cc.Node();
		node.addComponent(cc.Sprite).spriteFrame = sf;
		return node;
	},

	getSprNodeByUrl(url, cb) {
		const node = new cc.Node();
		const spr = node.addComponent(cc.Sprite);
		this.getSpriteFrimeByUrl(url, (sf) => {
			spr.spriteFrame = sf;
			if (cb) {
				cb(spr);
			}
		})
	},

	initView() {
		this.initTitle();
		this.initBg();
		this.initBubble();
		this.initAnima();
		this.initCirclePart();
		this.initBottomPart();
		this.initHotZone();
	
		this.initMaskLayer();
		this.showStartAudio();
	},

	initHotZone() {
		this.initHotZoneBg();
	},

	hotZoneBg: null,
	hotzoneCircleArr: null,
	initHotZoneBg() {

		if (!this.curGroup.bgItem) {
			return;
		}

		if (this.hotZoneBg) {
			this.hotZoneBg.parent.removeAllChildren();
		}

		this.hotZoneBg = new cc.Node();
		this.hotZoneBg.name = 'hotZoneBg';
		this.hotZoneBg.parent = cc.find('Canvas/frame/pic');
		this.hotZoneBg.zIndex = 4;


		this.getSprNodeByUrl(this.curGroup.bgItem.url, (spr) => {

			this.hotZoneBg.addChild(spr.node);
			this.hotZoneBg.width = spr.node.width;
			this.hotZoneBg.height = spr.node.height;

			const maxW = 797;
			const maxH = 430;

			setSprNodeMaxLen(this.hotZoneBg, maxW, maxH);

			this.curGroup.hotZoneItemArr.forEach((item) => {
				if (item.gIdx == '0') {
					this.setOneAnima(item);
				}
				if (item.gIdx == '1') {
					this.setOnePic(item);
				}

				console.log('hotZone item: ', item)
			});
		})

		return;

	},


	initAnima() {
		this.setStakeAnima(this.curGroup);
	},

	initCirclePart() {
		const circlePart = cc.find('Canvas/circlePart')

		for (let i = 0; i < 5; i ++) {
			const data = this.curGroup.picArr[i];
			const posNode = circlePart.getChildByName((i + 1).toString())
			if (data) {
				posNode.active = true;
				posNode.data = data;
				posNode.isClicked = false;
				
				this.addCircleListener(posNode);

				const maskNode = posNode.getChildByName('mask');
				maskNode.removeAllChildren();
				this.getSprNodeByUrl(data.pic_url, (spr) => {
					spr.node.parent = maskNode;
					setSprNodeMaxLen(spr.node, 124, 124);
				})

				if (!posNode.blackSpr) {

					const blackSpr = this.getSprNode('circle_black');
					blackSpr.parent = posNode;
					blackSpr.x = maskNode.x;
					blackSpr.y = maskNode.y;
					posNode.blackSpr = blackSpr;
				}
				posNode.blackSpr.active = false;
				
			} else {
				posNode.active = false;
			}
		}


	},

	addCircleListener(circlePosNode) {
		const circle = circlePosNode.getChildByName('circle');
		if (	circle.isAddTouch ) {
			return;
		}

		const touchCircle = () => {
			console.log('circle data: ', circle.parent.data)

			if (circlePosNode.isClicked || this.isShowRightAnima) {
				return;
			}
			circlePosNode.isClicked = true;

			if (circlePosNode.data.isRight == '0') {
				this.showCircleWrong(circle);
			} else {
				this.showCircleRight(circlePosNode.data);
			}
		}
		
		const touchSound = () => {
			if (circlePosNode.data.audio_url) {
				this.showSoundAnima(sound);
			}
			playAudioByUrl(circlePosNode.data.audio_url, () => {
				this.stopSoundAnima(sound);
			});
		}



		circle.on(cc.Node.EventType.TOUCH_START, touchCircle)
		circle.isAddTouch = true;

		const sound = circlePosNode.getChildByName('sound');
		sound.on(cc.Node.EventType.TOUCH_START, touchSound)
		sound.isAddTouch = true;

		const sprNode2 = this.getSprNode('icon_sound_2');
		sprNode2.parent = sound.parent;
		sprNode2.x = sound.x;
		sprNode2.y = sound.y;
		sprNode2.opacity = 0;
		sound.spr2 = sprNode2;
	},

	showCircleWrong(circle) {

		const black = circle.parent.blackSpr;
		
		// if (black.active) {
		// 	return;
		// }

		black.active = true;
		black.opacity = 0;

		cc.tween(black)
			.to(0.1, {opacity: 255})
			.start();


		this.curDragonDisplay.playAnimation('wrong', 1);
		this.curDragonDisplay.once(dragonBones.EventObject.COMPLETE, () => {
			this.curDragonDisplay.playAnimation('normal', -1);
		})

		cc.audioEngine.play(this.audioWrong.clip, false, 0.2)
	},

	showCircleRight(data) {

		this.isShowRightAnima = true; 
		this.curDragonDisplay.playAnimation('normal', -1);

		const hideBubble = () => {
			cc.tween(this.bubble)
				.to(0.15, {scale: 0})
				.delay(0.1)
				.call(() => {
					this.animaUp();
				})
				.start();

			cc.audioEngine.play(this.audioUp.clip, false, 0.2)
		}
		
		if (!data.audio_url) {
			hideBubble()
			return;
		}
		playAudioByUrl(data.audio_url, hideBubble)
	},

	animaUp() {
		const animaNode = this.stake.animaNode
		const targetP = animaNode.parent.convertToNodeSpaceAR(cc.v2(0, cc.winSize.height * 1.5));
		cc.tween(animaNode)
			.to(0.3, {y: targetP.y})
			.delay(0.2)
			.call(() => {
				this.showRightAnima();
			})
			.start();
	},
	
	isShowRightAnima: null,
	showRightAnima() {
		const animaNode = this.hotZoneBg.animaNode;
		animaNode.active = true;

		const targetP = animaNode.parent.convertToNodeSpaceAR(cc.v2(0, cc.winSize.height * 1.5));
		animaNode.y = targetP.y;
		
		cc.tween(animaNode)
			.delay(0.1)
			.to(0.3, {y: 0})
			.call(() => {
				this.bubbleJump(this.rightBubble);
			
				this.curRightDragonDisplay.playAnimation(this.curRightDragonDisplay.curName, -1);
				this.curRightDragonDisplay.timeScale = 1;
				this.showRightBubbleSound();
			})
			.start();

		cc.audioEngine.play(this.audioDown.clip, false, 0.2)

	},

	showRightBubbleSound() {
		playAudioByUrl(this.rightBubble.data.audio_url);

	},

	bubbleJump(bubble) {

		bubble.active = true;
		if (!bubble.baseS) {
			bubble.baseS = bubble.scale;
		}
		bubble.scale = 0;
		cc.tween(bubble)
		.to(0.8, {scale: bubble.baseS}, {easing: 'elasticOut'})
		.start();
	},


	maskLayer: null,
	initMaskLayer() {

		const bNode = this.getSprNode('black');
		bNode.scaleX = cc.winSize.width / bNode.width;
		bNode.scaleY = cc.winSize.height / bNode.height;
		bNode.parent = cc.find('Canvas');
		bNode.active = false;
		bNode.zIndex = 10;
		this.maskLayer = bNode;
	},

	showStartAudio() {
		playAudioByUrl(this.curGroup.title_audio_url, () => {
			this.showBubbleAudio(() => {
				this.curDragonDisplay.playAnimation('normal', -1);
				this.curDragonDisplay.timeScale = 1;

				this.resetBubble();
			});
		});
	},

	showBubbleAudio(cb = null) {
		playAudioByUrl(this.curGroup.bubble_audio_url, () => {
			if (cb) {
				cb();
			}
		});
	},

	showQuestionAudio() {
		playAudioByUrl(this.curGroup.question_audio_url);
	},
	
	initListener() {
	
		const canvas = cc.find('Canvas');
		if (canvas.hasEventListener(cc.Node.EventType.TOUCH_MOVE)) {
			return;
		
		}
		canvas.on(cc.Node.EventType.TOUCH_MOVE, (e) => {
			// this.canvasTouchMove(e);
		},)
		canvas.on(cc.Node.EventType.TOUCH_CANCEL, (e) => {
			// this.canvasTouchEnd(e);
		})
		canvas.on(cc.Node.EventType.TOUCH_END, (e) => {
			// this.canvasTouchEnd(e);
		})
	},

	initBgItem() {
		const titleBg = this.getSprNode('bg_item');
		titleBg.parent = cc.find('Canvas');
		titleBg.scale = this._mapScaleMin;
		titleBg.anchorX = 0;
		titleBg.anchorY = 0;
		titleBg.x = -titleBg.parent.width / 2
		titleBg.y = -titleBg.parent.height / 2;

	},

	bg: null,
	curGroup: null,
	stake: null,
	animaBubble: null,
	initBg() {
		const bgNode = cc.find('Canvas/bg')
		bgNode.scale = this._mapScaleMax;
		this.bg = bgNode;	
		
		const stake = this.getSprNode('stake');
		stake.parent = cc.find('Canvas');
		stake.scale = this._mapScaleMin;
		stake.anchorX = 0.5;
		stake.anchorY = 1;
		stake.x = stake.parent.width / 2 - stake.width / 2 - 20;
		stake.y = -stake.parent.height / 2 + stake.height;
		stake.zIndex = 1;
		this.stake = stake;

	},

	bubble: null,
	initBubble() {

		if (this.bubble) {
			this.bubble.removeFromParent();
		}

		this.getSprNodeByUrl(this.curGroup.pop_pic_url, (spr) => {
			spr.node.parent = this.stake;
			spr.node.zIndex = 10;
			spr.node.y = 376 + spr.node.height / 2 - 40;
			this.bubble = spr.node;
			this.bubbleJump(this.bubble);
			this.bubble.active = false;
		});
	},



	titleLabel: null,
	initTitle() {
		const titleNode = this.getSprNode('fish');
		titleNode.parent = cc.find('Canvas');
		titleNode.scale = this._mapScaleMin;
		titleNode.anchorX = 0;
		titleNode.anchorY = 1;

		titleNode.x = -titleNode.parent.width / 2
		titleNode.y = titleNode.parent.height / 2;

		const labelNode = new cc.Node();
		labelNode.parent = titleNode;
		const label = labelNode.addComponent(cc.RichText);
		const size = 60
		label.font = cc.find('Canvas/res/font/BRLNSR_1').getComponent(cc.Label).font;
		// label.string = `<outline color=#375700 width=4><size=${size}><color=#751e00>${this.curGroup.title }</color></size></outline>`
		label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		label.lineHeight = size;
		label.horizontalAlign = cc.macro.TextAlignment.LEFT
		labelNode.anchorX = 0;
		labelNode.anchorY = 1
		labelNode.x = 40;
		labelNode.y = -60;

		this.titleLabel = label;

		const maxW = titleNode.width * 0.85;
		if (labelNode.width > maxW) {
			labelNode.scale = maxW / labelNode.width;
		}

		titleNode.addComponent(cc.Button);
		titleNode.on('click', () => {
			playAudioByUrl(this.curGroup.title_audio_url);
		});
	},


	getSpriteFrimeByUrl(url, cb) {
		cc.loader.load({url}, (err, img) => {
			const spriteFrame = new cc.SpriteFrame(img)
			if (cb) {
				cb(spriteFrame);
			}
		})
	},


	showSoundAnima(iconNode, time = 0.4) {

		iconNode.isRunAnima = true;
		iconNode.spr2.opacity = 255;
		iconNode.opacity = 0;

		cc.tween(iconNode)
			.delay(time / 2)
			.call(() => {
				iconNode.spr2.opacity = 0;
				iconNode.opacity = 255;
			})
			.delay(time / 2)
			.call(() => {
				if (iconNode.isRunAnima) {
					this.showSoundAnima(iconNode);
				}
			})
			.start()
	},

	stopSoundAnima(iconNode) {
		iconNode.isRunAnima = false;
	},







	initBottomPart() {
		const bottomPart = cc.find('Canvas/bottomPart')
		bottomPart.scale = this._mapScaleMin;
		bottomPart.x = bottomPart.parent.width / 2;
		bottomPart.y = -bottomPart.parent.height / 2;
		bottomPart.zIndex = 10;

		const leftBtn = bottomPart.getChildByName('btn_left');
		const rightBtn = bottomPart.getChildByName('btn_right');
		const resetBtn = bottomPart.getChildByName('btn_reset');
		const cancelBtn = bottomPart.getChildByName('btn_cancel');
		

		btnClickAnima(leftBtn)
		leftBtn.on('click', () => {
			if (!this._cantouch) {
				return;
			}
			this._cantouch = false;
			this.leftBtnClick();
			this.refreshBtnStatue();
		})

		btnClickAnima(rightBtn)
		rightBtn.on('click', () => {
			if (!this._cantouch) {
				return;
			}
			this._cantouch = false;
			this.rightBtnClick();
			this.refreshBtnStatue();
		})

		btnClickAnima(resetBtn)
		resetBtn.on('click', () => {

			if (!this._cantouch) {
				return;
			}
			this._cantouch = false;
			this.resetBtnClick();
		})

		btnClickAnima(cancelBtn)
		cancelBtn.on('click', () => {
			// if (!this._cantouch) {
			// 	return;
			// }
			// this._cantouch = false;
			// this.cancelBtnClick();
		})

		this.refreshBtnStatue();
	},

	refreshBtnStatue() {

		const leftBtn = cc.find('Canvas/bottomPart/btn_left');
		const rightBtn = cc.find('Canvas/bottomPart/btn_right');

		leftBtn.opacity = 255;
		rightBtn.opacity = 255;

		if (this.groupIdx <= 0) {
			leftBtn.opacity = 80;
		}
		if (this.groupIdx >= this.data.groupArr.length - 1) {
			rightBtn.opacity = 80;
		}
	},

	leftBtnClick() {
		console.log('left btn click')
		
		if (this.groupIdx <= 0) {
			this._cantouch = true;
			return;
		}

		cc.audioEngine.play(this.audioClick.clip, false, 0.1)

		this.groupIdx --;
		this.curGroup = this.data.groupArr[this.groupIdx];

		this.showNewGroup()
	},

	rightBtnClick() {
		if (this.groupIdx >= this.data.groupArr.length - 1) {
			this._cantouch = true;
			return;
		}

		cc.audioEngine.play(this.audioClick.clip, false, 0.1)

		this.groupIdx ++;
		this.curGroup = this.data.groupArr[this.groupIdx];

		console.log(this.groupIdx);;

		this.showNewGroup()
	},

	resetBtnClick() {
		console.log('resetbtn click');

		cc.audioEngine.play(this.audioClick.clip, false, 0.1)
		this.showNewGroup()
	},

	cancelBtnClick() {

	},

	showNewGroup() {

		
		this.showMaskLayer(() => {

			
			this.resetTitle();
			this.initAnima();
			this.initCirclePart();
			this.initHotZone();
			this.initBubble();
			// this.initCenterPart1();
			// this.initCenterPart2();
			this.hideMaskLayer(() => {
				this.isShowRightAnima = false;
				this._cantouch = true;
				this.showBubbleAudio(() => {
					this.curDragonDisplay.playAnimation('normal', -1);
					this.curDragonDisplay.timeScale = 1;
					this.resetBubble();
				});
				// this.showQuestionAudio();
			});
		})
	},

	resetBubble() {
		this.bubble.scale = 1;
		
		this.bubbleJump(this.bubble);
	},

	showMaskLayer(cb) {
		console.log(' in showMaskLayer');
		this.maskLayer.opacity = 0;
		this.maskLayer.active = true;
		cc.tween(this.maskLayer)
			.to(0.5, {opacity: 255}, {easing: 'sineOut'})
			.call(() => {
				cb()
			})
			.start()
	},

	hideMaskLayer(cb = null) {
		console.log(' in hideMaskLayer');
		this.maskLayer.opacity = 255;
		cc.tween(this.maskLayer)
		.to(0.5, {opacity: 0}, {easing: 'sineIn'})
		.call(() => {
			this.maskLayer.active = false;
			if (cb) {
				cb()
			}
		})
		.start()
	},

	resetTitle() {

		const size = 60
		const label = this.titleLabel;
		label.string = `<size=${size}><color=#751e00>${this.curGroup.title }</color></size>`
		const labelNode = label.node;
		// console.log('curGroup: ', this.curGroup);

		const maxW = labelNode.parent.width * 0.85;
		if (labelNode.width > maxW) {
			labelNode.scale = maxW / labelNode.width;
		}
	},

	
	curDragonDisplay: null,
	setStakeAnima(data) {

		// const picNode = cc.find('Canvas/centerPart_2/frame/pic');
		// // const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.data.bgItem.rect.width;

		// const rectNode = new cc.Node();
		// // rectNode.name = 'rect' + data.index;
		// rectNode = picNode;


		// const ctx = rectNode.addComponent(cc.Graphics);
		// // 红色矩形
		// ctx.lineWidth = 4;
		// ctx.strokeColor = cc.Color.BLACK;
		// ctx.fillColor = cc.Color.WHITE.setA(100);

		// const scale = rate / this.hotZoneBg.scaleY;

		// rectNode.width = data.rect.width * scale;
		// rectNode.height = data.rect.height * scale;
		// rectNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		// rectNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		// rectNode.anchorX = rectNode.anchorY = 0;


		// if (this.data.bgItem.isShowDebugLine) {
		// 	ctx.rect(0, 0, rectNode.width, rectNode.height);
		// }
		// ctx.stroke();
		// ctx.fill();

		const picNode = this.stake;
		console.log('data: ', data);

		if (picNode.animaNode) {
			picNode.animaNode.removeFromParent();
		}
		const animaNode = new cc.Node();
		animaNode.parent = picNode;
		picNode.animaNode = animaNode;


		// if (data.audio_url) {
		// 	cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
		// 		animaNode.audioClip = audioClip;
		// 	});
		// }


		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);

		this.curDragonDisplay = dragonDisplay;

		const image = data.texPngData.url//"http://staging-teach.cdn.ireadabc.com/5a0c5af3e952acd0ac83a6e5c6f03ff1.png";
		const ske = data.skeJsonData.url//"http://staging-teach.cdn.ireadabc.com/bd825dcceea298d1146be8067ae3d17f.json";
		const atlas = data.texJsonData.url//"http://staging-teach.cdn.ireadabc.com/246f8991b729fa3e5a7f4802de828efa.json";
		cc.loader.load(image, (error, texture) => {

			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {

				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;

					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];
					// console.log('armatures: ', armatures);
					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}
					// console.log('armatureNames: ', armatureNames);
					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;
						// let animationNames = dragonDisplay.getAnimationNames(defaultArmatureName);
						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						let animationNames = [];
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						// rectNode.addComponent(cc.Button);
						// rectNode.on('click', () => {
						// 	if (rectNode.isClicked) {
						// 		// return;
						// 	}
						// 	rectNode.isClicked = true;
						// 	console.log('clicked');

						// 	if (animaNode.audioClip) {
						// 		cc.audioEngine.stopAll();
						// 		cc.audioEngine.play(animaNode.audioClip, false, 0.8);
						// 	}

							// if (animationNames.length > 0) {
							// 	dragonDisplay.playAnimation(animationNames[0], -1);
							// }
						// });

						dragonDisplay.playAnimation('normal', 1);
						dragonDisplay.timeScale = 0;
						
						dragonDisplay.animaNames = animationNames;

						// setSprNodeMaxLen(animaNode, 474, 290);
						// animaNode.addComponent(cc.Button)
						// animaNode.y = animaNode.height / 2;
						animaNode.y -= 30;

						animaNode.scale = 376 / animaNode.height;
						// animaNode.on('click', () => {
						// 	console.log('anima node clicked ~~~');
						// 	this.showDragonAnima();
						// })
					}

				});
			});
		});

	},

	showDragonAnima() {
		if (this.curDragonDisplay && this.curDragonDisplay.animaNames.length > 0) {
			this.curDragonDisplay.playAnimation(this.curDragonDisplay.animaNames[0], 1);
		}
	},

	rightBubble: null,
	setOnePic(data) {

	
		const rate = (this.hotZoneBg.scale * this.hotZoneBg.width) / this.curGroup.bgItem.rect.width;

		const picNode = new cc.Node();
		picNode.data = data;
		this.hotZoneBg.addChild(picNode);

		cc.loader.load({url: data.pic_url}, (err, img) => {

			const spr = picNode.addComponent(cc.Sprite);
			spr.spriteFrame = new cc.SpriteFrame(img)
			// spr.node.scale = data.mapScale;

			const scale = rate / this.hotZoneBg.scaleY;

			picNode.width = data.rect.width * scale;
			picNode.height = data.rect.height * scale;
			picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
			picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

			picNode.anchorX = picNode.anchorY = 0;
			// picNode.opacity = 0;

			picNode.baseS = picNode.scale;
			picNode.scale = 0;
			this.rightBubble = picNode;
			this.rightBubble.data = data;

			picNode.on(cc.Node.EventType.TOUCH_START, () => {
				this.showRightBubbleSound();
			})
			// data.pic = picNode;
		});


		// const picNode = new cc.Node();
		// picNode.data = data;
		// this.hotZoneBg.addChild(picNode);

		// cc.loader.load({url: data.pic_url}, (err, img) => {

		// 	const spr = picNode.addComponent(cc.Sprite);
		// 	spr.spriteFrame = new cc.SpriteFrame(img)

		// 	const scale = rate / this.hotZoneBg.scaleY;

		// 	picNode.width = data.rect.width * scale;
		// 	picNode.height = data.rect.height * scale;
		// 	picNode.x = -this.hotZoneBg.width / 2 + data.rect.x * scale;
		// 	picNode.y = this.hotZoneBg.height / 2 - data.rect.height * scale - data.rect.y * scale;

		// 	picNode.anchorX = picNode.anchorY = 0;
		// 	picNode.opacity = 0;

		// 	data.pic = picNode;
		// });

	},

	curRightDragonDisplay: null,
	setOneAnima(data) {

		if (this.hotZoneBg.animaNode) {
			this.hotZoneBg.animaNode.removeFromParent();
		}
		const animaNode = new cc.Node();
		animaNode.parent = this.hotZoneBg;
		animaNode.active = false;
		this.hotZoneBg.animaNode = animaNode;


		// if (data.audio_url) {
		// 	cc.assetManager.loadRemote(data.audio_url, (err, audioClip) => {
		// 		animaNode.audioClip = audioClip;
		// 	});
		// }


		const dragonDisplay = animaNode.addComponent(dragonBones.ArmatureDisplay);

		this.curRightDragonDisplay = dragonDisplay;

		const image = data.texPngData.url;
		const ske = data.skeJsonData.url;
		const atlas = data.texJsonData.url;
		cc.loader.load(image, (error, texture) => {
			cc.loader.load({url: atlas, type: 'txt'}, (error, atlasJson) => {
				cc.loader.load({url: ske, type: 'txt'}, (error, dragonBonesJson) => {

					const atlas = new dragonBones.DragonBonesAtlasAsset();
					atlas.atlasJson = atlasJson;
					atlas.texture = texture;

					const asset = new dragonBones.DragonBonesAsset();
					asset.dragonBonesJson = dragonBonesJson;

					dragonDisplay.dragonAtlasAsset = atlas;
					dragonDisplay.dragonAsset = asset;

					let json = JSON.parse(asset.dragonBonesJson);
					let armatures = json["armature"];

					let armatureNames = [];
					for (let i = 0; i < armatures.length; i++) {
						armatureNames.push(armatures[i].name);
					}

					if (armatureNames.length > 0) {
						let defaultArmatureName = armatureNames[0];
						dragonDisplay.armatureName = defaultArmatureName;

						let defaultArmature = armatures[0];
						let animations = defaultArmature.animation;
						let animationNames = [];
						for (let i = 0; i < animations.length; i++) {
							animationNames.push(animations[i].name);
						}

						// rectNode.addComponent(cc.Button);
						// rectNode.on('click', () => {
						// 	if (rectNode.isClicked) {
						// 		// return;
						// 	}
						// 	rectNode.isClicked = true;
						// 	console.log('clicked');

						// 	if (animaNode.audioClip) {
						// 		cc.audioEngine.stopAll();
						// 		cc.audioEngine.play(animaNode.audioClip, false, 0.8);
						// 	}

							if (animationNames.length > 0) {
								dragonDisplay.playAnimation(animationNames[0], 1);
								dragonDisplay.timeScale = 0;
								dragonDisplay.curName = animationNames[0];
								// dragonDisplay.playAnimation(animationNames[0], -1);
								// dragonDisplay.playAnimation(animationNames[0], -1);
							}
						// });

						// dragonDisplay.playAnimation('normal', -1);

						// dragonDisplay.animaNames = animationNames;

						// // setSprNodeMaxLen(animaNode, 474, 290);
						// animaNode.addComponent(cc.Button)
						// // animaNode.y = animaNode.height / 2;
						// animaNode.y -= 30;

						// animaNode.scale = 376 / animaNode.height;
						// animaNode.on('click', () => {
						// 	console.log('anima node clicked ~~~');
						// 	this.showDragonAnima();
						// })
					}

				});
			});
		});

	},

	// update (dt) {
	// 	this.updateWave();
	// }
});




