import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef, ChangeDetectorRef} from '@angular/core';
import {NzMessageService} from "ng-zorro-antd";



@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.css']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  // 储存数据用
  saveKey = "cc_mz_007";
  // 储存对象
  item;

  bgItem = {};
  hotZoneItemArr = [];
  animaArr = [];

  picArr;
  animaBtnName = '配置右侧龙骨动画'
  animaNames = ['normal', 'wrong']

  customTypeGroupArr = [

    {
      name: '图中动画',
      // rect: true,
      anima: true,
    },
    {
      name: '气泡',
      pic: true,
      audio: true
    }
  ]

  groupArr = [];

  constructor(private appRef: ApplicationRef,private changeDetectorRef: ChangeDetectorRef, private message: NzMessageService) {

  }


  ngOnInit() {

    this.item = {};

    // 获取存储的数据
    (<any> window).courseware.getData((data) => {

      if (data) {
        this.item = data;
      }

      this.init();
      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();
      this.refresh();

      console.log('this.item: ', this.item);

    }, this.saveKey);

  }


  ngOnChanges() {
  }

  ngOnDestroy() {
  }



  init() {
    // this.bgItem = this.item.bgItem || {};
    // this.hotZoneItemArr = this.item.hotZoneItemArr || [];

    // // this.animaArr = this.item.animaArr || [];
    // this.picArr = this.item.picArr || [];

    // // this.refreshAnimaArr();


    if (!this.item.groupArr) {
      this.item.groupArr = [];
    } 

    this.groupArr = [];
    this.curNgIndex = 0;
    this.setAngularArr();
  }

  curNgIndex = 0
  setAngularArr() {

    if (this.item.groupArr.length <= 0) {
      return;
    }
    if (this.item.groupArr[ this.curNgIndex ]) {
      this.groupArr[this.curNgIndex] = this.item.groupArr[ this.curNgIndex ];

      setTimeout(() => {
        this.curNgIndex ++;
        this.setAngularArr();
      },0);
    }

   

  }


  /**
   * 储存图片数据
   * @param e
   */
  onImageUploadSuccess(e, key, it) {


    it[key] = e.url;
    this.save();
  }

  /**
   * 储存音频数据
   * @param e
   */
  onAudioUploadSuccess(e, key, it) {

    it[key] = e.url;
    this.save();
  }

  saveHotZone(group, e) {
    console.log('e: ', e);
    const {bgItem, hotZoneItemArr} = e;
    // this.bgItem = bgItem;
    // this.hotZoneItemArr = hotZoneItemArr;

    group.bgItem = bgItem;
    group.hotZoneItemArr = hotZoneItemArr;

    // this.refreshAnimaArr();

    this.save();

    this.message.create(
      'success',
      '保存成功'
    );
  }

  refreshAnimaArr() {
    const tmpArr = [];
    this.hotZoneItemArr.forEach((item) => {
      let data = this.animaArr.find((anima) => {
        return anima.id === item.id;
      });

      if (!data) {
        data = this.createAnimaData(item);
      }
      tmpArr.push(data);
    });

    this.animaArr = tmpArr;
  }


  createAnimaData(hotZoneItem) {

    const animaData = {};
    animaData['id'] = hotZoneItem.id;
    return animaData;
  }


  addPic(group) {
    if (!group.picArr) {
      group.picArr = [];
    }
    group.picArr.push({
      pic_url: '',
      audio_url: '',
      isRight: '0'
    });

    // this.item.picArr = this.picArr;
    this.save();
  }

  deletePic(group, i) {
    group.picArr.splice(i, 1);
    // this.item.picArr = this.picArr;
    this.save();
  }


  addGroup() {
    this.item.groupArr.push({
      bgItem: {},
      hotZoneItemArr: [],
      picArr: [],
      skeJsonData: {},
      texJsonData: {},
      texPngData: {},
    });

    this.groupArr = this.item.groupArr;
    this.save();
  }

  deleteGroup(i) {
    this.item.groupArr.splice(i, 1);
    this.groupArr = this.item.groupArr;
    this.save();
  }

  saveAnima(e, group) {
    console.log('e:', e);
    group.skeJsonData = e.skeJsonData;
    group.texJsonData = e.texJsonData;
    group.texPngData = e.texPngData;
    this.save();
  }


  /**
   * 储存数据
   */
  save() {

    console.log('this.item: ', this.item);
    console.log('this.item JSON: ', JSON.stringify(this.item));
    (<any> window).courseware.setData(this.item, null, this.saveKey);
    this.refresh();
  }

  /**
   * 刷新 渲染页面
   */
  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

