const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    index: number;
    @property(cc.Node)
    chooseNode: cc.Node;
    @property(cc.Node)
    error: cc.Node;
    @property(cc.Node)
    correct: cc.Node;

    onLoad () {}

    init (index: number) {
        this.index = index;

        this.chooseNode.opacity = 0;
        this.error.active = false;
        this.correct.active = false;
    }

    updateChooseView(lv: number){
        if(this.index + 1 == lv){
            cc.tween(this.chooseNode)
                .to(0.3, { opacity: 255 })
                .start()
        }
    }

    updateEndView(isError: boolean){
        this.error.active = isError;
        this.correct.active = !isError;
        this.chooseNode.opacity = 0;
    }

    // update (dt) {}
}
