/**
 * Copyright (c) 2014-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

 cc.sys.capabilities["touches"] = true;

 !(function (global) {
   "use strict";
 
   var Op = Object.prototype;
   var hasOwn = Op.hasOwnProperty;
   var undefined; // More compressible than void 0.
   var $Symbol = typeof Symbol === "function" ? Symbol : {};
   var iteratorSymbol = $Symbol.iterator || "@@iterator";
   var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
   var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
 
   var inModule = typeof module === "object";
   var runtime = global.regeneratorRuntime;
   if (runtime) {
     if (inModule) {
       // If regeneratorRuntime is defined globally and we're in a module,
       // make the exports object identical to regeneratorRuntime.
       module.exports = runtime;
     }
     // Don't bother evaluating the rest of this file if the runtime was
     // already defined globally.
     return;
   }
 
   // Define the runtime globally (as expected by generated code) as either
   // module.exports (if we're in a module) or a new, empty object.
   runtime = global.regeneratorRuntime = inModule ? module.exports : {};
 
   function wrap(innerFn, outerFn, self, tryLocsList) {
     // If outerFn provided and outerFn.prototype is a Generator, then outerFn.prototype instanceof Generator.
     var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
     var generator = Object.create(protoGenerator.prototype);
     var context = new Context(tryLocsList || []);
 
     // The ._invoke method unifies the implementations of the .next,
     // .throw, and .return methods.
     generator._invoke = makeInvokeMethod(innerFn, self, context);
 
     return generator;
   }
   runtime.wrap = wrap;
 
   // Try/catch helper to minimize deoptimizations. Returns a completion
   // record like context.tryEntries[i].completion. This interface could
   // have been (and was previously) designed to take a closure to be
   // invoked without arguments, but in all the cases we care about we
   // already have an existing method we want to call, so there's no need
   // to create a new function object. We can even get away with assuming
   // the method takes exactly one argument, since that happens to be true
   // in every case, so we don't have to touch the arguments object. The
   // only additional allocation required is the completion record, which
   // has a stable shape and so hopefully should be cheap to allocate.
   function tryCatch(fn, obj, arg) {
     try {
       return { type: "normal", arg: fn.call(obj, arg) };
     } catch (err) {
       return { type: "throw", arg: err };
     }
   }
 
   var GenStateSuspendedStart = "suspendedStart";
   var GenStateSuspendedYield = "suspendedYield";
   var GenStateExecuting = "executing";
   var GenStateCompleted = "completed";
 
   // Returning this object from the innerFn has the same effect as
   // breaking out of the dispatch switch statement.
   var ContinueSentinel = {};
 
   // Dummy constructor functions that we use as the .constructor and
   // .constructor.prototype properties for functions that return Generator
   // objects. For full spec compliance, you may wish to configure your
   // minifier not to mangle the names of these two functions.
   function Generator() { }
   function GeneratorFunction() { }
   function GeneratorFunctionPrototype() { }
 
   // This is a polyfill for %IteratorPrototype% for environments that
   // don't natively support it.
   var IteratorPrototype = {};
   IteratorPrototype[iteratorSymbol] = function () {
     return this;
   };
 
   var getProto = Object.getPrototypeOf;
   var NativeIteratorPrototype = getProto && getProto(getProto(values([])));
   if (NativeIteratorPrototype &&
     NativeIteratorPrototype !== Op &&
     hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
     // This environment has a native %IteratorPrototype%; use it instead
     // of the polyfill.
     IteratorPrototype = NativeIteratorPrototype;
   }
 
   var Gp = GeneratorFunctionPrototype.prototype =
     Generator.prototype = Object.create(IteratorPrototype);
   GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
   GeneratorFunctionPrototype.constructor = GeneratorFunction;
   GeneratorFunctionPrototype[toStringTagSymbol] =
     GeneratorFunction.displayName = "GeneratorFunction";
 
   // Helper for defining the .next, .throw, and .return methods of the
   // Iterator interface in terms of a single ._invoke method.
   function defineIteratorMethods(prototype) {
     ["next", "throw", "return"].forEach(function (method) {
       prototype[method] = function (arg) {
         return this._invoke(method, arg);
       };
     });
   }
 
   runtime.isGeneratorFunction = function (genFun) {
     var ctor = typeof genFun === "function" && genFun.constructor;
     return ctor
       ? ctor === GeneratorFunction ||
       // For the native GeneratorFunction constructor, the best we can
       // do is to check its .name property.
       (ctor.displayName || ctor.name) === "GeneratorFunction"
       : false;
   };
 
   runtime.mark = function (genFun) {
     if (Object.setPrototypeOf) {
       Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
     } else {
       genFun.__proto__ = GeneratorFunctionPrototype;
       if (!(toStringTagSymbol in genFun)) {
         genFun[toStringTagSymbol] = "GeneratorFunction";
       }
     }
     genFun.prototype = Object.create(Gp);
     return genFun;
   };
 
   // Within the body of any async function, `await x` is transformed to
   // `yield regeneratorRuntime.awrap(x)`, so that the runtime can test
   // `hasOwn.call(value, "__await")` to determine if the yielded value is
   // meant to be awaited.
   runtime.awrap = function (arg) {
     return { __await: arg };
   };
 
   function AsyncIterator(generator) {
     function invoke(method, arg, resolve, reject) {
       var record = tryCatch(generator[method], generator, arg);
       if (record.type === "throw") {
         reject(record.arg);
       } else {
         var result = record.arg;
         var value = result.value;
         if (value &&
           typeof value === "object" &&
           hasOwn.call(value, "__await")) {
           return Promise.resolve(value.__await).then(function (value) {
             invoke("next", value, resolve, reject);
           }, function (err) {
             invoke("throw", err, resolve, reject);
           });
         }
 
         return Promise.resolve(value).then(function (unwrapped) {
           // When a yielded Promise is resolved, its final value becomes
           // the .value of the Promise<{value,done}> result for the
           // current iteration. If the Promise is rejected, however, the
           // result for this iteration will be rejected with the same
           // reason. Note that rejections of yielded Promises are not
           // thrown back into the generator function, as is the case
           // when an awaited Promise is rejected. This difference in
           // behavior between yield and await is important, because it
           // allows the consumer to decide what to do with the yielded
           // rejection (swallow it and continue, manually .throw it back
           // into the generator, abandon iteration, whatever). With
           // await, by contrast, there is no opportunity to examine the
           // rejection reason outside the generator function, so the
           // only option is to throw it from the await expression, and
           // let the generator function handle the exception.
           result.value = unwrapped;
           resolve(result);
         }, reject);
       }
     }
 
     var previousPromise;
 
     function enqueue(method, arg) {
       function callInvokeWithMethodAndArg() {
         return new Promise(function (resolve, reject) {
           invoke(method, arg, resolve, reject);
         });
       }
 
       return previousPromise =
         // If enqueue has been called before, then we want to wait until
         // all previous Promises have been resolved before calling invoke,
         // so that results are always delivered in the correct order. If
         // enqueue has not been called before, then it is important to
         // call invoke immediately, without waiting on a callback to fire,
         // so that the async generator function has the opportunity to do
         // any necessary setup in a predictable way. This predictability
         // is why the Promise constructor synchronously invokes its
         // executor callback, and why async functions synchronously
         // execute code before the first await. Since we implement simple
         // async functions in terms of async generators, it is especially
         // important to get this right, even though it requires care.
         previousPromise ? previousPromise.then(
           callInvokeWithMethodAndArg,
           // Avoid propagating failures to Promises returned by later
           // invocations of the iterator.
           callInvokeWithMethodAndArg
         ) : callInvokeWithMethodAndArg();
     }
 
     // Define the unified helper method that is used to implement .next,
     // .throw, and .return (see defineIteratorMethods).
     this._invoke = enqueue;
   }
 
   defineIteratorMethods(AsyncIterator.prototype);
   AsyncIterator.prototype[asyncIteratorSymbol] = function () {
     return this;
   };
   runtime.AsyncIterator = AsyncIterator;
 
   // Note that simple async functions are implemented on top of
   // AsyncIterator objects; they just return a Promise for the value of
   // the final result produced by the iterator.
   runtime.async = function (innerFn, outerFn, self, tryLocsList) {
     var iter = new AsyncIterator(
       wrap(innerFn, outerFn, self, tryLocsList)
     );
 
     return runtime.isGeneratorFunction(outerFn)
       ? iter // If outerFn is a generator, return the full iterator.
       : iter.next().then(function (result) {
         return result.done ? result.value : iter.next();
       });
   };
 
   function makeInvokeMethod(innerFn, self, context) {
     var state = GenStateSuspendedStart;
 
     return function invoke(method, arg) {
       if (state === GenStateExecuting) {
         throw new Error("Generator is already running");
       }
 
       if (state === GenStateCompleted) {
         if (method === "throw") {
           throw arg;
         }
 
         // Be forgiving, per 25.3.3.3.3 of the spec:
         // https://people.mozilla.org/~jorendorff/es6-draft.html#sec-generatorresume
         return doneResult();
       }
 
       context.method = method;
       context.arg = arg;
 
       while (true) {
         var delegate = context.delegate;
         if (delegate) {
           var delegateResult = maybeInvokeDelegate(delegate, context);
           if (delegateResult) {
             if (delegateResult === ContinueSentinel) continue;
             return delegateResult;
           }
         }
 
         if (context.method === "next") {
           // Setting context._sent for legacy support of Babel's
           // function.sent implementation.
           context.sent = context._sent = context.arg;
 
         } else if (context.method === "throw") {
           if (state === GenStateSuspendedStart) {
             state = GenStateCompleted;
             throw context.arg;
           }
 
           context.dispatchException(context.arg);
 
         } else if (context.method === "return") {
           context.abrupt("return", context.arg);
         }
 
         state = GenStateExecuting;
 
         var record = tryCatch(innerFn, self, context);
         if (record.type === "normal") {
           // If an exception is thrown from innerFn, we leave state ===
           // GenStateExecuting and loop back for another invocation.
           state = context.done
             ? GenStateCompleted
             : GenStateSuspendedYield;
 
           if (record.arg === ContinueSentinel) {
             continue;
           }
 
           return {
             value: record.arg,
             done: context.done
           };
 
         } else if (record.type === "throw") {
           state = GenStateCompleted;
           // Dispatch the exception by looping back around to the
           // context.dispatchException(context.arg) call above.
           context.method = "throw";
           context.arg = record.arg;
         }
       }
     };
   }
 
   // Call delegate.iterator[context.method](context.arg) and handle the
   // result, either by returning a { value, done } result from the
   // delegate iterator, or by modifying context.method and context.arg,
   // setting context.delegate to null, and returning the ContinueSentinel.
   function maybeInvokeDelegate(delegate, context) {
     var method = delegate.iterator[context.method];
     if (method === undefined) {
       // A .throw or .return when the delegate iterator has no .throw
       // method always terminates the yield* loop.
       context.delegate = null;
 
       if (context.method === "throw") {
         if (delegate.iterator.return) {
           // If the delegate iterator has a return method, give it a
           // chance to clean up.
           context.method = "return";
           context.arg = undefined;
           maybeInvokeDelegate(delegate, context);
 
           if (context.method === "throw") {
             // If maybeInvokeDelegate(context) changed context.method from
             // "return" to "throw", let that override the TypeError below.
             return ContinueSentinel;
           }
         }
 
         context.method = "throw";
         context.arg = new TypeError(
           "The iterator does not provide a 'throw' method");
       }
 
       return ContinueSentinel;
     }
 
     var record = tryCatch(method, delegate.iterator, context.arg);
 
     if (record.type === "throw") {
       context.method = "throw";
       context.arg = record.arg;
       context.delegate = null;
       return ContinueSentinel;
     }
 
     var info = record.arg;
 
     if (!info) {
       context.method = "throw";
       context.arg = new TypeError("iterator result is not an object");
       context.delegate = null;
       return ContinueSentinel;
     }
 
     if (info.done) {
       // Assign the result of the finished delegate to the temporary
       // variable specified by delegate.resultName (see delegateYield).
       context[delegate.resultName] = info.value;
 
       // Resume execution at the desired location (see delegateYield).
       context.next = delegate.nextLoc;
 
       // If context.method was "throw" but the delegate handled the
       // exception, let the outer generator proceed normally. If
       // context.method was "next", forget context.arg since it has been
       // "consumed" by the delegate iterator. If context.method was
       // "return", allow the original .return call to continue in the
       // outer generator.
       if (context.method !== "return") {
         context.method = "next";
         context.arg = undefined;
       }
 
     } else {
       // Re-yield the result returned by the delegate method.
       return info;
     }
 
     // The delegate iterator is finished, so forget it and continue with
     // the outer generator.
     context.delegate = null;
     return ContinueSentinel;
   }
 
   // Define Generator.prototype.{next,throw,return} in terms of the
   // unified ._invoke helper method.
   defineIteratorMethods(Gp);
 
   Gp[toStringTagSymbol] = "Generator";
 
   // A Generator should always return itself as the iterator object when the
   // @@iterator function is called on it. Some browsers' implementations of the
   // iterator prototype chain incorrectly implement this, causing the Generator
   // object to not be returned from this call. This ensures that doesn't happen.
   // See https://github.com/facebook/regenerator/issues/274 for more details.
   Gp[iteratorSymbol] = function () {
     return this;
   };
 
   Gp.toString = function () {
     return "[object Generator]";
   };
 
   function pushTryEntry(locs) {
     var entry = { tryLoc: locs[0] };
 
     if (1 in locs) {
       entry.catchLoc = locs[1];
     }
 
     if (2 in locs) {
       entry.finallyLoc = locs[2];
       entry.afterLoc = locs[3];
     }
 
     this.tryEntries.push(entry);
   }
 
   function resetTryEntry(entry) {
     var record = entry.completion || {};
     record.type = "normal";
     delete record.arg;
     entry.completion = record;
   }
 
   function Context(tryLocsList) {
     // The root entry object (effectively a try statement without a catch
     // or a finally block) gives us a place to store values thrown from
     // locations where there is no enclosing try statement.
     this.tryEntries = [{ tryLoc: "root" }];
     tryLocsList.forEach(pushTryEntry, this);
     this.reset(true);
   }
 
   runtime.keys = function (object) {
     var keys = [];
     for (var key in object) {
       keys.push(key);
     }
     keys.reverse();
 
     // Rather than returning an object with a next method, we keep
     // things simple and return the next function itself.
     return function next() {
       while (keys.length) {
         var key = keys.pop();
         if (key in object) {
           next.value = key;
           next.done = false;
           return next;
         }
       }
 
       // To avoid creating an additional object, we just hang the .value
       // and .done properties off the next function object itself. This
       // also ensures that the minifier will not anonymize the function.
       next.done = true;
       return next;
     };
   };
 
   function values(iterable) {
     if (iterable) {
       var iteratorMethod = iterable[iteratorSymbol];
       if (iteratorMethod) {
         return iteratorMethod.call(iterable);
       }
 
       if (typeof iterable.next === "function") {
         return iterable;
       }
 
       if (!isNaN(iterable.length)) {
         var i = -1, next = function next() {
           while (++i < iterable.length) {
             if (hasOwn.call(iterable, i)) {
               next.value = iterable[i];
               next.done = false;
               return next;
             }
           }
 
           next.value = undefined;
           next.done = true;
 
           return next;
         };
 
         return next.next = next;
       }
     }
 
     // Return an iterator with no values.
     return { next: doneResult };
   }
   runtime.values = values;
 
   function doneResult() {
     return { value: undefined, done: true };
   }
 
   Context.prototype = {
     constructor: Context,
 
     reset: function (skipTempReset) {
       this.prev = 0;
       this.next = 0;
       // Resetting context._sent for legacy support of Babel's
       // function.sent implementation.
       this.sent = this._sent = undefined;
       this.done = false;
       this.delegate = null;
 
       this.method = "next";
       this.arg = undefined;
 
       this.tryEntries.forEach(resetTryEntry);
 
       if (!skipTempReset) {
         for (var name in this) {
           // Not sure about the optimal order of these conditions:
           if (name.charAt(0) === "t" &&
             hasOwn.call(this, name) &&
             !isNaN(+name.slice(1))) {
             this[name] = undefined;
           }
         }
       }
     },
 
     stop: function () {
       this.done = true;
 
       var rootEntry = this.tryEntries[0];
       var rootRecord = rootEntry.completion;
       if (rootRecord.type === "throw") {
         throw rootRecord.arg;
       }
 
       return this.rval;
     },
 
     dispatchException: function (exception) {
       if (this.done) {
         throw exception;
       }
 
       var context = this;
       function handle(loc, caught) {
         record.type = "throw";
         record.arg = exception;
         context.next = loc;
 
         if (caught) {
           // If the dispatched exception was caught by a catch block,
           // then let that catch block handle the exception normally.
           context.method = "next";
           context.arg = undefined;
         }
 
         return !!caught;
       }
 
       for (var i = this.tryEntries.length - 1; i >= 0; --i) {
         var entry = this.tryEntries[i];
         var record = entry.completion;
 
         if (entry.tryLoc === "root") {
           // Exception thrown outside of any try block that could handle
           // it, so set the completion value of the entire function to
           // throw the exception.
           return handle("end");
         }
 
         if (entry.tryLoc <= this.prev) {
           var hasCatch = hasOwn.call(entry, "catchLoc");
           var hasFinally = hasOwn.call(entry, "finallyLoc");
 
           if (hasCatch && hasFinally) {
             if (this.prev < entry.catchLoc) {
               return handle(entry.catchLoc, true);
             } else if (this.prev < entry.finallyLoc) {
               return handle(entry.finallyLoc);
             }
 
           } else if (hasCatch) {
             if (this.prev < entry.catchLoc) {
               return handle(entry.catchLoc, true);
             }
 
           } else if (hasFinally) {
             if (this.prev < entry.finallyLoc) {
               return handle(entry.finallyLoc);
             }
 
           } else {
             throw new Error("try statement without catch or finally");
           }
         }
       }
     },
 
     abrupt: function (type, arg) {
       for (var i = this.tryEntries.length - 1; i >= 0; --i) {
         var entry = this.tryEntries[i];
         if (entry.tryLoc <= this.prev &&
           hasOwn.call(entry, "finallyLoc") &&
           this.prev < entry.finallyLoc) {
           var finallyEntry = entry;
           break;
         }
       }
 
       if (finallyEntry &&
         (type === "break" ||
           type === "continue") &&
         finallyEntry.tryLoc <= arg &&
         arg <= finallyEntry.finallyLoc) {
         // Ignore the finally entry if control is not jumping to a
         // location outside the try/catch block.
         finallyEntry = null;
       }
 
       var record = finallyEntry ? finallyEntry.completion : {};
       record.type = type;
       record.arg = arg;
 
       if (finallyEntry) {
         this.method = "next";
         this.next = finallyEntry.finallyLoc;
         return ContinueSentinel;
       }
 
       return this.complete(record);
     },
 
     complete: function (record, afterLoc) {
       if (record.type === "throw") {
         throw record.arg;
       }
 
       if (record.type === "break" ||
         record.type === "continue") {
         this.next = record.arg;
       } else if (record.type === "return") {
         this.rval = this.arg = record.arg;
         this.method = "return";
         this.next = "end";
       } else if (record.type === "normal" && afterLoc) {
         this.next = afterLoc;
       }
 
       return ContinueSentinel;
     },
 
     finish: function (finallyLoc) {
       for (var i = this.tryEntries.length - 1; i >= 0; --i) {
         var entry = this.tryEntries[i];
         if (entry.finallyLoc === finallyLoc) {
           this.complete(entry.completion, entry.afterLoc);
           resetTryEntry(entry);
           return ContinueSentinel;
         }
       }
     },
 
     "catch": function (tryLoc) {
       for (var i = this.tryEntries.length - 1; i >= 0; --i) {
         var entry = this.tryEntries[i];
         if (entry.tryLoc === tryLoc) {
           var record = entry.completion;
           if (record.type === "throw") {
             var thrown = record.arg;
             resetTryEntry(entry);
           }
           return thrown;
         }
       }
 
       // The context.catch method must only be called with a location
       // argument that corresponds to a known catch block.
       throw new Error("illegal catch attempt");
     },
 
     delegateYield: function (iterable, resultName, nextLoc) {
       this.delegate = {
         iterator: values(iterable),
         resultName: resultName,
         nextLoc: nextLoc
       };
 
       if (this.method === "next") {
         // Deliberately forget the last sent value so that we don't
         // accidentally pass it on to the delegate.
         this.arg = undefined;
       }
 
       return ContinueSentinel;
     }
   };
 })(
   // In sloppy mode, unbound `this` refers to the global object, fallback to
   // Function constructor if we're in global strict mode. That is sadly a form
   // of indirect eval which violates Content Security Policy.
   (function () { return this })() || Function("return this")()
 );
 




/*gobe_v1.1.5*/
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).GOBE={})}(this,(function(exports){"use strict";class EventEmitter{constructor(){this.handlers=[]}on(e){return this.handlers.push(e),this}emit(...e){this.handlers.forEach((t=>t.apply(this,e)))}off(e){const t=this.handlers.indexOf(e);this.handlers[t]=this.handlers[this.handlers.length-1],this.handlers.pop()}clear(){this.handlers=[]}}function createSignal(){const e=new EventEmitter;function t(t){return e.on(t)}return t.emit=(...t)=>e.emit(...t),t.off=t=>e.off(t),t.clear=()=>e.clear(),t}class Store{constructor(){this.stateEmitter=new EventEmitter,this.serverEventEmitter=new EventEmitter,this._state={state:0,openId:"",appId:"",serviceToken:"",playerId:"",lastRoomId:"",roomId:"",groupId:""},this._serverEventCode=0}get state(){return this._state.state}get serverEventCode(){return this._serverEventCode}get appId(){return this._state.appId}get serviceToken(){return this._state.serviceToken}get playerId(){return this._state.playerId}get lastRoomId(){return this._state.lastRoomId}get roomId(){return this._state.roomId}get groupId(){return this._state.groupId}get openId(){return this._state.openId}setStateAction(e){if(e==this._state.state)return;const t=this._state.state;this._state.state=e,this.stateEmitter.emit(e,t)}setServerEventAction(e,t){const r={eventType:this._serverEventCode,eventParam:t};this._serverEventCode=e;const o={eventType:e,eventParam:t};this.serverEventEmitter.emit(o,r)}setAppIdAction(e){this._state.appId=e}setOpenIdAction(e){this._state.openId=e}setServiceTokenAction(e){this._state.serviceToken=e}setPlayerIdAction(e){this._state.playerId=e}setLastRoomIdAction(e){this._state.lastRoomId=e}setRoomIdAction(e){this._state.roomId=e}setGroupIdAction(e){this._state.groupId=e}addStateListener(e){this.stateEmitter.on(e)}addServerEventListener(e){this.serverEventEmitter.on(e)}}var store=new Store;class Base{get state(){return store.state}get serverEventCode(){return store.serverEventCode}get appId(){return store.appId}get openId(){return store.openId}get serviceToken(){return store.serviceToken}get playerId(){return store.playerId}get lastRoomId(){return store.lastRoomId}get roomId(){return store.roomId}get groupId(){return store.groupId}constructor(){store.addStateListener(((...e)=>this.onStateChange(...e))),store.addServerEventListener(((...e)=>this.onServerEventChange(...e)))}setState(e){store.setStateAction(e)}setServerEvent(e,t=""){store.setServerEventAction(e,t)}setAppId(e){store.setAppIdAction(e)}setOpenId(e){store.setOpenIdAction(e)}setServiceToken(e){store.setServiceTokenAction(e)}setPlayerId(e){store.setPlayerIdAction(e)}setLastRoomId(e){store.setLastRoomIdAction(e)}setRoomId(e){store.setRoomIdAction(e)}setGroupId(e){store.setGroupIdAction(e)}onStateChange(e,t){}onServerEventChange(e,t){}}function __awaiter(e,t,r,o){return new(r||(r=Promise))((function(n,i){function s(e){try{u(o.next(e))}catch(e){i(e)}}function a(e){try{u(o.throw(e))}catch(e){i(e)}}function u(e){var t;e.done?n(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t)}))).then(s,a)}u((o=o.apply(e,t||[])).next())}))}class GOBEError extends Error{constructor(e,t){super(t),this.code=e,this.name="GOBE Error",Object.setPrototypeOf(this,new.target.prototype)}}const generateRequestId=()=>{var e;if("function"==typeof(null===(e=globalThis.crypto)||void 0===e?void 0:e.getRandomValues)){const e=new Uint32Array(1);return globalThis.crypto.getRandomValues(e)[0].toString()}return Math.random().toString().slice(2)};class Request{static post(e,t,r,o=!0){const n=/^([a-z][a-z\d+\-.]*:)?\/\//i.test(e)?e:"https://gobe-drcn.game.dbankcloud.cn"+e;return new Promise(((i,s)=>{const a=new XMLHttpRequest;a.open("POST",n),a.setRequestHeader("Content-Type","application/json"),a.withCredentials=!1,a.timeout=Request.timeout;e.includes("gamex-edge-service")&&(a.setRequestHeader("sdkVersionCode","10105200"),a.setRequestHeader("serviceToken",store.serviceToken),a.setRequestHeader("appId",store.appId),a.setRequestHeader("requestId",generateRequestId())),r&&Object.entries(r).forEach((([e,t])=>a.setRequestHeader(e,t))),a.send(JSON.stringify(t)),a.onerror=function(e){s(e)},a.ontimeout=function(e){s(e)},a.onreadystatechange=function(){if(4==a.readyState)if(200==a.status){const e=JSON.parse(a.responseText);o&&0!=e.rtnCode&&s(new GOBEError(e.rtnCode,e.msg)),i(e)}else s({data:a.responseText,status:a.status,statusText:a.statusText,headers:a.getAllResponseHeaders(),request:a})}}))}}Request.timeout=5e3;class Auth extends Base{constructor(e,t,r){super(),this.clientId=e,this.clientSecret=t,this.createSignature=r}requestAccessToken(){return __awaiter(this,void 0,void 0,(function*(){const e=yield Request.post("https://connect-drcn.hispace.hicloud.com/agc/apigw/oauth2/v1/token",{grant_type:"client_credentials",client_id:this.clientId,client_secret:this.clientSecret,useJwt:0},{app_id:this.appId},!1);if("ret"in e)throw new Error(e.ret.msg);return e.access_token}))}requestServiceToken(e,t){return __awaiter(this,void 0,void 0,(function*(){return yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.player.login",cpAccessToken:e,clientId:this.clientId,openId:this.openId},t))}))}requestGameConfig(){return __awaiter(this,void 0,void 0,(function*(){return yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.config.param"})}))}login(){return __awaiter(this,void 0,void 0,(function*(){const e=yield this.requestAccessToken(),t=this.createSignature?yield this.createSignature():void 0,{serviceToken:r,playerId:o,lastRoomId:n,timeStamp:i}=yield this.requestServiceToken(e,t);this.setState(1),this.setServiceToken(r),this.setPlayerId(o),this.setLastRoomId(n);return{gameInfo:(yield this.requestGameConfig()).configParam,timeStamp:i}}))}}class Player extends Base{constructor(e,t){super(),this.customStatus=e,this.customProperties=t}updateCustomStatus(e){return __awaiter(this,void 0,void 0,(function*(){return yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.custom.player.status.update",customPlayerStatus:e}),this.customStatus=e,this}))}}class WebSocketTransport{constructor(e){this.events=e,this.ws=null}connect(e){var t,r,o,n;this.ws=new WebSocket(e,this.protocols),this.ws.binaryType="arraybuffer",this.ws.onopen=null!==(t=this.events.onopen)&&void 0!==t?t:null,this.ws.onmessage=null!==(r=this.events.onmessage)&&void 0!==r?r:null,this.ws.onclose=null!==(o=this.events.onclose)&&void 0!==o?o:null,this.ws.onerror=null!==(n=this.events.onerror)&&void 0!==n?n:null}send(e){var t,r;e instanceof ArrayBuffer?null===(t=this.ws)||void 0===t||t.send(e):null===(r=this.ws)||void 0===r||r.send(new Uint8Array(e).buffer)}close(e,t){var r;null===(r=this.ws)||void 0===r||r.close(e,t)}}class Connection{constructor(e=WebSocketTransport){this.events={},this.transport=new e(this.events)}connect(e){this.transport.connect(e)}send(e){this.transport.send(e)}close(e,t){this.transport.close(e,t)}}class Heartbeat extends Base{constructor(){super()}schedule(){this.execute()}execute(){[1,2,3].includes(this.state)?this.send().finally((()=>{this.delay(this.execute,4e3)})):this.delay(this.execute,5e3)}delay(e,t){setTimeout(e.bind(this),t)}send(e=this.state,t=this.roomId){return Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.event.notify",eventType:e,roomId:t}).then((e=>{if(e.events)for(const t of e.events)this.setServerEvent(t.eventType,t.eventParam)}))}}var heartbeat=new Heartbeat,commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{},protobuf={exports:{}};(function(module){(function(undefined$1){!function(e,t,r){var o=function r(o){var n=t[o];return n||e[o][0].call(n=t[o]={exports:{}},r,n,n.exports),n.exports}(r[0]);o.util.global.protobuf=o,"function"==typeof undefined$1&&undefined$1.amd&&undefined$1(["long"],(function(e){return e&&e.isLong&&(o.util.Long=e,o.configure()),o})),module&&module.exports&&(module.exports=o)}({1:[function(e,t,r){t.exports=function(e,t){var r=new Array(arguments.length-1),o=0,n=2,i=!0;for(;n<arguments.length;)r[o++]=arguments[n++];return new Promise((function(n,s){r[o]=function(e){if(i)if(i=!1,e)s(e);else{for(var t=new Array(arguments.length-1),r=0;r<t.length;)t[r++]=arguments[r];n.apply(null,t)}};try{e.apply(t||null,r)}catch(e){i&&(i=!1,s(e))}}))}},{}],2:[function(e,t,r){var o=r;o.length=function(e){var t=e.length;if(!t)return 0;for(var r=0;--t%4>1&&"="===e.charAt(t);)++r;return Math.ceil(3*e.length)/4-r};for(var n=new Array(64),i=new Array(123),s=0;s<64;)i[n[s]=s<26?s+65:s<52?s+71:s<62?s-4:s-59|43]=s++;o.encode=function(e,t,r){for(var o,i=null,s=[],a=0,u=0;t<r;){var c=e[t++];switch(u){case 0:s[a++]=n[c>>2],o=(3&c)<<4,u=1;break;case 1:s[a++]=n[o|c>>4],o=(15&c)<<2,u=2;break;case 2:s[a++]=n[o|c>>6],s[a++]=n[63&c],u=0}a>8191&&((i||(i=[])).push(String.fromCharCode.apply(String,s)),a=0)}return u&&(s[a++]=n[o],s[a++]=61,1===u&&(s[a++]=61)),i?(a&&i.push(String.fromCharCode.apply(String,s.slice(0,a))),i.join("")):String.fromCharCode.apply(String,s.slice(0,a))};var a="invalid encoding";o.decode=function(e,t,r){for(var o,n=r,s=0,u=0;u<e.length;){var c=e.charCodeAt(u++);if(61===c&&s>1)break;if((c=i[c])===undefined$1)throw Error(a);switch(s){case 0:o=c,s=1;break;case 1:t[r++]=o<<2|(48&c)>>4,o=c,s=2;break;case 2:t[r++]=(15&o)<<4|(60&c)>>2,o=c,s=3;break;case 3:t[r++]=(3&o)<<6|c,s=0}}if(1===s)throw Error(a);return r-n},o.test=function(e){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(e)}},{}],3:[function(e,t,r){function o(){this._listeners={}}t.exports=o,o.prototype.on=function(e,t,r){return(this._listeners[e]||(this._listeners[e]=[])).push({fn:t,ctx:r||this}),this},o.prototype.off=function(e,t){if(e===undefined$1)this._listeners={};else if(t===undefined$1)this._listeners[e]=[];else for(var r=this._listeners[e],o=0;o<r.length;)r[o].fn===t?r.splice(o,1):++o;return this},o.prototype.emit=function(e){var t=this._listeners[e];if(t){for(var r=[],o=1;o<arguments.length;)r.push(arguments[o++]);for(o=0;o<t.length;)t[o].fn.apply(t[o++].ctx,r)}return this}},{}],4:[function(e,t,r){function o(e){return"undefined"!=typeof Float32Array?function(){var t=new Float32Array([-0]),r=new Uint8Array(t.buffer),o=128===r[3];function n(e,o,n){t[0]=e,o[n]=r[0],o[n+1]=r[1],o[n+2]=r[2],o[n+3]=r[3]}function i(e,o,n){t[0]=e,o[n]=r[3],o[n+1]=r[2],o[n+2]=r[1],o[n+3]=r[0]}function s(e,o){return r[0]=e[o],r[1]=e[o+1],r[2]=e[o+2],r[3]=e[o+3],t[0]}function a(e,o){return r[3]=e[o],r[2]=e[o+1],r[1]=e[o+2],r[0]=e[o+3],t[0]}e.writeFloatLE=o?n:i,e.writeFloatBE=o?i:n,e.readFloatLE=o?s:a,e.readFloatBE=o?a:s}():function(){function t(e,t,r,o){var n=t<0?1:0;if(n&&(t=-t),0===t)e(1/t>0?0:2147483648,r,o);else if(isNaN(t))e(2143289344,r,o);else if(t>34028234663852886e22)e((n<<31|2139095040)>>>0,r,o);else if(t<11754943508222875e-54)e((n<<31|Math.round(t/1401298464324817e-60))>>>0,r,o);else{var i=Math.floor(Math.log(t)/Math.LN2);e((n<<31|i+127<<23|8388607&Math.round(t*Math.pow(2,-i)*8388608))>>>0,r,o)}}function r(e,t,r){var o=e(t,r),n=2*(o>>31)+1,i=o>>>23&255,s=8388607&o;return 255===i?s?NaN:n*(1/0):0===i?1401298464324817e-60*n*s:n*Math.pow(2,i-150)*(s+8388608)}e.writeFloatLE=t.bind(null,n),e.writeFloatBE=t.bind(null,i),e.readFloatLE=r.bind(null,s),e.readFloatBE=r.bind(null,a)}(),"undefined"!=typeof Float64Array?function(){var t=new Float64Array([-0]),r=new Uint8Array(t.buffer),o=128===r[7];function n(e,o,n){t[0]=e,o[n]=r[0],o[n+1]=r[1],o[n+2]=r[2],o[n+3]=r[3],o[n+4]=r[4],o[n+5]=r[5],o[n+6]=r[6],o[n+7]=r[7]}function i(e,o,n){t[0]=e,o[n]=r[7],o[n+1]=r[6],o[n+2]=r[5],o[n+3]=r[4],o[n+4]=r[3],o[n+5]=r[2],o[n+6]=r[1],o[n+7]=r[0]}function s(e,o){return r[0]=e[o],r[1]=e[o+1],r[2]=e[o+2],r[3]=e[o+3],r[4]=e[o+4],r[5]=e[o+5],r[6]=e[o+6],r[7]=e[o+7],t[0]}function a(e,o){return r[7]=e[o],r[6]=e[o+1],r[5]=e[o+2],r[4]=e[o+3],r[3]=e[o+4],r[2]=e[o+5],r[1]=e[o+6],r[0]=e[o+7],t[0]}e.writeDoubleLE=o?n:i,e.writeDoubleBE=o?i:n,e.readDoubleLE=o?s:a,e.readDoubleBE=o?a:s}():function(){function t(e,t,r,o,n,i){var s=o<0?1:0;if(s&&(o=-o),0===o)e(0,n,i+t),e(1/o>0?0:2147483648,n,i+r);else if(isNaN(o))e(0,n,i+t),e(2146959360,n,i+r);else if(o>17976931348623157e292)e(0,n,i+t),e((s<<31|2146435072)>>>0,n,i+r);else{var a;if(o<22250738585072014e-324)e((a=o/5e-324)>>>0,n,i+t),e((s<<31|a/4294967296)>>>0,n,i+r);else{var u=Math.floor(Math.log(o)/Math.LN2);1024===u&&(u=1023),e(4503599627370496*(a=o*Math.pow(2,-u))>>>0,n,i+t),e((s<<31|u+1023<<20|1048576*a&1048575)>>>0,n,i+r)}}}function r(e,t,r,o,n){var i=e(o,n+t),s=e(o,n+r),a=2*(s>>31)+1,u=s>>>20&2047,c=4294967296*(1048575&s)+i;return 2047===u?c?NaN:a*(1/0):0===u?5e-324*a*c:a*Math.pow(2,u-1075)*(c+4503599627370496)}e.writeDoubleLE=t.bind(null,n,0,4),e.writeDoubleBE=t.bind(null,i,4,0),e.readDoubleLE=r.bind(null,s,0,4),e.readDoubleBE=r.bind(null,a,4,0)}(),e}function n(e,t,r){t[r]=255&e,t[r+1]=e>>>8&255,t[r+2]=e>>>16&255,t[r+3]=e>>>24}function i(e,t,r){t[r]=e>>>24,t[r+1]=e>>>16&255,t[r+2]=e>>>8&255,t[r+3]=255&e}function s(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24)>>>0}function a(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0}t.exports=o(o)},{}],5:[function(require,module,exports){function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}module.exports=inquire},{}],6:[function(e,t,r){t.exports=function(e,t,r){var o=r||8192,n=o>>>1,i=null,s=o;return function(r){if(r<1||r>n)return e(r);s+r>o&&(i=e(o),s=0);var a=t.call(i,s,s+=r);return 7&s&&(s=1+(7|s)),a}}},{}],7:[function(e,t,r){var o=r;o.length=function(e){for(var t=0,r=0,o=0;o<e.length;++o)(r=e.charCodeAt(o))<128?t+=1:r<2048?t+=2:55296==(64512&r)&&56320==(64512&e.charCodeAt(o+1))?(++o,t+=4):t+=3;return t},o.read=function(e,t,r){if(r-t<1)return"";for(var o,n=null,i=[],s=0;t<r;)(o=e[t++])<128?i[s++]=o:o>191&&o<224?i[s++]=(31&o)<<6|63&e[t++]:o>239&&o<365?(o=((7&o)<<18|(63&e[t++])<<12|(63&e[t++])<<6|63&e[t++])-65536,i[s++]=55296+(o>>10),i[s++]=56320+(1023&o)):i[s++]=(15&o)<<12|(63&e[t++])<<6|63&e[t++],s>8191&&((n||(n=[])).push(String.fromCharCode.apply(String,i)),s=0);return n?(s&&n.push(String.fromCharCode.apply(String,i.slice(0,s))),n.join("")):String.fromCharCode.apply(String,i.slice(0,s))},o.write=function(e,t,r){for(var o,n,i=r,s=0;s<e.length;++s)(o=e.charCodeAt(s))<128?t[r++]=o:o<2048?(t[r++]=o>>6|192,t[r++]=63&o|128):55296==(64512&o)&&56320==(64512&(n=e.charCodeAt(s+1)))?(o=65536+((1023&o)<<10)+(1023&n),++s,t[r++]=o>>18|240,t[r++]=o>>12&63|128,t[r++]=o>>6&63|128,t[r++]=63&o|128):(t[r++]=o>>12|224,t[r++]=o>>6&63|128,t[r++]=63&o|128);return r-i}},{}],8:[function(e,t,r){var o=r;function n(){o.util._configure(),o.Writer._configure(o.BufferWriter),o.Reader._configure(o.BufferReader)}o.build="minimal",o.Writer=e(16),o.BufferWriter=e(17),o.Reader=e(9),o.BufferReader=e(10),o.util=e(15),o.rpc=e(12),o.roots=e(11),o.configure=n,n()},{10:10,11:11,12:12,15:15,16:16,17:17,9:9}],9:[function(e,t,r){t.exports=u;var o,n=e(15),i=n.LongBits,s=n.utf8;function a(e,t){return RangeError("index out of range: "+e.pos+" + "+(t||1)+" > "+e.len)}function u(e){this.buf=e,this.pos=0,this.len=e.length}var c,l="undefined"!=typeof Uint8Array?function(e){if(e instanceof Uint8Array||Array.isArray(e))return new u(e);throw Error("illegal buffer")}:function(e){if(Array.isArray(e))return new u(e);throw Error("illegal buffer")},m=function(){return n.Buffer?function(e){return(u.create=function(e){return n.Buffer.isBuffer(e)?new o(e):l(e)})(e)}:l};function h(){var e=new i(0,0),t=0;if(!(this.len-this.pos>4)){for(;t<3;++t){if(this.pos>=this.len)throw a(this);if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e}return e.lo=(e.lo|(127&this.buf[this.pos++])<<7*t)>>>0,e}for(;t<4;++t)if(e.lo=(e.lo|(127&this.buf[this.pos])<<7*t)>>>0,this.buf[this.pos++]<128)return e;if(e.lo=(e.lo|(127&this.buf[this.pos])<<28)>>>0,e.hi=(e.hi|(127&this.buf[this.pos])>>4)>>>0,this.buf[this.pos++]<128)return e;if(t=0,this.len-this.pos>4){for(;t<5;++t)if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}else for(;t<5;++t){if(this.pos>=this.len)throw a(this);if(e.hi=(e.hi|(127&this.buf[this.pos])<<7*t+3)>>>0,this.buf[this.pos++]<128)return e}throw Error("invalid varint encoding")}function d(e,t){return(e[t-4]|e[t-3]<<8|e[t-2]<<16|e[t-1]<<24)>>>0}function f(){if(this.pos+8>this.len)throw a(this,8);return new i(d(this.buf,this.pos+=4),d(this.buf,this.pos+=4))}u.create=m(),u.prototype._slice=n.Array.prototype.subarray||n.Array.prototype.slice,u.prototype.uint32=(c=4294967295,function(){if(c=(127&this.buf[this.pos])>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<7)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<14)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(127&this.buf[this.pos])<<21)>>>0,this.buf[this.pos++]<128)return c;if(c=(c|(15&this.buf[this.pos])<<28)>>>0,this.buf[this.pos++]<128)return c;if((this.pos+=5)>this.len)throw this.pos=this.len,a(this,10);return c}),u.prototype.int32=function(){return 0|this.uint32()},u.prototype.sint32=function(){var e=this.uint32();return e>>>1^-(1&e)|0},u.prototype.bool=function(){return 0!==this.uint32()},u.prototype.fixed32=function(){if(this.pos+4>this.len)throw a(this,4);return d(this.buf,this.pos+=4)},u.prototype.sfixed32=function(){if(this.pos+4>this.len)throw a(this,4);return 0|d(this.buf,this.pos+=4)},u.prototype.float=function(){if(this.pos+4>this.len)throw a(this,4);var e=n.float.readFloatLE(this.buf,this.pos);return this.pos+=4,e},u.prototype.double=function(){if(this.pos+8>this.len)throw a(this,4);var e=n.float.readDoubleLE(this.buf,this.pos);return this.pos+=8,e},u.prototype.bytes=function(){var e=this.uint32(),t=this.pos,r=this.pos+e;if(r>this.len)throw a(this,e);return this.pos+=e,Array.isArray(this.buf)?this.buf.slice(t,r):t===r?new this.buf.constructor(0):this._slice.call(this.buf,t,r)},u.prototype.string=function(){var e=this.bytes();return s.read(e,0,e.length)},u.prototype.skip=function(e){if("number"==typeof e){if(this.pos+e>this.len)throw a(this,e);this.pos+=e}else do{if(this.pos>=this.len)throw a(this)}while(128&this.buf[this.pos++]);return this},u.prototype.skipType=function(e){switch(e){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:for(;4!=(e=7&this.uint32());)this.skipType(e);break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+e+" at offset "+this.pos)}return this},u._configure=function(e){o=e,u.create=m(),o._configure();var t=n.Long?"toLong":"toNumber";n.merge(u.prototype,{int64:function(){return h.call(this)[t](!1)},uint64:function(){return h.call(this)[t](!0)},sint64:function(){return h.call(this).zzDecode()[t](!1)},fixed64:function(){return f.call(this)[t](!0)},sfixed64:function(){return f.call(this)[t](!1)}})}},{15:15}],10:[function(e,t,r){t.exports=i;var o=e(9);(i.prototype=Object.create(o.prototype)).constructor=i;var n=e(15);function i(e){o.call(this,e)}i._configure=function(){n.Buffer&&(i.prototype._slice=n.Buffer.prototype.slice)},i.prototype.string=function(){var e=this.uint32();return this.buf.utf8Slice?this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+e,this.len)):this.buf.toString("utf-8",this.pos,this.pos=Math.min(this.pos+e,this.len))},i._configure()},{15:15,9:9}],11:[function(e,t,r){t.exports={}},{}],12:[function(e,t,r){r.Service=e(13)},{13:13}],13:[function(e,t,r){t.exports=n;var o=e(15);function n(e,t,r){if("function"!=typeof e)throw TypeError("rpcImpl must be a function");o.EventEmitter.call(this),this.rpcImpl=e,this.requestDelimited=Boolean(t),this.responseDelimited=Boolean(r)}(n.prototype=Object.create(o.EventEmitter.prototype)).constructor=n,n.prototype.rpcCall=function e(t,r,n,i,s){if(!i)throw TypeError("request must be specified");var a=this;if(!s)return o.asPromise(e,a,t,r,n,i);if(!a.rpcImpl)return setTimeout((function(){s(Error("already ended"))}),0),undefined$1;try{return a.rpcImpl(t,r[a.requestDelimited?"encodeDelimited":"encode"](i).finish(),(function(e,r){if(e)return a.emit("error",e,t),s(e);if(null===r)return a.end(!0),undefined$1;if(!(r instanceof n))try{r=n[a.responseDelimited?"decodeDelimited":"decode"](r)}catch(e){return a.emit("error",e,t),s(e)}return a.emit("data",r,t),s(null,r)}))}catch(e){return a.emit("error",e,t),setTimeout((function(){s(e)}),0),undefined$1}},n.prototype.end=function(e){return this.rpcImpl&&(e||this.rpcImpl(null,null,null),this.rpcImpl=null,this.emit("end").off()),this}},{15:15}],14:[function(e,t,r){t.exports=n;var o=e(15);function n(e,t){this.lo=e>>>0,this.hi=t>>>0}var i=n.zero=new n(0,0);i.toNumber=function(){return 0},i.zzEncode=i.zzDecode=function(){return this},i.length=function(){return 1};var s=n.zeroHash="\0\0\0\0\0\0\0\0";n.fromNumber=function(e){if(0===e)return i;var t=e<0;t&&(e=-e);var r=e>>>0,o=(e-r)/4294967296>>>0;return t&&(o=~o>>>0,r=~r>>>0,++r>4294967295&&(r=0,++o>4294967295&&(o=0))),new n(r,o)},n.from=function(e){if("number"==typeof e)return n.fromNumber(e);if(o.isString(e)){if(!o.Long)return n.fromNumber(parseInt(e,10));e=o.Long.fromString(e)}return e.low||e.high?new n(e.low>>>0,e.high>>>0):i},n.prototype.toNumber=function(e){if(!e&&this.hi>>>31){var t=1+~this.lo>>>0,r=~this.hi>>>0;return t||(r=r+1>>>0),-(t+4294967296*r)}return this.lo+4294967296*this.hi},n.prototype.toLong=function(e){return o.Long?new o.Long(0|this.lo,0|this.hi,Boolean(e)):{low:0|this.lo,high:0|this.hi,unsigned:Boolean(e)}};var a=String.prototype.charCodeAt;n.fromHash=function(e){return e===s?i:new n((a.call(e,0)|a.call(e,1)<<8|a.call(e,2)<<16|a.call(e,3)<<24)>>>0,(a.call(e,4)|a.call(e,5)<<8|a.call(e,6)<<16|a.call(e,7)<<24)>>>0)},n.prototype.toHash=function(){return String.fromCharCode(255&this.lo,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,255&this.hi,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)},n.prototype.zzEncode=function(){var e=this.hi>>31;return this.hi=((this.hi<<1|this.lo>>>31)^e)>>>0,this.lo=(this.lo<<1^e)>>>0,this},n.prototype.zzDecode=function(){var e=-(1&this.lo);return this.lo=((this.lo>>>1|this.hi<<31)^e)>>>0,this.hi=(this.hi>>>1^e)>>>0,this},n.prototype.length=function(){var e=this.lo,t=(this.lo>>>28|this.hi<<4)>>>0,r=this.hi>>>24;return 0===r?0===t?e<16384?e<128?1:2:e<2097152?3:4:t<16384?t<128?5:6:t<2097152?7:8:r<128?9:10}},{15:15}],15:[function(e,t,r){var o=r;function n(e,t,r){for(var o=Object.keys(t),n=0;n<o.length;++n)e[o[n]]!==undefined$1&&r||(e[o[n]]=t[o[n]]);return e}function i(e){function t(e,r){if(!(this instanceof t))return new t(e,r);Object.defineProperty(this,"message",{get:function(){return e}}),Error.captureStackTrace?Error.captureStackTrace(this,t):Object.defineProperty(this,"stack",{value:(new Error).stack||""}),r&&n(this,r)}return(t.prototype=Object.create(Error.prototype)).constructor=t,Object.defineProperty(t.prototype,"name",{get:function(){return e}}),t.prototype.toString=function(){return this.name+": "+this.message},t}o.asPromise=e(1),o.base64=e(2),o.EventEmitter=e(3),o.float=e(4),o.inquire=e(5),o.utf8=e(7),o.pool=e(6),o.LongBits=e(14),o.isNode=Boolean(void 0!==commonjsGlobal&&commonjsGlobal&&commonjsGlobal.process&&commonjsGlobal.process.versions&&commonjsGlobal.process.versions.node),o.global=o.isNode&&commonjsGlobal||"undefined"!=typeof window&&window||"undefined"!=typeof self&&self||this,o.emptyArray=Object.freeze?Object.freeze([]):[],o.emptyObject=Object.freeze?Object.freeze({}):{},o.isInteger=Number.isInteger||function(e){return"number"==typeof e&&isFinite(e)&&Math.floor(e)===e},o.isString=function(e){return"string"==typeof e||e instanceof String},o.isObject=function(e){return e&&"object"==typeof e},o.isset=o.isSet=function(e,t){var r=e[t];return!(null==r||!e.hasOwnProperty(t))&&("object"!=typeof r||(Array.isArray(r)?r.length:Object.keys(r).length)>0)},o.Buffer=function(){try{var e=o.inquire("buffer").Buffer;return e.prototype.utf8Write?e:null}catch(e){return null}}(),o._Buffer_from=null,o._Buffer_allocUnsafe=null,o.newBuffer=function(e){return"number"==typeof e?o.Buffer?o._Buffer_allocUnsafe(e):new o.Array(e):o.Buffer?o._Buffer_from(e):"undefined"==typeof Uint8Array?e:new Uint8Array(e)},o.Array="undefined"!=typeof Uint8Array?Uint8Array:Array,o.Long=o.global.dcodeIO&&o.global.dcodeIO.Long||o.global.Long||o.inquire("long"),o.key2Re=/^true|false|0|1$/,o.key32Re=/^-?(?:0|[1-9][0-9]*)$/,o.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/,o.longToHash=function(e){return e?o.LongBits.from(e).toHash():o.LongBits.zeroHash},o.longFromHash=function(e,t){var r=o.LongBits.fromHash(e);return o.Long?o.Long.fromBits(r.lo,r.hi,t):r.toNumber(Boolean(t))},o.merge=n,o.lcFirst=function(e){return e.charAt(0).toLowerCase()+e.substring(1)},o.newError=i,o.ProtocolError=i("ProtocolError"),o.oneOfGetter=function(e){for(var t={},r=0;r<e.length;++r)t[e[r]]=1;return function(){for(var e=Object.keys(this),r=e.length-1;r>-1;--r)if(1===t[e[r]]&&this[e[r]]!==undefined$1&&null!==this[e[r]])return e[r]}},o.oneOfSetter=function(e){return function(t){for(var r=0;r<e.length;++r)e[r]!==t&&delete this[e[r]]}},o.toJSONOptions={longs:String,enums:String,bytes:String,json:!0},o._configure=function(){var e=o.Buffer;e?(o._Buffer_from=e.from!==Uint8Array.from&&e.from||function(t,r){return new e(t,r)},o._Buffer_allocUnsafe=e.allocUnsafe||function(t){return new e(t)}):o._Buffer_from=o._Buffer_allocUnsafe=null}},{1:1,14:14,2:2,3:3,4:4,5:5,6:6,7:7}],16:[function(e,t,r){t.exports=m;var o,n=e(15),i=n.LongBits,s=n.base64,a=n.utf8;function u(e,t,r){this.fn=e,this.len=t,this.next=undefined$1,this.val=r}function c(){}function l(e){this.head=e.head,this.tail=e.tail,this.len=e.len,this.next=e.states}function m(){this.len=0,this.head=new u(c,0,0),this.tail=this.head,this.states=null}var h=function(){return n.Buffer?function(){return(m.create=function(){return new o})()}:function(){return new m}};function d(e,t,r){t[r]=255&e}function f(e,t){this.len=e,this.next=undefined$1,this.val=t}function p(e,t,r){for(;e.hi;)t[r++]=127&e.lo|128,e.lo=(e.lo>>>7|e.hi<<25)>>>0,e.hi>>>=7;for(;e.lo>127;)t[r++]=127&e.lo|128,e.lo=e.lo>>>7;t[r++]=e.lo}function g(e,t,r){t[r]=255&e,t[r+1]=e>>>8&255,t[r+2]=e>>>16&255,t[r+3]=e>>>24}m.create=h(),m.alloc=function(e){return new n.Array(e)},n.Array!==Array&&(m.alloc=n.pool(m.alloc,n.Array.prototype.subarray)),m.prototype._push=function(e,t,r){return this.tail=this.tail.next=new u(e,t,r),this.len+=t,this},f.prototype=Object.create(u.prototype),f.prototype.fn=function(e,t,r){for(;e>127;)t[r++]=127&e|128,e>>>=7;t[r]=e},m.prototype.uint32=function(e){return this.len+=(this.tail=this.tail.next=new f((e>>>=0)<128?1:e<16384?2:e<2097152?3:e<268435456?4:5,e)).len,this},m.prototype.int32=function(e){return e<0?this._push(p,10,i.fromNumber(e)):this.uint32(e)},m.prototype.sint32=function(e){return this.uint32((e<<1^e>>31)>>>0)},m.prototype.uint64=function(e){var t=i.from(e);return this._push(p,t.length(),t)},m.prototype.int64=m.prototype.uint64,m.prototype.sint64=function(e){var t=i.from(e).zzEncode();return this._push(p,t.length(),t)},m.prototype.bool=function(e){return this._push(d,1,e?1:0)},m.prototype.fixed32=function(e){return this._push(g,4,e>>>0)},m.prototype.sfixed32=m.prototype.fixed32,m.prototype.fixed64=function(e){var t=i.from(e);return this._push(g,4,t.lo)._push(g,4,t.hi)},m.prototype.sfixed64=m.prototype.fixed64,m.prototype.float=function(e){return this._push(n.float.writeFloatLE,4,e)},m.prototype.double=function(e){return this._push(n.float.writeDoubleLE,8,e)};var y=n.Array.prototype.set?function(e,t,r){t.set(e,r)}:function(e,t,r){for(var o=0;o<e.length;++o)t[r+o]=e[o]};m.prototype.bytes=function(e){var t=e.length>>>0;if(!t)return this._push(d,1,0);if(n.isString(e)){var r=m.alloc(t=s.length(e));s.decode(e,r,0),e=r}return this.uint32(t)._push(y,t,e)},m.prototype.string=function(e){var t=a.length(e);return t?this.uint32(t)._push(a.write,t,e):this._push(d,1,0)},m.prototype.fork=function(){return this.states=new l(this),this.head=this.tail=new u(c,0,0),this.len=0,this},m.prototype.reset=function(){return this.states?(this.head=this.states.head,this.tail=this.states.tail,this.len=this.states.len,this.states=this.states.next):(this.head=this.tail=new u(c,0,0),this.len=0),this},m.prototype.ldelim=function(){var e=this.head,t=this.tail,r=this.len;return this.reset().uint32(r),r&&(this.tail.next=e.next,this.tail=t,this.len+=r),this},m.prototype.finish=function(){for(var e=this.head.next,t=this.constructor.alloc(this.len),r=0;e;)e.fn(e.val,t,r),r+=e.len,e=e.next;return t},m._configure=function(e){o=e,m.create=h(),o._configure()}},{15:15}],17:[function(e,t,r){t.exports=i;var o=e(16);(i.prototype=Object.create(o.prototype)).constructor=i;var n=e(15);function i(){o.call(this)}function s(e,t,r){e.length<40?n.utf8.write(e,t,r):t.utf8Write?t.utf8Write(e,r):t.write(e,r)}i._configure=function(){i.alloc=n._Buffer_allocUnsafe,i.writeBytesBuffer=n.Buffer&&n.Buffer.prototype instanceof Uint8Array&&"set"===n.Buffer.prototype.set.name?function(e,t,r){t.set(e,r)}:function(e,t,r){if(e.copy)e.copy(t,r,0,e.length);else for(var o=0;o<e.length;)t[r++]=e[o++]}},i.prototype.bytes=function(e){n.isString(e)&&(e=n._Buffer_from(e,"base64"));var t=e.length>>>0;return this.uint32(t),t&&this._push(i.writeBytesBuffer,t,e),this},i.prototype.string=function(e){var t=n.Buffer.byteLength(e);return this.uint32(t),t&&this._push(s,t,e),this},i._configure()},{15:15,16:16}]},{},[8])})()})(protobuf);var $protobuf=protobuf.exports,$Reader=$protobuf.Reader,$Writer=$protobuf.Writer,$util=$protobuf.util,$root=$protobuf.roots.default||($protobuf.roots.default={}),common,grpc,gobes,game;$root.game=(game={},game.gobes=((gobes={}).grpc=((grpc={}).common=((common={}).dto=function(){var e={};return e.AckMessage=function(){function e(e){if(e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.rtnCode=0,e.prototype.msg="",e.create=function(t){return new e(t)},e.encode=function(e,t){return t||(t=$Writer.create()),null!=e.rtnCode&&Object.hasOwnProperty.call(e,"rtnCode")&&t.uint32(8).int32(e.rtnCode),null!=e.msg&&Object.hasOwnProperty.call(e,"msg")&&t.uint32(18).string(e.msg),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.AckMessage;e.pos<r;){var n=e.uint32();switch(n>>>3){case 1:o.rtnCode=e.int32();break;case 2:o.msg=e.string();break;default:e.skipType(7&n)}}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){return"object"!=typeof e||null===e?"object expected":null!=e.rtnCode&&e.hasOwnProperty("rtnCode")&&!$util.isInteger(e.rtnCode)?"rtnCode: integer expected":null!=e.msg&&e.hasOwnProperty("msg")&&!$util.isString(e.msg)?"msg: string expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.AckMessage)return e;var t=new $root.game.gobes.grpc.common.dto.AckMessage;return null!=e.rtnCode&&(t.rtnCode=0|e.rtnCode),null!=e.msg&&(t.msg=String(e.msg)),t},e.toObject=function(e,t){t||(t={});var r={};return t.defaults&&(r.rtnCode=0,r.msg=""),null!=e.rtnCode&&e.hasOwnProperty("rtnCode")&&(r.rtnCode=e.rtnCode),null!=e.msg&&e.hasOwnProperty("msg")&&(r.msg=e.msg),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.ClientFrame=function(){function e(e){if(this.data=[],e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.currentFrameId=0,e.prototype.data=$util.emptyArray,e.prototype.timestamp=$util.Long?$util.Long.fromBits(0,0,!1):0,e.create=function(t){return new e(t)},e.encode=function(e,t){if(t||(t=$Writer.create()),null!=e.currentFrameId&&Object.hasOwnProperty.call(e,"currentFrameId")&&t.uint32(8).int32(e.currentFrameId),null!=e.data&&e.data.length)for(var r=0;r<e.data.length;++r)t.uint32(18).string(e.data[r]);return null!=e.timestamp&&Object.hasOwnProperty.call(e,"timestamp")&&t.uint32(24).int64(e.timestamp),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.ClientFrame;e.pos<r;){var n=e.uint32();switch(n>>>3){case 1:o.currentFrameId=e.int32();break;case 2:o.data&&o.data.length||(o.data=[]),o.data.push(e.string());break;case 3:o.timestamp=e.int64();break;default:e.skipType(7&n)}}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){if("object"!=typeof e||null===e)return"object expected";if(null!=e.currentFrameId&&e.hasOwnProperty("currentFrameId")&&!$util.isInteger(e.currentFrameId))return"currentFrameId: integer expected";if(null!=e.data&&e.hasOwnProperty("data")){if(!Array.isArray(e.data))return"data: array expected";for(var t=0;t<e.data.length;++t)if(!$util.isString(e.data[t]))return"data: string[] expected"}return null!=e.timestamp&&e.hasOwnProperty("timestamp")&&!($util.isInteger(e.timestamp)||e.timestamp&&$util.isInteger(e.timestamp.low)&&$util.isInteger(e.timestamp.high))?"timestamp: integer|Long expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.ClientFrame)return e;var t=new $root.game.gobes.grpc.common.dto.ClientFrame;if(null!=e.currentFrameId&&(t.currentFrameId=0|e.currentFrameId),e.data){if(!Array.isArray(e.data))throw TypeError(".game.gobes.grpc.common.dto.ClientFrame.data: array expected");t.data=[];for(var r=0;r<e.data.length;++r)t.data[r]=String(e.data[r])}return null!=e.timestamp&&($util.Long?(t.timestamp=$util.Long.fromValue(e.timestamp)).unsigned=!1:"string"==typeof e.timestamp?t.timestamp=parseInt(e.timestamp,10):"number"==typeof e.timestamp?t.timestamp=e.timestamp:"object"==typeof e.timestamp&&(t.timestamp=new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber())),t},e.toObject=function(e,t){t||(t={});var r={};if((t.arrays||t.defaults)&&(r.data=[]),t.defaults)if(r.currentFrameId=0,$util.Long){var o=new $util.Long(0,0,!1);r.timestamp=t.longs===String?o.toString():t.longs===Number?o.toNumber():o}else r.timestamp=t.longs===String?"0":0;if(null!=e.currentFrameId&&e.hasOwnProperty("currentFrameId")&&(r.currentFrameId=e.currentFrameId),e.data&&e.data.length){r.data=[];for(var n=0;n<e.data.length;++n)r.data[n]=e.data[n]}return null!=e.timestamp&&e.hasOwnProperty("timestamp")&&("number"==typeof e.timestamp?r.timestamp=t.longs===String?String(e.timestamp):e.timestamp:r.timestamp=t.longs===String?$util.Long.prototype.toString.call(e.timestamp):t.longs===Number?new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber():e.timestamp),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.ClientMessage=function(){function e(e){if(e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.code=0,e.prototype.seq="",e.prototype.timestamp=$util.Long?$util.Long.fromBits(0,0,!1):0,e.prototype.msg=$util.newBuffer([]),e.create=function(t){return new e(t)},e.encode=function(e,t){return t||(t=$Writer.create()),null!=e.code&&Object.hasOwnProperty.call(e,"code")&&t.uint32(8).int32(e.code),null!=e.seq&&Object.hasOwnProperty.call(e,"seq")&&t.uint32(18).string(e.seq),null!=e.timestamp&&Object.hasOwnProperty.call(e,"timestamp")&&t.uint32(24).int64(e.timestamp),null!=e.msg&&Object.hasOwnProperty.call(e,"msg")&&t.uint32(34).bytes(e.msg),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.ClientMessage;e.pos<r;){var n=e.uint32();switch(n>>>3){case 1:o.code=e.int32();break;case 2:o.seq=e.string();break;case 3:o.timestamp=e.int64();break;case 4:o.msg=e.bytes();break;default:e.skipType(7&n)}}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){return"object"!=typeof e||null===e?"object expected":null!=e.code&&e.hasOwnProperty("code")&&!$util.isInteger(e.code)?"code: integer expected":null!=e.seq&&e.hasOwnProperty("seq")&&!$util.isString(e.seq)?"seq: string expected":null!=e.timestamp&&e.hasOwnProperty("timestamp")&&!($util.isInteger(e.timestamp)||e.timestamp&&$util.isInteger(e.timestamp.low)&&$util.isInteger(e.timestamp.high))?"timestamp: integer|Long expected":null!=e.msg&&e.hasOwnProperty("msg")&&!(e.msg&&"number"==typeof e.msg.length||$util.isString(e.msg))?"msg: buffer expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.ClientMessage)return e;var t=new $root.game.gobes.grpc.common.dto.ClientMessage;return null!=e.code&&(t.code=0|e.code),null!=e.seq&&(t.seq=String(e.seq)),null!=e.timestamp&&($util.Long?(t.timestamp=$util.Long.fromValue(e.timestamp)).unsigned=!1:"string"==typeof e.timestamp?t.timestamp=parseInt(e.timestamp,10):"number"==typeof e.timestamp?t.timestamp=e.timestamp:"object"==typeof e.timestamp&&(t.timestamp=new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber())),null!=e.msg&&("string"==typeof e.msg?$util.base64.decode(e.msg,t.msg=$util.newBuffer($util.base64.length(e.msg)),0):e.msg.length&&(t.msg=e.msg)),t},e.toObject=function(e,t){t||(t={});var r={};if(t.defaults){if(r.code=0,r.seq="",$util.Long){var o=new $util.Long(0,0,!1);r.timestamp=t.longs===String?o.toString():t.longs===Number?o.toNumber():o}else r.timestamp=t.longs===String?"0":0;t.bytes===String?r.msg="":(r.msg=[],t.bytes!==Array&&(r.msg=$util.newBuffer(r.msg)))}return null!=e.code&&e.hasOwnProperty("code")&&(r.code=e.code),null!=e.seq&&e.hasOwnProperty("seq")&&(r.seq=e.seq),null!=e.timestamp&&e.hasOwnProperty("timestamp")&&("number"==typeof e.timestamp?r.timestamp=t.longs===String?String(e.timestamp):e.timestamp:r.timestamp=t.longs===String?$util.Long.prototype.toString.call(e.timestamp):t.longs===Number?new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber():e.timestamp),null!=e.msg&&e.hasOwnProperty("msg")&&(r.msg=t.bytes===String?$util.base64.encode(e.msg,0,e.msg.length):t.bytes===Array?Array.prototype.slice.call(e.msg):e.msg),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.FrameExtInfo=function(){function e(e){if(e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.seed=$util.Long?$util.Long.fromBits(0,0,!1):0,e.create=function(t){return new e(t)},e.encode=function(e,t){return t||(t=$Writer.create()),null!=e.seed&&Object.hasOwnProperty.call(e,"seed")&&t.uint32(8).int64(e.seed),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.FrameExtInfo;e.pos<r;){var n=e.uint32();n>>>3==1?o.seed=e.int64():e.skipType(7&n)}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){return"object"!=typeof e||null===e?"object expected":null!=e.seed&&e.hasOwnProperty("seed")&&!($util.isInteger(e.seed)||e.seed&&$util.isInteger(e.seed.low)&&$util.isInteger(e.seed.high))?"seed: integer|Long expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.FrameExtInfo)return e;var t=new $root.game.gobes.grpc.common.dto.FrameExtInfo;return null!=e.seed&&($util.Long?(t.seed=$util.Long.fromValue(e.seed)).unsigned=!1:"string"==typeof e.seed?t.seed=parseInt(e.seed,10):"number"==typeof e.seed?t.seed=e.seed:"object"==typeof e.seed&&(t.seed=new $util.LongBits(e.seed.low>>>0,e.seed.high>>>0).toNumber())),t},e.toObject=function(e,t){t||(t={});var r={};if(t.defaults)if($util.Long){var o=new $util.Long(0,0,!1);r.seed=t.longs===String?o.toString():t.longs===Number?o.toNumber():o}else r.seed=t.longs===String?"0":0;return null!=e.seed&&e.hasOwnProperty("seed")&&("number"==typeof e.seed?r.seed=t.longs===String?String(e.seed):e.seed:r.seed=t.longs===String?$util.Long.prototype.toString.call(e.seed):t.longs===Number?new $util.LongBits(e.seed.low>>>0,e.seed.high>>>0).toNumber():e.seed),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.FrameInfo=function(){function e(e){if(this.data=[],e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.playerId="",e.prototype.data=$util.emptyArray,e.prototype.timestamp=$util.Long?$util.Long.fromBits(0,0,!1):0,e.create=function(t){return new e(t)},e.encode=function(e,t){if(t||(t=$Writer.create()),null!=e.playerId&&Object.hasOwnProperty.call(e,"playerId")&&t.uint32(10).string(e.playerId),null!=e.data&&e.data.length)for(var r=0;r<e.data.length;++r)t.uint32(18).string(e.data[r]);return null!=e.timestamp&&Object.hasOwnProperty.call(e,"timestamp")&&t.uint32(24).int64(e.timestamp),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.FrameInfo;e.pos<r;){var n=e.uint32();switch(n>>>3){case 1:o.playerId=e.string();break;case 2:o.data&&o.data.length||(o.data=[]),o.data.push(e.string());break;case 3:o.timestamp=e.int64();break;default:e.skipType(7&n)}}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){if("object"!=typeof e||null===e)return"object expected";if(null!=e.playerId&&e.hasOwnProperty("playerId")&&!$util.isString(e.playerId))return"playerId: string expected";if(null!=e.data&&e.hasOwnProperty("data")){if(!Array.isArray(e.data))return"data: array expected";for(var t=0;t<e.data.length;++t)if(!$util.isString(e.data[t]))return"data: string[] expected"}return null!=e.timestamp&&e.hasOwnProperty("timestamp")&&!($util.isInteger(e.timestamp)||e.timestamp&&$util.isInteger(e.timestamp.low)&&$util.isInteger(e.timestamp.high))?"timestamp: integer|Long expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.FrameInfo)return e;var t=new $root.game.gobes.grpc.common.dto.FrameInfo;if(null!=e.playerId&&(t.playerId=String(e.playerId)),e.data){if(!Array.isArray(e.data))throw TypeError(".game.gobes.grpc.common.dto.FrameInfo.data: array expected");t.data=[];for(var r=0;r<e.data.length;++r)t.data[r]=String(e.data[r])}return null!=e.timestamp&&($util.Long?(t.timestamp=$util.Long.fromValue(e.timestamp)).unsigned=!1:"string"==typeof e.timestamp?t.timestamp=parseInt(e.timestamp,10):"number"==typeof e.timestamp?t.timestamp=e.timestamp:"object"==typeof e.timestamp&&(t.timestamp=new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber())),t},e.toObject=function(e,t){t||(t={});var r={};if((t.arrays||t.defaults)&&(r.data=[]),t.defaults)if(r.playerId="",$util.Long){var o=new $util.Long(0,0,!1);r.timestamp=t.longs===String?o.toString():t.longs===Number?o.toNumber():o}else r.timestamp=t.longs===String?"0":0;if(null!=e.playerId&&e.hasOwnProperty("playerId")&&(r.playerId=e.playerId),e.data&&e.data.length){r.data=[];for(var n=0;n<e.data.length;++n)r.data[n]=e.data[n]}return null!=e.timestamp&&e.hasOwnProperty("timestamp")&&("number"==typeof e.timestamp?r.timestamp=t.longs===String?String(e.timestamp):e.timestamp:r.timestamp=t.longs===String?$util.Long.prototype.toString.call(e.timestamp):t.longs===Number?new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber():e.timestamp),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.PlayerInfo=function(){function e(e){if(e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.playerId="",e.create=function(t){return new e(t)},e.encode=function(e,t){return t||(t=$Writer.create()),null!=e.playerId&&Object.hasOwnProperty.call(e,"playerId")&&t.uint32(10).string(e.playerId),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.PlayerInfo;e.pos<r;){var n=e.uint32();n>>>3==1?o.playerId=e.string():e.skipType(7&n)}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){return"object"!=typeof e||null===e?"object expected":null!=e.playerId&&e.hasOwnProperty("playerId")&&!$util.isString(e.playerId)?"playerId: string expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.PlayerInfo)return e;var t=new $root.game.gobes.grpc.common.dto.PlayerInfo;return null!=e.playerId&&(t.playerId=String(e.playerId)),t},e.toObject=function(e,t){t||(t={});var r={};return t.defaults&&(r.playerId=""),null!=e.playerId&&e.hasOwnProperty("playerId")&&(r.playerId=e.playerId),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.QueryFrameResult=function(){function e(e){if(this.relayFrameInfos=[],e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.relayFrameInfos=$util.emptyArray,e.create=function(t){return new e(t)},e.encode=function(e,t){if(t||(t=$Writer.create()),null!=e.relayFrameInfos&&e.relayFrameInfos.length)for(var r=0;r<e.relayFrameInfos.length;++r)$root.game.gobes.grpc.common.dto.RelayFrameInfo.encode(e.relayFrameInfos[r],t.uint32(10).fork()).ldelim();return t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.QueryFrameResult;e.pos<r;){var n=e.uint32();n>>>3==1?(o.relayFrameInfos&&o.relayFrameInfos.length||(o.relayFrameInfos=[]),o.relayFrameInfos.push($root.game.gobes.grpc.common.dto.RelayFrameInfo.decode(e,e.uint32()))):e.skipType(7&n)}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){if("object"!=typeof e||null===e)return"object expected";if(null!=e.relayFrameInfos&&e.hasOwnProperty("relayFrameInfos")){if(!Array.isArray(e.relayFrameInfos))return"relayFrameInfos: array expected";for(var t=0;t<e.relayFrameInfos.length;++t){var r=$root.game.gobes.grpc.common.dto.RelayFrameInfo.verify(e.relayFrameInfos[t]);if(r)return"relayFrameInfos."+r}}return null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.QueryFrameResult)return e;var t=new $root.game.gobes.grpc.common.dto.QueryFrameResult;if(e.relayFrameInfos){if(!Array.isArray(e.relayFrameInfos))throw TypeError(".game.gobes.grpc.common.dto.QueryFrameResult.relayFrameInfos: array expected");t.relayFrameInfos=[];for(var r=0;r<e.relayFrameInfos.length;++r){if("object"!=typeof e.relayFrameInfos[r])throw TypeError(".game.gobes.grpc.common.dto.QueryFrameResult.relayFrameInfos: object expected");t.relayFrameInfos[r]=$root.game.gobes.grpc.common.dto.RelayFrameInfo.fromObject(e.relayFrameInfos[r])}}return t},e.toObject=function(e,t){t||(t={});var r={};if((t.arrays||t.defaults)&&(r.relayFrameInfos=[]),e.relayFrameInfos&&e.relayFrameInfos.length){r.relayFrameInfos=[];for(var o=0;o<e.relayFrameInfos.length;++o)r.relayFrameInfos[o]=$root.game.gobes.grpc.common.dto.RelayFrameInfo.toObject(e.relayFrameInfos[o],t)}return r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.QueryFrame=function(){function e(e){if(e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.currentFrameId=0,e.prototype.size=0,e.prototype.mode=0,e.create=function(t){return new e(t)},e.encode=function(e,t){return t||(t=$Writer.create()),null!=e.currentFrameId&&Object.hasOwnProperty.call(e,"currentFrameId")&&t.uint32(8).int32(e.currentFrameId),null!=e.size&&Object.hasOwnProperty.call(e,"size")&&t.uint32(16).int32(e.size),null!=e.mode&&Object.hasOwnProperty.call(e,"mode")&&t.uint32(24).int32(e.mode),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.QueryFrame;e.pos<r;){var n=e.uint32();switch(n>>>3){case 1:o.currentFrameId=e.int32();break;case 2:o.size=e.int32();break;case 3:o.mode=e.int32();break;default:e.skipType(7&n)}}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){return"object"!=typeof e||null===e?"object expected":null!=e.currentFrameId&&e.hasOwnProperty("currentFrameId")&&!$util.isInteger(e.currentFrameId)?"currentFrameId: integer expected":null!=e.size&&e.hasOwnProperty("size")&&!$util.isInteger(e.size)?"size: integer expected":null!=e.mode&&e.hasOwnProperty("mode")&&!$util.isInteger(e.mode)?"mode: integer expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.QueryFrame)return e;var t=new $root.game.gobes.grpc.common.dto.QueryFrame;return null!=e.currentFrameId&&(t.currentFrameId=0|e.currentFrameId),null!=e.size&&(t.size=0|e.size),null!=e.mode&&(t.mode=0|e.mode),t},e.toObject=function(e,t){t||(t={});var r={};return t.defaults&&(r.currentFrameId=0,r.size=0,r.mode=0),null!=e.currentFrameId&&e.hasOwnProperty("currentFrameId")&&(r.currentFrameId=e.currentFrameId),null!=e.size&&e.hasOwnProperty("size")&&(r.size=e.size),null!=e.mode&&e.hasOwnProperty("mode")&&(r.mode=e.mode),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.RelayFrameInfo=function(){function e(e){if(this.frameInfo=[],e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.currentRoomFrameId=0,e.prototype.frameInfo=$util.emptyArray,e.prototype.ext=null,e.create=function(t){return new e(t)},e.encode=function(e,t){if(t||(t=$Writer.create()),null!=e.currentRoomFrameId&&Object.hasOwnProperty.call(e,"currentRoomFrameId")&&t.uint32(8).int32(e.currentRoomFrameId),null!=e.frameInfo&&e.frameInfo.length)for(var r=0;r<e.frameInfo.length;++r)$root.game.gobes.grpc.common.dto.FrameInfo.encode(e.frameInfo[r],t.uint32(18).fork()).ldelim();return null!=e.ext&&Object.hasOwnProperty.call(e,"ext")&&$root.game.gobes.grpc.common.dto.FrameExtInfo.encode(e.ext,t.uint32(26).fork()).ldelim(),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.RelayFrameInfo;e.pos<r;){var n=e.uint32();switch(n>>>3){case 1:o.currentRoomFrameId=e.int32();break;case 2:o.frameInfo&&o.frameInfo.length||(o.frameInfo=[]),o.frameInfo.push($root.game.gobes.grpc.common.dto.FrameInfo.decode(e,e.uint32()));break;case 3:o.ext=$root.game.gobes.grpc.common.dto.FrameExtInfo.decode(e,e.uint32());break;default:e.skipType(7&n)}}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){if("object"!=typeof e||null===e)return"object expected";if(null!=e.currentRoomFrameId&&e.hasOwnProperty("currentRoomFrameId")&&!$util.isInteger(e.currentRoomFrameId))return"currentRoomFrameId: integer expected";if(null!=e.frameInfo&&e.hasOwnProperty("frameInfo")){if(!Array.isArray(e.frameInfo))return"frameInfo: array expected";for(var t=0;t<e.frameInfo.length;++t)if(r=$root.game.gobes.grpc.common.dto.FrameInfo.verify(e.frameInfo[t]))return"frameInfo."+r}var r;return null!=e.ext&&e.hasOwnProperty("ext")&&(r=$root.game.gobes.grpc.common.dto.FrameExtInfo.verify(e.ext))?"ext."+r:null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.RelayFrameInfo)return e;var t=new $root.game.gobes.grpc.common.dto.RelayFrameInfo;if(null!=e.currentRoomFrameId&&(t.currentRoomFrameId=0|e.currentRoomFrameId),e.frameInfo){if(!Array.isArray(e.frameInfo))throw TypeError(".game.gobes.grpc.common.dto.RelayFrameInfo.frameInfo: array expected");t.frameInfo=[];for(var r=0;r<e.frameInfo.length;++r){if("object"!=typeof e.frameInfo[r])throw TypeError(".game.gobes.grpc.common.dto.RelayFrameInfo.frameInfo: object expected");t.frameInfo[r]=$root.game.gobes.grpc.common.dto.FrameInfo.fromObject(e.frameInfo[r])}}if(null!=e.ext){if("object"!=typeof e.ext)throw TypeError(".game.gobes.grpc.common.dto.RelayFrameInfo.ext: object expected");t.ext=$root.game.gobes.grpc.common.dto.FrameExtInfo.fromObject(e.ext)}return t},e.toObject=function(e,t){t||(t={});var r={};if((t.arrays||t.defaults)&&(r.frameInfo=[]),t.defaults&&(r.currentRoomFrameId=0,r.ext=null),null!=e.currentRoomFrameId&&e.hasOwnProperty("currentRoomFrameId")&&(r.currentRoomFrameId=e.currentRoomFrameId),e.frameInfo&&e.frameInfo.length){r.frameInfo=[];for(var o=0;o<e.frameInfo.length;++o)r.frameInfo[o]=$root.game.gobes.grpc.common.dto.FrameInfo.toObject(e.frameInfo[o],t)}return null!=e.ext&&e.hasOwnProperty("ext")&&(r.ext=$root.game.gobes.grpc.common.dto.FrameExtInfo.toObject(e.ext,t)),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e.ServerMessage=function(){function e(e){if(e)for(var t=Object.keys(e),r=0;r<t.length;++r)null!=e[t[r]]&&(this[t[r]]=e[t[r]])}return e.prototype.code=0,e.prototype.seq="",e.prototype.timestamp=$util.Long?$util.Long.fromBits(0,0,!1):0,e.prototype.msg=$util.newBuffer([]),e.create=function(t){return new e(t)},e.encode=function(e,t){return t||(t=$Writer.create()),null!=e.code&&Object.hasOwnProperty.call(e,"code")&&t.uint32(8).int32(e.code),null!=e.seq&&Object.hasOwnProperty.call(e,"seq")&&t.uint32(18).string(e.seq),null!=e.timestamp&&Object.hasOwnProperty.call(e,"timestamp")&&t.uint32(24).int64(e.timestamp),null!=e.msg&&Object.hasOwnProperty.call(e,"msg")&&t.uint32(34).bytes(e.msg),t},e.encodeDelimited=function(e,t){return this.encode(e,t).ldelim()},e.decode=function(e,t){e instanceof $Reader||(e=$Reader.create(e));for(var r=void 0===t?e.len:e.pos+t,o=new $root.game.gobes.grpc.common.dto.ServerMessage;e.pos<r;){var n=e.uint32();switch(n>>>3){case 1:o.code=e.int32();break;case 2:o.seq=e.string();break;case 3:o.timestamp=e.int64();break;case 4:o.msg=e.bytes();break;default:e.skipType(7&n)}}return o},e.decodeDelimited=function(e){return e instanceof $Reader||(e=new $Reader(e)),this.decode(e,e.uint32())},e.verify=function(e){return"object"!=typeof e||null===e?"object expected":null!=e.code&&e.hasOwnProperty("code")&&!$util.isInteger(e.code)?"code: integer expected":null!=e.seq&&e.hasOwnProperty("seq")&&!$util.isString(e.seq)?"seq: string expected":null!=e.timestamp&&e.hasOwnProperty("timestamp")&&!($util.isInteger(e.timestamp)||e.timestamp&&$util.isInteger(e.timestamp.low)&&$util.isInteger(e.timestamp.high))?"timestamp: integer|Long expected":null!=e.msg&&e.hasOwnProperty("msg")&&!(e.msg&&"number"==typeof e.msg.length||$util.isString(e.msg))?"msg: buffer expected":null},e.fromObject=function(e){if(e instanceof $root.game.gobes.grpc.common.dto.ServerMessage)return e;var t=new $root.game.gobes.grpc.common.dto.ServerMessage;return null!=e.code&&(t.code=0|e.code),null!=e.seq&&(t.seq=String(e.seq)),null!=e.timestamp&&($util.Long?(t.timestamp=$util.Long.fromValue(e.timestamp)).unsigned=!1:"string"==typeof e.timestamp?t.timestamp=parseInt(e.timestamp,10):"number"==typeof e.timestamp?t.timestamp=e.timestamp:"object"==typeof e.timestamp&&(t.timestamp=new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber())),null!=e.msg&&("string"==typeof e.msg?$util.base64.decode(e.msg,t.msg=$util.newBuffer($util.base64.length(e.msg)),0):e.msg.length&&(t.msg=e.msg)),t},e.toObject=function(e,t){t||(t={});var r={};if(t.defaults){if(r.code=0,r.seq="",$util.Long){var o=new $util.Long(0,0,!1);r.timestamp=t.longs===String?o.toString():t.longs===Number?o.toNumber():o}else r.timestamp=t.longs===String?"0":0;t.bytes===String?r.msg="":(r.msg=[],t.bytes!==Array&&(r.msg=$util.newBuffer(r.msg)))}return null!=e.code&&e.hasOwnProperty("code")&&(r.code=e.code),null!=e.seq&&e.hasOwnProperty("seq")&&(r.seq=e.seq),null!=e.timestamp&&e.hasOwnProperty("timestamp")&&("number"==typeof e.timestamp?r.timestamp=t.longs===String?String(e.timestamp):e.timestamp:r.timestamp=t.longs===String?$util.Long.prototype.toString.call(e.timestamp):t.longs===Number?new $util.LongBits(e.timestamp.low>>>0,e.timestamp.high>>>0).toNumber():e.timestamp),null!=e.msg&&e.hasOwnProperty("msg")&&(r.msg=t.bytes===String?$util.base64.encode(e.msg,0,e.msg.length):t.bytes===Array?Array.prototype.slice.call(e.msg):e.msg),r},e.prototype.toJSON=function(){return this.constructor.toObject(this,$protobuf.util.toJSONOptions)},e}(),e}(),common),grpc),gobes),game);var compiled=$root;const{dto:dto}=compiled.game.gobes.grpc.common;class Logger{static log(e){console.log("[GOBE LOG]:",Object.assign({timestamp:Date.now()},e))}static warn(e){console.warn("[GOBE WARN]:",Object.assign({timestamp:Date.now()},e))}static error(e){console.error("[GOBE ERROR]:",Object.assign({timestamp:Date.now()},e))}}const{ServerMessage:ServerMessage,ClientMessage:ClientMessage,AckMessage:AckMessage,ClientFrame:ClientFrame,QueryFrame:QueryFrame,RelayFrameInfo:RelayFrameInfo,QueryFrameResult:QueryFrameResult}=dto,PlayerFrameInfo=dto.PlayerInfo;class Room extends Base{constructor(e,t){super(),this.onJoin=createSignal(),this.onLeave=createSignal(),this.onDismiss=createSignal(),this.onDisconnect=createSignal(),this.onStartFrameSync=createSignal(),this.onStopFrameSync=createSignal(),this.onRecvFrame=createSignal(),this.onRequestFrameError=createSignal(),this.connection=null,this.frameId=0,this.frameRequestMaxSize=1e3,this.frameRequesting=!1,this.frameRequestSize=0,this.frameRequestList=[],this.autoFrameRequesting=!1,this.autoFrameRequestCacheList=[],this.endpoint="",this._isSyncing=!1,this.config=t,this._isSyncing=1==t.roomStatus,this._client=e,this._player=new Player}get id(){return this.config.roomId}get roomType(){return this.config.roomType}get roomName(){return this.config.roomName}get roomCode(){return this.config.roomCode}get customRoomProperties(){return this.config.customRoomProperties}get ownerId(){return this.config.ownerId}get maxPlayers(){return this.config.maxPlayers}get players(){return this.config.players}get router(){return this.config.router}get isPrivate(){return this.config.isPrivate}get createTime(){return this.config.createTime}get player(){return this._player}get isSyncing(){return this._isSyncing}connect(e,t){this.connection=new Connection,this.connection.events.onmessage=this.onMessageCallback.bind(this),this.connection.events.onclose=e=>{5!=this.state&&(this.onDisconnect.emit({playerId:this.playerId},e),Logger.warn({eventType:"WebSocket Close",event:e})),this.setState(1),this.setRoomId(""),this.stopWSHeartbeat()},this.endpoint=this.buildEndpoint(e,t),this.connection.connect(this.endpoint)}sendFrame(e){var t;this.checkInSync();const r=ClientFrame.create({currentFrameId:this.frameId,timestamp:Date.now(),data:"string"==typeof e?[e]:e}),o=ClientMessage.create({timestamp:Date.now(),seq:this.sendFrame.name,code:4,msg:ClientFrame.encode(r).finish()});null===(t=this.connection)||void 0===t||t.send(ClientMessage.encode(o).finish())}requestFrame(e,t){var r;this.checkInSync(),this.checkNotInRequesting(),this.frameRequesting=!0,this.frameRequestSize=t;const o=Math.ceil(t/this.frameRequestMaxSize);let n=0;for(;n<o;){const o=e+this.frameRequestMaxSize*n,i=QueryFrame.create({mode:1,currentFrameId:o,size:Math.min(this.frameRequestMaxSize,t-n*this.frameRequestMaxSize)}),s=ClientMessage.create({timestamp:Date.now(),seq:this.requestFrame.name,code:6,msg:QueryFrame.encode(i).finish()});null===(r=this.connection)||void 0===r||r.send(ClientMessage.encode(s).finish()),n+=1}}removeAllListeners(){[this.onJoin,this.onLeave,this.onDismiss,this.onDisconnect,this.onStartFrameSync,this.onStopFrameSync,this.onRecvFrame].forEach((e=>e.clear()))}reconnect(){return __awaiter(this,void 0,void 0,(function*(){if(yield this._client.init(),!this.lastRoomId)throw new GOBEError(90002);const{roomInfo:e,ticket:t}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.room.join",roomId:this.config.roomId,customPlayerStatus:this._player.customStatus,customPlayerProperties:this._player.customProperties}));this.setState(4),this.setRoomId(e.roomId),yield heartbeat.send(4),this.connect(e.router.routerAddr,t)}))}startFrameSync(){return __awaiter(this,void 0,void 0,(function*(){this.checkNotInSync(),yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.frame.sync.begin",roomId:this.id}),yield heartbeat.send(6)}))}stopFrameSync(){return __awaiter(this,void 0,void 0,(function*(){this.checkInSync(),yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.frame.sync.stop",roomId:this.id}),yield heartbeat.send(7)}))}update(){return __awaiter(this,void 0,void 0,(function*(){const{roomInfo:e}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.room.detail",roomId:this.id});return Object.assign(this.config,e),this}))}leave(){return __awaiter(this,void 0,void 0,(function*(){yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.room.leave",roomId:this.id}),yield heartbeat.send(5),this.setState(5)}))}dismiss(){return __awaiter(this,void 0,void 0,(function*(){yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.room.dismiss",roomId:this.id}),yield heartbeat.send(5),this.setState(5)}))}removePlayer(e){return __awaiter(this,void 0,void 0,(function*(){this.checkNotInSync(),yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.room.remove",roomId:this.id,playerId:e})}))}onMessageCallback(e){return __awaiter(this,void 0,void 0,(function*(){const t=ServerMessage.decode(new Uint8Array(e.data)),{code:r}=t.toJSON(),{msg:o}=t;switch(r){case 1:this.clearRequestFrame(),this.startWSHeartbeat(),this.setState(2),this.setRoomId(this.id),this.onJoin.emit({playerId:this.playerId});break;case 8:this.setState(3),this.frameId=0,this._isSyncing=!0,this.onStartFrameSync.emit();break;case 10:{const e=RelayFrameInfo.decode(o).toJSON();this.autoFrameRequesting?this.autoFrameRequestCacheList.push(e):e.currentRoomFrameId-this.frameId>1?(this.autoFrameRequesting=!0,this.autoFrameRequestCacheList.push(e),this.requestFrame(this.frameId+1,e.currentRoomFrameId-this.frameId-1)):(this.frameId=e.currentRoomFrameId,this.onRecvFrame.emit(e));break}case 9:this.setState(2),this._isSyncing=!1,this.onStopFrameSync.emit();break;case 7:{const e=AckMessage.decode(o).toJSON();e.rtnCode&&0!=e.rtnCode&&(this.clearRequestFrame(),this.onRequestFrameError.emit(new GOBEError(e.rtnCode,e.msg)));break}case 17:{const e=QueryFrameResult.decode(o).toJSON().relayFrameInfos;if(this.frameRequestList.push(...e),this.frameRequestList.length==this.frameRequestSize){const e=this.autoFrameRequestCacheList,t=this.frameRequestList;t.sort(((e,t)=>e.currentRoomFrameId-t.currentRoomFrameId)),this.autoFrameRequesting?(this.clearRequestFrame(),this.frameId=e[e.length-1].currentRoomFrameId,this.onRecvFrame.emit([...t,...e])):(this.clearRequestFrame(),this.onRecvFrame.emit(t))}break}case 12:{const e=PlayerFrameInfo.decode(o).toJSON();this.onJoin.emit(e);break}case 13:{const e=PlayerFrameInfo.decode(o).toJSON();this.onLeave.emit(e);break}case 15:{const e=PlayerFrameInfo.decode(o).toJSON();this.onDisconnect.emit(e);break}case 16:yield heartbeat.send(5),this.setState(5),this.onDismiss.emit()}}))}clearRequestFrame(){this.frameRequesting=!1,this.frameRequestSize=0,this.frameRequestList=[],this.autoFrameRequesting=!1,this.autoFrameRequestCacheList=[]}startWSHeartbeat(){this.wsHeartbeatTimer=setInterval((()=>this.doWSHeartbeat()),5e3)}doWSHeartbeat(){var e;const t=ClientMessage.create({code:2,seq:this.doWSHeartbeat.name,timestamp:Date.now()});null===(e=this.connection)||void 0===e||e.send(ClientMessage.encode(t).finish())}stopWSHeartbeat(){this.wsHeartbeatTimer&&clearInterval(this.wsHeartbeatTimer)}buildEndpoint(e,t){return`wss://${e}/hw-game-obe/endpoint?sdkVersion=10105200&ticket=${t}`}checkInSync(){if(!this._isSyncing)throw new GOBEError(90005);return!0}checkNotInSync(){if(this._isSyncing)throw new GOBEError(90006);return!0}checkNotInRequesting(){if(this.frameRequesting)throw new GOBEError(90010);return!0}}class Group extends Base{constructor(e,t){super(),this.onJoin=createSignal(),this.onLeave=createSignal(),this.onDismiss=createSignal(),this.onUpdate=createSignal(),this.onMatchStart=createSignal(),this.config=t,this._client=e,this._player=new Player}get id(){return this.config.groupId}get groupName(){return this.config.groupName}get maxPlayers(){return this.config.maxPlayers}get ownerId(){return this.config.ownerId}get customGroupProperties(){return this.config.customGroupProperties}get isLock(){return this.config.isLock}get isPersistent(){return this.config.isPersistent}get players(){return this.config.players}get player(){return this._player}query(){return __awaiter(this,void 0,void 0,(function*(){const{groupInfo:e}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.group.detail",groupId:this.id});return Object.assign(this.config,e),this}))}leave(){return __awaiter(this,void 0,void 0,(function*(){yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.group.leave",groupId:this.id})}))}dismiss(){return __awaiter(this,void 0,void 0,(function*(){yield Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.group.dismiss",groupId:this.id})}))}updateGroup(e){return __awaiter(this,void 0,void 0,(function*(){this.checkUpdatePermission(),yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.group.change",groupId:this.id},e))}))}checkUpdatePermission(){if(this.playerId!=this.ownerId)throw new GOBEError(80003,"You are no permission to update!");return!0}onServerEventChange(e){return __awaiter(this,void 0,void 0,(function*(){switch(e.eventType){case 1:this.onMatchStart.emit(e);break;case 6:this.onJoin.emit(e);break;case 7:this.onLeave.emit(e);break;case 8:this._client.removeGroup(),this.onDismiss.emit(e);break;case 9:this.onUpdate.emit(e)}}))}removeAllListeners(){[this.onJoin,this.onLeave,this.onDismiss,this.onUpdate,this.onMatchStart].forEach((e=>e.clear()))}}class Client extends Base{constructor(e){super(),this._room=null,this._group=null,this._pollInterval=2e3,this._isMatching=!1,this._isCancelMatch=!1,this._loginTimestamp=0,this.setAppId(e.appId),this.setOpenId(e.openId),this._auth=new Auth(e.clientId,e.clientSecret,e.createSignature)}get room(){return this._room}get group(){return this._group}get loginTimestamp(){return this._loginTimestamp}init(){return __awaiter(this,void 0,void 0,(function*(){const{gameInfo:e,timeStamp:t}=yield this._auth.login();return this._loginTimestamp=t,e.httpTimeout&&(Request.timeout=e.httpTimeout),e.pollInterval&&(this._pollInterval=e.pollInterval),this}))}createRoom(e,t){return __awaiter(this,void 0,void 0,(function*(){this.checkCreateRoomConfig(e),this.checkInit(),this.checkCreateOrJoin();const{roomInfo:r,ticket:o}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.room.create",isPrivate:0},e,t));return this.setState(4),this.setRoomId(r.roomId),yield heartbeat.send(4),this._room=new Room(this,r),this._room.player.customStatus=null==t?void 0:t.customPlayerStatus,this._room.player.customProperties=null==t?void 0:t.customPlayerProperties,this._room.connect(r.router.routerAddr,o),this._room}))}createGroup(e,t){return __awaiter(this,void 0,void 0,(function*(){this.checkCreateGroupConfig(e),this.checkInit(),this.checkGroupCreateOrJoin();const{groupInfo:r}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign(Object.assign({method:"client.gobe.group.create"},e),t));return this.setGroupId(r.groupId),this._group=new Group(this,r),this._group.player.customStatus=null==t?void 0:t.customPlayerStatus,this._group.player.customProperties=null==t?void 0:t.customPlayerProperties,this._group}))}joinRoom(e,t){return __awaiter(this,void 0,void 0,(function*(){this.checkInit(),this.checkCreateOrJoin();const r=this.checkJoinRoomConfig(e),{roomInfo:o,ticket:n}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign(Object.assign({method:"client.gobe.room.join"},r),t));return this.setState(4),this.setRoomId(o.roomId),yield heartbeat.send(4),this._room=new Room(this,o),this._room.player.customStatus=null==t?void 0:t.customPlayerStatus,this._room.player.customProperties=null==t?void 0:t.customPlayerProperties,this._room.connect(o.router.routerAddr,n),this._room}))}joinGroup(e,t){return __awaiter(this,void 0,void 0,(function*(){this.checkInit(),this.checkGroupCreateOrJoin();const{groupInfo:r}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.group.join",groupId:e},t));return this.setGroupId(r.groupId),this._group=new Group(this,r),this._group.player.customStatus=null==t?void 0:t.customPlayerStatus,this._group.player.customProperties=null==t?void 0:t.customPlayerProperties,this._group}))}leaveRoom(){var e;return __awaiter(this,void 0,void 0,(function*(){return this.checkInit(),this.checkLeaveOrdismiss(),yield null===(e=this._room)||void 0===e?void 0:e.leave(),this}))}dismissRoom(){var e;return __awaiter(this,void 0,void 0,(function*(){return this.checkInit(),this.checkLeaveOrdismiss(),yield null===(e=this._room)||void 0===e?void 0:e.dismiss(),this}))}leaveGroup(){var e;return __awaiter(this,void 0,void 0,(function*(){return this.checkInit(),this.checkGroupLeaveOrdismiss(),yield null===(e=this._group)||void 0===e?void 0:e.leave(),this._group=null,this}))}dismissGroup(){var e;return __awaiter(this,void 0,void 0,(function*(){return this.checkInit(),this.checkGroupLeaveOrdismiss(),yield null===(e=this._group)||void 0===e?void 0:e.dismiss(),this._group=null,this}))}removeGroup(){this._group=null}getAvailableRooms(e){return __awaiter(this,void 0,void 0,(function*(){this.checkInit();const{rooms:t,count:r,offset:o,hasNext:n}=yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.room.list.query"},e));return{rooms:t,count:r,offset:o,hasNext:n}}))}matchRoom(e,t){return __awaiter(this,void 0,void 0,(function*(){this.checkInit(),this.checkCreateOrJoin();const r=this._pollInterval,o=Date.now();const n=yield function t(){return new Promise(((n,i)=>{Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.room.match"},e)).then((e=>n(e.roomId))).catch((e=>{104102==(null==e?void 0:e.code)?setTimeout((()=>{n(t())}),r):Date.now()-o>=3e5?i(new GOBEError(104103)):i(e)}))}))}();return this.joinRoom(n,t)}))}matchPlayer(e,t){return __awaiter(this,void 0,void 0,(function*(){this.checkInit(),this.checkCreateOrJoin();const r=yield this.matchPolling((()=>Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.online.match"},e))));return this.joinRoom(r,t)}))}matchGroup(e,t){var r;return __awaiter(this,void 0,void 0,(function*(){if(this.checkInit(),this.checkCreateOrJoin(),this.checkMatching(),(null===(r=this._group)||void 0===r?void 0:r.ownerId)==this.playerId){const t=yield Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.group.change",groupId:this.groupId,isLock:1})),{players:r}=t.groupInfo;if(r.length!=e.playerInfos.length)throw new GOBEError(90011);const o=r.map((e=>e.playerId)),n=new Set(o);for(const{playerId:t}of e.playerInfos)if(!n.has(t))throw new GOBEError(90011)}const o=yield this.matchPolling((()=>Request.post("/gamex-edge-service/v1/gameXClientApi",Object.assign({method:"client.gobe.group.match"},e))));return this.joinRoom(o,t)}))}cancelMatch(){this.checkInit(),this._isCancelMatch=!0}requestCancelMatch(){return new Promise(((e,t)=>{Request.post("/gamex-edge-service/v1/gameXClientApi",{method:"client.gobe.match.cancel"},void 0,!1).then((r=>{0===r.rtnCode?e(r):t(r)}))}))}matchPolling(e){return this._isMatching=!0,new Promise(((t,r)=>{this._isCancelMatch?this.requestCancelMatch().then((()=>{this._isMatching=!1,r(new GOBEError(104205))})).catch((o=>{104206===o.rtnCode&&o.roomId?(this._isMatching=!1,t(o.roomId)):104204===o.rtnCode?setTimeout((()=>{t(this.matchPolling(e))}),this._pollInterval):(this._isMatching=!1,r(o))})).finally((()=>{this._isCancelMatch=!1})):e().then((e=>{this._isMatching=!1,t(e.roomId)})).catch((o=>{104202===o.code?setTimeout((()=>{t(this.matchPolling(e))}),this._pollInterval):(this._isMatching=!1,r(o))}))}))}onStateChange(e,t){1==e&&0!=t&&(this._room=null)}checkInit(){if(0==this.state)throw new GOBEError(90001);return!0}checkCreateOrJoin(){if(this._room&&1!=this.state)throw new GOBEError(90003);return!0}checkGroupCreateOrJoin(){if(this._group&&1==this.state)throw new GOBEError(80004);return!0}checkLeaveOrdismiss(){if(!this._room&&1==this.state)throw new GOBEError(90002);return!0}checkGroupLeaveOrdismiss(){if(!this._group&&1==this.state)throw new GOBEError(80001);return!0}checkCreateRoomConfig(e){var t;if(((null===(t=e.roomName)||void 0===t?void 0:t.length)||0)>64)throw new GOBEError(10001);return!0}checkCreateGroupConfig(e){var t;if(((null===(t=e.groupName)||void 0===t?void 0:t.length)||0)>64)throw new GOBEError(80002);return!0}checkJoinRoomConfig(e){const t={roomId:"",roomCode:""};switch(e.length){case 6:t.roomCode=e;break;case 18:t.roomId=e;break;default:throw new GOBEError(90007)}return t}checkMatching(){if(this._isMatching)throw new GOBEError(90008);return!0}}class Random{constructor(e){if(this.mask=123459876,this.m=2147483647,this.a=16807,"number"!=typeof e||e!=e||e%1!=0||e<1)throw new TypeError("Seed must be a positive integer.");this.seed=e%1e8}getNumber(){this.seed=this.seed^this.mask,this.seed=this.a*this.seed%this.m;const e=this.seed/this.m;return this.seed=this.seed^this.mask,e}}heartbeat.schedule(),exports.Base=Base,exports.Client=Client,exports.EventEmitter=EventEmitter,exports.GOBEError=GOBEError,exports.Group=Group,exports.Player=Player,exports.RandomUtils=Random,exports.Room=Room,Object.defineProperty(exports,"__esModule",{value:!0})}));
