cc.Class({
    extends: cc.Component,

    properties: {

    },

    start() {
        const layout = cc.find('Canvas/layout');
        const str = 'Now Loading...';
        str.split('').forEach((word, idx) => {
            const node = new cc.Node();
            const label = node.addComponent(cc.Label);
            label.string = word;
            node.parent = layout;
            cc.tween(node)
                .delay(idx / 4)
                .by(0.3, { y: 50 }, { easing: 'sineOut' })
                .by(0.3, { y: -50 }, { easing: 'sineIn' })
                .delay((str.length - idx) / 4)
                .union()
                .repeatForever()
                .start();
        });
        const totalWidth = layout.children.reduce((width, node, idx) => {
            return width + node.width;
        }, 0);
        layout.width = totalWidth;

        const baseUrl = 'https://staging-teach.ireadabc.com';
        const uri = '/api/template/v1/middleLayer_for_debug'
        const reqData = {};

        this.callNetworkApiGet(baseUrl, uri, reqData, (respData) => {
            const data = JSON.parse(respData);
            const configData = data.data.conf.android;
            // configData.sceneName
            cc.assetManager.loadBundle(configData.bondleUrl, { version: configData.version }, async (err, bundle) => {
                if (err) {
                    return this.asyncDelayLog(err);
                }
                bundle.loadScene(configData.sceneName, (err, scene) => {
                    if (err) {
                        this.asyncDelayLog('err: ', err);
                    }
                    cc.director.runScene(scene);
                });
            });
        });
    },

    callNetworkApiGet(baseUrl, uri, data, callBack) {
        let queryStr = '?';
        for (const key in data) {
            if (Object.hasOwnProperty.call(data, key)) {
                const value = data[key];
                queryStr += `${key}=${value}`;
            }
        }
        const xhr = new XMLHttpRequest();
        xhr.onreadystatechange = () => {
            if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
                callBack(xhr.responseText);
            }
        };
        const url = `${baseUrl}${uri}${queryStr}`;
        console.log('url = ' + url);
        xhr.open('GET', url, true);
        xhr.send();
    },

});
