cc.Class({
    extends: cc.Component,

    properties: {

    },

    start() {
        const layout = cc.find('Canvas/layout');
        const str = 'Now Loading...';
        // str.split('').forEach((word, idx) => {
        //     const node = new cc.Node();
        //     const label = node.addComponent(cc.Label);
        //     label.string = word;
        //     node.parent = layout;
        //     cc.tween(node)
        //         .delay(idx / 4)
        //         .by(0.3, { y: 50 }, { easing: 'sineOut' })
        //         .by(0.3, { y: -50 }, { easing: 'sineIn' })
        //         .delay((str.length - idx) / 4)
        //         .union()
        //         .repeatForever()
        //         .start();
        // });
        const totalWidth = layout.children.reduce((width, node, idx) => {
            return width + node.width;
        }, 0);
        layout.width = totalWidth;

        const baseUrl = 'https://staging-openapi.iteachabc.com';
        const uri = '/api/template/v1/middleLayer_for_iplayabc'
        const reqData = {};

        cc.game.addPersistRootNode(cc.find('cacertNode'));

        this.callNetworkApiGet(baseUrl, uri, reqData, (respData) => {
            const data = JSON.parse(respData);
            let configData = data.data.conf.web_desktop;
            if (cc.sys.os == cc.sys.OS_IOS) {
                configData = data.data.conf.ios;
            } else if (cc.sys.os == cc.sys.OS_ANDROID) {
                configData = data.data.conf.android;
            }

            console.log('汪汪汪: ' + configData.sceneName);
            cc.assetManager.loadBundle(configData.bondleUrl, { version: configData.version }, async (err, bundle) => {
                if (err) {
                    console.log(err);
                    return;
                }

                // 方便Debug壳的打包
                const isDebug = cc.find('Canvas/MainScene').active === false;
                if(isDebug){
                    // 如果没有牛津的主界面，就显示debug的界面，方便调试
                    bundle.loadScene(configData.sceneName, null, null, (e, scene) => {
                        if (e) {
                            console.log(e);
                            return;
                        }
                        cc.director.runScene(scene);
                    });
                }

                const canvas = cc.find('Canvas');
                canvas.emit('MIDDLE_LAYER_LOADED', { scene: null });
                globalThis.configData = configData;
            });
        });
    },

    callNetworkApiGet(baseUrl, uri, data, callBack) {
        let queryStr = '?';
        for (const key in data) {
            if (Object.hasOwnProperty.call(data, key)) {
                const value = data[key];
                queryStr += `${key}=${value}`;
            }
        }
        const xhr = new XMLHttpRequest();
        xhr.onreadystatechange = () => {
            if (xhr.readyState == 4 && (xhr.status >= 200 && xhr.status < 400)) {
                callBack(xhr.responseText);
            }
        };
        const url = `${baseUrl}${uri}${queryStr}`;
        console.log('url = ' + url);
        xhr.open('GET', url, true);
        xhr.send();
    },

});
