var Light = cc.Class({
	extends: cc.Component,

	properties: {
		photo2: {
			default: [],
			type: cc.SpriteFrame,
			displayName: "图片资源"
		}
	},

	ctor: function () {
		Light.inst = this;
		g.Light = Light;
	},

	addLightNum(Num) {
		let length = Num;
		const starLayout = cc.find('Canvas/bg/connent/nodCenter/bg_trafficlight2');
		starLayout.removeAllChildren();

		//最大长度
		this.MaxLength = length

		for (let i = 0; i < length; i++) {
			const starBase = cc.instantiate(cc.find('itemLigth'));
			starBase.getChildByName("sprite").getComponent(cc.Sprite).spriteFrame = this.photo2[i % 3];
			starBase.name = `itemLigth_${i}`;
			starBase.parent = starLayout;
		}
		this.currentStarIdx = 0;

		if (length <= 3) {
			for (let j = 0; j < 3 - length; j++) {
				var starBase2 = cc.instantiate(cc.find('itemLigth2'));
				starBase2.parent = starLayout;
			}
		}
	},

	showLight() {
		if (this.currentStarIdx >= this.MaxLength) {
			return -1
		}
		if (!this.currentStarIdx) {
			this.currentStarIdx = 0;
		}
		const starBase = cc.find(`Canvas/bg/connent/nodCenter/bg_trafficlight2/itemLigth_${this.currentStarIdx}`);
		starBase.getChildByName("sprite").active = true;
		this.currentStarIdx++;
		if (this.currentStarIdx >= this.MaxLength) {
			return -1
		}
	}
});
