const { asyncDelay } = require("../common/demo_jj_game_02_utils");

/**
 * 资源管理器
 */
g.res_mgr = {
	//获得表数据数据
	getFormData() {
		console.log('初始化数据');
		
		if (window && window.courseware) {
			window.courseware.getData((res) => {
				//存入数据管理器
				g.data_mgr.data = res;
				//数据处理
				g.data_mgr.proGameData();
				console.log("获得表单数据:" + res);
			});
			return;
		}

		const middleLayer = cc.find('middleLayer');
		if (middleLayer) {
			const middleLayerComponent = middleLayer.getComponent('middleLayer');
			middleLayerComponent.getData((res) => {
				//存入数据管理器
				g.data_mgr.data = res;
				//数据处理
				g.data_mgr.proGameData();
				console.log("获得表单数据:" + res);
			});
			return;
		}

		//console.error('没有查找到courseware.getData方法', error);
		//获得默认数据
		g.data_mgr.data = g.data_mgr.getDefaultData();
		//数据处理
		g.data_mgr.proGameData();
	},

	//得到图片资源
	getSpriteFrimeByUrl(url, cb) {
		cc.assetManager.loadRemote(url, cc.SpriteFrame, (e, sp) => {
			const spriteFrame = new cc.SpriteFrame(sp)
			cb && cb(spriteFrame);
		});
	},

	playAudioByUrl(audio_url, cb) {
		if (audio_url) {
			cc.assetManager.loadRemote(audio_url, (err, audioClip) => {
				cb && cb(audioClip);
			});
		}
	},


	playAudioByUrlAndId(audio_url, cb = null, loadCb = null) {
		return new Promise((resolve, reject) => {
			if (!audio_url) return resolve(null);
	
			cc.assetManager.loadRemote(audio_url, (err, audioClip) => {
				cc.audioEngine.stopAll();
				const audioId = cc.audioEngine.play(audioClip, false);
				cc.audioEngine.setFinishCallback(audioId, () => {
					cb && cb();
					resolve(audioId);
				});
				loadCb && loadCb(audioId);
			});
		});
	},

	

	//加载龙骨
	loadSpine(animationDisplay, Info) {
		if (Info.type == 'Image') {
			return;
		}
		cc.assetManager.loadAny([{ url: Info.tex_json, ext: '.txt' }, { url: Info.ske_json, ext: '.txt' }], (error, assets) => {
			if (error) {
				console.log(error)
			}
			else {
				cc.assetManager.loadRemote(Info.tex_png, (error, texture) => {
					if (error) {
						console.log(error)
					}
					else {
						var atlas = new dragonBones.DragonBonesAtlasAsset();
						atlas._uuid = Info.tex_json;
						atlas.atlasJson = assets[0];
						atlas.texture = texture;

						var asset = new dragonBones.DragonBonesAsset();
						asset._uuid = Info.ske_json;
						asset.dragonBonesJson = assets[1];

						animationDisplay.dragonAtlasAsset = atlas;
						animationDisplay.dragonAsset = asset;
						let data = asset._dragonBonesJsonData.armature[0];
						if (!data) {
							return;
						}
						animationDisplay.armatureName = data.name;
						g.data_mgr.dragonName = data.animation[0].name;

						animationDisplay.node.active = true;
					}
				});
			}
		});
	},




// -------------------- 数据上报 --------------------

  setSRRecord(key, value) {
	const middleLayer = cc.find('middleLayer');
	if (middleLayer) {
	  const middleLayerComponent = middleLayer.getComponent('middleLayer');
	  middleLayerComponent.setSRRecord(key, value);
	} else {
	  console.log('setSRRecord');
	}
  },
  
   addSRAudioDuration( value) {
	const middleLayer = cc.find('middleLayer');
	if (middleLayer) {
	  const middleLayerComponent = middleLayer.getComponent('middleLayer');
	  middleLayerComponent.addSRAudioDuration(value);
	} else {
	  console.log('addSRAudioDuration');
	}
  },
  
   showSRResultByRecord(isShowScore) {
	const middleLayer = cc.find('middleLayer');
	if (middleLayer) {
	  const middleLayerComponent = middleLayer.getComponent('middleLayer');
	  middleLayerComponent.showSRResultByRecord(isShowScore);
	} else {
	  console.log('showSRResultByRecord');
	}
  },
  
  
   setTotalQuestions(total) {
	const middleLayer = cc.find('middleLayer');
	if (middleLayer) {
		middleLayer.getComponent('middleLayer').setTotalQuestions(total);    
	} else {
		console.log(total);
	}
  },
  
  
   setQuestionResult(index, score) {
	const middleLayer = cc.find('middleLayer');
	if (middleLayer) {
		middleLayer.getComponent('middleLayer').setQuestionResult(index, score);    
	} else {
		console.log(index, score);
	}
  },
  
  
   showSRResultByQuestion(isShowScore) {
	const middleLayer = cc.find('middleLayer');
	if (middleLayer) {
		middleLayer.getComponent('middleLayer').showSRResultByQuestion(isShowScore);    
	} else {
		console.log();
	}
  },
  
   async showSRResultByAllRight(isShowScore = false)  {
	this.setTotalQuestions(1);
	await asyncDelay(0.1);
	this.setQuestionResult(0, 100);
	await asyncDelay(0.1);
	this.showSRResultByQuestion(isShowScore);
  }
}