const tools = require("../script/demo_jj_game_02_tools");
var onlyOne
cc.Class({
	extends: cc.Component,

	properties: {
		quan: cc.Node,
		tipsAnim: cc.Animation,
		sprite: cc.Sprite,
		db: dragonBones.ArmatureDisplay
	},

	data: null,

	onLoad() {
		this._playing = false
		this.quan.active = false
		this.tipsAnim.node.active = false
	},

	onEnable() {
		this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this)
	},

	onDisable() {
		this.node.off(cc.Node.EventType.TOUCH_START, this.onTouchStart, this)
	},

	initWithData(data, scale, xvalue, yvalue) {
		this.data = data
		let rect = this.data.rect

		this.node.x = (rect.x + rect.width / 2) * scale + xvalue
		this.node.y = (rect.y + rect.height / 2) * scale + yvalue
		this.node.width = rect.width * scale
		this.node.height = rect.height * scale
		this.sprite.node.active = false

		let comps = this.getComponentsInChildren(cc.Widget)
		for (let one of comps) {
			one.updateAlignment()
		}
		this.audioId = null
		this._isComplent = false;
	},

	onTouchStart() {
		if (g.data_mgr.nodPlayer) {
			g.data_mgr.nodPlayer.onStopAudio();
		}
		if (this._playing) return
		if (this.audioId) return
		if (this.data) {
			if (!this._isComplent) {
				this.db.node.active = true;
				this.playCatDragon();
				g.game.inst.onBtnCheck();
				//已经完成
				this._isComplent = true;
			}

			if (this.data.pic_url && this.data.gIdx == 0) {
				tools.getSpriteFrimeByUrl(this.data.pic_url, (sp) => {
					this.sprite.spriteFrame = sp
					this.sprite.node.width = this.node.width
					this.sprite.node.height = this.node.height
					this.sprite.node.active = true
				})
			}
			this.quan.active = true

			if (!this._playing) {
				this._playing = true;
				g.data_mgr.nodPlayer = this;
				cc.systemEvent.once('stopMusic', this.onStopAudio, this)
				// if (onlyOne != this) {
				//     this._playing = false
				//     return
				// }
				let url = this.data.audio_url
				if (url && url != '') {
					setTimeout(() => {
						// this.playAudio(url)
						g.res_mgr.playAudioByUrlAndId(url, () => {
						}, (audioId) => {
							const duration = cc.audioEngine.getDuration(audioId);
							g.res_mgr.addSRAudioDuration(duration);
						});
					}, 500)
				} else {
					this._playing = false
				}
			}

			// if (onlyOne && onlyOne != this) {
			//     onlyOne.hideBox()
			// }
			// onlyOne = this
		}
	},

	//播放猫动画
	playCatDragon() {
		this.db.armatureName = "Armature";
		this.db.playAnimation("newAnimation", 1);
	},

	onClickHide() {
		this.sprite.node.active = false
		this.hideBox()
	},

	/**隐藏边框 */
	hideBox() {
		this.quan.active = false
		this.stopAudio()
	},

	/** 播放音乐 */
	playAudio(url) {
		cc.assetManager.loadRemote(url, (err, audioClip) => {
			if (err) return
			if (!this._playing) return
			this.audioId = cc.audioEngine.play(audioClip, false, 0.8);
			cc.audioEngine.setFinishCallback(this.audioId, this.stopAudio.bind(this));
			this.tipsAnim.node.active = true
			this.tipsAnim.play()
		});
	},

	onStopAudio() {
		this._playing = false
		this.stopAudio()
	},
	stopAudio() {
		g.data_mgr.nodPlayer = null;
		this._playing = false
		if (this.audioId != null) {
			cc.audioEngine.stop(this.audioId)
			this.audioId = null
		}
		this.tipsAnim.stop()
		this.tipsAnim.node.active = false
		cc.systemEvent.off('stopMusic', this.onStopAudio, this)
	},
	/** 音频id */
	audioId: null,
});
