/**
 * item
 */

cc.Class({
	extends: cc.Component,

	properties: {
		Item_name: {
			default: null,
			type: cc.Label,
			displayName: "名字"
		},
		Item_redName: {
			default: null,
			type: cc.Label,
			displayName: "红色名字"
		},
		Item_photo: {
			default: null,
			type: cc.Node,
			displayName: "图片"
		},
		Item_complete: {
			default: null,
			type: cc.Node,
			displayName: "完成显示"
		},
	},

	start: function () {
		this.node.on(cc.Node.EventType.TOUCH_START, this.touchBegan, this);
		this.node.on(cc.Node.EventType.TOUCH_MOVE, this.touchMove, this);
		this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
		this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchCancel, this);
	},

	//触摸开始
	touchBegan: function (event) {
		this.isMove = false;
		this.deltaPos = this.node.x + this.node.y;
	},

	//触摸移动
	touchMove: function (event) {
		console.log("触发移动事件")

		if (this.node.isComplent || this._isRotate) {
			console.log("移动停止")
			return
		}

		var delta = event.getDelta();
		this.node.x += delta.x;
		this.node.y += delta.y;

		console.log("开始移动", "x坐标：" + this.node.x, "y坐标：" + this.node.y)

		var deltaPos = this.node.x + this.node.y;
		if (Math.abs(this.deltaPos - deltaPos) > 10) {
			this.isMove = true;
		}
	},


	//触摸结束
	touchEnd: function (event) {
		//获得世界坐标
		var posScreen = event.getLocation(); //点击事件获取位置
		var posNode = this.node.convertToNodeSpaceAR(posScreen);
		console.log("世界坐标" + posNode);

		if (!this.isMove) {
			cc.log("点击了");
			this.onBtnRotate();
			//回到原来的位置
			this.node.x = 0;
			this.node.y = 0;
			return
		}

		var answer = g.game.inst.checkAnswer(this.node, this.node.type);

		if (answer) {
			this.setItemState(answer);
		} else {
			this.errorEffect();
		}
	},

	setItemState: function (content) {
		this.Item_complete.active = true;
		this.node.isComplent = true;
		g.data_mgr.nowNum -= 1;
		if (g.data_mgr.nowNum == 0) {
			setTimeout(() => {
				g.speaker.inst.play_congratulation();
				g.effect.inst.showEffect2();
			}, 500)
		}
		g.speaker.inst.play_good();

		if (g.game.inst.getOptionType() == 2) {
			// newItem_temp.scale = 0.8;
			// this.node.scale = this.node.scale * 0.8;
			var newItem_temp = cc.instantiate(g.game.inst.Item_0[3]);
		} else {
			var newItem_temp = cc.instantiate(g.game.inst.Item_0[2]);
		}
		// var newItem_temp = cc.instantiate(g.game.inst.Item_0[2]);

		content.getChildByName("db").active = true;
		content.getChildByName("db").getComponent(dragonBones.ArmatureDisplay).playAnimation("newAnimation", 1);
		if (this.node.width >= 150) {
			if (g.game.inst.getOptionType() == 2) {
				this.node.scale = 0.45;
				this.node.x = 0;
			} else {
				this.node.scale = 0.6;
				this.node.x = 0;
			}
		} else {
			if (g.game.inst.getOptionType() == 2) {
				this.node.scale = 0.7;
				this.node.x = 0;
			} else {
				this.node.scale = 0.9;
				this.node.x = 0;
			}
		}

		this.node.parent = newItem_temp;

		newItem_temp.parent = content.getChildByName("scrollView").getChildByName("view").getChildByName("content");

		this.node.x = 0;
		this.node.y = 0;
	},

	errorEffect: function () {
		g.speaker.inst.play_error();

		this.node.getChildByName("red").active = true;
		cc.tween(this.node)
			.to(0.1, { scaleY: 0.9, scaleX: 1.1 })
			.to(0.15, { scaleY: 1.1, scaleX: 0.9 })
			.to(0.1, { scaleY: 1, scaleX: 1 })
			.start()
		setTimeout(() => {
			this.node.getChildByName("red").active = false;
			//回到原来的位置
			this.node.x = 0;
			this.node.y = 0;
		}, 500)
	},

	//触摸取消
	touchCancel: function (event) {
		//回到原来的位置
		this.node.x = 0;
		this.node.y = 0;

		this.isMove = false;
	},

	//更新界面ui
	updateUI: function (Info) {
		//当前数据
		this.itemInfo = Info;

		//初始化数据
		this.InitData();

		//是否已经完成了
		this.node.isComplent = false;
	},

	//点击翻面
	onBtnRotate: function () {
		//翻面音效
		g.speaker.inst.play_btn();

		var scaleX = this.node.scaleY;

		this._isRotate = true;
		setTimeout(() => {
			this._isRotate = false;
		}, 600)

		cc.tween(this.node)
			.to(0.3, { scaleX: 0 })
			.call(() => {
				if (this.Item_name.node.active) {
					this.Item_name.node.active = false;
					this.Item_photo.active = true;
					this.Item_redName.node.active = false;
				} else {
					this.Item_name.node.active = true;
					this.Item_photo.active = false;
					this.Item_redName.node.active = true;
				}
			})
			.to(0.3, { scaleX: scaleX })
			.start();
	},

	//初始化信息
	InitData: function () {
		//设置图片
		g.res_mgr.getSpriteFrimeByUrl(this.itemInfo.picUrl, (list) => {

			this.Item_photo.getComponent(cc.Sprite).spriteFrame = list;
			this.photoScare(this.Item_photo, g.game.inst.idx);
			// this.photoScare(this.nodeState[2].getChildByName("spt_item"), 1);
		});
		//设置名字
		this.Item_name.string = this.itemInfo.word;
		//设置红色名字
		this.Item_redName.string = this.itemInfo.word;
	},

	//图片适配
	photoScare: function (node, type) {
		var maxNum = type == 0 ? 50 : 75;
		let maxSize = Math.min(maxNum / node.height, maxNum / node.width);
		if (node.perScale == undefined) {
			node.perScale = node.scaleX;
		} else {
			node.scaleX = node.perScale;
			node.scaleY = node.perScale;
		}
		node.scaleX *= maxSize;
		node.scaleY *= maxSize;
	},
});
