// 事件汞
let eventList = {};	// 响应列表（元素结构：eventName,[[target:cb]]）
g.event_mgr = {
	// 注册事件-响应 入参：事件名、响应、目标名
	reg: function (eventName, cb, target) {
		var event = eventList[eventName];
		if (!event) {
			event = eventList[eventName] = {};
		}
		event[target] = cb;
	},
	// 注销事件-响应 入参：事件名、目标名
	unReg: function (eventName, target) {
		var event = eventList[eventName];
		if (event) {
			if (event[target]) {
				event[target] = null;
			}
		}
	},
	unRegName: function (eventName) {
		eventList[eventName] = {};
	},
	// 广播事件 入参：事件名、参数
	send: function (eventName, params) {
		var event = eventList[eventName];
		if (event) {
			for (var target in event) {
				var cb = event[target];
				if (cb) {
					cb(params);
				}
			}
		}
	},
	getReglist: function () {
		return eventList;
	}
};