
/**
 * 游戏主逻辑
 */
var game = cc.Class({
	extends: cc.Component,

	properties: {
		btnRestart: {
			default: null,
			type: cc.Node,
			displayName: "重开按钮"
		}
	},

	ctor: function () {
		game.inst = this;
		g.game = game;
	},

	// 生命周期 onLoad
	onLoad() {
		//初始化游戏
		this.initGame();
		if (window.addEventListener) {
			window.addEventListener('resize', this.scaleEventCallBack, false)
		} else if (window.attachEvent) {
			window.attachEvent('resize', this.scaleEventCallBack, false)
		}
		cc.debug.setDisplayStats(false);
	},

	//屏幕缩放
	scaleEventCallBack: function () {
		g.event_mgr.send("adjustUI");
	},

	//初始化游戏
	initGame: function () {
		//获得数据
		g.res_mgr.getFormData();
	},

	onBtnTest() {
		g.Light.inst.addLightNum(3);
	},
	onBtnTest2() {
		g.Light.inst.showLight();
	},

	//检查当前缩放倍数
	checkScale: function (num) {
		var scale = 1;
		if (num > 2 && num <= 4) {
			scale = 0.74
		}
		if (num > 4) {
			scale = 0.65
		}
		return scale;
	},

	//添加节点
	addItem: function () {
		let itemArr = g.data_mgr.getSheepArr();
		this.idx = this.checkNodeParent();
		g.data_mgr.nowNum = itemArr.length;

		itemArr.sort(function () { return Math.random() > 0.5 ? -1 : 1; })


		for (var i = 0; i < itemArr.length; i++) {
			let newItem_0 = cc.instantiate(this.Item_0[itemArr.length > 14 ? 0 : 1]);
			//更新子项
			var com = newItem_0.getChildByName("item").getComponent("item");
			let itemInfo = itemArr[i];
			com.updateUI(itemInfo);
			newItem_0.active = true;
			//设置类别
			let sheepInfo = g.data_mgr.getSheep(i);
			newItem_0.getChildByName("item").type = this.checkType(sheepInfo.sheepfoldId);


			newItem_0.parent = this.contentArr_2[this.idx];
		};
	},

	//检测放到哪个节点底下
	checkNodeParent: function () {
		//获取到总列表
		var itemArr = g.data_mgr.getSheepArr();

		//
		if (itemArr.length <= 7) {
			this.contentArr_2[1].active = true;
			var idx = 1;
		} else {
			this.contentArr_2[0].active = true;
			var idx = 0;
		}
		return idx;
	},

	//检查类别
	checkType: function (Id) {
		for (var i in g.data_mgr.getSheepfoldArr()) {
			var sheepfoldInfo = g.data_mgr.getSheepfoldArr()[i];
			if (Id == sheepfoldInfo.id) {
				return ~~i + 1;
			}
		}
		return -1;
	},

	//设置目标节点类型
	setOptionType: function () {
		//设置类型
		this.OptionType = g.data_mgr.getSheepfoldArr().length - 3;
	},

	getOptionType: function () {
		return this.OptionType;
	},

	//更新界面信息
	UpdataUi: function () {
		this.btnRestart.active = false;

		//设置题目长度
		g.scoreStart.inst.addStar(g.data_mgr.data.starArr.length);
		g.data_mgr.ansId = 0;
		g.data_mgr.startId = 0;
		//初始化单题题目
		this.InitQuestion();
	},

	//初始化单个题目
	InitQuestion() {
		var question = g.data_mgr.data.starArr[g.data_mgr.startId].queArr[g.data_mgr.ansId]
		//初始化灯
		g.Light.inst.addLightNum(question.hotZoneItemArr.length);
		//初始化标题
		g.titleType.inst.showTitle(question.title, question.title_audio_url);
		if (question.title_audio_url) {
			g.data_mgr.gameState = 2;
			setTimeout(() => {
				g.titleType.inst.onBtnPlayEffect();
			}, 500)
		}
		//设置中间图片
		g.picNode.inst.onShow(question);
	},

	onBtnCheck() {
		//默认答对

		//播放特效

		//灯+1
		g.speaker.inst.playEffect(g.enum.E_Audio.Right);
		let num = g.Light.inst.showLight();
		if (num == -1) {
			g.data_mgr.ansId += 1;
			if (g.data_mgr.ansId >= g.data_mgr.data.starArr[g.data_mgr.startId].queArr.length) {
				//大星星音效
				g.speaker.inst.playEffect(g.enum.E_Audio.Star);
				g.scoreStart.inst.showStar();
				g.data_mgr.ansId = 0;
				g.data_mgr.startId += 1;
			}
			setTimeout(() => {
				if (g.data_mgr.startId >= g.data_mgr.data.starArr.length) {
					g.speaker.inst.playEffect(g.enum.E_Audio.Flowers);
					g.effect.inst.showEffect2();
					this.btnRestart.active = true;
					const middleLayer = cc.find('middleLayer');
					if (middleLayer) {
						const middleLayerComponent = middleLayer.getComponent('middleLayer');
						if (middleLayerComponent.role == 'student') {
							middleLayerComponent.onHomeworkFinish(() => { });
						}
					} else {
						console.log('onHomeworkFinish');
					}

					g.res_mgr.showSRResultByAllRight();
				} else {
					this.InitQuestion();
				}
			}, 1500)
		}
	},

	//播放标题音效
	playAudioTitle: function () {
		//获得播放路径
		var path = g.data_mgr.data.audio_url;
		// g.res_mgr.playAudioByUrl(path, (url) => {
		// 	g.snd_mgr.playEffect(url, null);
		// });

		g.res_mgr.playAudioByUrlAndId(path, () => {
		}, (audioId) => {
			const duration = cc.audioEngine.getDuration(audioId);
			g.res_mgr.addSRAudioDuration(duration);
		});
	},

	//重置UI界面
	resetUI: function () {
		//移除所有子节点
		this.contentArr_2[0].removeAllChildren();
		this.contentArr_2[1].removeAllChildren();
		//移除所有子节点
		g.event_mgr.send("reSetGame");
	},

	//重新开始
	onBtnReStart: function () {
		g.speaker.inst.playEffect(g.enum.E_Audio.BtnCommom);
		//移除所有计时器
		this.unscheduleAllCallbacks();
		//初始化界面
		this.UpdataUi();
	},

	//游戏开始
	gameStart: function () {
		console.log("游戏开始:" + g.data_mgr);
		//播放一个上面的音乐
		this.setAudioInfo(1);
	},


	checkAnswer(caller, option_i) {
		if (caller == undefined) {
			return;
		}

		if (option_i != -1) {
			let nodOption = this.contType[this.OptionType].children[option_i - 1]
			if (nodOption) {

				let AABB = nodOption.getComponent("DragGameOptionObject").setAABB();
				let callerAABB = this.getCallerAABB(caller);
				var isIntersect = AABB.containsRect(callerAABB);//判断是否被包含
				console.log(isIntersect)
				if (isIntersect) {
					return nodOption;
				}
				return false
			}
		}
	},

	getCallerAABB(caller) {
		let svLeftBottomPoint = caller.parent.convertToWorldSpaceAR(
			cc.v2(
				caller.x,
				caller.y
			)
		);
		var posNode_1 = cc.rect(
			svLeftBottomPoint.x,
			svLeftBottomPoint.y,
			0,
			0
		);
		return posNode_1
	},






});
