/**
 * 适配
 */
cc.Class({
	extends: cc.Component,

	properties: {
		UIMax: {
			default: [],
			type: cc.Node,
			displayName: "等比放大"
		},
		topUI: {
			default: [],
			type: cc.Widget,
		},

		bgScaleMax: {
			default: [],
			type: cc.Node,
			displayName: "背景适配"
		},

		nodeUIOffset: {
			default: [],
			type: cc.Node,
			displayName: "节点偏移"
		},

		canvasView: {
			default: null,
			type: cc.Canvas,
			displayName: "根节点"
		},
		isCanvas: {
			default: false,
		}
	},

	onLoad: function () { //开启适配
		this.widgetList = [];

		this.scheduleOnce(function () {
			if (!this.isCanvas) {
				this.init();
			} else {
				var canvaSize = this.findCanvas();
				var w = (canvaSize.width) / 720;
				var h = (canvaSize.height) / 1280;
				this.MaxSize = w / h > 1 ? w / h : h / w;

				this.setUIMax(this.MaxSize);
				this.settopUI(this.MaxSize);
				this.setBgScale();
				this.setUiPositon();
				var scene = cc.director.getScene();

				var list = scene.getComponentsInChildren(cc.Widget)
				for (var i in list) {
					list[i].updateAlignment();
				}
			}
		}, 0);

		g.event_mgr.reg("adjustUI", () => {
			this.setBgScale();
			this.setUiPositon();
		});
		this.MaxSize = 1;
	},
	init: function () {
		var canvaSize = this.findCanvas();
		cc.director._scene.width = canvaSize.width;
		cc.director._scene.height = canvaSize.height;

		var diff = canvaSize.width / canvaSize.height;
		var bili = 750 / 1334;
		if (diff > bili) {
			this.canvasView.fitWidth = false;
			this.canvasView.fitHeight = true;
		} else if (diff < bili) {
			this.canvasView.fitWidth = true;
			this.canvasView.fitHeight = false;
		} else {
			this.canvasView.fitWidth = true;
			this.canvasView.fitHeight = true;
		}
		var w = (canvaSize.width) / 750;
		var h = (canvaSize.height) / 1334;
		this.MaxSize = w / h > 1 ? w / h : h / w;

		g.data_mgr.MaxSize = this.MaxSize;
		this.setUIMax(this.MaxSize);
		this.settopUI(this.MaxSize);
		this.setBgScale();
		this.setUiPositon();
		var scene = cc.director.getScene();
		var list = scene.getComponentsInChildren(cc.Widget)
		for (var i in list) {
			list[i].updateAlignment();
		}
	},

	onDestroy: function () {
		if (g.event_pump) {
			g.event_pump.unReg("adjustUI");
		}
	},
	settopUI: function (s) {
		if (!g.data_mgr.phoneInfo) {
			return;
		}
		var top = g.data_mgr.phoneInfo;
		top = top * s;
		for (var i in this.topUI) {
			if (this.topUI[i].perTop == undefined) {
				this.topUI[i].perTop = this.topUI[i].top;

			} else {
				this.topUI[i].top = this.topUI[i].perTop;
			}
			this.topUI[i].top += top;
			console.log(this.topUI[i].top);
		}
	},

	//背景适配
	setBgScale: function () {
		for (var i in this.bgScaleMax) {
			// 1. 先找到 SHOW_ALL 模式适配之后，本节点的实际宽高以及初始缩放值
			let scaleForShowAll = Math.min(
				cc.view.getCanvasSize().width / this.bgScaleMax[i].width,
				cc.view.getCanvasSize().height / this.bgScaleMax[i].height
			);
			let realWidth = this.bgScaleMax[i].width * scaleForShowAll;
			let realHeight = this.bgScaleMax[i].height * scaleForShowAll;

			// 2. 基于第一步的数据，再做缩放适配
			this.bgScaleMax[i].scale = Math.max(
				cc.view.getCanvasSize().width / realWidth,
				cc.view.getCanvasSize().height / realHeight
			);
		}
	},

	//适配节点位置
	setUiPositon: function () {
		for (var i in this.nodeUIOffset) {
			// 1. 先找到 SHOW_ALL 模式适配之后，本节点的实际宽高以及初始缩放值
			let srcScaleForShowAll = Math.min(
				cc.view.getCanvasSize().width / 1280,
				cc.view.getCanvasSize().height / 720
			);
			let realWidth = 1280 * srcScaleForShowAll;
			let realHeight = 720 * srcScaleForShowAll;

			// 2. 基于第一步的数据，再做节点宽高重置
			this.nodeUIOffset[i].width = 1280 * (cc.view.getCanvasSize().width / realWidth);
			this.nodeUIOffset[i].height = 720 * (cc.view.getCanvasSize().height / realHeight);
		}
	},

	setUIMax: function (size) {
		for (var i in this.UIMax) {
			if (this.UIMax[i].perScale == undefined) {
				this.UIMax[i].perScale = this.UIMax[i].scaleX;

			} else {
				this.UIMax[i].scaleX = this.UIMax[i].perScale;
				this.UIMax[i].scaleY = this.UIMax[i].perScale;
			}
			this.UIMax[i].scaleX *= size;
			this.UIMax[i].scaleY *= size;
		}
	},
	findCanvas: function () {
		if (cc.sys.isNative) {
			return {
				width: cc.view.getFrameSize().width,
				height: cc.view.getFrameSize().height
			};
		} else {
			return {
				width: cc.game.canvas.clientWidth,
				height: cc.game.canvas.clientHeight
			};
		}
	}
});
