// Learn cc.Class:
//  - https://docs.cocos.com/creator/manual/en/scripting/class.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

var scoreStart = cc.Class({
    extends: cc.Component,

    properties: {
    },

    ctor: function () {
        scoreStart.inst = this;
        g.scoreStart = scoreStart;
    },

    addStar(num) {
        let length = num;

        const starLayout = cc.find('Canvas/bg/connent/nodCenter/Layout');
        starLayout.removeAllChildren();

        for (let i = 0; i < length; i++) {
            const starBase = cc.instantiate(cc.find('StarBase'));
            starBase.name = `starBase_${i}`;
            starBase.parent = starLayout;
        }
        this.currentStarIdx = 0;
    },

    currentStarIdx: null,
    showStar() {
        if (!this.currentStarIdx) {
            this.currentStarIdx = 0;
        }

        const starBase = cc.find(`Canvas/bg/connent/nodCenter/Layout/starBase_${this.currentStarIdx}`);
        if (!starBase) {
            return;
        }
        const star = starBase.getChildByName('Star');
        const starBig = star.getChildByName('StarBig');
        starBig.scale = 1;
        star.active = true;
        star.scaleX = 0.7 / starBase.scale;
        star.scaleY = 1 / starBase.scale;
        star.angle = 90;
        const canvas = cc.find('Canvas');
        const startPos = this.exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 2));
        const middlePos = this.exchangeNodePos(star.parent, canvas, cc.v2(0, -canvas.height / 4));
        star.x = startPos.x;
        star.y = startPos.y - starBig.height;

        console.log('middlePos = ' + JSON.stringify(middlePos));
        const time = 1;
        cc.tween(star)
            .to(0.3, { y: middlePos.y + 80 }, { easing: 'quadOut' })
            .to(0.1, { y: middlePos.y + 40, scaleX: 1.2 / starBase.scale, scaleY: 0.8 / starBase.scale }, { easing: 'quadOut' })
            .to(0.1, { y: middlePos.y, scaleX: 1 / starBase.scale, scaleY: 1 / starBase.scale }, { easing: 'quadOut' })
            .delay(0.1)
            .to(0.8, { angle: -720, scale: 1 })
            .start();

        cc.tween(star)
            .delay(0.6)
            .to(0.8, { x: 0 }, { easing: 'quadIn' })
            .start();
        cc.tween(star)
            .delay(0.6)
            .to(0.8, { y: 0 }, { easing: 'quadOut' })
            .start();

        cc.tween(starBig)
            .delay(0.6)
            .to(0.8, { scale: 0 }, { easing: 'quadOut' })
            .call(() => {
                // this.checkGameEnd();
            })
            .start();

        this.currentStarIdx++;
    },

    Between(a, b, c) {
        return [a, b, c].sort()[1];
    },

    exchangeNodePos(targetNode, baseNode, basePos) {
        return targetNode.convertToNodeSpaceAR(baseNode.convertToWorldSpaceAR(cc.v2(basePos.x, basePos.y)));
    },

});
