var titleType = cc.Class({
	extends: cc.Component,

	properties: {
		TitleType: {
			default: [],
			type: cc.Node,
			displayName: "标题类型"
		}
	},

	ctor: function () {
		titleType.inst = this;
		g.titleType = titleType;
	},
	start() {

	},

	//显示标题
	showTitle(lab, audio) {
		this.unschedule(this.setSndEff);
		var nodTitle = this.checkNode(lab, audio);
		this.lab = lab;
		this.stopAudio();
		this.audio = audio;
		this.updateUi(nodTitle)

		//设置contentArr位置
		nodTitle.y += 150;
		cc.tween(nodTitle)
			.to(0.8, { y: nodTitle.y - 150 })
			.start();

		nodTitle.active = true;
	},

	stopAudio() {
		cc.audioEngine.stop(this.audio)
	},

	//更新界面
	updateUi(nodTitle) {
		nodTitle.getChildByName("title") && (nodTitle.getChildByName("title").getComponent(cc.Label).string = this.lab)
		this.btnSnd = nodTitle.getChildByName("audio") && nodTitle.getChildByName("audio").getChildByName("audio")
	},

	onBtnPlayEffect() {
		//获得播放路径
		this.schedule(this.setSndEff, 0.3);

		// g.res_mgr.playAudioByUrl(this.audio, (url) => {
		// 	g.snd_mgr.playEffect(url, () => {
		// 		//关闭效果
		// 		this.unschedule(this.setSndEff);
		// 		this.btnSnd.active = true;
		// 	});
		// });


		g.res_mgr.playAudioByUrlAndId(this.audio, () => {
			//关闭效果
			console.log('onBtnPlayEffect..');
			this.unschedule(this.setSndEff);
			this.btnSnd.active = true;
		}, (audioId) => {
			const duration = cc.audioEngine.getDuration(audioId);
			g.res_mgr.addSRAudioDuration(duration);
		});
	},

	//喇叭
	setSndEff: function () {
		this.btnSnd.active = !this.btnSnd.active;
	},

	checkNode(lab, audio) {
		for (var i in this.TitleType) {
			this.TitleType[i].active = false;
		}
		if (lab && audio) {
			return this.TitleType[2]
		}
		if (lab) {
			return this.TitleType[1]
		}
		if (audio) {
			return this.TitleType[0]
		}
		return null;
	},

	//
	onBtnEffect() {

	}
});
