import {
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnChanges,
  OnInit,
  Output,
  ApplicationRef,
  ChangeDetectorRef
} from '@angular/core';



@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})
export class FormComponent implements OnInit, OnChanges, OnDestroy {

  picArr = [];

  _item: any;


  KEY = 'dfzx_05';





  // @Input()
  set item(item) {
    this._item = item;
    // this.init();

  }
  get item() {
    return this._item;
  }

  @Output()
  update = new EventEmitter();



  constructor(private appRef: ApplicationRef,
              public changeDetectorRef: ChangeDetectorRef) {

  }


  ngOnInit() {

    this.item = {};
    this.item.contentObj = {};

    const getData = (<any> window).courseware.getData;
    getData((data) => {

      if (data) {
        this.item = data;
      } else {
        this.item = {};
      }

      if ( !this.item.contentObj ) {
        this.item.contentObj = {};
      }

      console.log('~data:', data);
      this.init();

      this.changeDetectorRef.markForCheck();
      this.changeDetectorRef.detectChanges();

      this.refresh();

    }, this.KEY);

    // this.initData();
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }


  init() {

    if (this.item.contentObj.picArr) {
      this.picArr = this.item.contentObj.picArr;
    } else {
      this.picArr = this.getDefaultPicArr();
      this.item.contentObj.picArr = this.picArr;
    }

    console.log('item:' , this.item);
    // this.picArr = this.getDefaultPicArr();
    // this.item.contentObj.picArr = this.picArr;
    // console.log('this.item:;', this.picArr);

  }

  getDefaultPicArr() {
    const arr = [];
    // for (let i = 0; i < 4; i ++) {
    //   const data = {};
    //   data['pic_url'] = '';
    //
    //   const soundArr = [];
    //   for (let i = 0; i < 3; i++) {
    //     const tmpData = {};
    //     tmpData['answer'] = false;
    //     tmpData['audio_url'] = '';
    //     soundArr.push(tmpData);
    //   }
    //   data['soundArr'] = soundArr;
    //
    //   arr.push(data);
    // }

    return arr;
  }



  initData() {


  }


  deleteItem(data) {
    const index = this.picArr.indexOf(data);
    if (index !== -1) {
      this.picArr.splice(index, 1);
    }

    // this.update.emit(this.item);
    this.save();
  }







  onImageUploadSuccessByItem(e, item, id = null) {

    if (id != null) {
      item[id + '_pic_url'] = e.url;
    } else {
      item.pic_url = e.url;
    }

    this.save();
    // this.update.emit(this.item);

    // console.log('this.item: ', this.item);
  }




  onAudioUploadSuccessByItem(e, item, id = null) {

    if (id != null) {
      item[id + '_audio_url'] = e.url;
    } else {
      item.audio_url = e.url;
    }
    // this.update.emit(this.item);
    this.save();
  }



  addPic() {
    this.picArr.push({
      pic_url: '',
      audio_url: '',
      // text: '',
      // radioValue: 'A'
    });

    this.saveItem();
  }

  radioClick(it, radioValue) {
    it.radioValue = radioValue;

    this.saveItem();
  }

  clickCheckBox() {
    console.log(' in clickCheckBox');
    this.saveItem();
  }


  saveItem() {
    // this.update.emit(this.item);
    this.save();
  }


  save() {
    (<any> window).courseware.setData(this.item, null, this.KEY);
    this.refresh();
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }

}

