import {Component, ElementRef, ViewChild, OnInit, Input, OnDestroy, HostListener} from '@angular/core';

import {
  getAngleByPos,
  MySprite,
  getPosByAngle,
  Label,
  MyAnimation,
  moveItem,
  randomSortByArr,
  scaleItem,
  rotateItem,
  tweenChange,
  hideItem,
  showItem,
  BitMapLabel,
  ColorSpr,
  removeItemFromArr, ShapeRect, alphaItem, circleMove, ShapeCircle
} from './Unit';
import res from './resources';

import {Subject} from 'rxjs';
import {debounceTime} from 'rxjs/operators';

import * as _ from 'lodash';
import TWEEN from '@tweenjs/tween.js';
import {del} from 'selenium-webdriver/http';


@Component({
  selector: 'app-play',
  templateUrl: './play.component.html',
  styleUrls: ['./play.component.scss']
})
export class PlayComponent implements OnInit, OnDestroy {
  // 数据
  _data;

  @Input()
  set data(data) {
    this._data = data;
  }
  get data() {
    return this._data;
  }

  @Input()
  sid;

  @ViewChild('canvas') canvas: ElementRef;
  @ViewChild('wrap') wrap: ElementRef;
  canvasWidth = 1280;
  canvasHeight = 720;

  canvasBaseW = 1280;
  canvasBaseH = 720;

  ctx;
  fps = 0;
  frametime = 0;  // 上一帧动画的时间，   两帧时间差


  mx;
  my; // 点击坐标



  // 资源
  rawImages = new Map(res);

  // 声音

  bgAudio = new Audio();
  successAudio = new Audio();
  wrongAudio = new Audio();
  rightAudio = new Audio();
  titleAudio = new Audio();


  images = new Map();

  animationId: any;
  winResizeEventStream = new Subject();


  audioObj = {};
  renderArr;
  mapScale = 1;

  canvasLeft;
  canvasTop;


  canTouch = true;


  // -----

  KEY = 'dfzx_05';
  oldFrameColorId;
  curCard;
  bottomCard;


  picW = 800;
  picH = 260;
  mask;
  ball;
  stick;
  robot;



  pageW = 840;
  page1;
  page2;
  arm1;
  arm2;
  centerPageArr;
  pageOffX = 100;
  curPic;



  picArr;
  roleArr;
  picIndex = 0;
  curData;
  bgTop;
  topImg;
  curWordArr;
  wordMoveFlag;
  maxScore;
  bottomY;
  leftScore;
  rightScore;
  leftScoreLabel;
  rightScoreLabel;
  addScoreNum = 20;
  leftWin;
  rightWin;
  startPageArr = [];



  bgItemArr;
  rightArr;

  title;


  startBtn;
  starArr;

  wand;

  light;
  replayBtn;
  endPageArr;
  gameEndFlag;
  showPetalFlag;





  @HostListener('window:resize', ['$event'])
  onResize(event) {
    this.winResizeEventStream.next();
  }


  ngOnInit() {


    const getData = (<any> window).courseware.getData;
    getData((data) => {

      if (data && typeof data == 'object') {
        this.data = data;
      } else {
        this.data = {};
      }

      console.log('data:' , data);
      if (!this.data.contentObj) {
        this.data.contentObj = {};
      }

      this.initDefaultData();



      this.initAudio();
      this.initImg();
      this.initListener();

    }, this.KEY);


    //
    // // this.initAudio();
    // this.initImg();
    // this.initListener();
  }

  initDefaultData() {

    let picArr = this.data.contentObj.picArr;
    if (!picArr || picArr.length <= 0) {
      picArr = [{
        pic_url: 'assets/default/pic.png',
        audio_url: 'assets/default/audio.mp3'
      }];

      this.data.contentObj.picArr = picArr;
    }

  }

  ngOnDestroy() {
    window.cancelAnimationFrame(this.animationId);
    this.bgAudio.pause();
    this.gameEndFlag = true;
  }

  initData() {

    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;

    this.canvas.nativeElement.width = this.wrap.nativeElement.clientWidth;
    this.canvas.nativeElement.height = this.wrap.nativeElement.clientHeight;

    // this.mapScale = this.canvasWidth / this.canvasBaseW;
    this.mapScale = this.canvasHeight / this.canvasBaseH;
    this.renderArr = [];

    console.log(' in initData', this.data);






    this.canTouch = true;
    this.renderArr = [];

    if (!this.data.contentObj.picArr) {
      this.data.contentObj.picArr = [];
    }
    this.picArr = this.data.contentObj.picArr;

    // this.picArr = randomSortByArr(this.picArr);
    this.picIndex = 0;



  }





  initAudio() {

    const contentObj = this.data.contentObj;
    if (!contentObj) { return; }



    // const addAudio = (key) => {
    //   const audioUrl = contentObj[key];
    //   if (audioUrl) {
    //     const audio = new Audio();
    //     audio.src = audioUrl;
    //     audio.load();
    //     this.audioObj[key] = audio;
    //   }
    // }
    //
    // for (let i = 0; i < 4; i ++) {
    //   const key = i + '_audio_url';
    //   addAudio(key);
    // }
    //
    // addAudio('audio_url');
    //


    const addUrlToAudioObj = (audioUrl) => {

      if (audioUrl) {

        console.log('audioUrl:', audioUrl);
        const audio = new Audio();
        audio.src = audioUrl;
        audio.load();
        this.audioObj[audioUrl] = audio;
      }
    };


    const picArr = contentObj.picArr;

    if (picArr) {

      console.log('picArr: ', picArr);
      for (let i = 0; i < picArr.length; i++) {
        addUrlToAudioObj(picArr[i].audio_url);
      }
    }









    //
    // const titleUrl = this.data.contentObj.title_audio_url;
    // if (titleUrl) {
    //
    //   this.titleAudio.src = titleUrl;
    //   this.titleAudio.load();
    // }



    // this.bgAudio.src = 'assets/bat-mail/music/bg.mp3';
    // this.bgAudio.load();
    // this.bgAudio.loop = true;
    // this.bgAudio.volume = 0.5;
    //
    // this.wrongAudio.src = 'assets/common/music/wrong.mp3';
    // this.wrongAudio.load();
    //
    // this.rightAudio.src = 'assets/common/music/right.mp3';
    // this.rightAudio.load();
    //
    // this.successAudio.src = 'assets/magic-hat/music/finish.mp3';
    // this.successAudio.load();
    //
    // this.successAudio.onended = () => {
    //   // this.showSuccessAudio();
    // };
    //
    //
    //

  }

  initImg() {

    const contentObj = this.data.contentObj;
    if (contentObj) {

      const picArr = this.data.contentObj.picArr;
      if (picArr) {

        for (let i = 0; i < picArr.length; i++) {

          const picUrl = picArr[i].pic_url;
          if (picUrl) {
            this.rawImages.set(picUrl, picUrl);
          }
        }
      }

    }


    // this.initFontImg();



    // 预加载资源

    this.loadResources().then(() => {
      // this.setfontData();

      window['air'].hideAirClassLoading(this.KEY, this.data);

      this.init();
      this.update();
    });

  }

  initFontImg() {



    // const fontbaseUrlW = 'assets/mechanical/letter/';
    // const fontDataW = {};
    //
    // let num = 97;
    // for (let i = 0; i < 26; i++) {
    //
    //   const key = String.fromCharCode(num + i);  // 'a'
    //   const url = fontbaseUrlW + key + '.png';
    //
    //   this.rawImages.set(url, url);
    //   fontDataW[key] = url;
    // }
    //
    //
    // this.fontDataW = fontDataW;
  }

  setfontData() {

    // for (let key in this.fontDataW) {
    //   this.fontDataW[key] = this.images.get(this.fontDataW[key]);
    // }
  }








  init() {

    this.initData();
    this.initCtx();

    this.initView();


  }

  initCtx() {

    this.ctx = this.canvas.nativeElement.getContext('2d');
    this.canvas.nativeElement.width = this.canvasWidth;
    this.canvas.nativeElement.height = this.canvasHeight;



    // console.log('this.ctx.canvas w: ', this.ctx.canvas.width);
    // console.log('this.ctx.canvas h: ', this.ctx.canvas.height);
  }


  initView() {

    this.initBg();

    this.initCard();

    // this.initCardTop();
    // this.initCardBottom();

    // this.initRobot();

    // this.initArm();
    //
    //
    // this.initCenterPage();
    // this.setPagePoint();
    //
    // this.initPic();
  }

  initCard() {

    const card = new MySprite(this.ctx);
    card.init(this.images.get(this.getFrameColor()));
    card.setScaleXY(this.mapScale);
    card.x = this.canvasWidth / 2;
    card.y = this.canvasHeight / 2;
    this.addPic(card);

    this.renderArr.push(card);

    this.curCard = card;

    this.addBottomCard();

  }

  getFrameColor() {
    let arr = ['1', '2', '3'];
    if (this.oldFrameColorId) {
      removeItemFromArr(arr, this.oldFrameColorId);
    }

    arr = randomSortByArr(arr);
    const colorId = arr[0];
    this.oldFrameColorId = colorId;
    return 'frame_' + colorId;
  }

  addPic(card) {



    const curData = this.picArr[this.picIndex];

    const w = 340;
    const h = 340;
    const pic = new MySprite(this.ctx);
    pic.init(this.images.get(curData.pic_url));
    const sx = w / pic.width;
    const sy = h / pic.height;
    const s = Math.min(sx, sy);
    pic.setScaleXY(s);

    pic.x = 5;
    card.addChild(pic);

    card.data = curData;


    this.picIndex ++;
    if (this.picIndex >= this.picArr.length) {
      this.picIndex = 0;
    }
  }


  initRobot() {
    const robot = new MySprite(this.ctx);
    robot.init(this.images.get('robot'));
    robot.setScaleXY(this.mapScale);
    robot.x = this.canvasWidth / 2 - 50 * this.mapScale;
    robot.y = this.canvasHeight / 2 + 50 * this.mapScale;
    this.renderArr.push(robot);
    this.robot = robot;

    const stick = new MySprite(this.ctx);
    stick.init(this.images.get('stick'));
    stick.anchorY = 0.95;
    stick.x = robot.width / 2 + stick.width / 2 - 5;
    stick.y = -25;
    robot.addChild(stick);
    this.stick = stick;

    const ball = new MySprite(this.ctx);
    ball.init(this.images.get('ball'));
    ball.x = stick.x;
    ball.y = stick.y - stick.height;
    robot.addChild(ball);
    this.ball = ball;


    const mask = new MySprite(this.ctx);
    mask.init(this.images.get('mask'));
    mask.x = 31;
    mask.y = 2;
    robot.addChild(mask);
    this.mask = mask;

    // const w = 800;
    // const h = 260;
    // const rect = new ShapeRect(this.ctx);
    // rect.setSize(w, h);
    // rect.anchorX = 0.5;
    // rect.anchorY = 0.5;
    // mask.addChild(rect);



  }





  initBg() {

    this.bgItemArr = [];

    const bg = new MySprite(this.ctx);
    bg.init(this.images.get('bg'));
    bg.x = this.canvasWidth / 2;
    bg.y = this.canvasHeight / 2;
    const sx = this.canvasWidth / bg.width;
    const sy = this.canvasHeight / bg.height;
    const s = Math.max(sx, sy);
    bg.setScaleXY(s);
    this.bgItemArr.push(bg);


    const bgBottom = new MySprite(this.ctx);
    bgBottom.init(this.images.get('bg_bottom'), 0.5, 1);
    bgBottom.setScaleXY(this.canvasWidth / bgBottom.width);
    bgBottom.x = this.canvasWidth / 2;
    bgBottom.y = this.canvasHeight;
    this.bgItemArr.push(bgBottom);

  }


  resetArm() {
    this.arm1.page1.removeChildren();
    this.arm1.page2.removeChildren();
    this.arm2.page1.removeChildren();
    this.arm2.page2.removeChildren();

    this.arm1.x = this.arm1.baseX;
    this.arm1.y = this.arm1.baseY;

    this.arm2.x = this.arm2.baseX;
    this.arm2.y = this.arm2.baseY;

    this.arm1.page1.visible = true;
    this.arm2.page1.visible = true;
    this.arm1.page2.visible = false;
    this.arm2.page2.visible = false;


    this.picIndex ++ ;
    if (this.picIndex >= this.picArr.length) {
      this.picIndex = 0;

      this.picArr = randomSortByArr(this.picArr);
    }

    this.setPagePoint();
    this.initPic();
  }

  initPic() {

    const w = 380 ; // * this.mapScale;

    const curData = this.picArr[this.picIndex];
    const pic = new MySprite(this.ctx);
    if (curData) {
      pic.init(this.images.get(curData.pic_url), 1);
    }
    pic.x = - (this.pageW - w) / 2; // this.canvasWidth / 2;
    // pic.y = this.canvasHeight / 2;

    const sx = w / pic.width;
    const sy = w / pic.height;
    const s = Math.min(sx, sy);
    pic.setScaleXY(s);

    this.curPic = pic;
    this.arm2.page2.addChild(pic);
    // this.page1.removeChild(pic);
  }




  initArm() {


    const pageOffX = this.pageOffX;

    const arm1 = new MySprite(this.ctx);
    arm1.init(this.images.get('arm_1_1'), 0, 1);
    arm1.setScaleXY(this.mapScale);
    arm1.x = - arm1.width * arm1.scaleX - this.pageW / 2 * this.mapScale;
    arm1.y = this.canvasHeight + 60 * this.mapScale;
    this.renderArr.push(arm1);

    const page1 = new MySprite(this.ctx);
    page1.init(this.images.get('page_1'), 0);
    page1.x = arm1.width - pageOffX;
    page1.y = - arm1.height + 80;
    arm1.addChild(page1);

    page1.alpha = 1;




    const page1_2 = new MySprite(this.ctx);
    page1_2.init(this.images.get('page_1_2'), 0);
    page1_2.x = page1.x;
    page1_2.y = page1.y;
    page1_2.visible = false;
    arm1.addChild(page1_2);

    arm1['page1'] = page1;
    arm1['page2'] = page1_2;

    arm1['baseX'] = arm1.x;
    arm1['baseY'] = arm1.y;


    const finger = new MySprite(this.ctx);
    finger.init(this.images.get('finger_1_1'), 0, 1);
    arm1.addChild(finger);




    const arm2 = new MySprite(this.ctx);
    arm2.init(this.images.get('arm_2_1'), 1, 1);
    arm2.setScaleXY(this.mapScale);
    arm2.x = this.canvasWidth + arm2.width * arm2.scaleX + this.pageW / 2 * this.mapScale;
    arm2.y = arm1.y;
    this.renderArr.push(arm2);

    const page2 = new MySprite(this.ctx);
    page2.init(this.images.get('page_2'), 1);
    page2.x = -arm2.width + pageOffX;
    page2.y = - arm2.height + 80;
    page2.alpha = 1;
    arm2.addChild(page2);


    const page2_2 = new MySprite(this.ctx);
    page2_2.init(this.images.get('page_2_2'), 1);
    page2_2.x = page2.x;
    page2_2.y = page2.y;
    page2_2.visible = false;
    arm2.addChild(page2_2);

    arm2['baseX'] = arm2.x;
    arm2['baseY'] = arm2.y;

    arm2['page1'] = page2;
    arm2['page2'] = page2_2;


    const finger2 = new MySprite(this.ctx);
    finger2.init(this.images.get('finger_2_1'), 1, 1);
    arm2.addChild(finger2);

    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (arm1.width) * arm1.scaleX + pageOffX * arm1.scaleX;




    // moveItem(arm1, tx, arm1.y);
    //
    // moveItem(arm2, this.canvasWidth - tx, arm2.y);



    this.page1 = page1;
    this.page2 = page2;
    this.arm1 = arm1;
    this.arm2 = arm2;








  }


  setPagePoint() {

    const page1 = this.page1;
    const page2 = this.page2;

    const curData = this.picArr[this.picIndex];
    console.log('this.picArr: ', this.picArr);
    console.log('curData: ', curData);

    if (!curData) {
      return;
    }

    const wordArr1 = curData.wordArr_1;
    const wordArr2 = curData.wordArr_2;


    const centerW = 60;
    const edge = 20;
    const maxW = page1.width - (centerW + edge * 2);

    let num = wordArr1.length;
    let disW = 20;
    let circleW = 68;

    let totalW = edge * 2 + circleW * num + disW * (num - 1);
    let s = 1;
    if (totalW >= maxW) {
      s = maxW / totalW;
      totalW = maxW;
    }

    disW *= s;
    circleW *= s;

    let offX = (maxW - totalW) / 2 + edge + circleW / 2;







    // const disW = (w - circleW * 3) / 4;
    // const offX = disW + circleW / 2;

    for (let i = 0; i < wordArr1.length; i++) {

      const tmpData = wordArr1[i];

      let color = 'green';
      if (tmpData.color) {
        color = tmpData.color;
      }
      const point = new MySprite(this.ctx);
      const key = 'point_' + color;
      point.init(this.images.get(key));
      point.setScaleXY(s);
      point.x = offX + i * (circleW + disW);
      page1.addChild(point);

    }




    num = wordArr2.length;
    disW = 20;
    circleW = 68;

    totalW = edge * 2 + circleW * num + disW * (num - 1);
    s = 1;
    if (totalW >= maxW) {
      s = maxW / totalW;
      totalW = maxW;
    }

    disW *= s;
    circleW *= s;

    offX = (maxW - totalW) / 2 + edge + circleW / 2;

    for (let i = 0; i < wordArr2.length; i++) {

      const tmpData = wordArr2[i];
      let color = 'green';
      if (tmpData.color) {
        color = tmpData.color;
      }
      const point = new MySprite(this.ctx);
      const key = 'point_' + color;
      point.init(this.images.get(key));
      point.setScaleXY(s);
      point.x = (offX + centerW - page2.width) + i * (circleW + disW);
      page2.addChild(point);
    }

  }


  initCenterPage() {

    this.centerPageArr = [];



    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (this.arm1.width) * this.arm1.scaleX + this.pageOffX * this.arm1.scaleX;

    const arm1_2 = new MySprite(this.ctx);
    arm1_2.init(this.images.get('arm_1_2'), 0, 1);
    arm1_2.setScaleXY(this.mapScale);
    arm1_2.x = tx;
    arm1_2.y = this.arm1.y;
    // arm1_2.visible = false;
    this.centerPageArr.push(arm1_2);

    const finger = new MySprite(this.ctx);
    finger.init(this.images.get('finger_1_2'), 0, 1);
    arm1_2.addChild(finger, -2);



    const arm2_2 = new MySprite(this.ctx);
    arm2_2.init(this.images.get('arm_2_2'), 1, 1);
    arm2_2.setScaleXY(this.mapScale);
    arm2_2.x = this.canvasWidth - tx;
    arm2_2.y = this.arm2.y;
    // arm2_2.visible = false;
    this.centerPageArr.push(arm2_2);

    const finger2 = new MySprite(this.ctx);
    finger2.init(this.images.get('finger_2_2'), 1, 1);
    arm2_2.addChild(finger2, -2);


    const centerPage = new MySprite(this.ctx);
    centerPage.init(this.images.get('center_page'), 0);
    centerPage.x = this.page1.x;
    centerPage.y = this.page1.y;
    arm1_2.addChild(centerPage, -1);


    this.hideArr(this.centerPageArr);
    // this.hideArr(this.centerPageArr);

  }








  initStartPage() {

    this.starArr = [];

    const maskLayer = new ShapeRect(this.ctx);
    maskLayer.init(this.images.get(''));
    maskLayer.setSize(this.canvasWidth, this.canvasHeight);
    maskLayer.x = this.canvasWidth / 2;
    maskLayer.y = this.canvasHeight / 2;
    maskLayer.fillColor = '#000000';
    maskLayer.alpha = 0.8;
    this.startPageArr.push(maskLayer);

    const startBtn = new MySprite(this.ctx);
    startBtn.init(this.images.get('start_btn'));
    startBtn.x = this.canvasWidth / 2;
    startBtn.y = this.canvasHeight / 5 * 3;
    startBtn.setScaleXY(this.mapScale);
    this.startPageArr.push(startBtn);
    this.startBtn = startBtn;
  }


  initEndPage() {


    const maskLayer = new ShapeRect(this.ctx);
    maskLayer.init(this.images.get(''));
    maskLayer.setSize(this.canvasWidth, this.canvasHeight);
    maskLayer.x = this.canvasWidth / 2;
    maskLayer.y = this.canvasHeight / 2;
    maskLayer.fillColor = '#000000';
    maskLayer.alpha = 0.8;
    this.endPageArr.push(maskLayer);

    const leftWin = new MySprite(this.ctx);
    leftWin.init(this.images.get('left_win'));
    leftWin.x = this.canvasWidth / 2;
    leftWin.y = this.canvasHeight / 2.5;
    leftWin.setScaleXY(this.mapScale);
    this.endPageArr.push(leftWin);


    const rightWin = new MySprite(this.ctx);
    rightWin.init(this.images.get('right_win'));
    rightWin.x = this.canvasWidth / 2;
    rightWin.y = this.canvasHeight / 2.5;
    rightWin.setScaleXY(this.mapScale);
    this.endPageArr.push(rightWin);

    this.leftWin = leftWin;
    this.rightWin = rightWin;

    // const light = new MySprite(this.ctx);
    // light.init(this.images.get('light_png'));
    // light.x = this.canvasWidth / 2;
    // light.y = this.canvasHeight / 5 * 2;
    // light.setScaleXY(this.mapScale);
    // this.endPageArr.push(light);
    // this.light = light;
    //
    // const hand = new MySprite(this.ctx);
    // hand.init(this.images.get('hand_png'));
    // hand.x = this.canvasWidth / 2;
    // hand.y = light.y;
    // hand.setScaleXY(this.mapScale);
    // this.endPageArr.push(hand);
    // this.hand = hand;

    const replayBtn = new MySprite(this.ctx);
    replayBtn.init(this.images.get('replay_btn'));
    replayBtn.x = this.canvasWidth / 2;
    replayBtn.y = this.canvasHeight / 5 * 3.5;
    replayBtn.setScaleXY(this.mapScale);
    this.endPageArr.push(replayBtn);
    this.replayBtn = replayBtn;


    this.hideArr(this.endPageArr);

    // const lightAction = () => {
    //   light.rotation = 0;
    //   rotateItem(light, 360, 10, () => {
    //     lightAction();
    //   });
    // };
    //
    // lightAction();

  }


  initScore() {


    const addLabelShadow = (label) => {

      const labelShadow = new Label(this.ctx);
      labelShadow.init();
      labelShadow.text = label.text;
      labelShadow.fontSize = label.fontSize;
      labelShadow.fontName = label.fontName;
      labelShadow.fontColor = '#e4688f';
      labelShadow.textAlign = 'center';
      labelShadow.y = 3;
      labelShadow.setShadow(0, 2, 2, 'rgba(154, 23, 58, 0.5)');
      label.addChild(labelShadow, -1);
      label.shadowLabel = labelShadow;

    };

    const labelLeft = new Label(this.ctx);
    labelLeft.init();
    labelLeft.text = '0';
    labelLeft.fontSize = 60;
    labelLeft.fontName = 'BRLNSDB';
    labelLeft.fontColor = '#fef9ff';
    labelLeft.textAlign = 'center';

    labelLeft.x = - this.bgTop.width / 4;
    labelLeft.y = this.bgTop.height / 5;

    labelLeft.refreshSize();

    addLabelShadow(labelLeft);

    this.bgTop.addChild(labelLeft);
    this.leftScoreLabel = labelLeft;




    const labelRight = new Label(this.ctx);
    labelRight.init();
    labelRight.text = '0';
    labelRight.fontSize = 60;
    labelRight.fontName = 'BRLNSDB';
    labelRight.fontColor = '#fef9ff';
    labelRight.textAlign = 'center';

    labelRight.x = this.bgTop.width / 4;
    labelRight.y = this.bgTop.height / 5;

    labelRight.refreshSize();

    addLabelShadow(labelRight);

    this.bgTop.addChild(labelRight);

    this.rightScoreLabel = labelRight;


    // console.log('label.width: ', label.width);
  }







  showEndPage() {

    this.showArr(this.endPageArr);
    this.canTouch = true;
    this.gameEndFlag = true;

    this.showEndPatal();

    this.successAudio.play();

    if (this.leftScore >= this.maxScore) {
      this.rightWin.visible = false;
    } else {
      this.leftWin.visible = false;
    }
  }


  showEndPatal() {

    this.showPetalFlag = true;
    this.addPetal();

  }

  addPetal() {

    if (!this.showPetalFlag) {
      return;
    }

    const petal = this.getPetal();
    this.endPageArr.push(petal);

    moveItem(petal, petal.x, this.canvasHeight + petal.height * petal.scaleY, petal['time'], () => {
      removeItemFromArr(this.endPageArr, petal);
    });

    rotateItem(petal, petal['tr'], petal['time']);

    setTimeout(() => {
      this.addPetal();
    }, 100);
  }


  getPetal() {

    const petal = new MySprite(this.ctx);

    const id = Math.ceil( Math.random() * 3 );
    petal.init(this.images.get('petal_' + id));

    const randomS = (Math.random() * 0.4 + 0.6) * this.mapScale;
    petal.setScaleXY(randomS);

    const randomR = Math.random() * 360;
    petal.rotation = randomR;

    const randomX = Math.random() * this.canvasWidth;
    petal.x = randomX;
    petal.y = -petal.height / 2 * petal.scaleY;

    const randomT = 2 + Math.random() * 5;
    petal['time'] = randomT;

    let randomTR = 360 * Math.random(); // - 180;
    if (Math.random() < 0.5) { randomTR *= -1; }
    petal['tr'] = randomTR;

    return petal;
  }



  gameEnd() {
    this.showEndPage();
  }




  mapDown(event) {


    if (!this.canTouch) {
      return;
    }

    if (this.picArr.length <= 0) {
      return;
    }

    if (this.curCard) {
      if (this.checkClickTarget(this.curCard)) {
        this.clickCurCard();
        return;
      }
    }

    this.changeCard();







  }

  clickCurCard() {
    const curData = this.curCard.data;

    const audio = this.audioObj[curData.audio_url];
    if (audio) {
      audio.play();
    }
  }


  changeCard() {

    this.canTouch = false;
    const x = this.canvasWidth * 1.5;
    const y = this.canvasHeight * - 0.7;
    moveItem(this.curCard, x, y, 1, () => {
      // this.canTouch = true;
    }, TWEEN.Easing.Sinusoidal.Out);

    rotateItem(this.curCard, 150);


    this.bottomCard.visible = true;
    scaleItem(this.bottomCard, this.mapScale, 0.6, () => {
      this.canTouch = true;
    }, TWEEN.Easing.Elastic.Out);
    this.curCard = this.bottomCard;

    this.addBottomCard();

  }

  addBottomCard() {

    const bottomCard = new MySprite(this.ctx);
    bottomCard.init(this.images.get(this.getFrameColor()));
    bottomCard.setScaleXY(this.mapScale * 0.95);
    bottomCard.x = this.canvasWidth / 2;
    bottomCard.y = this.canvasHeight / 2;
    bottomCard.visible = false;
    this.addPic(bottomCard);

    this.renderArr.unshift(bottomCard);
    this.bottomCard = bottomCard;
  }



  moveArm1() {

    this.canTouch = false;
    const arm1 = this.arm1;
    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (arm1.width) * arm1.scaleX + this.pageOffX * arm1.scaleX;

    moveItem(this.arm1, tx, arm1.y, 0.8, () => {
     this.canTouch = true;
     this.clickLeft();
    } );
  }

  moveArm2() {

    const arm1 = this.arm1;
    const arm2 = this.arm2;
    const offX = this.canvasWidth / 2 - this.pageW / 2 * this.mapScale;
    const tx = offX - (arm1.width) * arm1.scaleX + this.pageOffX * arm1.scaleX;

    this.canTouch = false;

    moveItem(arm2, this.canvasWidth - tx, arm2.y, 0.8, () => {
     this.canTouch = true;
     this.clickRight();
    } );

  }



  clickTitle() {
    this.titleAudio.play();
  }

  clickEmpty() {
    this.moveDown();
  }


  clickBall() {

    // console.log('in clickBall');

    this.canTouch = false;

    const down = () => {

      const targetY = this.stick.y + this.stick.height;
      tweenChange(this.ball, {y: targetY}, 0.8, () => {
        up();
      }, TWEEN.Easing.Quadratic.In, () => {
        this.stick.scaleY = (this.stick.y - this.ball.y) / this.stick.height;
      });

      if (this.curPic) {
        hideItem(this.curPic, 0.7);
        showItem(this.mask, 0.7);
      }
    };

    const up = () => {
      const targetY = this.stick.y - this.stick.height;
      tweenChange(this.ball, {y: targetY}, 0.8, () => {
        this.canTouch = true;
      }, TWEEN.Easing.Quadratic.Out, () => {
        this.stick.scaleY = (this.stick.y - this.ball.y) / this.stick.height;
      });

      this.showPic();
    };

    down();
  }

  showPic() {




    this.mask.removeChildren();

    const data = this.picArr[this.picIndex];
    this.curData = data;

    const curPic = new MySprite(this.ctx);
    curPic.init(this.images.get(data.pic_url));
    const sx = this.picW / curPic.width;
    const sy = this.picH / curPic.height;
    const s = Math.min(sx, sy);
    curPic.setScaleXY(s);

    this.robot.addChild(curPic);
    curPic.x = this.mask.x;
    curPic.y = this.mask.y;

    this.curPic = curPic;

    curPic.alpha = 0;
    showItem(curPic);
    hideItem(this.mask);

    this.picIndex ++;
    if (this.picIndex >= this.picArr.length) {
      this.picIndex = 0;
    }

  }


  clickPic() {

    // console.log('in clickPic');
    const curData = this.curData;
    const audio = this.audioObj[curData.audio_url];
    if (audio) {
      audio.play();
    }
  }


  clickLeft() {
    const curData = this.picArr[this.picIndex];
    const audio = this.audioObj[curData.word_1_audio_url];
    if (audio) {
      audio.play();
    }
  }

  clickRight() {
    const curData = this.picArr[this.picIndex];
    const audio = this.audioObj[curData.word_2_audio_url];
    if (audio) {
      audio.play();
    }
  }

  clickCenter() {

    console.log(' in clickCenter');

    this.canTouch = false;


    this.arm1.visible = false;
    this.arm2.visible = false;

    this.showArr(this.centerPageArr);

    setTimeout(() => {
      this.arm1.visible = true;
      this.arm2.visible = true;

      this.hideArr(this.centerPageArr);

      this.arm1.page1.visible = false;
      this.arm1.page2.visible = true;

      this.arm2.page1.visible = false;
      this.arm2.page2.visible = true;

      this.canTouch = true;
    }, 0.25 * 1000);
    // this.arm1.centerSpr.visible = true;

    // this.arm1.centerSpr.x = this.arm1.x;
    // this.arm1.centerSpr.y = this.arm1.y;



  }







  mapMove(event) {


  }

  mapUp(event) {


  }





  moveDown() {

    this.canTouch = false;

    const data = {y: this.arm1.y};
    const tween = tweenChange(data, {y: this.arm1.y + this.canvasHeight}, 1,
      () => {
      this.canTouch = true;
      this.resetArm();
    },
      TWEEN.Easing.Quadratic.In,
      (item, progress) => {

      this.arm1.y = item.y;
      this.arm2.y = item.y;

    });


  }



  update() {


    this.animationId = window.requestAnimationFrame(this.update.bind(this));
    // 清除画布内容
    this.ctx.clearRect(0, 0, this.canvasWidth, this.canvasHeight);


    TWEEN.update();



    // this.updateWordArr();
    //
    this.updateArr(this.bgItemArr);
    // this.updateArr(this.curWordArr);
    this.updateArr(this.renderArr);
    // this.updateArr(this.centerPageArr);
    // this.updateArr(this.endPageArr);



  }


  updateItem(item) {
    if (item) {
      item.update();
    }
  }

  updateArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].update(this);
    }
  }





  initListener() {

    this.winResizeEventStream
      .pipe(debounceTime(500))
      .subscribe(data => {
        this.renderAfterResize();
      });




      if (this.IsPC()) {

        this.canvas.nativeElement.addEventListener('mousedown', (event) => {

          setMxMyByMouse(event);
          this.mapDown(event);
        });

        this.canvas.nativeElement.addEventListener('mousemove', (event) => {

          setMxMyByMouse(event);
          this.mapMove(event);
        });

        this.canvas.nativeElement.addEventListener('mouseup', (event) => {

          setMxMyByMouse(event);
          this.mapUp(event);
        });


        const setMxMyByMouse = (event) => {

          this.mx = event.offsetX;
          this.my = event.offsetY;
        };



      } else {

        this.canvas.nativeElement.addEventListener('touchstart', (event) => {

          setMxMyByTouch(event);
          this.mapDown(event);
        });

        this.canvas.nativeElement.addEventListener('touchmove', (event) => {
          setMxMyByTouch(event);
          this.mapMove(event);
        });

        this.canvas.nativeElement.addEventListener('touchend', (event) => {
          setMxMyByTouch(event);
          this.mapUp(event);
        });

        this.canvas.nativeElement.addEventListener('touchcancel', (event) => {
          setMxMyByTouch(event);
          this.mapUp(event);
        });


        const setMxMyByTouch = (event) => {

          // console.log('in setMxMyByTouch', event);
          if (event.touches.length <= 0) {
            return;
          }

          if (this.canvasLeft == null) {
            setParentOffset();
          }

          this.mx = event.touches[0].pageX - this.canvasLeft;
          this.my = event.touches[0].pageY - this.canvasTop;
        };


        const setParentOffset = () => {

          const rect = this.canvas.nativeElement.getBoundingClientRect();
          this.canvasLeft = rect.left;
          this.canvasTop = rect.top;
        };
      }



  }




  showArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].visible = true;
    }
  }

  hideArr(arr) {
    if (!arr) {
      return;
    }
    for (let i = 0; i < arr.length; i++) {
      arr[i].visible = false;
    }
  }



  IsPC() {

    if (window['ELECTRON']) {
      return false; // 封装客户端标记
    }


    if (document.body.ontouchmove !== undefined && document.body.ontouchmove !== undefined) {
      return false;
    } else {
      return true;
    }

  }


  loadResources() {
    const pr = [];
    this.rawImages.forEach((value, key) => {// 预加载图片

      const p = this.preload(value)
        .then(img => this.images.set(key, img))
        .catch(err => console.log(err));
      pr.push(p);
    });
    return Promise.all(pr);
  }

  preload(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      // img.crossOrigin = "anonymous";
      img.onload = () => resolve(img);
      img.onerror = reject;
      img.src = url;
    });
  }


  renderAfterResize() {
    this.canvasWidth = this.wrap.nativeElement.clientWidth;
    this.canvasHeight = this.wrap.nativeElement.clientHeight;
    this.init();
  }



  checkClickTarget(target) {

    const rect = target.getBoundingBox();

    if (this.checkPointInRect(this.mx, this.my, rect)) {
      return true;
    }
    return false;
  }

  getWorlRect(target) {

    let rect = target.getBoundingBox();

    if (target.parent) {

      const pRect = this.getWorlRect(target.parent);
      rect.x += pRect.x;
      rect.y += pRect.y;
    }
    return rect;
  }

  checkPointInRect(x, y, rect) {
    if (x >= rect.x && x <= rect.x + rect.width) {
      if (y >= rect.y && y <= rect.y + rect.height) {
        return true;
      }
    }
    return false;
  }

  getPosByAngle(angle, len) {

    const radian = angle * Math.PI / 180;
    const x = Math.sin(radian) * len;
    const y = Math.cos(radian) * len;

    return {x, y};

  }

  getPosDistance(sx, sy, ex, ey) {

    const _x = ex - sx;
    const _y = ey - sy;
    const len = Math.sqrt( Math.pow(_x, 2) + Math.pow(_y, 2) );
    return len;
  }

}
