import {Component, EventEmitter, Input, OnDestroy, OnChanges, OnInit, Output, ApplicationRef} from '@angular/core';
// import defauleFormData from '../../assets/default/formData/defaultData_LST08.js'

@Component({
  selector: 'app-form',
  templateUrl: './form.component.html',
  styleUrls: ['./form.component.scss']
})

export class FormComponent implements OnInit, OnChanges, OnDestroy {

  _item: any;
  dataArray: Array<Object> = [];

  contentObj = {
    dataArray: [],
  }
  defauleFormData = {
    version: "1.0",
    key: "DataKey_dfzx_ppp",
    question: {},
    dataArray: [
      {
        correct: [
          {
            type: "Text",
            text: "",
            audio_url: "",
            image_url: "",
          }
        ],
        incorrect: [
  
        ]
      }
    ]
  }
  KEY = 'DataKey_dfzx_ppp';

  set item(item) {
    this._item = item;
  }
  get item() {
    return this._item;
  }

  @Output()
  update = new EventEmitter();
  constructor(private appRef: ApplicationRef) {

  }

  ngOnInit() {
    this.item = {};
    this.item.contentObj = {};
    const getData = (<any> window).courseware.getData;
    getData((data) => {
      // console.log("读取数据", data)
      if (data) {
        this.item = data;
      } else {
        this.item = {};
      }
      if ( !this.item.contentObj ) {
        this.item.contentObj = {};
      }
      this.init();
      this.refresh();
      this.save()
    }, this.KEY);
  }
  ngOnChanges() {

  }

  ngOnDestroy() {
  }

  saveData(e){
    this.save();
  }

  init() {
    if (Object.keys(this.item.contentObj).length != 0 && this.item.contentObj.version && this.item.contentObj.version==this.defauleFormData.version) {
      // console.log("使用默认数据", this.item.contentObj)
      this.contentObj = this.item.contentObj;
      this.dataArray = this.item.contentObj.dataArray;
    } else {
      this.contentObj = this.defauleFormData;
      this.dataArray = this.defauleFormData.dataArray
      // console.log("使用默认数据", this.contentObj)
      this.item.contentObj = this.contentObj;
      this.item.contentObj.dataArray = this.dataArray;
      this.item.contentObj.question = this.defauleFormData.question;
    }
  }

  cardItemData(){
    return {
      correct: [
        {
          type: "Text",
          text: "",
          audio_url: "",
          image_url: "",
        }
      ],
      incorrect: [

      ]
    }
  }

  cardChoiceData(){
    return { type:"Text", image_url:"", text:"", audio_url:"" }
  }

  addChoice(item) { 
    console.log(item)
    item.push(this.cardChoiceData());
    this.saveItem();
  }

  deleteChoice(item, index){
    item.splice(index,1)
    this.save()
  }

  copyItem(items, index) {
    let copy = JSON.parse(JSON.stringify(items[index]))
    items.push(copy)
    this.save()
  }

  getDefaultPicArr() {
    let arr = []; 
    return arr;
  }

  initData() {

  }

  onUploadSuccessByItem(e, item, key) { 
    item[key] = e.url; 
    this.save();
  }

  onImageUploadSuccessByItem(e, item, key) {
    item[key] = e.url
    this.save(); 
  }
 
  onAudioUploadSuccessByItem(e, item, key) { 
    item[key] = e.url; 
    this.save();
  }

  onTitleAudioUploadSuccess(e) { 
    this.item.contentObj.titleAudio_url = e.url;
    this.save();
  }

  addItem(type) { 
    let item = this.cardItemData();
    this[type].push(item);
    this.saveItem();
  }

  deleteItem(type, index){
    this[type].splice(index,1)
    this.save()
  }

  handleMoveItemUp(key, index){
    if(index!=0){
      this[key][index] = this[key].splice(index-1, 1, this[key][index])[0];
    }else{
      this[key].push(this[key].shift());
    }
    this.save()
  }

  handleMoveItemDown(key, index){
    if(index!=this[key].length-1){
      this[key][index] = this[key].splice(index+1, 1, this[key][index])[0];
    }else{
      this[key].unshift( this[key].splice(index,1)[0]);
    }
    this.save()
  }

  radioClick(it, radioValue) {
    it.radioValue = radioValue;
    this.saveItem();
  }

  clickCheckBox() {
    this.saveItem();
  }

  saveItem() {
    this.save();
  }

  save() {
    (<any> window).courseware.setData(this.item, null, this.KEY);
    this.refresh();

    /* Remove this when commit */
    if(location.href.indexOf("localhost") != -1) {
      (<any> window).axios.post(`http://www.datalist.com.cn:8060/json/save/${this.KEY}`, this.item)
    }
    /* Remove this when commit */

    console.log("保存", this.item)
  }

  refresh() {
    setTimeout(() => {
      this.appRef.tick();
    }, 1);
  }
}

